// Init
UI.moduleBuilder['setting']['MenuChipTTS'] =function(){
    // ??????????
    var MenuChipTTS_Data = {
        bg:UI.window_bg,
        normal_bg:UI.item_bg,
        TTS_title:"[SE3021]"//'[Accessibility]'

    };
    var template = Util.readJson("module/setting/MenuChipTTS.json");
    var MenuChipTTS_page = SubModule.create(MenuChipTTS_Data, template);
    var lastSubModule=null;
    var defaultFocus = UI.getItem(MenuChipTTS_page, "Audio_Menu_Prompts_group");
    var itemLineHeight = 116;
    MenuChipTTS_page.currFocus = defaultFocus;
//action

    var MenuChipTTSItemContent={
        Video_Description_group:'[SE3027]',//"Video Description",
        Audio_Menu_Prompts_group:'[SE3028]',//"Menu Audio",
        High_Contrast_Menu_group:'[SE3030]'//"High Contrast Menu"
    };
    var Group_array=["Video_Description_group","Audio_Menu_Prompts_group","High_Contrast_Menu_group"];
    MenuChipTTS_page.onShow=function(){
        initSwitchData(MenuChipTTS_page,"Video_Description_group","pic_video");
        initSwitchData(MenuChipTTS_page,"Audio_Menu_Prompts_group","pic_audio");
        initSwitchData(MenuChipTTS_page,"High_Contrast_Menu_group","pic_high_contrast");
        initTitleContent();
        UI.getTween(UI.base.cursor).set({alpha:1});
    };
    MenuChipTTS_page.onPush=function(){
        curDisplayItemHandler();
        MenuChipTTS_page.currFocus = defaultFocus;
        lastSubModule=getLastSubModule();
    }
    MenuChipTTS_page.onkey_BACKSPACE=function(){
        UI.popSubModule();
        if(lastSubModule == "menuChip"){
            if(window["setting"]["menuChip"]){
                window["setting"]["menuChip"].open();
            }
            else {
                UI.pushSubModule("setting","menuChip",true,MenuChipTTS_page.param,null,"CHIP"+ CHIPS.TTS);

            }
        }
    }
    Switchbar_common(MenuChipTTS_page,"Video_Description_group","pic_video","group_name");
    Switchbar_common(MenuChipTTS_page,"Audio_Menu_Prompts_group","pic_audio","group_name");
    Switchbar_common(MenuChipTTS_page,"High_Contrast_Menu_group","pic_high_contrast","group_name");
    function Switchbar_common(submodule,groupname,pic_switch_name,txt_switch_name){
        try {
            var switchBar = UI.getItem(submodule, groupname);
            var switchBarText = UI.getItem(switchBar, txt_switch_name);
            var switchComp = UI.getItem(switchBar, pic_switch_name);
            Switch.create(switchComp, true);
            //switchBar.updateCache();
            switchBar.onFocus = function () {
                switchComp.onFocus();
                //UI.setTextColor(switchBarText, "#FFFFFF");
                ////switchBar.updateCache();
                //UI.updateStage();
                return true;
            };
            switchBar.onNormal = function () {
                switchComp.onNormal();
                UI.setTextColor(switchBarText,"#FFFFFF");
                //switchBar.updateCache();
                UI.updateStage();
                return true;
            };
            switchBar.onkey_LEFT=switchBar.onkey_RIGHT=
            switchBar.onkey_ENTER = function (focus) {
                switch(groupname){
                    case "Video_Description_group":
                        switchComp.switch();
                        VideoDescriptionEnterHandler(switchComp.flag);
                        break;
                    case "Audio_Menu_Prompts_group":
                        AudioPromptsEnterHandler(switchComp.flag);
                        switchComp.switch();
                        break;
                    case "High_Contrast_Menu_group":
                        switchComp.switch();
                        HighControlEnterHandler(switchComp.flag);
                        if (switchComp.flag) {
                            UI.base.toHiContrast(focus);
                        } else {
                            UI.base.toNormalContrast(focus);
                        }
                        UI.updateStage();
                        break;
                    default:
                        break;
                }
            };
            UI.updateStage();
        }
        catch(ex){DBG_ERROR("Switchbar_common func is error"+ex.message);}
    }

    function getLastSubModule(){
        return MenuChipTTS_page.caller;
    }
    function initTitleContent(){
        try{
            for(var i=0;i<Group_array.length;i++){
                var TitleContent=UI.getItem(UI.getItem(MenuChipTTS_page,Group_array[i]),"group_name");
                UI.setText(TitleContent,MenuChipTTSItemContent[Group_array[i]]);
            }
        }catch(ex){DBG_ERROR(ex.message)}
    }

    function AudioPromptsEnterHandler( flag ) {
        var type = flag == true ? 0 : 1;
        DBG_INFO("Audio type:" + type);
        setTTSSwitch(type);
    }

    function VideoDescriptionEnterHandler(flag){
        var type = flag == true ? 1 : 0;
        setVideoDescription(type);
    }

    function enableAudioMPS(){
        return (GLOBAL.CURRENT_COUNTRY == 'CAN' ? false :true)
    }

    function curDisplayItemHandler(){
        var curItemArray=['Audio_Menu_Prompts_group','Video_Description_group','High_Contrast_Menu_group'];
        var curDisplayItems = [], curNotDisplayItemsContainer = [], sortByDisplayItems=[], sortByDisplayItemsContainer = [];

        if(GLOBAL.TUNER_AVAILIBALE){
            curDisplayItems.push(curItemArray[1]);
        }
        if(enableAudioMPS()){
            curDisplayItems.push(curItemArray[0]);
        }
        curDisplayItems.push(curItemArray[2]);

        for(var i=0; i < curItemArray.length; i++){
            if(curDisplayItems.indexOf(curItemArray[i])>-1){
                sortByDisplayItemsContainer.push(UI.getItem(MenuChipTTS_page ,curItemArray[i]));
                sortByDisplayItems.push(curItemArray[i]);
            }else{
                curNotDisplayItemsContainer.push(UI.getItem(MenuChipTTS_page ,curItemArray[i]));
            }
        }
        if(!sortByDisplayItemsContainer.length){
            DBG_ERROR('sortByDisplayItemsContainer  is error:'+sortByDisplayItemsContainer);
        }
        defaultFocus=sortByDisplayItemsContainer[0];

        for(var i=0; i < curNotDisplayItemsContainer.length; i++){
            curNotDisplayItemsContainer[i].alpha = 0;
            curNotDisplayItemsContainer[i].downTo = '';
            curNotDisplayItemsContainer[i].upTo = '';
        }
        var initPositionY=sortByDisplayItemsContainer[0].getBounds().height/2;

        for(var i=0 ; i < sortByDisplayItemsContainer.length ;i++){
            sortByDisplayItemsContainer[i].alpha = 1;
            sortByDisplayItemsContainer[i].y = initPositionY +itemLineHeight*i;

            if(i == 0){
                sortByDisplayItemsContainer[i].upTo= '';
            }
            if (i < sortByDisplayItemsContainer.length-1){
                sortByDisplayItemsContainer[Math.min(i+1,sortByDisplayItemsContainer.length-1)].upTo=sortByDisplayItems[i];
            }
            if(i == sortByDisplayItemsContainer.length-1){
                sortByDisplayItemsContainer[i].downTo = ''
            }else{
                sortByDisplayItemsContainer[i].downTo = sortByDisplayItems[Math.min(i+1,sortByDisplayItemsContainer.length-1)];
            }
        }
    }
}