UI.moduleBuilder['setting']['KeypadToast'] = function(){
    var KeypadToastData = {
        Bg:{color:0x222536},
        BottomBg:{color:0x282C40},
        RedKeyPad:"setting/bt_red.png",
        GreenKeyPad:"setting/bt_green.png",
        YellowKeyPad:"setting/bt_yellow.png",
        BlueKeyPad:"setting/bt_blue.png",
        EnterPad:"setting/bt_enter.png"

    };
    var template = Util.readJson("module/setting/KeypadToast.json");
    var KeypadToast = SubModule.create(KeypadToastData, template);
    var NumPadList = UI.getItem(KeypadToast, "NumPadList");
    var ColorPadList = UI.getItem(KeypadToast, "ColorPadList");
    var EnterPad = UI.getItem(KeypadToast, "EnterPad");


    var info = {
        template: "NumKeyPadTile",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 3,
        distanceX: 12,
        distanceY: 18,
        container: NumPadList
    };
    var allArray = [];
    var NumData = ["1", "2", "3", "4", "5", "6", "7", "8", "9","-","0"," "];
    var ColorValue = "0x475275";
    initKpad();
    function initKpad(){
        for (var i = 0; i < 11; i++) {
            if(GLOBAL.HICONTRAST && i ==0 ){
                ColorValue = "0x000000";
            }else{
                ColorValue = "0x475275";
            }
                var target = UI.getItem(NumPadList, "NumData"+i);
                if(!!target){
                    UI.setImage(target.children[0],{color:ColorValue});
                }

            allArray.push(
                {
                    tileBg: {color:ColorValue},
                    Num: NumData[i],
                    name: "NumData" + i
                }
            )
        }
        UI.setImage(RedKeyPad,"setting/bt_red.png");
        UI.setImage(GreenKeyPad,"setting/bt_green.png");
        UI.setImage(YellowKeyPad,"setting/bt_yellow.png");
        UI.setImage(BlueKeyPad,"setting/bt_blue.png");
        UI.setImage(EnterPad,"setting/bt_enter.png");
        UI.updateStage();
    }
    Gird.create(allArray, info);
    info.container = NumPadList;
    KeypadToast.focusRing=new PIXI.Graphics();
    KeypadToast.focusRing.clear().lineStyle(4, 0xFFFFFF, 0.8).drawRect(0, 0,96,60);
    KeypadToast.focusRing.pivot.x = 96 / 2;
    KeypadToast.focusRing.pivot.y = 60 / 2;
    ColorPadList.focusRing=new PIXI.Graphics();
    ColorPadList.focusRing.clear().lineStyle(4, 0xFFFFFF, 0.8).drawRect(0, 0,69,43);
    ColorPadList.focusRing.pivot.x = 69 / 2;
    ColorPadList.focusRing.pivot.y = 43 / 2;
    ColorPadList.addChild(ColorPadList.focusRing);
    NumPadList.addChild(KeypadToast.focusRing);
    var Num = UI.getItem(NumPadList, "NumData0");
    var Num3 = UI.getItem(NumPadList, "NumData2");
    var Num6 = UI.getItem(NumPadList, "NumData5");
    var Num9 = UI.getItem(NumPadList, "NumData8");
    var Num1 = UI.getItem(NumPadList, "NumData0");
    var Num2 = UI.getItem(NumPadList, "NumData1");
    var Num4 = UI.getItem(NumPadList, "NumData3");
    var sign = UI.getItem(NumPadList, "NumData9");
    var Num7 = UI.getItem(NumPadList, "NumData6");
    var Num0 = UI.getItem(NumPadList, "NumData10");
    var RedKeyPad =  UI.getItem(KeypadToast, "RedKeyPad");
    var GreenKeyPad =  UI.getItem(KeypadToast, "GreenKeyPad");
    var YellowKeyPad =  UI.getItem(KeypadToast, "YellowKeyPad");
    var BlueKeyPad =  UI.getItem(KeypadToast, "BlueKeyPad");
    RedKeyPad.downTo = "NumData0";
    GreenKeyPad.downTo = "NumData1";
    YellowKeyPad.downTo = "NumData1";
    BlueKeyPad.downTo = "NumData2";
    Num1.upTo = "RedKeyPad";
    Num2.upTo = "GreenKeyPad";
    Num3.upTo = "BlueKeyPad";
    Num1.leftTo = null;
    Num4.leftTo = "NumData2";
    Num7.leftTo = "NumData5";
    Num0.rightTo = "EnterPad";
    Num1.downTo = "NumData3";
    Num3.rightTo = "NumData3";
    Num6.rightTo = "NumData6";
    Num9.rightTo = "NumData9";
    sign.leftTo = "NumData8";
    EnterPad.leftTo = "NumData10";
    EnterPad.upTo = "NumData8";
    Num9.downTo = "EnterPad";
    KeypadToast.onPush = function () {
        initKpad();
        UI.popGhostModule("LayoutToast");
        APPMODULE.LayoutToast = null;
        if(checkIsAppOn()&& UI.getCurrModule().name=="base"){
            DBG_INFO("checkIsAppOn is right and currmodule name is:" + UI.getCurrModule().name);
            registerKeyCodesForKeypad();
        }
        Num = UI.getItem(NumPadList, "NumData0");
        addFocusStyle(Num);
        UI.setKpadTimeout(autoExitKpad, 15 * 1000);
    };
    KeypadToast.onPop = function () {
        if(checkIsAppOn()&& UI.getCurrModule().name=="base"){
            registerKeyCodesForApp();
        }
        UI.clearKpadTimeout();
    };
    KeypadToast.onkey_BACKSPACE = KeypadToast.onkey_ESCAPE = function () {
        if(checkIsAppOn()&& UI.getCurrModule().name=="base"){
            registerKeyCodesForApp();
        }
        UI.popGhostModule("KeypadToast");
        APPMODULE.KpadToast = null;
    };

    function autoExitKpad(){
        APPMODULE.KpadToast = null;
        UI.popGhostModule("KeypadToast");
    }

    KeypadToast.onkey_ENTER = function () {

        switch(Num.name) {
            case "NumData10":
                UI.send_key_to_dfb(guijs.SYSCMD_0);
                break;
            case "NumData0":
                UI.send_key_to_dfb(guijs.SYSCMD_1);
                break;
            case "NumData1":
                UI.send_key_to_dfb(guijs.SYSCMD_2);
                break;
            case "NumData2":
                UI.send_key_to_dfb(guijs.SYSCMD_3);
                break;
            case "NumData3":
                UI.send_key_to_dfb(guijs.SYSCMD_4);
                break;
            case "NumData4":
                UI.send_key_to_dfb(guijs.SYSCMD_5);
                break;
            case "NumData5":
                UI.send_key_to_dfb(guijs.SYSCMD_6);
                break;
            case "NumData6":
                UI.send_key_to_dfb(guijs.SYSCMD_7);
                break;
            case "NumData7":
                UI.send_key_to_dfb(guijs.SYSCMD_8);
                break;
            case "NumData8":
                UI.send_key_to_dfb(guijs.SYSCMD_9);
                break;
            case "NumData9":
                UI.send_key_to_dfb(guijs.SYSCMD_DIGIT_DOT);
                break;
            case "RedKeyPad":
                UI.send_key_to_dfb(guijs.SYSCMD_RED);
                break;
            case "GreenKeyPad":
                UI.send_key_to_dfb(guijs.SYSCMD_GREEN);
                break;
            case "YellowKeyPad":
                UI.send_key_to_dfb(guijs.SYSCMD_YELLOW);
                break;
            case "BlueKeyPad":
                UI.send_key_to_dfb(guijs.SYSCMD_BLUE);
                break;
            case "EnterPad":
                UI.popGhostModule("KeypadToast");
                APPMODULE.KpadToast = null;
                return true;
            default :
                break;
        }

    };

    KeypadToast.onkey_RIGHT = function () {
        var LastTarget = Num;
        if(Num.rightTo) {
            Num = UI.getItem(KeypadToast, Num.rightTo);
            addFocusStyle(Num,LastTarget);
        }
        UI.updateStage();
    };
    KeypadToast.onkey_DOWN = function () {
        var LastTarget = Num;
        if (Num.downTo) {
            Num = UI.getItem(KeypadToast, Num.downTo);
            addFocusStyle(Num,LastTarget);
        }
    };
    KeypadToast.onkey_UP = function () {
        var LastTarget = Num;
        if (Num.upTo) {
            Num = UI.getItem(KeypadToast, Num.upTo);
            addFocusStyle(Num,LastTarget);
        }
    };
    KeypadToast.onkey_LEFT = function () {
        var LastTarget = Num;
        if (Num.leftTo) {
            Num = UI.getItem(KeypadToast, Num.leftTo);
            addFocusStyle(Num,LastTarget);
        }
    };

    function addFocusStyle(target,lasttarget){
        if(target.parent.name =="NumPadList"){
            if(GLOBAL.TTS && target.name != "EnterPad"){
                UI.callTTS(target.data.Num);
                DBG_INFO("current k-pad is: " + target.data.Num);
            }
            KeypadToast.focusRing.alpha = 1;
            ColorPadList.focusRing.alpha = 0;
            KeypadToast.focusRing.x = target.x;
            KeypadToast.focusRing.y = target.y;
            if(GLOBAL.HICONTRAST){
                if(target.name == "EnterPad"){
                    UI.setImage(lasttarget.children[0],{color:"0x475275"});
                    UI.setImage(target,"setting/bt_enterhigh.png");
                }else if(lasttarget && lasttarget.name == "EnterPad"){
                    UI.setImage(lasttarget,"setting/bt_enter.png");
                    UI.setImage(target.children[0],{color:"0x000000"});
                }else if(lasttarget && lasttarget.name == "RedKeyPad"){
                    UI.setImage(lasttarget,"setting/bt_red.png");
                    UI.setImage(target.children[0],{color:"0x000000"});
                }else if(lasttarget && lasttarget.name == "GreenKeyPad"){
                    UI.setImage(lasttarget,"setting/bt_green.png");
                    UI.setImage(target.children[0],{color:"0x000000"});
                }else if(lasttarget && lasttarget.name == "YellowKeyPad"){
                    UI.setImage(lasttarget,"setting/bt_yellow.png");
                    UI.setImage(target.children[0],{color:"0x000000"});
                }else if(lasttarget && lasttarget.name == "BlueKeyPad"){
                    UI.setImage(lasttarget,"setting/bt_blue.png");
                    UI.setImage(target.children[0],{color:"0x000000"});
                }else if(lasttarget){
                    UI.setImage(lasttarget.children[0],{color:"0x475275"});
                    UI.setImage(target.children[0],{color:"0x000000"});
                }
            }
        }else{
            KeypadToast.focusRing.alpha = 0;
            ColorPadList.focusRing.alpha = 1;
            ColorPadList.focusRing.x = target.x;
            ColorPadList.focusRing.y = target.y;
            if(GLOBAL.HICONTRAST){
                UI.setImage(lasttarget.children[0],{color:"0x475275"});
                if(target.name == "RedKeyPad" && lasttarget.name == "GreenKeyPad"){
                    UI.setImage(lasttarget,"setting/bt_green.png");
                    UI.setImage(target,"setting/bt_redhigh.png");
                }else if(target.name == "RedKeyPad"){
                    UI.setImage(target,"setting/bt_redhigh.png");
                }else if(target.name == "GreenKeyPad" && lasttarget.name == "RedKeyPad"){
                    UI.setImage(lasttarget,"setting/bt_red.png");
                    UI.setImage(target,"setting/bt_greenhigh.png");
                }else if(target.name == "GreenKeyPad" && lasttarget.name == "NumData1"){
                    UI.setImage(target,"setting/bt_greenhigh.png");
                    UI.setImage(lasttarget.children[0],{color:"0x475275"});
                }else if(target.name == "GreenKeyPad" && lasttarget.name == "YellowKeyPad"){
                    UI.setImage(lasttarget,"setting/bt_yellow.png");
                    UI.setImage(target,"setting/bt_greenhigh.png");
                }else if(target.name == "YellowKeyPad" && lasttarget.name == "BlueKeyPad"){
                    UI.setImage(lasttarget,"setting/bt_blue.png");
                    UI.setImage(target,"setting/bt_yellowhigh.png");
                }else if(target.name == "YellowKeyPad"){
                    UI.setImage(lasttarget,"setting/bt_green.png");
                    UI.setImage(target,"setting/bt_yellowhigh.png");
                } else if(target.name == "BlueKeyPad" && lasttarget.name == "NumData2"){
                    UI.setImage(target,"setting/bt_bluehigh.png");
                    UI.setImage(lasttarget.children[0],{color:"0x475275"});
                }else if(target.name == "BlueKeyPad"){
                    UI.setImage(lasttarget,"setting/bt_yellow.png");
                    UI.setImage(target,"setting/bt_bluehigh.png");
                }
            }else{

            }
        }
        UI.updateStage();
    }
};