/**
 * Created by Hisense on 2016-2-29.
 */
// Init
UI.moduleBuilder['setting']['AudioSAPList'] = function(){

    var initData = {
        AudioSAPListBg: UI.window_bg,
        SAPTitle:"[SE0827]"//SAP
    };
    var template = Util.readJson("module/setting/AudioSAPList.json");
    var AudioSAPList = SubModule.create(initData, template);

    AudioSAPList.operateData = {
        "SAPList": [
            {
                "map": 0,
                "name": "[SE0828]",//SE0828 : "Mono",
                "flag": false
            },
            {
                "map": 1,
                "name": "[SE0453]",//SE0453 : "Stereo",
                "flag": false
            },
            {
                "map": 2,
                "name": "[SE0827]",//[SE0827] : SAP
                "flag": false
            }
        ],
        "currSapIdx": 0
    };
    function SndgetSapIdx() {
        try {

            var Saptmp = tv ? model.sound.getSap() : 1;
            DBG_INFO("model.sound.getSap=" + Saptmp);
            for (var i = 0; i < AudioSAPList.operateData.SAPList.length; i++) {
                if (Saptmp == AudioSAPList.operateData.SAPList[i].map) {
                    break;
                }
            }
            return i;

        } catch (ex) {
            DBG_ERROR("SndgetSapIdx:" + ex.message);
        }
    }

    // 初始化Grid控件
    // 取得目标锚点
    var List = UI.getItem(AudioSAPList, "List");

    // Grid的配置信息JSON
    var info = {
        // 每个图标使用的模板名
        template: "DialogListItem",
        // V表示竖向排列，H表示横向排列
        direction: CONST.GIRD_DIRECTION.H,
        // 每隔几个图标就换行
        breakNum: 1,
        // 每隔图标之间的距离
        distanceX: 0,
        distanceY: 20,
        // 要将此Grid添加到哪个锚点位置上
        container: List
    };

    // 声明一个初始化用数组，将数据配置好
    var allArray = [];
    for (var i = 0; i < AudioSAPList.operateData.SAPList.length; i++) {
        allArray.push(
            {
                ItemName: AudioSAPList.operateData.SAPList[i].name,
                tileBg: UI.item_bg,
                name: "item" + i,
                isFlag: "setting/ic_radiobutton_normal.png"
            }
        )
    }
    // 调用Grid.create方法生成Gird并添加到锚点位置上
    Gird.create(allArray, info);

    AudioSAPList.onPush = function () {
        AudioSAPList.operateData.currTunerModeIdx = SndgetSapIdx();
        DBG_INFO("setAudioSAPList.onPush");
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png");
        }
        AudioSAPList.currFocus = UI.getItem(List, "item" + AudioSAPList.operateData.currTunerModeIdx);
        UI.setImage(AudioSAPList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage());
        UI.updateStage();
    };

    function SndSetCurrSapIdx(idx) {
        try {
            AudioSAPList.operateData.currSapIdx = idx;

            var SAPMapList = AudioSAPList.operateData.SAPList;
            if (idx > SAPMapList.length - 1) {
                DBG_ERROR("SndSetCurrSapIdx:idx=" + idx);
                idx = 0;
            }
            DBG_INFO("model.sound.setSap:" + SAPMapList[idx].map);
            tv ? model.sound.setSap(SAPMapList[idx].map) : 1;

        } catch (ex) {
            DBG_ERROR("SndSetCurrSapIdx:" + ex.message);
        }

    }

    List.onkey_ENTER = function (focus) {
        var index = List.initSequence.indexOf(focus);//AudioSAPList.currFocus.name.slice(-1);
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png");
        }
        UI.setImage(AudioSAPList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage());
        SndSetCurrSapIdx(index);
//        UI.clearAllSubModule("setting");
//        openLiveTVModule([Msg.INFO, 0]);
//        return true;
    };
    List.onkey_BACKSPACE = function () {
        UI.popSubModule();
        if(window["setting"]["menuChip"]){
            window["setting"]["menuChip"].open();
        }
        else {
            UI.pushSubModule("setting","menuChip",true,AudioSAPList.param,null,"CHIP"+ CHIPS.SAP);

        }
    }

};