// Init
UI.moduleBuilder['setting']['AudioAdvanceDTS'] = function(){

    var AudioAdvanceDTSData = {
        audioSheetImg: UI["setting_bg"],
        audioImg1: "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_audio_154x154.png",
        sndModeImg1: UI.btn_normal_bg,
        audiotitle1:"[SE0058]",//Sound
        autoVolumeControlTitle:"[SE0411]",
        preAudioLanTitle:"[SE0684]"//Preferred Audio Language
    };
    var template = Util.readJson("module/setting/AudioAdvanceDTS.json");
    var AudioAdvanceDTS = SubModule.create(AudioAdvanceDTSData, template);

    var audioRightGrp = UI.getItem(AudioAdvanceDTS, "audioRightGrp");
    var autoVolumeControlMenu = UI.getItem(AudioAdvanceDTS,"autoVolumeControlMenu");
    var preAudioLanMenu = UI.getItem(audioRightGrp, "preAudioLanMenu");
    var CurrPreAudioLan = UI.getItem(preAudioLanMenu, "CurrPreAudioLan");
    AudioAdvanceDTS.currFocus = autoVolumeControlMenu;
    AudioAdvanceDTS.pageData = {

        "audioLan": ["English", "Français", "Español"],//["English", "French", "Spanish"]

        ARCDeviceWorkingState: {
            Working: 1,
            RestIng: 0
        },
        autoVolumeControlVec: [0,0,0,0,0]
    };
    /*UI.addMask(audioRightGrp, 1148, 926, 80, 6);
    UI.setView(audioRightGrp, 1148, 926);*/
    //UI.addScrollbar(audioRightGrp);


    AudioAdvanceDTS.onPush = function(){
        try{
            initSwitchData(audioRightGrp, "autoVolumeControlMenu", "autoVolumeControlSwitchImg");
            var speakerArc = tv ? model.sound.getSpeakerArc() : 2;
            disableAutoVolume(speakerArc);
            UI.updateStage();

            if(tv){
                try{
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_FAVOURED, AudioFavouredChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_AVC_OUTPUT, AudioAVCOutputChaged);
                }
                catch (ex){
                    DBG_ERROR(ex.message)
                }
            }
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }

    };
    AudioAdvanceDTS.onShow = function () {
        try {
            UI.getItem(setting, 'AudioMainPanel').alpha = 0;
            AudioAdvanceDTS.alpha = 1;
            getPreAudioLan();
        }catch (ex) {
            DBG_ERROR(ex.message);
        }

    };
    function initSwitchData(submodule, groupname, pic_switch) {
        try {
            var switchBar = UI.getItem(submodule, groupname);
            var switchComp = UI.getItem(switchBar, pic_switch);
            switch (groupname) {
                case "autoVolumeControlMenu":
                    var tmpDataAvc = tv?createArray(model.sound.getAvcOutput()):[0,0,0,0,0];
                    DBG_INFO("model.sound.getAvcOutput():" + objToString(tmpDataAvc));
                    AudioAdvanceDTS.pageData.autoVolumeControlVec = tmpDataAvc;
                    var tmpData = tmpDataAvc[0];
                    DBG_INFO("tmpDataAvc[0]:" + tmpDataAvc[0]+"  tmpDataAvc[1]: "+tmpDataAvc[1]);
                    switchComp.setSwitch(tmpData);
                    break;
                default:
                    break;
            }
            UI.updateStage();
        } catch (ex) {
            DBG_ERROR(ex.message)
        }
    }

    function disableAutoVolume(val) {
        if (val ==1) {
            autoVolumeControlMenu.alpha = 1;
            autoVolumeControlMenu.disable = false;
            AudioAdvanceDTS.currFocus = autoVolumeControlMenu;
        } else {
            autoVolumeControlMenu.alpha = 0.3;
            autoVolumeControlMenu.disable = true;
            AudioAdvanceDTS.currFocus = preAudioLanMenu;
        }
    }

    function getPreAudioLan() {
        try {
            var tmppreAudioLan = tv ? model.language.getAudioFavoured() : 1;
            DBG_INFO("model.language.getAudioFavoured:" + tmppreAudioLan);
            AudioFavouredChaged(tmppreAudioLan);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function PreAudioMap(val) {
        try {
            if (1 == val) {
                return 0;
            } else if (2 == val) {
                return 1;
            } else if (4 == val) {
                return 2;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function AudioFavouredChaged(val){
        try{
            DBG_INFO("AudioFavouredChaged:"+val);
            var preAudioLan = PreAudioMap(val);
            CurrPreAudioLan.selectCurrent(preAudioLan);
        }
        catch (ex){
            DBG_ERROR(ex.message)
        }
    }

    function AudioAVCOutputChaged(val) {
        try {
            DBG_INFO("model.sound.AudioAVCOutputChaged():" + objToString(createArray(val)));
            var tmpAVC = tv ? createArray(val) : [0,0,0,0,0];
            AudioAdvanceDTS.pageData.autoVolumeControlVec = tmpAVC;
            var tmpAVCData = tmpAVC[0];
            DBG_INFO("tmpAVC[0]:" + tmpAVC[0]+"  tmpAVC[1]: "+tmpAVC[1]);
            switchComp.setSwitch(tmpAVCData);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    var audioLeftGrp = UI.getItem(AudioAdvanceDTS, "audioLeftGrp");
    var audioHelpInfo = UI.getItem(AudioAdvanceDTS, "audioHelpInfo");
    var audioInfoGrp = UI.getItem(AudioAdvanceDTS, "audioLeftGrp");
    var audiotitle1 = UI.getItem(audioInfoGrp, "audiotitle1");



    switchBar_common(AudioAdvanceDTS, "autoVolumeControlMenu", "autoVolumeControlSwitchImg");
    selectBar_common(AudioAdvanceDTS, "preAudioLanMenu", "preAudioLanTitle", "CurrPreAudioLan", AudioAdvanceDTS.pageData.audioLan, "AudioPreLanList");


    AudioAdvanceDTS.sndHelpInfo = {
        autoVolumeControlMenu: {
            title: "auto Volume Control",
            info: "[OT0446]"//Activate to prevent the volume from changing when you switch TV channels
        },
        preAudioLanMenu: {
            title: "Preferred Audio Language",
            info: "[SE0685]"//"Set the default audio output language for the type of digital broadcast content that you're viewing."
        }
    };
    function sndMainPageHelpInfo(id) {
        //UI.setText(audiotitle1,AudioAdvanceDTS.sndHelpInfo[id].title);
        UI.setText(audioHelpInfo, AudioAdvanceDTS.sndHelpInfo[id].info);
    }


    function selectBar_common(submodule, group_name, select_title, select_txt, item_value_arrary, subname) {
        try {
            var selectBar = UI.getItem(submodule, group_name);
            var selectComp = UI.getItem(selectBar, select_txt);
            Select.create(selectComp, item_value_arrary);

            selectBar.onFocus = function () {
                sndMainPageHelpInfo(group_name);
                return true;
            };
            selectBar.onkey_RIGHT = function () {
                selectComp.selectNext();
                UI.updateStage();
                var index = item_value_arrary.indexOf(selectComp.selected);
                DBG_INFO("set " + group_name + ":" + index);
                selectBarMoveHandler(group_name, index);

            };
            selectBar.onkey_LEFT = function () {
                selectComp.selectPrev();
                UI.updateStage();
                var index = item_value_arrary.indexOf(selectComp.selected);
                DBG_INFO("set " + group_name + ":" + index);
                selectBarMoveHandler(group_name, index);
            };
            selectBar.onkey_ENTER = function () {
                UI.pushSubModule("setting", subname, true);
            }

        }
        catch (e) {
            DBG_ERROR("Selectbar_common func is error");
        }
    }

    function switchBar_common(submodule, groupname, pic_switch_name) {
        try {
            var switchBar = UI.getItem(submodule, groupname);
            var switchComp = UI.getItem(switchBar, pic_switch_name);
            Switch.create(switchComp, true);
            UI.updateStage();
            switchBar.onFocus = function () {
                switchComp.onFocus();
                sndMainPageHelpInfo(groupname);
                UI.updateStage();
                return true;
            };
            switchBar.onkey_ENTER = function () {
                switchMove();
            };
            switchBar.onkey_LEFT = function(){
                switchMove();
            };
            switchBar.onkey_RIGHT = function(){
                switchMove();
            };
            function switchMove(){
                try{
                    switchComp.switch();
                    UI.updateStage();
                    var AutoVolumeControlFlag = switchComp.flag == true ? 1 : 0;
                    AudioAdvanceDTS.pageData.autoVolumeControlVec[0]=AutoVolumeControlFlag;
                    DBG_INFO("model.sound.setAvcOutput:" + AudioAdvanceDTS.pageData.autoVolumeControlVec);
                    (!!tv)&&model.sound.setAvcOutput(createIntergerVector(AudioAdvanceDTS.pageData.autoVolumeControlVec));
                }
                catch (ex){
                    DBG_ERROR(ex.message);
                }
            }
        }
        catch (e) {
            DBG_ERROR("Switchbar_common func is error");
        }
    }

    function selectBarMoveHandler(group_name, index) {
        switch (group_name) {
            case "preAudioLanMenu":
                var prelan = PreAudioMapOpp(index);
                DBG_INFO("model.language.setAudioFavoured:" + prelan);
                tv ? model.language.setAudioFavoured(prelan) : true;
                break;
            default:
                break;


        }
    }

    function PreAudioMapOpp(val) {
        try {
            if (0 == val) {
                return 1;
            } else if (1 == val) {
                return 2;
            } else if (2 == val) {
                return 4;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    AudioAdvanceDTS.onPop = function () {
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_FAVOURED, AudioFavouredChaged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_AVC_OUTPUT, AudioAVCOutputChaged);
    }

};
