// Init
UI.moduleBuilder['setting']['picReset'] = function(){

    var initData = {
        allBg: UI['bg_overlay'],
        resetDialogBg: UI.window_bg,
        okBtnBg: UI.item_bg,
        cancelBtnBg: UI.item_bg
    };
    var template = Util.readJsonObject("module/setting/picReset.json");

    var picResetData = {
        picReset: {
            resetTitle: '[SE0532]',//'Restore Current Picture Mode Settings',
            resetInfo: '[SE2043]',//'This will reset current picture settings to factory mode. Do you want to continue?"',//'This will reset current picture settings to factory mode. Do you want to continue?',
            okBtnText: '[GE0007]',
            cancelBtnText: '[GE0008]'
        },
        picColorTunerReset: {
            resetTitle: '[SE3563]',
            resetInfo: '[SE3564]',
            okBtnText: '[GE0007]',
            cancelBtnText: '[GE0008]'
        },
        picBalance2PotReset: {
            resetTitle: '[SE1884]',
            resetInfo: '[SE0510]',
            okBtnText: '[GE0007]',
            cancelBtnText: '[GE0008]'
        },
        picBalance10PotReset: {
            resetTitle: '[SE1884]',
            resetInfo: '[SE0510]',
            okBtnText: '[GE0007]',
            cancelBtnText: '[GE0008]'
        },
        picGammaCalibrationReset: {
            resetTitle: '[SE3569]',
            resetInfo: '[SE3570]',
            okBtnText: '[GE0007]',
            cancelBtnText: '[GE0008]'
        }
    };

    DBG_INFO("PictureConfig.PicResetSign:" + PictureConfig.PicResetSign);
    template.picReset.items.resetDialog.items.resetTitle.value = picResetData[PictureConfig.PicResetSign].resetTitle;
    template.picReset.items.resetDialog.items.resetInfo.value = picResetData[PictureConfig.PicResetSign].resetInfo;
    template.picReset.items.resetDialog.items.okBtn.items.okBtnText.value = picResetData[PictureConfig.PicResetSign].okBtnText;
    template.picReset.items.resetDialog.items.cancelBtn.items.cancelBtnText.value = picResetData[PictureConfig.PicResetSign].cancelBtnText;

    var picReset = SubModule.create(initData, template);

    picReset.onPush = function () {
        UI.setText(UI.getItem(picReset, 'resetTitle'), picResetData[PictureConfig.PicResetSign].resetTitle);
        UI.setText(UI.getItem(picReset, 'resetInfo'), picResetData[PictureConfig.PicResetSign].resetInfo);
        UI.updateStage();
        UI.getCurrModule().currFocus = picReset.currFocus = UI.getItem(picReset, "cancelBtn");
    };

    picReset.onShow = function () {
        PictureConfig.PicResetSign == "picReset" ? picReset.noAutoClose = false : picReset.noAutoClose = true;
        picReset.alpha = 1;
    };

    //var picReset = UI.getSubModule("picReset");
    var okBtn = UI.getItem(picReset, "okBtn");
    var cancelBtn = UI.getItem(picReset, "cancelBtn");

    function setModelValue() {
        try {
            DBG_INFO('PictureConfig.PicResetSign: ' + PictureConfig.PicResetSign);
            switch (PictureConfig.PicResetSign) {
                case PicSignDefine.PicResetSign.PIC_RESET:
                    tv && model.video.ResetDefaultPictureSettings(1);   //参数无意义
                    DBG_INFO("model.video.ResetDefaultPictureSettings(1)");
                    break;
                case PicSignDefine.PicResetSign.PIC_COLOR_TUNER_RESET:
                    tv && model.video.ResetColorTunerSettings();
                    DBG_INFO("model.video.ResetColorTunerSettings()");
                    break;
                case PicSignDefine.PicResetSign.PIC_BALANCE_2_POT_RESET:
                    tv && model.video.ResetWhiteBalanceSettings();
                    DBG_INFO("model.video.ResetWhiteBalanceSettings()");
                    break;
                case PicSignDefine.PicResetSign.PIC_BALANCE_10_POT_RESET:
                    var is20PointSupport = tv ? model.video.getwbfeature() : 1;
                    if(is20PointSupport) {
                        tv && model.video.Reset20PointWhiteBalanceSettings();
                        DBG_INFO("model.video.Reset20PointWhiteBalanceSettings()");
                    } else {
                        tv && model.video.Reset10PointWhiteBalanceSettings();
                        DBG_INFO("model.video.Reset10PointWhiteBalanceSettings()");
                    }
                    break;
                case PicSignDefine.PicResetSign.PIC_GAMMA_CALIBRATION_RESET:
                    tv && model.video.ResetGammaCalibration();
                    DBG_INFO("model.video.ResetGammaCalibration()");
                    break;
                default:
                    DBG_ERROR('PictureConfig.PicResetSign Err' + PictureConfig.PicResetSign);
                    break;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    okBtn.onkey_ENTER = function () {
        if(PictureConfig.PicResetSign == 'picBalance10PotReset'){
            PictureConfig.PicOKOrCancelSign = PicSignDefine.PicOKOrCancelSign.PIC_OK;
            DBG_INFO("PictureConfig.PicOKOrCancelSign: " + PictureConfig.PicOKOrCancelSign);
        }
        setModelValue();
        UI.popSubModule();
        return true;
    };
    cancelBtn.onkey_ENTER = function () {
        if(PictureConfig.PicResetSign == 'picBalance10PotReset'){
            PictureConfig.PicOKOrCancelSign = PicSignDefine.PicOKOrCancelSign.PIC_CANCEL;
            DBG_INFO("PictureConfig.PicOKOrCancelSign: " + PictureConfig.PicOKOrCancelSign);
        }
        UI.popSubModule();
        return true;
    };

};