/**
 * Created by manli1 on 2016-4-26.
 */
UI.moduleBuilder['setting']['picPQ2Adjust'] = function(){
    var picPQ2AdjustData = {
        percentBG: UI["liveTV_bg"],
        disable_bg: UI.disable_bg
    };
    var template = Util.readJsonObject("module/setting/picPQ2Adjust.json");
    DBG_INFO("PictureConfig.PQ2AdjustSign: " + PictureConfig.PQ2AdjustSign);

    var picPQ2Adjust = SubModule.create(picPQ2AdjustData, template);

    var picPQ2AdjustPageData = {
        PQ2AdjustVal: 0
    };
    var PQ2SignFlag = {
        TintFlag: 0,
        SharpnessFlag: 1,
        JudderFlag: 2,
        BlurFlag: 3
    };
    var CustomIndx = 4;
    var SignFlag;
    // ['Tint', 'Sharpness',"Judder Reduction", 'Blur Reduction'];
    var pctCmpValueVec = ['[SE0054]', '[SE0053]', '[SE3141]', '[SE3142]'];
    var pctCmpDescriptionVec = ['[SE0479]', '[SE0480]', ' ',' '];
    var title = UI.getItem(picPQ2Adjust, "title");
    var description = UI.getItem(picPQ2Adjust, "description");

    picPQ2Adjust.onPush = function (){
        SignFlag = getSignFlag();
        UI.setText(description, pctCmpDescriptionVec[SignFlag]);
        UI.setText(title, pctCmpValueVec[SignFlag], false);
        createPercent();
        getPQ2AdjustValue();
        picPQ2Adjust.currFocus = UI.getItem(picPQ2Adjust, "PQ2AdjustPercentBar");
        setOnkeyLeftRightFunc(PQ2AdjustPercentBar, PQ2AdjustPercentComp, picPQ2AdjustPageData.PQ2AdjustVal);
        UI.updateStage();
    };
    picPQ2Adjust.onShow = function () {
        UI.hideCursor();
    };

    var PQ2AdjustPercentBar = UI.getItem(picPQ2Adjust, "PQ2AdjustPercentBar");
    var PQ2AdjustPercentComp = UI.getItem(PQ2AdjustPercentBar, "percentBarLine");
    var PQ2AdjustPercentTxt = UI.getItem(PQ2AdjustPercentBar, "percentBarText");

    function getSignFlag(){
        try {
            var flag;
            switch (PictureConfig.PQ2AdjustSign){
                case PicSignDefine.PQ2AdjustSign.PIC_TINT:
                    flag = PQ2SignFlag.TintFlag;
                    break;
                case PicSignDefine.PQ2AdjustSign.PIC_SHARPNESS:
                    flag = PQ2SignFlag.SharpnessFlag;
                    break;
                case PicSignDefine.PQ2AdjustSign.PIC_JUDDER:
                    flag = PQ2SignFlag.JudderFlag;
                    break;
                case PicSignDefine.PQ2AdjustSign.PIC_BLUR:
                    flag = PQ2SignFlag.BlurFlag;
                    break;
                default:
                    DBG_ERROR("PictureConfig.PQ2AdjustSign is error.")
            }
            return flag;
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    function getPQ2AdjustValue(){
        switch (PictureConfig.PQ2AdjustSign){
            case PicSignDefine.PQ2AdjustSign.PIC_TINT:
                picPQ2AdjustPageData.PQ2AdjustVal = tv ? model.video.getTint() : 2;
                DBG_INFO('model.video.getTint(' +picPQ2AdjustPageData.PQ2AdjustVal + ')');
                break;
            case PicSignDefine.PQ2AdjustSign.PIC_SHARPNESS:
                picPQ2AdjustPageData.PQ2AdjustVal = tv ? model.video.getSharpness() : parseInt(Math.random()*10);
                DBG_INFO('model.video.getSharpness(' +picPQ2AdjustPageData.PQ2AdjustVal + ')');
                break;
            case PicSignDefine.PQ2AdjustSign.PIC_JUDDER:
                picPQ2AdjustPageData.PQ2AdjustVal = tv ? model.video.getJudderReduction() : 5;
                DBG_INFO('model.video.getJudderReduction(' +picPQ2AdjustPageData.PQ2AdjustVal + ')');
                break;
            case PicSignDefine.PQ2AdjustSign.PIC_BLUR:
                picPQ2AdjustPageData.PQ2AdjustVal = tv ? model.video.getBlurReduction() : 6;
                DBG_INFO('model.video.getBlurReduction(' +picPQ2AdjustPageData.PQ2AdjustVal + ')');
                break;
            default:
                DBG_ERROR("PictureConfig.PQ2AdjustSign is error.")
        }
        DBG_INFO("getPQ2AdjustValue(): " + picPQ2AdjustPageData.PQ2AdjustVal);
        PQ2AdjustPercentComp.setPercent(picPQ2AdjustPageData.PQ2AdjustVal);
    }

    function createPercent(){
        if(PictureConfig.PQ2AdjustSign ==  PicSignDefine.PQ2AdjustSign.PIC_JUDDER
            || PictureConfig.PQ2AdjustSign ==  PicSignDefine.PQ2AdjustSign.PIC_BLUR){
            Percent.create(PQ2AdjustPercentComp, PQ2AdjustPercentTxt, picPQ2AdjustPageData.PQ2AdjustVal, 0, 10);
        }else if(PictureConfig.PQ2AdjustSign ==  PicSignDefine.PQ2AdjustSign.PIC_TINT){
            Percent.create(PQ2AdjustPercentComp, PQ2AdjustPercentTxt, picPQ2AdjustPageData.PQ2AdjustVal, -50, 50);
        }else{
            Percent.create(PQ2AdjustPercentComp, PQ2AdjustPercentTxt, picPQ2AdjustPageData.PQ2AdjustVal, 0, 50);
        }
    }

    function setCustomFocus(Idx){
        Idx = ({0: 5, 1: 4, 2: 3, 3: 2, 4: 1, 5: 0}[Idx]);
        var curIdx = tv ? model.video.getEnumSmoothMotion() : 0;
        if (curIdx == Idx){
            return;
        }
        tv && model.video.setEnumSmoothMotion(Idx);
        DBG_INFO("model.video.setEnumSmoothMotion(" + Idx + ")");
    }
    function setOnkeyLeftRightFunc(bar, comp, val) {

        bar.onkey_LEFT = function () {
            DBG_INFO(bar.name + "onkey_LEFT");
            val -= 1;
            var minVal = SignFlag == PQ2SignFlag.TintFlag ? -50 : 0;
            val < minVal && (val = minVal);
            comp.setPercent(val);
            if(SignFlag == PQ2SignFlag.JudderFlag || SignFlag == PQ2SignFlag.BlurFlag){
                setCustomFocus(CustomIndx);
            }
            setPQ2Value(val);
        };
        bar.onkey_RIGHT = function () {
            DBG_INFO(bar.name + "onkey_RIGHT");
            val += 1;
            var maxVal = (SignFlag == PQ2SignFlag.JudderFlag)|| (SignFlag == PQ2SignFlag.BlurFlag)? 10 : 50;
            val > maxVal && (val = maxVal);
            comp.setPercent(val);
            if(SignFlag == PQ2SignFlag.JudderFlag || SignFlag == PQ2SignFlag.BlurFlag){
                setCustomFocus(CustomIndx);
            }
            setPQ2Value(val);
        };
        bar.onFocus = function () {
            return false;
        }
    }
    function setPQ2Value(val){
        switch (PictureConfig.PQ2AdjustSign){
            case PicSignDefine.PQ2AdjustSign.PIC_TINT:
                tv && model.video.setTint(val);
                DBG_INFO('model.video.setTint(' +val + ')');
                break;
            case PicSignDefine.PQ2AdjustSign.PIC_SHARPNESS:
                tv && model.video.setSharpness(val);
                DBG_INFO('model.video.setSharpness(' +val + ')');
                break;
            case PicSignDefine.PQ2AdjustSign.PIC_JUDDER:
                tv && model.video.setJudderReduction(val);
                DBG_INFO('model.video.setJudderReduction(' +val + ')');
                break;
            case PicSignDefine.PQ2AdjustSign.PIC_BLUR:
                tv && model.video.setBlurReduction(val);
                DBG_INFO('model.video.setBlurReduction(' +val + ')');
                break;
            default:
                DBG_ERROR("PictureConfig.PQ2AdjustSign is error.")
        }
    }

    function setOnkeyEnterFunc(cmp){
        cmp.onkey_ENTER = function (focus) {
            return false;
        }
    }
    setOnkeyEnterFunc(picPQ2Adjust);

};