// Init
UI.moduleBuilder['setting']['picBacklightAdjustDelEco'] = function(){
    try {
        // Init sub module

        var initData = {
            bg: "setting/pic/Picture_mode_bg_percent.png",
            percentBG: "setting/pic/Picture_mode_bg_percent.png",
            onImg:"setting/pic/mode/OverScan_On.png",
            offImg:"setting/pic/mode/OverScan_Off.png",
            UpArrow: "setting/pic/card_wheel/UpArrow.png",
            DownArrow: "setting/pic/card_wheel/DownArrow.png",
            cardWheelBg: {color: getCardWheelColor()},
            cardWheelShadow: "setting/pic/card_wheel/shadow_top.png",
            cardWheelIcon_0: "setting/pic/card_wheel/local_dimming.png",
            cardWheelIcon_1: "setting/pic/card_wheel/backlight_level.png"
        };
        var template = Util.readJsonObject("module/setting/picBacklightAdjustDelEco.json");
        var logReportModeVec={
            "DynamicBacklightControl":["Off","Low","Middle","High"],
            "LocalDimming":["Off","Low","Middle","High"],
            "LocalDimmingOnOff":["Off","On"]
        };
        var logReportStr="";

        try {
            var localDimmingSupport = tv ? model.video.getLocalDimmingExist() : 2;
            DBG_INFO('model.video.getLocalDimmingExist(): ' + localDimmingSupport);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

        var picBacklightAdjustCfg = {
            DynamicBacklightControl: {
                title: localDimmingSupport ? '[SE0972]' : '[SE0470]',
                description: localDimmingSupport ? '[SE1070]' : '[SE0471] ',//SE1070 : "Adjust the backlight by sections according to the changes in the image and increase the contrast",
                array: localDimmingSupport ? [
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/off.png", tileTxt: "[GE0006]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/low.png", tileTxt: "[GE0003]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/medium.png", tileTxt: "[SE0052]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/high.png", tileTxt: "[GE0001]"}
                ] : [
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/off.png", tileTxt: "[GE0006]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/low.png", tileTxt: "[GE0003]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/high.png", tileTxt: "[GE0001]"}
                ]
            },
            picLocalDimmingOnOff: {
                title: '[SE0972]',
                description: '[SE1070]',
                array: [
                    {tileBg: UI.btn_normal_bg, tileImg: initData.onImg, Info:"[SE1070]"}//"Off"
                ]
            }
        };
        var LocalDimmingType = {
            DynamicBacklightControl:0,
            LocalDimmingAll:1,
            LocalDimmingOnOff:2
        };
        var TtsOnOff=["[GE0006]", "[GE0005]"];//["Off", "On"],
        try {
            if(LocalDimmingType.LocalDimmingOnOff==localDimmingSupport){
                picBacklightAdjustCfg.DynamicBacklightControl = picBacklightAdjustCfg.picLocalDimmingOnOff;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

        template.picBacklightAdjustDelEco.items.DynamicBacklightControl.items.title.value = picBacklightAdjustCfg.DynamicBacklightControl.title;
        template.picBacklightAdjustDelEco.items.DynamicBacklightControl.items.description.value = picBacklightAdjustCfg.DynamicBacklightControl.description;

        template.picBacklightAdjustDelEco.items.BacklightLevel.position.y = 1500;

        var cardWheel = {
            "type": 0,
            "position": {
                "x": 30,
                "y": 20
            },
            "items": {}
        };

        var cardWheelItem = {
            "type": 0,
            "position": {
                "x": 0,
                "y": 124
            },
            "navigation": {
                "leftTo": null,
                "rightTo": null,
                "upTo": null,
                "downTo": null
            },
            "items": {
                "cardWheelBg": {
                    "type": 7,
                    "bound": {
                        "w": 230,
                        "h": 160
                    },
                    "position": {
                        "x": 0,
                        "y": 0
                    }
                },
                "cardWheelShadow": {
                    "type": 7,
                    "bound": {
                        "w": 280,
                        "h": 200
                    },
                    "position": {
                        "x": -30,
                        "y": -20
                    }
                },
                "cardWheelIcon": {
                    "type": 7,
                    "bound": {
                        "w": 72,
                        "h": 72
                    },
                    "position": {
                        "x": 79,
                        "y": 44
                    }
                }
            }
        };

        // 20 50 150 200 0
        //位置不准确，缩放为中心缩放
        var cardWheelItemIndexVec = [{y: 0}, {y: 95}];

        for (var i = 0; i < cardWheelItemIndexVec.length; i++) {
            var cardWheelItemTemp = getObjCopy(cardWheelItem);
            cardWheelItemTemp.position.y = cardWheelItemIndexVec[i].y;
            cardWheelItemTemp.items['cardWheelIcon_' + i] = getObjCopy(cardWheelItemTemp.items.cardWheelIcon);
            delete (cardWheelItemTemp.items.cardWheelIcon);
            cardWheel.items["cardWheel_" + i] = cardWheelItemTemp;

        }
        template.picBacklightAdjustDelEco.items['cardWheel'] = cardWheel;

        var picBacklightAdjustDelEco = SubModule.create(initData, template);

        var DynamicBacklightControl = UI.getItem(picBacklightAdjustDelEco, "DynamicBacklightControl");
        var DynamicBacklightControlGrid = UI.getItem(DynamicBacklightControl, "grid");
        var DynamicBacklightControlArray = [];
        for (var i = 0; i < picBacklightAdjustCfg.DynamicBacklightControl.array.length; i++) {
            DynamicBacklightControlArray.push(picBacklightAdjustCfg.DynamicBacklightControl.array[i]);
        }
        var DynamicBacklightControlInfo;
        if(LocalDimmingType.LocalDimmingOnOff==localDimmingSupport){
            DynamicBacklightControlInfo = {
                template: "picModeNewTileSecond",
                direction: CONST.GIRD_DIRECTION.V,
                breakNum: 1,
                distanceX: 20,
                distanceY: 0,
                container: DynamicBacklightControlGrid
            };
        }else{
            DynamicBacklightControlInfo = {
                template: "picModeNewTile",
                direction: CONST.GIRD_DIRECTION.V,
                breakNum: 1,
                distanceX: 20,
                distanceY: 0,
                container: DynamicBacklightControlGrid
            };
        }
        Gird.create(DynamicBacklightControlArray, DynamicBacklightControlInfo);
        UI.addMask(DynamicBacklightControlGrid, 1760, 180, 40, 30);
        UI.setView(DynamicBacklightControlGrid, 1760, 180);

        var PicBacklightAdjustPageData = {
            localDimmingOn: 0,
            dynamicBacklightVal: 0,
            backlightVal: 0
        };
        var DynamicLastFocusName;

        picBacklightAdjustDelEco.onPush = function () {
            try {
                DBG_INFO('picBacklightAdjustDelEco.onPush');
                var CmpVec = [DynamicBacklightControl, BacklightLevel];

                for (var i = 0; i < CmpVec.length; i++) {
                    CmpVec[i].alpha = 0;
                    CmpVec[i].y = 0;
                }
                cardWheelObj.init();
                getPicBacklightModelValue();
                setOnkeyLeftRightFunc(BacklightLevel, BacklightLevelCmp, PicBacklightAdjustPageData.backlightVal);

                picBacklightAdjustDelEco.currFocus = LocalDimmingType.LocalDimmingOnOff==localDimmingSupport ?
                    UI.getItem(DynamicBacklightControlGrid, "picModeNewTileSecond0") :
                    UI.getItem(DynamicBacklightControlGrid, "picModeNewTile" + PicBacklightAdjustPageData.dynamicBacklightVal);
                if (!picBacklightAdjustDelEco.currFocus) {
                    picBacklightAdjustDelEco.currFocus = LocalDimmingType.LocalDimmingOnOff==localDimmingSupport ?
                        UI.getItem(DynamicBacklightControlGrid, "picModeNewTileSecond0") :
                        UI.getItem(DynamicBacklightControlGrid, "picModeNewTile0");
                    PicBacklightAdjustPageData.dynamicBacklightVal = 0;
                }
                if (localDimmingSupport!=2) {
                    BacklightLevelCmp.setCmpEnable((PicBacklightAdjustPageData.dynamicBacklightVal != 0) ? 0 : 1);
                } else {
                    var localDimmingONOFFtmp = tv ? model.video.getEnumLocalDimming() : 1;
                    BacklightLevelCmp.setCmpEnable((localDimmingONOFFtmp != 0) ? 0 : 1);
                }
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }

        };

        picBacklightAdjustDelEco.onShow = function () {
            try {
                DBG_INFO('picBacklightAdjustDelEco.onShow');

                var normalCfg = {y: 0 + 175, alpha: 1};
                UI.getItem(picBacklightAdjustDelEco, PictureConfig.PicBacklightSign).alpha = 1;
                UI.getItem(picBacklightAdjustDelEco, PictureConfig.PicBacklightSign).y = normalCfg.y;

                if (DynamicBacklightControlGrid.selectedItem) {
                    DynamicBacklightControlGrid.selectedItem.removeChild(DynamicSelectedFlag,true);
                }
                if(LocalDimmingType.LocalDimmingOnOff==localDimmingSupport){
                    DynamicBacklightControlGrid.selectedItem = UI.getItem(DynamicBacklightControlGrid, "picModeNewTileSecond0");
                    UI.getItem(DynamicBacklightControlGrid, "picModeNewTileSecond0").addChild(DynamicSelectedFlag);
                }else{
                    DynamicBacklightControlGrid.selectedItem = UI.getItem(DynamicBacklightControlGrid, "picModeNewTile" + PicBacklightAdjustPageData.dynamicBacklightVal);
                    UI.getItem(DynamicBacklightControlGrid, "picModeNewTile" + PicBacklightAdjustPageData.dynamicBacklightVal).addChild(DynamicSelectedFlag);
                }

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        //该函数中实现value初始化
        function getPicBacklightModelValue() {
            try {
                if (localDimmingSupport == LocalDimmingType.DynamicBacklightControl) {
                    var dynamicBacklightValTmp = tv ? model.video.getDynamicBacklight() : 1;
                    dynamicBacklightValTmp = {0:0, 1:1, 3:2}[dynamicBacklightValTmp];
                    DBG_INFO("model.video.getDynamicBacklight(): " + dynamicBacklightValTmp);
                } else {
                    var localDimmingTmp = tv ? model.video.getEnumLocalDimming() : 1;
                    DBG_INFO('model.video.getEnumLocalDimming(): ' + localDimmingTmp);
                }
                if(LocalDimmingType.LocalDimmingOnOff==localDimmingSupport){
                    PicBacklightAdjustPageData.dynamicBacklightVal = 0;
                    PicBacklightAdjustPageData.localDimmingOn = localDimmingTmp;
                    UI.setVoiceStr(DynamicBacklightControlGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.localDimmingOn]);
                    setLocalDimmingOnOff(PicBacklightAdjustPageData.localDimmingOn);
                }else{
                    PicBacklightAdjustPageData.dynamicBacklightVal =
                        (localDimmingSupport == LocalDimmingType.DynamicBacklightControl) ?
                            dynamicBacklightValTmp : localDimmingTmp;
                }

                if (GLOBAL.LAUNCHER_BRAND == "shp"){
                    picBacklightAdjustCfg.DynamicBacklightControl.title = "[SE2891]";
                    UI.setText(UI.getItem(DynamicBacklightControl, "title"), picBacklightAdjustCfg.DynamicBacklightControl.title);
                    DBG_INFO("AdvancedAquoMotionEnhancement.name = " + picBacklightAdjustCfg.DynamicBacklightControl.title)
                }

                PicBacklightAdjustPageData.backlightVal = tv ? model.video.getBacklight() : 17;// 0~100
                DBG_INFO("model.video.getBacklight(): " + PicBacklightAdjustPageData.backlightVal);
                BacklightLevelCmp.setPercent(PicBacklightAdjustPageData.backlightVal);

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function setLocalDimmingOnOff(isOn){
            if(isOn){
                UI.setImage(DynamicBacklightControlGrid.children[0].children[1], initData.onImg, false);
            }else{
                UI.setImage(DynamicBacklightControlGrid.children[0].children[1], initData.offImg, false);
            }
        }

        var BacklightLevel = UI.getItem(picBacklightAdjustDelEco, "BacklightLevel");
        var BacklightLevelCmp = UI.getItem(BacklightLevel, "percentBarLine");
        var BacklightLevelTxt = UI.getItem(BacklightLevel, "percentBarText");

        function CardWheelFunc() {
            var self = this;
            var cardWheelVec = [];
            self.cardWheelVec = cardWheelVec;
            var cardWheelLength = 2;
            for (var i = 0; i < cardWheelLength; i++) {
                self.cardWheelVec.push(UI.getItem(picBacklightAdjustDelEco, "cardWheel_" + i));
            }
            var posYVec = [0 + 80, 95 + 80];
            var DelayTimeData = {
                Time_0: 0,
                Time_400: 400
            };
            var ToVecNumeber = {
                Vec0: 0,
                Vec1: 1,
                Vec2: 2
            };
            var ToYPosition = {
                Y_57: 57,
                Y_80: 80,
                Y_105: 105
            };

            //初始化，0位于最高的一个，当前哪个元素应该是Vector第一个
            self.setHeadIdx = function (idx) {
                try {
                    DBG_INFO('self.setHeadIdx: ' + idx);
                    for (var i = 0; i < idx; i++) {
                        cardWheelVec.unshift(cardWheelVec.pop());
                    }
                    getTweenTime(ToVecNumeber.Vec1,DelayTimeData.Time_0,ToYPosition.Y_80);
                    switchLayer(cardWheelVec)
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };
            self.init = function () {
                var picBacklightAdjustSignVec = ['DynamicBacklightControl', 'BacklightLevel'];
                var idx = picBacklightAdjustSignVec.indexOf(PictureConfig.PicBacklightSign);
                DBG_INFO("PictureConfig.PicBacklightSign "+ PictureConfig.PicBacklightSign);

                cardWheelVec = [];
                for (var i = 0; i < cardWheelLength; i++) {
                    cardWheelVec.push(UI.getItem(picBacklightAdjustDelEco, "cardWheel_" + i));
                }
                self.setHeadIdx(({0: 1, 1: 0}[idx]));
            };
            self.initCardWheel = function(){
                for (var i = 0; i < cardWheelLength; i++) {
                    cardWheelVec.push(UI.getItem(picBacklightAdjustDelEco, "cardWheel_" + i));
                    var cardWheelShadow = UI.getItem(cardWheelVec[cardWheelVec.length - 1], "cardWheelShadow");
                    cardWheelShadow.doFlip = true;
                }
            };
            function switchLayer(cardWheelVec) {
                UI.moveTo(cardWheelVec[1], 1);
                UI.moveTo(cardWheelVec[0], 0);
            }
            self.keyUp = function () {
                cardWheelVec.unshift(cardWheelVec.pop());
                getTweenTime(ToVecNumeber.Vec0,DelayTimeData.Time_400,ToYPosition.Y_57);
            };
            self.keyDown = function () {
                cardWheelVec.push(cardWheelVec.shift());
                getTweenTime(ToVecNumeber.Vec2,DelayTimeData.Time_400,ToYPosition.Y_105);
            };

            function getTweenTime(number,time,position) {
                DBG_INFO('posYVec['+number + '] ' + 'delayTime:' + time + ' toPosition:' + position);
                UI.getTween(cardWheelVec[1]).to({y: posYVec[number], alpha: 1}, time/2, UI.ease.quadOut).call(switchLayer, [cardWheelVec]).to({
                    y: posYVec[1]
                }, time/2, UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10))).to({y: position}, time/2,UI.ease.quadOut).to({y:ToYPosition.Y_80,scaleX: 1, scaleY:1,alpha: 1},time/2,UI.ease.quadIn);

                UI.getTween(cardWheelVec[0]).to({y: posYVec[0], alpha: 0.75}, time);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10))).to({y: 57, scaleX: 0.67, scaleY: 0.67, alpha: 0.75}, 100);
            }
        }
        var cardWheelObj = new CardWheelFunc();
        cardWheelObj.initCardWheel();

        Percent.create(BacklightLevelCmp, BacklightLevelTxt, PicBacklightAdjustPageData.backlightVal, 0, 100);

        var DynamicSelectedFlag= new PIXI.Graphics();
        DynamicSelectedFlag.beginFill(OEMFunction.getInstance().getBrandColor()).drawRect(0, 152, 295, 8).endFill();
        DynamicBacklightControlGrid.onFocus = function () {
            DBG_INFO("DynamicBacklightControlGrid.onFocus");
            var currFocus = picBacklightAdjustDelEco.currFocus;
            DynamicLastFocusName = currFocus.name;
            if (!DynamicBacklightControlGrid.selectedItem) {
                currFocus.addChild(DynamicSelectedFlag);
                DynamicBacklightControlGrid.selectedItem = UI.getItem(DynamicBacklightControlGrid, currFocus.name);
            }
            UI.updateStage();
            return true;
        };

        DynamicBacklightControlGrid.onkey_ENTER = function () {
            var currFocus = picBacklightAdjustDelEco.currFocus;
            if (DynamicBacklightControlGrid.selectedItem) {
                DynamicBacklightControlGrid.selectedItem.removeChild(DynamicSelectedFlag,true);
                DynamicBacklightControlGrid.selectedItem = UI.getItem(DynamicBacklightControlGrid, currFocus.name);
            }
            currFocus.addChildAt(DynamicSelectedFlag,currFocus.children.length-1);
            var curFocusIdx;
            if (localDimmingSupport == LocalDimmingType.DynamicBacklightControl) {
                PicBacklightAdjustPageData.dynamicBacklightVal = parseInt(currFocus.name.substr(14));
                curFocusIdx = PicBacklightAdjustPageData.dynamicBacklightVal;
                curFocusIdx = {0:0, 1:1, 2:3}[curFocusIdx];
                tv && model.video.setDynamicBacklight(curFocusIdx);
                DBG_INFO('model.video.setDynamicBacklight(' + curFocusIdx + ')');
                BacklightLevelCmp.setCmpEnable((curFocusIdx != 0) ? 0 : 1);
                logReportStr="Dynamic Backlight Control";
                DBG_INFO("logReportModeVec.DynamicBacklightControl:"+logReportModeVec.DynamicBacklightControl[curFocusIdx]);
                try {
                    LGReport.GTSETItem(logReportStr, logReportModeVec.DynamicBacklightControl[curFocusIdx]);
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            } else if (localDimmingSupport == LocalDimmingType.LocalDimmingAll){
                PicBacklightAdjustPageData.dynamicBacklightVal = parseInt(currFocus.name.substr(14));
                curFocusIdx = PicBacklightAdjustPageData.dynamicBacklightVal;//LocalDimmingToBottom(PicBacklightAdjustPageData.dynamicBacklightVal);
                tv && model.video.setEnumLocalDimming(curFocusIdx);
                DBG_INFO('model.video.setEnumLocalDimming(' + curFocusIdx + ')');
                BacklightLevelCmp.setCmpEnable((curFocusIdx != 0) ? 0 : 1);
                logReportStr="Local Dimming";
                DBG_INFO("logReportModeVec.LocalDimming:"+logReportModeVec.LocalDimming[curFocusIdx]);
                try {
                    LGReport.GTSETItem(logReportStr, logReportModeVec.LocalDimming[curFocusIdx]);
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }else if (localDimmingSupport == LocalDimmingType.LocalDimmingOnOff){
                PicBacklightAdjustPageData.dynamicBacklightVal = parseInt(currFocus.name.substr(20));
                curFocusIdx = (PicBacklightAdjustPageData.localDimmingOn);
                curFocusIdx = curFocusIdx ? 0 : 1;
                PicBacklightAdjustPageData.localDimmingOn = curFocusIdx;
                tv && model.video.setEnumLocalDimming(curFocusIdx);
                DBG_INFO('model.video.setEnumLocalDimming(' + curFocusIdx + ')');
                UI.setVoiceStr(DynamicBacklightControlGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.localDimmingOn]);
                setLocalDimmingOnOff(curFocusIdx);
                BacklightLevelCmp.setCmpEnable((curFocusIdx != 0) ? 0 : 1);
                logReportStr="Local Dimming";
                DBG_INFO("logReportModeVec.LocalDimming:"+logReportModeVec.LocalDimmingOnOff[curFocusIdx]);
                try {
                    LGReport.GTSETItem(logReportStr, logReportModeVec.LocalDimmingOnOff[curFocusIdx]);
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }
            UI.updateStage();
        };

        if(localDimmingSupport == LocalDimmingType.LocalDimmingOnOff){
            DynamicBacklightControlGrid.onkey_LEFT = DynamicBacklightControlGrid.onkey_RIGHT = DynamicBacklightControlGrid.onkey_ENTER;
        }

        function setOnkeyUpDownFunc(cmpOri, cmpUpTo, cmpDownTo) {
            var topCfg = {y: -100 + 175, alpha: 0};
            var normalCfg = {y: 0 + 175, alpha: 1};
            var btmCfg = {y: 100 + 175, alpha: 0};

            cmpOri.onkey_UP = function (focus) {
                try {
                    DBG_INFO(cmpOri.name + ".onkey_UP");
                    UI.getTween(cmpOri).to(btmCfg, 300);
                    UI.getTween(cmpUpTo).to(topCfg, 0).to(normalCfg, 400);

                    var lastFocusName;
                    if (cmpUpTo.name == "BacklightLevel") {
                        picBacklightAdjustDelEco.currFocus = cmpUpTo;
                        TTSCall(cmpUpTo);
                    } else {//mode to mode
                        if (cmpUpTo.name == "DynamicBacklightControl") {
                            lastFocusName = localDimmingSupport == LocalDimmingType.LocalDimmingOnOff
                                ? "picModeNewTileSecond" + PicBacklightAdjustPageData.dynamicBacklightVal
                                :"picModeNewTile" + PicBacklightAdjustPageData.dynamicBacklightVal;
                            if(localDimmingSupport == LocalDimmingType.LocalDimmingOnOff){
                                UI.setVoiceStr(DynamicBacklightControlGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.localDimmingOn]);
                            }
                            picBacklightAdjustDelEco.currFocus = UI.getItem(DynamicBacklightControlGrid, lastFocusName);
                            UI.focusTo(UI.getItem(DynamicBacklightControlGrid, lastFocusName));
                        }else {
                            DBG_INFO(cmpOri.name + ".onkey_UP ERROR");
                        }
                    }
                    PictureConfig.PicBacklightSign = cmpUpTo.name;
                    DBG_INFO("PictureConfig.PicBacklightSign"+cmpUpTo.name);
                    cardWheelObj.keyUp();
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };

            cmpOri.onkey_DOWN = function (focus) {
                try {
                    DBG_INFO(cmpOri.name + ".onkey_DOWN");
                    UI.getTween(cmpOri).to(topCfg, 300);
                    UI.getTween(cmpDownTo).to(btmCfg, 0).to(normalCfg, 400);

                    if (cmpDownTo.name == "BacklightLevel") {
                        picBacklightAdjustDelEco.currFocus = cmpDownTo;
                        TTSCall(cmpDownTo);
                    } else {//mode to mode
                        var lastFocusName;
                        if (cmpDownTo.name == "DynamicBacklightControl") {
                            lastFocusName = localDimmingSupport == LocalDimmingType.LocalDimmingOnOff
                                ? "picModeNewTileSecond" + PicBacklightAdjustPageData.dynamicBacklightVal
                                :"picModeNewTile" + PicBacklightAdjustPageData.dynamicBacklightVal;
                            if(localDimmingSupport == LocalDimmingType.LocalDimmingOnOff){
                                UI.setVoiceStr(DynamicBacklightControlGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.localDimmingOn]);
                            }
                            picBacklightAdjustDelEco.currFocus = UI.getItem(DynamicBacklightControlGrid, lastFocusName);
                            UI.focusTo(UI.getItem(DynamicBacklightControlGrid, lastFocusName));
                        } else {
                            DBG_INFO(cmpOri.name + ".onkey_UP ERROR");
                        }
                    }
                    PictureConfig.PicBacklightSign = cmpDownTo.name;
                    DBG_INFO("PictureConfig.PicBacklightSign"+cmpDownTo.name);
                    cardWheelObj.keyDown();
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };
        }

        function TTSCall(cmpTo){
            if (cmpTo.name == "BacklightLevel"){
                UI.callTTS(eval("PicBacklightAdjustPageData.backlightVal") + " ");
                DBG_INFO("UI.callTTS: "+ eval("PicBacklightAdjustPageData.backlightVal") + " ");
            }
        }

        setOnkeyUpDownFunc(DynamicBacklightControl, BacklightLevel, BacklightLevel);
        setOnkeyUpDownFunc(BacklightLevel, DynamicBacklightControl, DynamicBacklightControl);

        function setOnkeyLeftRightFunc(bar, comp, val) {
            function setModelValue(name, val) {
                switch (name) {
                    case "BacklightLevel":
                        tv && model.video.setBacklight(val);
                        DBG_INFO("model.video.setBacklight(" + val + ")");
                        PicBacklightAdjustPageData.backlightVal=val;
                        break;
                    default:
                        DBG_ERROR('setModelValue Error[name error]');
                        break;
                }
            }

            bar.onkey_LEFT = function () {
                try {
                    DBG_INFO(bar.name + ".onkey_LEFT");
                    if (false == comp.getCmpEnable()) {
                        return;
                    }
                    val -= 1;
                    var minVal = 0;
                    val < minVal && (val = minVal);
                    comp.setPercent(val);
                    setModelValue(bar.name, val);
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };
            bar.onkey_RIGHT = function () {
                try {
                    DBG_INFO(bar.name + ".onkey_RIGHT");
                    if (false == comp.getCmpEnable()) {
                        return;
                    }
                    val += 1;
                    var maxVal = 100;
                    val > maxVal && (val = maxVal);
                    comp.setPercent(val);
                    setModelValue(bar.name, val);
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };
            bar.onFocus = function () {
                return false;
            };
            bar.onNormal = function () {
                if (GLOBAL.HICONTRAST) {
                    UI.base.toNormalContrast(UI.getItem(DynamicBacklightControlGrid, DynamicLastFocusName));
                }
                return true;
            }
        }

        function setOnkeyEnterFunc(cmp){
            cmp.onkey_ENTER = function (focus) {
                return false;
            }
        }
        setOnkeyEnterFunc(BacklightLevel);

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};