// Init
UI.moduleBuilder['setting']['networkInformation'] = function(){

    var mainPanelData = {
        networkInfoBgImg:UI.setting_bg,
        networkInfoImg:"setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_network_154x154.png",
        networkInfoLineImg:"setting/settingline.png",
        networkInfoTitle2:"[SE0119]",//"Network",
        networkInfoTitle3:"[SE0629]",//"View information about your network connection."
        networkInfoCrtTitle:"[SE0119]",  //"Network"
        networkInfoIPTitle:"[SE0175]",   //IP Address
        networkInfoMaskTitle:"[SE0176]",  //Netmask
        networkInfoGatewayTitle:"[SE0177]",  //Gateway
        networkInfoDNS1Title:"[SE0178]",  //DNS Server 1
        networkInfoDNS2Title:"[SE0179]",  //DNS Server 2
        networkInfoMacTitle:"[SE0181]"  //MAC Address

    };
    var template = Util.readJson("module/setting/networkInformation.json");
    var networkInfoPanel = SubModule.create(mainPanelData, template);
    var networkInfoGrp = UI.getItem(networkInfoPanel,"networkInfoGrp");
    var networkInfoBgGrp = UI.getItem(networkInfoPanel, "networkInfoBgGrp");
    var ChTitle3 = UI.getItem(networkInfoBgGrp, "networkInfoTitle3");
    ChTitle3.children[0].lineHeight = 50;
    ChTitle3.children[0].lineWidth = 512;

    var networkInfoCrt = UI.getItem(networkInfoGrp, "networkInfoCrt");
    var networkInfoCrtTitle = UI.getItem(networkInfoCrt,"networkInfoCrtTitle");
    //Network
    LabelValue.create(networkInfoCrtTitle, "[SE0119]", FontDef.Arial_36, "0xFFFFFF");

    var networkInfoIP = UI.getItem(networkInfoGrp,"networkInfoIP");
    var networkInfoIPTitle = UI.getItem(networkInfoIP,"networkInfoIPTitle");

    //IP Address
    LabelValue.create(networkInfoIPTitle, "[SE0175]", FontDef.Arial_36, "0xFFFFFF");

    var networkInfoMask = UI.getItem(networkInfoGrp,"networkInfoMask");
    var networkInfoMaskTitle = UI.getItem(networkInfoMask,"networkInfoMaskTitle");
    LabelValue.create(networkInfoMaskTitle, "[SE0176]", FontDef.Arial_36, "0xFFFFFF");

    var networkInfoGateway = UI.getItem(networkInfoGrp,"networkInfoGateway");
    var networkInfoGatewayTitle = UI.getItem(networkInfoGateway,"networkInfoGatewayTitle");
    LabelValue.create(networkInfoGatewayTitle, "[SE0177]", FontDef.Arial_36, "0xFFFFFF");

    var networkInfoDNS1 = UI.getItem(networkInfoGrp,"networkInfoDNS1");
    var networkInfoDNS1Title = UI.getItem(networkInfoDNS1,"networkInfoDNS1Title");

    LabelValue.create(networkInfoDNS1Title, "[SE0178]", FontDef.Arial_36, "0xFFFFFF");

    var networkInfoDNS2 = UI.getItem(networkInfoGrp,"networkInfoDNS2");
    var networkInfoDNS2Title = UI.getItem(networkInfoDNS2,"networkInfoDNS2Title");

    LabelValue.create(networkInfoDNS2Title, "[SE0179]", FontDef.Arial_36, "0xFFFFFF");

    var networkInfoMac = UI.getItem(networkInfoGrp,"networkInfoMac");
    var networkInfoMacTitle = UI.getItem(networkInfoMac,"networkInfoMacTitle");

    LabelValue.create(networkInfoMacTitle, "[SE0181]", FontDef.Arial_36, "0xFFFFFF");

    var LANGUAGE = {
        "Ether":"[SE0159]",
        "Wireless":"[SE0600]",
        "Off":"[GE0006]"
    };

    networkInfoPanel.onShow =  function(){
        try{
            var networkMainPanel = UI.getSubModule("networkMainPanel");
            if(networkMainPanel){
                networkMainPanel.alpha = 0;
            }
            showInformation();
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, networkInfoStatusChanged);
            UI.setText(ChTitle3,"[SE0629]"); //"View information about your network connection."
            //UI.base.cursor.alpha = 0;
//            UI.getTween(UI.base.cursor).set({alpha:0});
//            UI.updateStage();

        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    };
    networkInfoPanel.currFocus = UI.getItem(networkInfoPanel, "networkInfoGrp");
//    UI.base.cursor.alpha = 0;
    function showInformation(){
        var networkType = tv?model.network.getEnumNetworking():1;
//            var networkType = 1;
        var ip = '';
        var mask = '';
        var gateway = '';
        var dns1 = '';
        var dns2 = '';
        var mac ='';
        ip = tv?model.network.getIp_address():"192.168.1.100";
        mask = tv?model.network.getSubnet_mask():"192.168.1.100";
        gateway = tv?model.network.getGateway():"192.168.1.100";
        dns1 = tv?model.network.getDns_server_1():"192.168.1.100";
        dns2 = tv?model.network.getDns_server_2():"192.168.1.100";
//        mac = tv?model.network.getMac_address():"192.168.1.100";
        if(networkType == NetWorkType.ETHER){
            mac = tv?model.network.getMac_address():"192.168.1.100";
        }else if(networkType == NetWorkType.WIRELESS){
            mac = tv?model.network.getMac_address_wifi():"192.168.1.100";
        }
        var NetStatus = tv ? model.network.getEnumNetworkAvailable() : 0; //1 success  0 fail
        DBG_INFO("getEnumNetworking():" + networkType);
        DBG_INFO("getEnumNetworking():" + ip);
        if(networkType == NetWorkType.ETHER){
            networkInfoCrtTitle.setValue(LANGUAGE.Ether);
        }else if(networkType == NetWorkType.WIRELESS){
            if(NetStatus == NetWorkConnect.CONNECT){
                var currSSID = model.network.getSsid();
                networkInfoCrtTitle.setValue(currSSID);
            }else{
                networkInfoCrtTitle.setValue(LANGUAGE.Wireless);
            }

        }else{
            networkInfoCrtTitle.setValue(LANGUAGE.Off);
        }
        if(NetStatus == NetWorkConnect.DISCONNECT){
            ip = " ";
            mask = " ";
            gateway = " ";
            dns1 = " ";
            dns2 = " ";
        }
        networkInfoIPTitle.setValue(ip);
        networkInfoMaskTitle.setValue(mask);
        networkInfoGatewayTitle.setValue(gateway);
        networkInfoDNS1Title.setValue(dns1);
        networkInfoDNS2Title.setValue(dns2);
        networkInfoMacTitle.setValue(mac);

    }
    function networkInfoStatusChanged(val){
        showInformation();
    }

//    networkInfoPanel.onkey_BACKSPACE = function() {
//        UI.popSubModule();
//    };
    networkInfoPanel.onPop = function(){
        DBG_ALWAYS("network Information   onPop  !!!!!!!!!!!!!!!");
//        UI.base.cursor.alpha = 1;
//        UI.getTween(UI.base.cursor).set({alpha:0});
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED,networkInfoStatusChanged);
    }
    networkInfoPanel.afterPush = function () {
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 0;
    }

    networkInfoGrp.onFocus=function(){
        UI.base.cursor.alpha=0;
        return false;
    }
    networkInfoGrp.onNormal=function(){

        return false;
    }
};