/**
 * Created by jiaguili on 16-1-29.
 */
UI.moduleBuilder['setting']['SettingSysAlexaDialog'] = function(){

    var initData = {
        "title": "Setup Wizard",
        "content": "The Setup Wizard is about to begin. Are you sure you want to continue?",
        "btn2text": "OK",
        "btn1text": "Cancel",
        "sheetImg1": UI['bg_overlay'],
        "bgImg1": UI.window_bg,
        "btn1bgImg": UI.item_bg,
        "btn2bgImg": UI.item_bg
    };
    var operateData = {
        "datatype": 0,
        "datalist": [
            {
                "title": "[SE3748]",//"Sign out",
                "content":"[SE3772]",// "Are you sure to sign out Amazon account? Then you will not be able to launch voice service by your remote control.",
                "button1": "[GE0008]",//"Cancel",
                "button2":"[SE3748]"
            },
            {
                "title":  "[SE3748]",//"Sign out",
                "content": "[SE3773]",//"After resetting, both of your Hisense and Amazon account will be signed out. Then you will not be able to use Voice Service.Are you sure to reset it?",//
                "button1": "[GE0008]",//"Cancel",
                "button2": "[SE3748]"//"Reset"
            },
            {
                "title": "[SE3748]",//"Upgrade",
                "content": "[SE3774]",//"After resetting, Your Hisense account will be signed out.Then you will not be able to use Voice Service.Are you sure to reset it?",//"The memory is not enough,you need to restart the TV and then upgrade.",
                "button1": "[GE0008]",//"Cancel",
                "button2":  "[SE3748]"//"Reset"
            },
            {
                "title": "[SE3768]",//"Setup Checklist"
                "content": "[SE3775]",//"You have not set up the voice control service.",//"The memory is not enough,you need to restart the TV and then upgrade.",
                "button1": "",//"Cancel",
                "button2": "[LA0082]"
            },
            {
                "title": "[SE3768]",//"Setup Checklist",//"Upgrade",
                "content": "[SE3777]",//"You are signed out of Hisense account",//"",
                "button1": "",//"Cancel",
                "button2": "[LA0082]"
            },
            {
                "title": "[SE3768]",//"Voice Control Diagnosis",
                "content":"[SE3776]",// "You have not signed into your Amazon account",//"The memory is not enough,you need to restart the TV and then upgrade.",
                "button1": "",//"Cancel",
                "button2": "[SE3779]"//"Sign in"
            },
            {
                "title": "[SE3754]",//"Upgrade",
                "content":"[SE3778]" +"http://a.hismarttv.com/wso/signin.",
                "button1": "",//"Cancel",
                "button2": "[GE0007]"
            },
            {
                "title": "[ALX0032]",//Deactivate Amazon Alexa Service
                "content": "[ALX0033]",
                "button1": "[GE0008]",//"Cancel",
                "button2": "[SE4272]"
            },
            {
                "title": "[ALX0032]",//Deactivate Amazon Alexa Service
                "content": "[ALX0033]",
                "button1": "[GE0008]",//"Cancel",
                "button2": "[SE4272]"
            }
        ]

    }
    var template = Util.readJson("module/setting/SettingSysAlexaDialog.json");
    var SettingSysAlexaDialog = SubModule.create(initData, template);
    SettingSysAlexaDialog.currFocus = UI.getItem(SettingSysAlexaDialog, "btn2");
    SettingSysAlexaDialog.operateData = operateData;
    var btn1 = UI.getItem(SettingSysAlexaDialog, "btn1");
    var btn2 = UI.getItem(SettingSysAlexaDialog, "btn2");
    var title = UI.getItem(SettingSysAlexaDialog, "title");
    var contentinfo = UI.getItem(SettingSysAlexaDialog, "content");
    var btn2text = UI.getItem(SettingSysAlexaDialog, "btn2text");
    var btn1text = UI.getItem(SettingSysAlexaDialog, "btn1text");
//    contentinfo.children[0].lineHeight = 50;
    contentinfo.children[0].lineWidth = 820;

    SettingSysAlexaDialog.onPush = function () {
        UI.setText(title, SettingSysAlexaDialog.operateData.datalist[setting.sysdata.curAlexaDialogType].title);
        UI.setText(contentinfo, SettingSysAlexaDialog.operateData.datalist[setting.sysdata.curAlexaDialogType].content);
        UI.setText(btn1text, SettingSysAlexaDialog.operateData.datalist[setting.sysdata.curAlexaDialogType].button1);
        UI.setText(btn2text, SettingSysAlexaDialog.operateData.datalist[setting.sysdata.curAlexaDialogType].button2);
       if(setting.sysdata.curAlexaDialogType>2&&setting.sysdata.curAlexaDialogType!==7&&setting.sysdata.curAlexaDialogType!==8){
           btn1.disable=true;
           btn1.alpha=0;
       }
        else {
           btn1.disable=false;
           btn1.alpha=1.0;
       }
        if(setting.sysdata.curAlexaDialogType==6){
            var SettingSysAccountlist = UI.getSubModule("SettingSysAccountlist");
            if(!!SettingSysAccountlist){
                UI.setText(contentinfo,  Config.language.SE3778.replace("XXXX",SettingSysAccountlist.operateData.url));
            }
            else {
                UI.setText(contentinfo,  Config.language.SE3778.replace("XXXX","mytv.hisense.com/wso/signin"));
            }


        }
        SettingSysAlexaDialog.currFocus = UI.getItem(SettingSysAlexaDialog, "btn2");

    }
    SettingSysAlexaDialog.onPop=function(){


    }
    btn1.onkey_ENTER = function () {
        UI.popSubModule();
    }
    btn2.onkey_ENTER = function () {
        try {
            if (setting.sysdata.curAlexaDialogType == 0) {
                //todo sign out the amazon account
                AVSClient.register.logout("amazon");
                UI.popSubModule();
                DBG_ERROR("logout amazon");

            }
            else if (setting.sysdata.curAlexaDialogType == 1) {
                //reset
                AVSClient.register.logout("hisense");
                AVSClient.register.logout("amazon");
                Hisense.File.delete("hisenseUI/avsRegister", 1);
                Hisense.File.delete("hisenseUI/disVoiceChrome", 1);
                UI.popSubModule();
                DBG_ERROR("logout amazon hisense");
            }else if (setting.sysdata.curAlexaDialogType == 2) {
                AVSClient.register.logout("hisense");
                AVSClient.register.logout("amazon");
                Hisense.File.delete("hisenseUI/avsRegister", 1);
                Hisense.File.delete("hisenseUI/disVoiceChrome", 1);
                UI.popSubModule();
                DBG_ERROR("logout hisense");
            }
            else if (setting.sysdata.curAlexaDialogType == 3) {
                // set up the voice control service.
                UI.popAllModule();
                UI.pushSubModule("Alexa","register_bg",true);
                DBG_ERROR("push register_bg");
            }
            else if (setting.sysdata.curAlexaDialogType == 4) {
                // signed in  Hisense account
                UI.popAllModule();
                UI.pushSubModule("Alexa","register_bg",true);
                DBG_ERROR("push register_bg");
            }
            else if (setting.sysdata.curAlexaDialogType == 5) {
                // NO Amazon account found.
                UI.popAllModule();
                UI.pushSubModule("Alexa","register_bg",true);
                DBG_ERROR("push register_bg");
            }
            else if (setting.sysdata.curAlexaDialogType == 6) {

                UI.popSubModule();
            }
            else if ( setting.sysdata.curAlexaDialogType == 7) {
                var SettingSysAlexa = UI.getSubModule("SettingSysAlexa");
                if (!!SettingSysAlexa) {
                    SettingSysAlexa.operateData.freshstylecallback.call(this, 0);
                }
                AVSClient.register.logout("hisense");
                AVSClient.register.logout("amazon");
                if(Config.tv) {
                    Hisense.File.delete("hisenseUI/avsRegister", 1);
                    Hisense.File.delete("hisenseUI/disVoiceChrome", 1);
                }
                DBG_ERROR("logout amazon hisense");
                UI.popSubModule();
            }
            else if ( setting.sysdata.curAlexaDialogType == 8) {
                AVSClient.register.logout("hisense");
                AVSClient.register.logout("amazon");
                if(Config.tv) {
                    Hisense.File.delete("hisenseUI/avsRegister", 1);
                    Hisense.File.delete("hisenseUI/disVoiceChrome", 1);
                }
                UI.popSubModule();
                DBG_ERROR("logout amazon hisense");
                var SettingSysLocationPanel = UI.getSubModule("SettingSysLocationPanel");
                if (!!SettingSysLocationPanel) {
                    SettingSysLocationPanel.operateData.freshlocationcallback.call(this);
                }
            }
        }
        catch (e) {
            DBG_ERROR(e.message)
        }

    }
    SettingSysAlexaDialog.onkey_BACKSPACE = function () {
        UI.popSubModule();
    }
};