/**
 * Created by Hisense on 2016-2-29.
 */
// Init
UI.moduleBuilder['setting']['AudioPreLanList'] = function(){

    var initData = {
        AudioBg: UI['bg_overlay'],
        AudioPreLanListBg: UI.window_bg,
        PreLanTitle:"[SE0684]"//Preferred Audio Language
    };
    var template = Util.readJson("module/setting/AudioPreLanList.json");
    var AudioPreLanList = SubModule.create(initData, template);

    AudioPreLanList.operateData = {
        "PreLanList": [
            {
                "map": 1,
                "name": "English",//"English",
                "flag": false
            },
            {
                "map": 4,
                "name": "Español",//"Spanish",
                "flag": false
            },
            {
                "map": 2,
                "name": "Français",//"French",
                "flag": false
            }
        ],
        "currPreLanIdx": 0
    };
    function SndgetPreLanIdx() {
        try {

            var AudioFavouredTmp = tv ? model.language.getAudioFavoured() : 2;
            DBG_INFO("model.language.getAudioFavoured=" + AudioFavouredTmp);
            for (var i = 0; i < AudioPreLanList.operateData.PreLanList.length; i++) {
                if (AudioFavouredTmp == AudioPreLanList.operateData.PreLanList[i].map) {
                    break;
                }
            }
            return i;

        } catch (ex) {
            DBG_ERROR("SndgetPreLanIdx:" + ex.message);
        }
    }

    // 初始化Grid控件
    // 取得目标锚点
    var List = UI.getItem(AudioPreLanList, "List");

    // Grid的配置信息JSON
    var info = {
        // 每个图标使用的模板名
        template: "DialogListItem",
        // V表示竖向排列，H表示横向排列
        direction: CONST.GIRD_DIRECTION.H,
        // 每隔几个图标就换行
        breakNum: 1,
        // 每隔图标之间的距离
        distanceX: 0,
        distanceY: 20,
        // 要将此Grid添加到哪个锚点位置上
        container: List
    };

    // 声明一个初始化用数组，将数据配置好
    var allArray = [];
    for (var i = 0; i < AudioPreLanList.operateData.PreLanList.length; i++) {
        allArray.push(
            {
                ItemName: AudioPreLanList.operateData.PreLanList[i].name,
                tileBg: UI.item_bg,
                name: "item" + i,
                isFlag: "setting/ic_radiobutton_normal.png"
            }
        )
    }
    // 调用Grid.create方法生成Gird并添加到锚点位置上
    Gird.create(allArray, info);
    // 设置视野范围，当焦点超出此范围时，整个Grid会反向移动，达到滚动效果（此处配置的x，y是全局坐标）

    // 设置遮罩范围，隐藏显示不下的图标
    AudioPreLanList.operateData.currPreLanIdx = SndgetPreLanIdx();
    AudioPreLanList.currFocus = UI.getItem(List, "item" + AudioPreLanList.operateData.currPreLanIdx);
    AudioPreLanList.onShow = function () {
        AudioPreLanList.operateData.currPreLanIdx = SndgetPreLanIdx();
        DBG_INFO("setAudioPreLanList.onShow");
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png",List.children[i]);
        }
        AudioPreLanList.currFocus = UI.getItem(List, "item" + AudioPreLanList.operateData.currPreLanIdx);
        UI.setImage(AudioPreLanList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage(),AudioPreLanList.currFocus );
        UI.focusTo(UI.getItem(List, "item" + AudioPreLanList.operateData.currPreLanIdx));
    };

    function SndPreLanIdx(idx) {
        try {
            AudioPreLanList.operateData.currPreLanIdx = idx;

            var PreLanMapList = AudioPreLanList.operateData.PreLanList;
            if (idx > PreLanMapList.length - 1) {
                DBG_ERROR("SndPreLanIdx:idx=" + idx);
                idx = 0;
            }
            DBG_INFO("model.language.setAudioFavoured:"+PreLanMapList[idx].map);
            tv? model.language.setAudioFavoured(PreLanMapList[idx].map) :1;

        } catch (ex) {
            DBG_ERROR("SndPreLanIdx:" + ex.message);
        }

    }

    List.onkey_ENTER = function (focus) {
        var index = List.initSequence.indexOf(focus);//AudioPreLanList.currFocus.name.slice(-1);
        for (var i = 0; i < List.children.length -1; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png");
        }
        UI.setImage(AudioPreLanList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage());
        SndPreLanIdx(index);
        UI.popSubModule();
        return true;
    };

};