// Init
UI.moduleBuilder['setting']['AudioDigitalAudioDelay'] = function(){

    var AudioDelayData = {
        sndModeImg1: UI["liveTV_bg"],
        AudioDelayTitle: "[SE0559]",//Digital Audio Delay
        AudioDelayInfo: "[SE0560]"//Adjust the digital audio output delay time to sync sound from an external speaker with the images on the TV.

    };
    var template = Util.readJson("module/setting/AudioDigitalAudioDelay.json");
    var AudioDelay = SubModule.create(AudioDelayData, template);
    var audioDelayBar = UI.getItem(AudioDelay, "audioDelayBar");
    var bar = UI.getItem(AudioDelay,"bar");
    AudioDelay.currFocus = audioDelayBar;
    AudioDelay.onShow = function(){
        var delayValue = tv ? model.sound.getDigitalAudioDelay() : 12;
        DBG_INFO("model.sound.getDigitalAudioDelay():"+delayValue);
        bar.setPercent(delayValue);

    };

    var AudioDigitalAudioDelay = UI.getSubModule("AudioDigitalAudioDelay");
    AudioDigitalAudioDelay.onkey_BACKSPACE = function () {
        var AudioSpeaker = UI.getSubModule("AudioSpeaker");
        AudioSpeaker.alpha = 1;
        UI.popSubModule();
    };
    percentBar_common(AudioDigitalAudioDelay,"audioDelayBar","bar","value",0,25);
    function percentBar_common(submodule, groupname,percentImg,percentTxt,min,max){
        try{
            var percentBar = UI.getItem(submodule, groupname);
            var percentComp = UI.getItem(percentBar, percentImg);
            var percentTxt = UI.getItem(percentBar, percentTxt);


            Percent.create(percentComp, percentTxt, 0,min,max);
            percentBar.onFocus = function(focus) {
                percentComp.onFocus();
                return false;
            };
            percentBar.onNormal = function(focus) {
                percentComp.onNormal();
                return true;
            };
            percentBar.onkey_RIGHT = function() {
                percentComp.plus();
                //percentBar.updateCache();
                //UI.updateStage();
                //DBG_INFO(" model.sound.setDigitalAudioDelay:"+percentComp.percent);
                if(!!tv){
                    model.sound.setDigitalAudioDelay(percentComp.percent);
                }
            };
            percentBar.onkey_LEFT = function() {
                percentComp.minus();
                //percentBar.updateCache();
                //UI.updateStage();
                if(!!tv){
                    model.sound.setDigitalAudioDelay(percentComp.percent);
                }
            };
        }
        catch(ex){
            DBG_ERROR(ex.message);
        }
    }
};