// Init
UI.moduleBuilder['mixBar']['mixBar'] = function(){

    var mixBarListData = {
        mixBarListBg: "mixBar/bg_512x816.png",
        powerOffBg: UI.btn_normal_bg,
        powerOffImg: "mixBar/la_ic_power_off.png",
        mixBarTitle:"[SE0333]",//"Source"
        powerOffTitle:"[SE0983]"//Power Off
    };
    var template = Util.readJson("module/mixBar/mixBar.json");
    var mixBar = SubModule.create(mixBarListData, template);
    var mixTimer=null;
    var mixBarList = UI.getItem(mixBar, "mixBarList");
    var powerOffMenu = UI.getItem(mixBar, "powerOffMenu");
    mixBar.currFocus = powerOffMenu;
    function refreshMixBar() {

        mixBarList.removeAllChildren();

        var array = [];
        mixBarList.mixBarData = [];
        mixBarList.mixBarData = getInputsDataForMixBar();
        DBG_INFO("getInputsDataForLauncher:" + JSON.stringify(mixBarList.mixBarData));
        for (var i = 0; i < mixBarList.mixBarData.length; i++) {
            var data = null;

            data = {
                template: "mixBarTile",
                tileBg: UI.btn_normal_bg,
                DeviceImg: mixBarList.mixBarData[i].img,
                DeviceName: mixBarList.mixBarData[i].rename ? mixBarList.mixBarData[i].rename : mixBarList.mixBarData[i].name,
                name: mixBarList.mixBarData[i].name,
                LockImg:"mixBar/lock.png"
            };

            array.push(data);
        }

        var info = {
            template: "mixBarTile",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 1,
            distanceX: 0,
            distanceY: 12,
            container: mixBarList
        };
        Gird.create(array, info);
        powerOffMenu.upTo = mixBarList.mixBarData[mixBarList.mixBarData.length - 1].name;
        var lockTime = getIsInlockTime();
        for (var i = 0; i < mixBarList.mixBarData.length; i++) {
            var mixBarListItem = mixBarList.initSequence[i];
            if(!!mixBarList.mixBarData[i].alpha && mixBarListItem.children[2].alpha){
                mixBarListItem.children[2].alpha = mixBarList.mixBarData[i].alpha;
            }
            //UI.setTextColor(mixBarListItem.children[2], mixBarList.mixBarData[i].color);
            if(!!lockTime && mixBarList.mixBarData[i].locked == true){
                DBG_INFO("mixBarList.mixBarData[i].lock:"+i);
                UI.getItem(mixBarListItem, "LockImg").alpha = 1;
            }
            else {
                UI.getItem(mixBarListItem, "LockImg").alpha = 0;
            }
        }
        UI.updateStage();
    };
    mixBar.onShow = function () {
        refreshMixBar();
        UI.focusTo(powerOffMenu);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SOURCE_DETECT_CHANGED, mixBar.sourceDetectChanged);
    }
    mixBar.sourceDetectChanged = function() {
        DBG_INFO("----sourceDetectChanged--");
        var index = mixBarList.initSequence.indexOf(UI.getCurrFocus());
        refreshMixBar();
        try{
            if(UI.getCurrFocus().name=="powerOffMenu"){
                UI.focusTo(powerOffMenu);
            }
            else {
                var target = mixBarList.initSequence[index];
                UI.focusTo(target);
            }
        }catch(ex){
            DBG_ERROR(ex.message);
        }
    }
    mixBar.onPush = function(){
        UI.setLiveTVMenuTimeout(autoExitMixBar, 5*1000);
        if(!!mixBar.param&&mixBar.param=="btnOne"){
            if(!!mixTimer){
                clearTimeout(mixTimer);
                mixTimer=null;
            }
            mixTimer=setTimeout(function(){
                changeSource();
            },3200)
        }
    }
    function autoExitMixBar(){
        UI.popSubModule();
        openLiveTVModule();

    }
    mixBar.onkey=function(){
        if(!!mixBar.param&&mixBar.param=="btnOne") {
            if (!!mixTimer) {
                clearTimeout(mixTimer);
                mixTimer = null;
            }
            mixTimer = setTimeout(function () {
                changeSource();
            }, 3200)
        }
        return true;
    }

    powerOffMenu.onkey_ENTER = function () {
        powerOff();
        return true;

    }
    powerOffMenu.onkey_KEYPADMENU = function () {
        if(!!GLOBAL.KEYPAD_STATE){
            powerOff();
        }else{
            var target = mixBarList.initSequence[0];
            UI.focusTo(target);
        }
      //  return true;
    }
    powerOffMenu.onkey_CHUP = function () {
        var target = mixBarList.initSequence[mixBarList.initSequence.length - 1];
        UI.focusTo(target);
        //return true;
    }
    powerOffMenu.onkey_CHDOWN = function(){
        return false;
    }
    mixBarList.onkey_ENTER = function (focus) {
        ChangeInput(focus);
        return true;

    }
    mixBarList.onkey_KEYPADMENU = function (focus) {
        if(!!GLOBAL.KEYPAD_STATE){
            ChangeInput(focus);
        }else{
            var index = mixBarList.initSequence.indexOf(focus);
            if (index < mixBarList.mixBarData.length - 1) {
                var mixBarListItem = mixBarList.initSequence[index + 1];
                UI.focusTo(mixBarListItem);
            }
            else {
                UI.focusTo(powerOffMenu);
            }
        }
      //  return true;
    }
    mixBarList.onkey_CHDOWN = function (focus) {
        var index = mixBarList.initSequence.indexOf(focus);
        if (index < mixBarList.mixBarData.length - 1) {
            var mixBarListItem = mixBarList.initSequence[index + 1];
            UI.focusTo(mixBarListItem);
        }
        else {
            UI.focusTo(powerOffMenu);
        }
        //return true;
    }
    mixBarList.onkey_CHUP = function (focus) {
        var index = mixBarList.initSequence.indexOf(focus);
        if (index > 0) {
            var mixBarListItem = mixBarList.initSequence[index - 1];
            UI.focusTo(mixBarListItem);
        }
        //return true;
    }
    function powerOff() {
        UI.popSubModule();
        if (tv) {
            switchOffTV(1);
        }
    };
    function changeSource(){
        if(UI.getCurrFocus().name=="powerOffMenu"){
            powerOff();
        }
        else {
            ChangeInput(UI.getCurrFocus());
        }

    }
    function ChangeInput(focus) {

        var index = mixBarList.initSequence.indexOf(focus);
        var id = mixBarList.mixBarData[index].id;
        DBG_INFO("id:" + id);
        if (!!tv) {
            changeSourceTo(id);
        }
        UI.popSubModule();
        openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
    };
    mixBar.onkey_BACKSPACE = function () {
        UI.popSubModule();
        openLiveTVModule();
    }
    mixBar.onkey_EXIT = function () {
        UI.popAllModule();
        openLiveTVModule();
    }
    mixBar.onPop = function (){
        UI.clearLiveTVMenuTimeout();
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SOURCE_DETECT_CHANGED,mixBar.sourceDetectChanged);
        if (!!mixTimer) {
            clearTimeout(mixTimer);
            mixTimer = null;
        }
    }

};
