/**
 * Created by jiangbo1 on 2016/2/16.
 */
UI.moduleBuilder['liveTV']['channelList'] = function () {
    /*default data*/
    var ChListData = {
        chlist_bg: GLOBAL.IMAGE_LIST.CHANNEL_LIST_BG,
        tabBar: {color: (GLOBAL.LAUNCHER_BRAND == "his")? "0x00a9c2": "0xbb2071"},
        optTipImage: GLOBAL.IMAGE_LIST.GREEN40,
        inputNumBg:UI.item_bg,
        allTitle: "[SE0085]",
        favTitle: "[SE2619]",
        hisTitle: "[SE0835]",
        optTipText: "[SE2396]"
    };
    var template = Util.readJson("module/liveTV/channelList.json");
    var channelList = SubModule.create(ChListData, template);

    var allListTitle = UI.getItem(channelList, "allTitle");
    var favListTitle = UI.getItem(channelList, "favTitle");
    var hisListTitle = UI.getItem(channelList, "hisTitle");
    var tabBar = UI.getItem(channelList, "tabBar");
    var listGroup = UI.getItem(channelList, "listGroup");
    var optTipText = UI.getItem(channelList, "optTipText");
    var optTipImage = UI.getItem(channelList, "optTipImage");
    var allList = UI.getItem(listGroup, "allList");
    var favList = UI.getItem(listGroup, "favList");
    var hisList = UI.getItem(listGroup, "hisList");
    var targetMap = [allList, favList, hisList];
    var prixMap = ["ALL", "FAV", "HIS"];
    optTipText.ADDTIP = "[SE2396] / [SE1885]";
    optTipText.REMOVETIP = "[TV0183]";
    optTipText.alpha = 0.8;
    var tabBarX = [107, 321, 535];

    channelList.currFocus = tabBar;
    var maxItem = 9, channelIndex = 0, oriIndex = [],
        panelCenter = 2580, listCenter = 680.5, listWidth = 640, listHeight = 870,
        baseDuration = 500, baseScale = 1.05, baseAlpha = 0.6;
    var SpeedMap = [1, 1, 1, 2, 2, 2, 4], rptTimes = 0;

    var addFavIco = UI.getItem(channelList, "addFavIco");
    var addFavText = UI.getItem(channelList, "addFavText");
    var addFavTextTimer = null;
    setLiveTVText(addFavText,"[OT0456]", true);//"You haven't added a favorite channel. You can add favorite channels by pressing green key in All channel list,to create a convenient channel list."
    addFavText.alpha = 0;

    //channelIndex:     焦点在整个列表中的序号
    //allList.index:    焦点在initSequence序号。注意bigList的initSequence比数据短

    allList.index = 1;
    allList.initSequence = [];
    UI.addMask(allList, listWidth, listHeight, 20, 10);
    UI.setView(allList, listWidth, listHeight, 0, 0);
    favList.index = 1;
    allList.initSequence = [];
    UI.addMask(favList, listWidth, listHeight, 20, 10);
    UI.setView(favList, listWidth, listHeight, 0, 0);
    hisList.index = 1;
    allList.initSequence = [];
    UI.addMask(hisList, listWidth, listHeight, 20, 10);
    UI.setView(hisList, listWidth, listHeight, 0, 0);

    var tunerMap = {
        Antenna: "[SE0384]",
        Cable: "[SE0385]",
        Satellite: "[SE0386]"
    };

    var oprtData = {
        allLists: [],
        allChannels: {},
        favChannels: {},
        hisChannels: [],
        crntList: {},

        listIndex: 0,
        channelIndex: 0
    };
    var inputedNum='';
    var locateNum=0;
    var InputTimeout=0;
    var holdTimer = 0;
    var input_num=UI.getItem(channelList,'input_num');
    var inputNumGrp=UI.getItem(channelList,'inputNumGrp');
    inputNumGrp.alpha=0;

    var numArray = ['ZERO', 'ONE', 'TWO', 'THREE', 'FOUR', 'FIVE', 'SIX', 'SEVEN', 'EIGHT', 'NINE'];
    numArray.forEach (function ( v, index ) {
        eval('listGroup.onkey_' + v + '=NumKeyMapProcess.bind(this,index)');
    })

    function showInputNumGrp(showFlag){
        if(showFlag){
            inputNumGrp.alpha=1;
            UI.updateStage();
        }else{
            inputNumGrp.alpha=0;
            UI.setText(input_num,'');
        }

    }

    function findNearlyChannel(number) {
        var i=0;
        number=parseInt(number);

        var curNumArray = [];
        if (oprtData.listIndex == CHLISTINDEX.FAV) {
            var chnl, index;
            var Channels = oprtData.favChannels[oprtData.crntList.name];
            for(index in Channels) {
                chnl = Channels[index];
                !!chnl.number && (curNumArray.push(chnl.number));
            }
        }
        else if (oprtData.listIndex == CHLISTINDEX.HIS) {
            var chnl, index;
            var Channels = oprtData.hisChannels;
            for(index in Channels) {
                chnl = Channels[index];
                !!chnl.number && (curNumArray.push(chnl.number));
            }

        } else {
            curNumArray = oprtData.channelNumberGrp[oprtData.crntList.name];
        }
        curNumArray.sort(function (a , b)
        {
            return parseInt(a) - parseInt(b)
        });

        var arrayMaxNum=parseInt(curNumArray[curNumArray.length-1]);
        if(number>=arrayMaxNum){
            locateNum=curNumArray[curNumArray.length-1];
            return locateNum;
        }
        quickLocateIndex(0,curNumArray.length-1,number ,curNumArray);
        return locateNum;
    }

    function quickLocateIndex( startIndex, endIndex, number, locateArray ) {
        if (parseInt(number) <= 0 && locateArray) {
            locateNum = locateArray[0];
            return;
        }else{
            if(!locateArray){
                DBG_ERROR('locateArray is null:'+locateArray);
                locateNum=0;
                return;
            }
        }
        if (number <= parseInt(locateArray[startIndex])) {
            locateNum = locateArray[startIndex];
            return;
        } else {
            if (number >= parseInt(locateArray[endIndex])) {
                locateNum = locateArray[endIndex];
                return;
            } else {
                if (startIndex + 1 >= endIndex) {
                    if ((parseInt(locateArray[startIndex]) + parseInt(locateArray[endIndex])) >= 2 * number) {
                        locateNum = locateArray[startIndex];
                    } else {
                        locateNum = locateArray[endIndex];
                    }
                    return;
                }
                var middle = Math.floor((endIndex + startIndex) / 2);
                if (number >= parseInt(locateArray[middle])) {
                    quickLocateIndex(middle, endIndex, number, locateArray);
                } else {
                    quickLocateIndex(startIndex, middle, number, locateArray);
                }
            }
        }

    }

    function NumKeyMapProcess( keyValue ) {
        try {
            if (CONST.KEY_STATE.REPEAT == UI.keyState) {
                return;
            }
            showInputNumGrp(true);
            inputedNum += (keyValue + "");
            if (inputedNum.length <= 4) {
                UI.setText(input_num, inputedNum);
            }else{
                inputedNum = keyValue+ "";
                UI.setText(input_num, inputedNum);
            }
            clearTimeout(InputTimeout);
            clearTimeout(holdTimer);
            if(inputedNum.length==4){
                InputTimeout = setTimeout(function () {
                    execute();
                }, 100);
            }else{
                InputTimeout = setTimeout(function () {
                    execute();
                }, 2000);
            }

            holdTimer = setTimeout(function() {
                clearTimeout(InputTimeout);
                execute();
            }, 900)

        } catch ( ex ) {
            DBG_ERROR('EPGNumKeyMapProcess is error' + ex.message)
        }
    }

    function execute(){
        clearTimeout(InputTimeout);
        clearTimeout(holdTimer);
        showInputNumGrp(false);
        inputedNum = findNearlyChannel(inputedNum);
        if (false == GoToChnlNum(inputedNum)) {
            //GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.CHANNEL_NOTFOUND;
            //UI.pushGhostModule("setting", "SettingSysToast");
        }
        inputedNum = '';
    }

    function GoToChnlNum( num ) {
        try {
            DBG_INFO('goto channel num:'+num);
            var currList;
            if (oprtData.listIndex == CHLISTINDEX.FAV) {
                currList = oprtData.favChannels[oprtData.crntList.name]
            }
            else if (oprtData.listIndex == CHLISTINDEX.HIS) {
                currList = oprtData.hisChannels
            }
            else {
                currList = oprtData.allChannels[oprtData.crntList.name]
            }

            if (! currList) {
                return false;
            }
            var seekIndex = -1;
            for (var i = 0; i < currList.length; i++) {
                if (currList[i].number == num) {
                    seekIndex = i;
                    break;
                }
            }
            if (seekIndex <= -1) {
                return false;
            }
            if(seekIndex==channelIndex){
                return true;
            }
            gotoChannelIndex(seekIndex);
        } catch ( ex ) {
            DBG_ERROR('GoToChnlNum is error' + ex.message)
        }
    }

    function resetGridData(info, target, data) {
        if (!data) data = [];
        var allArray = [];
        for (var i = 0; i < data.length; i++) {
            allArray.push(
                {
                    name: prixMap[info.uid] + i,
                    chlNo: data[i].number,
                    chlName: data[i].name,
                    uid: data[i].uid,
                    tileBg: UI.chlist_bg,//GLOBAL.IMAGE_LIST.CHANNEL_ITEM_BG,
                    isFav: data[i].favType ? GLOBAL.IMAGE_LIST.FAV48 : GLOBAL.IMAGE_LIST.NONE,
                    isLock: (1 == GLOBAL.PARENTAL_LOCK_SWITCH && data[i].isLock) ? GLOBAL.IMAGE_LIST.LOCK48 : GLOBAL.IMAGE_LIST.NONE
                }
            )
        }
        if (0 == allArray.length) {
            allArray.push({
                name: prixMap[info.uid] + 0,
                chlNo: "",
                chlName: prixMap[info.uid] == "FAV"?"[OT0456]":"[SE1020]",
                uid: 0,
                tileBg: UI.chlist_bg,//GLOBAL.IMAGE_LIST.CHANNEL_ITEM_BG,
                isFav: GLOBAL.IMAGE_LIST.NONE,
                isLock: GLOBAL.IMAGE_LIST.NONE
            });
        }
        /*info.container.removeAllChildren();
        info.container.initSequence = [];
        removeLiveTVShape(target);
        Gird.create(allArray, info);
        UI.addMask(target, listWidth, listHeight, 40, 10);
        UI.setView(target, listWidth, listHeight);
        UI.addScrollbar(target, -33);*/

        if (!!info.container.refreshPageData) {
            info.container.data = allArray;
            info.container.refreshPageData();
        }
        else {
            info.container.removeAllChildren();
            info.container.parent.removeChild(info.container.scroll);
            BigList.create(allArray, info);
        }
        var crntFocusName = !!UI.getCurrFocus() && UI.getCurrFocus().name;
        for (var i = 0; i < target.initSequence.length; i++) {
            if (!crntFocusName || crntFocusName != target.initSequence[i].name) {
                target.initSequence[i].alpha = baseAlpha;
            }
        }
    }

    function updateCache(container) {
        for (var i = 0; i < container.children.length; i++) {
            var item = container.children[i];
            //item.updateCache();
        }
    }

    function getListName(name){
        return name ? (tunerMap[name] ? tunerMap[name] : name) : "N/A";
    }

    function rewriteChannelListData(listId) {
        try {
            setLiveTVText(allListTitle, getListName(oprtData.crntList.name));
            // Gird的配置信息JSON
            var gridInfo = {
                template: "channelTile",
                direction: CONST.GIRD_DIRECTION.V,
                distance: 6,
                container: allList,
                pageCount: 9,
                scrollBar : true,
                scrollBarOffset : -36
            };
            var gridInfoFav = {
                template: "channelTile",
                direction: CONST.GIRD_DIRECTION.V,
                distance: 6,
                container: favList,
                pageCount: 9,
                scrollBar : true,
                scrollBarOffset : -36
            };
            var gridInfoHis = {
                template: "channelTile",
                direction: CONST.GIRD_DIRECTION.V,
                distance: 6,
                container: hisList,
                pageCount: 9,
                scrollBar : true,
                scrollBarOffset : -36
            };

            //while (listGroup.children.length > 3) listGroup.children.pop();

            if (null === listId || 0 === listId) {
                //gridInfo.container = allList;
                gridInfo.uid = CHLISTINDEX.ALL;
                resetGridData(gridInfo, allList, oprtData.allChannels[oprtData.crntList.name]);
            }
            if (null == listId || 1 === listId) {
                //gridInfo.container = favList;
                gridInfoFav.uid = CHLISTINDEX.FAV;
                resetGridData(gridInfoFav, favList, oprtData.favChannels[oprtData.crntList.name]);
            }
            if (null === listId || 2 === listId) {
                //gridInfo.container = hisList;
                gridInfoHis.uid = CHLISTINDEX.HIS;
                resetGridData(gridInfoHis, hisList, oprtData.hisChannels);
            }
            //updateCache(allList);
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    }

    function setCurrentPageData(target, listIdx, chIdx, flip) {
        /*var minI = Math.max(0, chIdx - maxItem),
            maxI = Math.min(target.initSequence.length, chIdx + maxItem);
        target.initSequence.forEach(function (v) {
            //v.alpha = 0;
            if (v.parent) {
                v.parent.removeChild(v);
            }
        });
        for (var i = minI; i < maxI; i++) {
            target.initSequence[i].alpha = baseAlpha;
            target.addChild(target.initSequence[i]);
            target.addChild(UI.base.cursor);
        }
        channelIndex = Math.min(target.initSequence.length - 1, chIdx);*/
        if(addFavTextTimer) {
            clearTimeout(addFavTextTimer);
            addFavTextTimer = null;
        }
        if(flip) return;

        switch (listIdx) {
            case CHLISTINDEX.ALL:
                setLiveTVText(optTipText, optTipText.ADDTIP, true);
                //UI.setText(optTipText, optTipText.ADDTIP);
                //UI.setImage(optTipImage, GLOBAL.IMAGE_LIST.GREEN40);
                setLiveTVImage(optTipImage, GLOBAL.IMAGE_LIST.GREEN40);
                setLiveTVImage(addFavIco, GLOBAL.IMAGE_LIST.NONE);
                addFavText.alpha = 0;
                allListTitle.alpha = 1;
                favListTitle.alpha = hisListTitle.alpha = 0.6;
                break;
            case CHLISTINDEX.FAV:
                setLiveTVText(optTipText, optTipText.REMOVETIP, true);
                //UI.setText(optTipText, optTipText.REMOVETIP);
                //UI.setImage(optTipImage, GLOBAL.IMAGE_LIST.RED40);
                setLiveTVImage(optTipImage, GLOBAL.IMAGE_LIST.GREEN40);
                if(!!oprtData.favChannels[oprtData.crntList.name] && oprtData.favChannels[oprtData.crntList.name].length > 0) {
                    setLiveTVImage(addFavIco, GLOBAL.IMAGE_LIST.NONE);
                    addFavText.alpha = 0;
                    UI.base.cursor.alpha = 1;
                    favList.alpha = 1;
                } else {
                    UI.base.cursor.alpha = 0;
                    favList.alpha = 0;
                    addFavTextTimer = setTimeout(function() {
                        setLiveTVImage(addFavIco, GLOBAL.IMAGE_LIST.ADDFAV_ICO);
                        addFavText.alpha = 0.6;
                    }, 300);

                }

                favListTitle.alpha = 1;
                allListTitle.alpha = hisListTitle.alpha = 0.6;
                break;
            case CHLISTINDEX.HIS:
                setLiveTVText(optTipText, "", true);
                //UI.setText(optTipText, "");
                //UI.setImage(optTipImage, GLOBAL.IMAGE_LIST.NONE);
                setLiveTVImage(optTipImage, GLOBAL.IMAGE_LIST.NONE);
                setLiveTVImage(addFavIco, GLOBAL.IMAGE_LIST.NONE);
                addFavText.alpha = 0;
                hisListTitle.alpha = 1;
                favListTitle.alpha = allListTitle.alpha = 0.6;
                break;
            default :
                break;
        }
        optTipText._bounds = null;
        var textBounds = optTipText.children[0].width;
        if(textBounds){
            //optTipText.regX = parseInt(textBounds.width / 2);
            optTipText.x =  parseInt(listWidth + 40 - textBounds);
            //if(optTipText.x - optTipText.regX < 60) optTipText.x = optTipText.regX + 60;
            //optTipImage.regX = 30;
            optTipImage.x = optTipText.x  - optTipImage.getBounds().width - 110;
        }
    }

    function showListByIndex(listIdx, chIdx, duration) {
        DBG_INFO("showListByIndex listIdx = " + listIdx + "chIdx = " + chIdx);
        UI.getTween(UI.base.cursor, true).set({alpha: 0});
        var target = targetMap[listIdx];
        var listName = oprtData.crntList.name;
        oprtData.listIndex = listIdx;
        var list = liveTV.getChannelsByListIndex(listName, oprtData.listIndex);

        var focus_target = target.initSequence[0];
        /*var focus_target = target.initSequence[chIdx];//UI.getItem(target, prixMap[listIdx] + chIdx);
        if (chIdx >= 0 && chIdx < list.length) {
//            var focus_target = target.initSequence[chIdx];//UI.getItem(target, prixMap[listIdx] + chIdx);
            focus_target = target.initSequence[0];
        }
        else {
            focus_target = target.initSequence[0];
            channelIndex = chIdx = 0;
        }*/
        if (null == target) return;
        setCurrentPageData(target, listIdx, chIdx);

        //channelList.currFocus = focus_target;
        UI.getTween(tabBar, true).to({x: tabBarX[listIdx]}, baseDuration, UI.ease.quadOut);
        UI.getTween(listGroup, true).to({x: 40 - listWidth * listIdx}, (duration || baseDuration), UI.ease.quadOut).call(function (target) {
            if (!checkLiveTVState(LIVETV.CHANNEL_LIST))return;
            //UI.getTween(UI.base.cursor, true).set({alpha: 1});
            //UI.focusTo(target);
        }, [focus_target]);

        channelIndex = chIdx;
        if (target.index < 0 || target.index > list.length - 1) {
            target.index = 0;
            channelIndex = 0;
        }
        else if (target.index == 0 && channelIndex > 0) {
            target.index = 1;
        }

        if(UI.getCurrSubModule().name != "channelList") {
            channelList.currFocus = focus_target;
        }
        else {
            target.navTo(chIdx, target.index);
        }
    }

    function resetChannelList(opt) {
        oprtData = opt;
        /*if (checkLiveTVState(LIVETV.CHANNEL_LIST)) {
            UI.popSubModule();
            openLiveTVModule([Msg.INFO, 0]);
        }*/
        rewriteChannelListData(null);
    }

    function findChannelIndex(chnls, chnl) {
        for (var i = 0; i < chnls.length; i++) {
            if (compareChannel(chnls[i], chnl)) return i;
        }
        return -1;
    }

    function updateGridItem(listName, chnl) {
        //bigList don't need this
        return;

        var index, item, chnls;

        for (var i = 0; i < prixMap.length; i++) {
            chnls = liveTV.getChannelsByListIndex(listName, i);
            if (!chnls) continue;
            index = findChannelIndex(chnls, chnl);
            if (-1 == index) continue;
            //item = UI.getItem(targetMap[i], prixMap[i] + index);
            item = targetMap[i].initSequence[index];
            if (null == item) continue;
            //UI.setImage(UI.getItem(item, "isFav"), chnl.favType ? GLOBAL.IMAGE_LIST.FAV48 : GLOBAL.IMAGE_LIST.NONE, item);
            setLiveTVImage(UI.getItem(item, "isFav"), chnl.favType ? GLOBAL.IMAGE_LIST.FAV48 : GLOBAL.IMAGE_LIST.NONE, item);
            //item.updateCache();
        }
        //index = oprtData.favChannels[listName].indexOf(chnl);
        //index = oprtData.hisChannels.indexOf(chnl);

        //var item = UI.getItem(allList, "All0");
    }

    function findFavFocusIndexByCrnt(crntIndex, total) {
        if (crntIndex > total - 1 && total > 0) return total - 1;
        return crntIndex;
    }

    function onFavEdit(actId, ret) {
        UI.activeKey();
        var flag = ret[0], chId = ret[1];
        var listName = oprtData.crntList.name;
        var chnl = objectFindByKey(oprtData.allChannels[listName], "uid", chId);
        if (null == chnl) return;
        chnl.favType = (1 == flag);
        if (chnl.favType) {
            chnl.attr |= ServicelistModel.SERVICE_BITMASK_IS_FAVORITE;
        }
        else {
            chnl.attr &= (~ServicelistModel.SERVICE_BITMASK_IS_FAVORITE);
        }
        liveTV.updateChannelAttribute(-1, chnl.uid, chnl.listUid, SPChannel.ATTRIBUTE, chnl.attr);
        oprtData.favChannels[listName] = liveTV.getFavChannels(oprtData.allChannels[listName]);
        liveTV.setHisChannelAfterEdit(chnl);
        updateGridItem(listName, chnl);
        rewriteChannelListData(1);
        if (UI.getCurrSubModule().name == LIVETV.CHANNEL_LIST && CHLISTINDEX.FAV == oprtData.listIndex) {
            var ind = findFavFocusIndexByCrnt(channelIndex, oprtData.favChannels[listName].length);
            channelList.currFocus = UI.getItem(favList, "FAV" + ind);
            setCurrentPageData(favList, CHLISTINDEX.FAV, ind);
            UI.focusTo(channelList.currFocus);
        }
        else {
            UI.updateStage();
        }
        var crntChannel = liveTV.getCurrentChannelInfo();
        if(compareChannel(crntChannel, chnl)) crntChannel.favType = chnl.favType;
    }

    function setFavInChannelList(chnl, flag) {
        UI.inactiveKey();
        if (tv) {
            //model.channelSearch.FavouriteSet(chnl.uid, flag ? 1 : 0);
            model.servicelist.SetServiceAttribute(ServicelistModel.SERVICE_ATTR_FAVORITE,flag ? 1 : 0,chnl.uid);
            onFavEdit(null, [flag ? 1 : 0, chnl.uid]);
        }
        else {
            onFavEdit(null, [flag ? 1 : 0, chnl.uid]);
        }
    }

    function refreshLockIcon(sMode) {
        try {
            var i, j, chnls, tileItem, chnl, target;
            for (i = 0; i < targetMap.length; i++) {
                chnls = liveTV.getChannelsByListIndex(oprtData.crntList.name, i);
                target = targetMap[i];
                for (j = 0; j < chnls.length; j++) {
                    chnl = chnls[j];
                    tileItem = target.initSequence[j];
                    //UI.setImage(tileItem.children[CHNLTILE.CHNL_LOCK],
                    setLiveTVImage(tileItem.children[CHNLTILE.CHNL_LOCK],
                        (1 == sMode && chnl.isLock) ?
                            GLOBAL.IMAGE_LIST.LOCK48 :
                            GLOBAL.IMAGE_LIST.NONE);
                }
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    listGroup.onkey_LEFT = function () {
        if (0 == oprtData.listIndex) return false;
        oriIndex[oprtData.listIndex] = channelIndex;
        var targetIndex = oriIndex[oprtData.listIndex - 1];
        var curChnls = liveTV.getChannelsByListIndex(oprtData.crntList.name, oprtData.listIndex);
        var nextChnls = liveTV.getChannelsByListIndex(oprtData.crntList.name, oprtData.listIndex - 1);
        /*if(curChnls.length > 0 && nextChnls.length > 0){
            var index = findChannelIndex(nextChnls, curChnls[channelIndex]);
            if (-1 != index) targetIndex = index;
        }*/
        showListByIndex(oprtData.listIndex - 1, targetIndex);
        return true;
    }
    listGroup.onkey_RIGHT = function () {
        if (2 == oprtData.listIndex) return;
        oriIndex[oprtData.listIndex] = channelIndex;
        var targetIndex = oriIndex[oprtData.listIndex + 1];
        var curChnls = liveTV.getChannelsByListIndex(oprtData.crntList.name, oprtData.listIndex);
        var nextChnls = liveTV.getChannelsByListIndex(oprtData.crntList.name, oprtData.listIndex + 1);
        /*if(curChnls.length > 0 && nextChnls.length > 0){
            var index = findChannelIndex(nextChnls, curChnls[channelIndex]);
            if (-1 != index) targetIndex = index;
        }*/
        showListByIndex(oprtData.listIndex + 1, targetIndex);
        return true;
    }

    function getChannelListGain(t, x) {
        if (t < 14) return 1;
        if (x >= SpeedMap.length) x = SpeedMap.length - 1;
        return SpeedMap[x];
    }

    function clearChannelListRepeat() {
        rptTimes = 0;
        clearTimeout(holdTimer);
    }

    /*function flipChannelList(flag, focus) {
        var target = targetMap[oprtData.listIndex];
        if (1 == target.initSequence.length) return false;
        var index = target.initSequence.indexOf(UI.getCurrSubModule().currFocus);
        var presetIndex = index + flag * getChannelListGain(target.initSequence.length, rptTimes++);
        if (1 == flag && presetIndex > target.initSequence.length - 1) {
            presetIndex = 0;
        }
        else if (-1 == flag && presetIndex < 0) {
            presetIndex = target.initSequence.length - 1;
        }
        setCurrentPageData(target, oprtData.listIndex, presetIndex, true);
        //UI.focusTo(UI.getItem(target, prixMap[oprtData.listIndex] + ("" + presetIndex)));
        UI.focusTo(target.initSequence[presetIndex]);
        return false;
    }*/

    function flipChannelList(flag, focus) {
        var target = targetMap[oprtData.listIndex];
        var idx = channelIndex + flag;
        if (idx < 0) {
            channelIndex = target.data.length - 1;
            target.navTo(channelIndex, 7);
            return false;
        }
        else if (idx > target.data.length - 1) {
            channelIndex = 0;
            target.navTo(channelIndex, 0);
            return false;
        }

        channelIndex += flag;
        target.index = target.initSequence.indexOf(channelList.currFocus) + flag;
        var posType = target.getPosType();
        if (posType == 1) {
            target.index = Math.max(1, target.index);
            target.index = Math.min(target.initSequence.length -2, target.index);
        }
        if (flag == 1) {
            target.navNext();
        }
        else if (flag == -1) {
            target.navPrev();
        }
        return true;
    }

    function gotoChannelIndex(index) {
        var target = targetMap[oprtData.listIndex];
        channelIndex = index;

        target.navTo(channelIndex, 6);
        return true;
    }

    listGroup.onkey_DOWN = flipChannelList.bind(this, 1);
    listGroup.onkey_UP = flipChannelList.bind(this, -1);

    allList.onkey_GREEN = function (focus, evt) {
        var listName = oprtData.crntList.name;
        var chnls = liveTV.getChannelsByListIndex(listName, oprtData.listIndex);
        if (!chnls[channelIndex]) return;
        setFavInChannelList(chnls[channelIndex], !chnls[channelIndex].favType);
    }

    favList.onkey_GREEN = function (focus, evt) {
        var listName = oprtData.crntList.name;
        var chnls = liveTV.getChannelsByListIndex(listName, oprtData.listIndex);
        if (!chnls[channelIndex]) return;
        setFavInChannelList(chnls[channelIndex], !chnls[channelIndex].favType);
        if(channelIndex > favList.children.length - 1) channelIndex = 0;
        UI.focusTo(favList.children[channelIndex]);
    }
    listGroup.onFocus = function (focus) {
        //focus.updateCache();
        //DBG_ONXX("channelList", "onFocus");
        onFocusLiveTVTarget(focus, baseScale, baseDuration);
    };

    listGroup.onNormal = function (focus) {
        onNormalLiveTVTarget(focus, baseAlpha, baseDuration);
    };

    /**
     * 收到消息，重置焦点
     * @param chnl
     */
    function refreshHisList(chnl) {
        rewriteChannelListData(CHLISTINDEX.HIS);
        if (CHLISTINDEX.HIS == oprtData.listIndex) {
            //todo 刷焦点
            var index = 0;//todo
            if(oprtData.hisChannels) {
                for(var i = 0; i < oprtData.hisChannels.length; i++) {
                    if(oprtData.hisChannels[i].uid == chnl.uid) {
                        index = i;
                        break;
                    }
                }
                channelIndex = index;
                hisList.navTo(index);
            }
        }
    }
    channelList.onPush = function () {
        try {
            DBG_INFO("channelList onPush");
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_UPDATED, resetChannelList);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_FAV_SET, onFavEdit);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, clearChannelListRepeat);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PARENTAL_LOCK_SWITCH, refreshLockIcon);

	        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SET_RECENT_WATCH, refreshHisList);
            GLOBAL.CURRENT_CHLIST_INDEX = Config.tv?parseInt(model.tvservice.getPlayFavChannelList()):0;
            oprtData = liveTV.getChannelListOprtData();
            channelIndex = oprtData.channelIndex;
            oriIndex = [0, 0, 0];
            if (!!channelList.param && channelList.param == "showFavList") {
                tabBar.x = tabBarX[CHLISTINDEX.FAV];
                listGroup.x = listCenter - listWidth * CHLISTINDEX.FAV;
                showListByIndex(CHLISTINDEX.FAV, oprtData.channelIndex);
            }
            else {
                if(oprtData.listIndex == 1) {
                    var curChannel = liveTV.getCurrentChannelInfo();
                    var chnls = {}, listName = oprtData.crntList.name;;
                    for(i = 0; i < oprtData.favChannels[listName].length; i++) {
                        chnls = oprtData.favChannels[listName][i];
                        if(compareChannel(chnls, curChannel)) {
                            oprtData.channelIndex = i;
                            break;
                        }
                    }
                }
                showListByIndex(oprtData.listIndex, oprtData.channelIndex, 50);
            }
            rewriteChannelListData(CHLISTINDEX.HIS);
            //UI.getTween(channelList, true).to({x: 1920 - listWidth - 20}, baseDuration, UI.ease.quartOut);
            channelList.x = 1920 - listWidth - 20;
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    channelList.onShow = function() {
        UI.setLiveTVMenuTimeout(autoExitLiveTVSubModel, 15*1000);
    };

    channelList.onPop = function (focus) {
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_UPDATED, resetChannelList);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_FAV_SET, onFavEdit);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, clearChannelListRepeat);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PARENTAL_LOCK_SWITCH, refreshLockIcon);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SET_RECENT_WATCH, refreshHisList);

        UI.clearLiveTVMenuTimeout();
        DBG_ONXX("channelList", "onPop");
        //oprtData.listIndex = 0;
        //UI.getTween(focus, true).to({scaleX: 1, scaleY: 1, alpha: baseAlpha}, baseDuration, UI.ease.quartOut);
        //UI.getTween(UI.base.cursor, true).to({scaleX: 1, scaleY: 1, alpha: 0}, baseDuration, UI.ease.quartOut);
        UI.getCurrModule().currFocus = null;
        channelList.currFocus = tabBar;
        tabBar.x = tabBarX[0];
        listGroup.x = listCenter;
        UI.getTween(channelList, true).to({x: panelCenter}, baseDuration, UI.ease.quartOut);
        UI.getTween(UI.base.cursor, true).set({alpha: 0});
        var favChannelList = oprtData.favChannels[oprtData.crntList.name];

        setPlayedChListIndexOnPop(oprtData.listIndex, favChannelList);
    }

    channelList.onkey_ENTER = function (focus) {
        if (inputNumGrp.alpha == 1) {
            clearTimeout(InputTimeout);
            execute();
            DBG_INFO('locate channel index and return');
            return;
        }

        var listName = oprtData.crntList.name;
        DBG_INFO("channelList.onkey_ENTER listName = " + listName + "channelIndex = " + channelIndex);
        var chnls = liveTV.getChannelsByListIndex(listName, oprtData.listIndex);

        /*UI.popSubModule();
        openLiveTVModule([Msg.INFO, 0, Msg.PASSWORD, 0, Msg.AUDIO, 0, Msg.SIGNAL, 0]);*/

        if (chnls[channelIndex] && !compareChannel(chnls[channelIndex], liveTV.getCurrentChannelInfo())) {
            var preChnl = liveTV.setStateBefChangeChannel(ChangeType.CH_OBJ, chnls[channelIndex]);
            if (preChnl) {
                setPlayedChListIndex(oprtData.listIndex);
                liveTV.changeChannel(preChnl);
                GLOBAL.CH_CHANED_ON_CHANNEL_LIST = true;
            }
        }
        else if(compareChannel(chnls[channelIndex], liveTV.getCurrentChannelInfo())){
            setPlayedChListIndex(oprtData.listIndex);
            liveTV.resetChnnelListIndex();
            GLOBAL.CH_CHANED_ON_CHANNEL_LIST = true;
        }
    };

    channelList.onkey_CHDOWN = function() {
        //todo 翻页
        var target = targetMap[oprtData.listIndex];
        target.nextPage();
        var len = 0;
        if(oprtData.listIndex == CHLISTINDEX.HIS) {
            len = hisList.data.length - 1;
        } else {
            len = favList.data.length - 1;
        }
        if (channelIndex >= len) {
            channelIndex = 0;
            target.navTo(channelIndex);
        }
        channelIndex = target.getCurrIndex();
    };
    channelList.onkey_CHUP = function() {
        //todo 翻页
        var target = targetMap[oprtData.listIndex];
        target.prevPage();
        var len = 0;
        if(oprtData.listIndex == CHLISTINDEX.HIS) {
            len = hisList.data.length - 1;
        } else {
            len = favList.data.length - 1;
        }

        if (channelIndex == 0) {
            channelIndex = len; //favList.data.length - 1;
            target.navTo(channelIndex);
        }
        channelIndex = target.getCurrIndex();
    };

    liveTV.allList = allList;
    allList.onkey_CHUP = function() {
        allList.prevPage();
        if (channelIndex == 0) {
            channelIndex = allList.data.length - 1;
            allList.navTo(channelIndex);
        }
        channelIndex = allList.getCurrIndex();
    };
    allList.onkey_CHDOWN = function() {
        allList.nextPage();
        if (channelIndex >= allList.data.length - 1) {
            channelIndex = 0;
            allList.navTo(channelIndex);
        }
        channelIndex = allList.getCurrIndex();
    };

    channelList.onkey_CH_LIST = channelList.onkey_FAVCHANNEL = function() {
        UI.popSubModule();
        openLiveTVModule([Msg.INFO, 0]);
    };

    channelList.x = panelCenter;

    resetChannelList(liveTV.getChannelListOprtData());
    UI.addMask(listGroup, listWidth, listHeight, 20, 10);
};