/**
 * Created by jiangbo1 on 2016/2/29.
 */

UI.moduleBuilder['liveTV']['operateTip'] = function () {
    var infoDetailPageData = {
        bgImgBig: {color: "0x000000"},
        bgImg: {color: "0x363e5b"},
        title: "",  //"Live TV operating tutorial",[TV0136]
        tutorialText: "[TV0137]",   //"Welcome to check the navigation tutorial.",
        btnStartBgImg: UI.item_bg,
        btnStartText: "[SE0271]",
        helpTitle: "[TV0139]",  //"Press OK to load channel list",
        arrowLeft: "liveTV/operatetip/arrow_epg_dialog_left.png",
        arrowRight: "liveTV/operatetip/arrow_epg_dialog_right.png",
        helpImg: "liveTV/operatetip/6586_tutorial_na1.png",
        helpText: "[TV0140]",   //"You can press OK key to invoke channel list, and press back or OK to dismiss it.",
        footerImg: {color: "0x2f344d"},
        progressText: "1/4",
        footerIcon: "liveTV/operatetip/hotkey_tutorial_back_exit.png",
        footerText: "[SE1673]" //"Skip"
    };
    var template = Util.readJson("module/liveTV/operateTip.json");
    var optTip = SubModule.create(infoDetailPageData, template);

    var pageData = {
        "btnStartFlag": true,  //key_ENTER enable flag
        "index": 0,
        "helpTitleStr":isAmericanFlag()?[
            "[OT0063]",//Press [Up] to load info bar
            "[OT0062]",//"Press [OK] to load channel list"
            "[OT0466]",//"Press [Menu] to load onscreen menu",
            "[OT0065]"//"Press [Back] to jump to previous channel",
        ] : [
            "[OT0063]",//Press [Up] to load info bar
            "[OT0062]",//"Press [OK] to load channel list"
            "[OT0466]",//"Press [Menu] to load onscreen menu",
            "[OT0065]"//"Press [Back] to jump to previous channel",
        ],
        "helpImgUrl": [
                "liveTV/operatetip/6586_tutorial_na1.png",
                "liveTV/operatetip/6586_tutorial_na2.png",
                "liveTV/operatetip/6586_tutorial_na3.png",
                "liveTV/operatetip/6586_tutorial_na4.png"
            ],
        "helpTextStr":[
            "[OT0468]", //"Info bar shows channel number,channel name,program name,play process,\n the next program,more info of current program, and resolution etc.
            "[SE3863]", //Channel list shows channel number,channel name,program name. It gives\n you access to the channel management and your favorite lists.
            "[SE3864]", //Adjust subtitle, audio language or headphone and get access to your recording list in this menu
            ""
        ]
    };

    var bgImgBig = UI.getItem(optTip, "bgImgBig");
    var bgImg = UI.getItem(optTip, "bgImg");
    var tutorialText = UI.getItem(optTip, "tutorialText");
    var btnStart = UI.getItem(optTip, "btnStart");
    var helpTitle = UI.getItem(optTip, "helpTitle");
    var helpImg = UI.getItem(optTip, "helpImg");
    var arrowLeft = UI.getItem(optTip, "arrowLeft");
    var arrowRight = UI.getItem(optTip, "arrowRight");
    var helpText = UI.getItem(optTip, "helpText");
    var progressText = UI.getItem(optTip, "progressText");
    var footerGrp = UI.getItem(optTip, "footerGrp");
    var footerImg = UI.getItem(footerGrp, "footerImg");

    optTip.currFocus = btnStart;

    /*--------------------------Action---------------------------*/
    var footerIcon = UI.getItem(optTip, "footerIcon");
    var footerText = UI.getItem(optTip, "footerText");

    optTip.onPush = function() {
        DBG_ONXX("optTip", "onPush");
        if (Config.tv) model.tvservice.setPlaySuccessLiveTV(0);
        pageData.btnStartFlag = true;
        bgImgBig.alpha = 0.8;
        bgImg.alpha = 0.9;
        var bnds = footerText.getBounds();
        if(isAmericanFlag()) {
            footerIcon.width = 111;
            footerIcon.x = parseInt(footerImg.width - bnds.width - 140);
            setLiveTVImage(footerIcon, "liveTV/operatetip/hotkey_epg_back.png");
            pageData.helpImgUrl = [
                "liveTV/operatetip/photo_a_tutorial_na_1.png",
                "liveTV/operatetip/photo_a_tutorial_na_2.png",
                "liveTV/operatetip/photo_a_tutorial_na_3.png",
                "liveTV/operatetip/photo_a_tutorial_na_4.png"];
        } else {
            footerIcon.x = parseInt(footerImg.width - bnds.width - 195);
        }
        arrowLeft.alpha = 0;
        btnStart.y = 2920;//ɼŵԶ
        if (!pageData.btnStartFlag) return;
        createjs.Tween.removeAllTweens(focus);
        pageData.btnStartFlag = false;
        UI.base.cursor.alpha = 0;
        tutorialText.alpha = 0;
        btnStart.alpha = 0;
        helpTitle.alpha = 1;
        helpImg.alpha = 1;
        helpText.alpha = 0.6;
        arrowRight.alpha = 1;
        progressText.alpha = 0.6;
        pageData.index = 0;
        setLiveTVText(helpTitle, pageData.helpTitleStr[pageData.index]);
        setLiveTVImage(helpImg, pageData.helpImgUrl[pageData.index]);
        setLiveTVText(helpText, pageData.helpTextStr[pageData.index]);
        setLiveTVText(progressText, pageData.index + 1 + "/" + pageData.helpImgUrl.length);
        UI.updateStage();
    };

    optTip.onFocus = function(focus) {
        onFocusLiveTVTarget(focus, 1.05, 500);
    };
    optTip.onNormal = function(focus) {
        onNormalLiveTVTarget(focus, 1, 500);
    };

    optTip.onkey = function(focus, evt) {
        var enableKey = [
            CONST.KEY.VK_EXIT, CONST.KEY.VK_BACKSPACE,
            CONST.KEY.VK_ENTER, CONST.KEY.VK_LEFT, CONST.KEY.VK_RIGHT
        ];
        return enableKey.indexOf(evt.keyCode) > -1
    };
    btnStart.onkey_BACKSPACE = function() {
        UI.popAllModule();
        openLiveTVModule();
    };
    btnStart.onkey_RIGHT = function() {
        operateTipUpdate(1);
    };
    btnStart.onkey_LEFT = function() {
        operateTipUpdate(-1);
    };

    optTip.onkey_CHDOWN = function() {
    };
    optTip.onkey_CHUP = function() {
    };

    function operateTipUpdate(offset) {
        if (pageData.btnStartFlag) return;
        if (pageData.index + offset < 0 || pageData.index + offset > pageData.helpImgUrl.length - 1) return;
        pageData.index += offset;
        setLiveTVText(helpTitle, pageData.helpTitleStr[pageData.index]);
        setLiveTVImage(helpImg, pageData.helpImgUrl[pageData.index]);
        setLiveTVText(helpText, pageData.helpTextStr[pageData.index]);
        setLiveTVText(progressText, pageData.index + 1 + "/" + pageData.helpImgUrl.length);
        if (pageData.index == 0) {
            arrowLeft.alpha = 0;
            arrowRight.alpha = 1;
        }
        else if (pageData.index == pageData.helpImgUrl.length - 1) {
            arrowLeft.alpha = 1;
            arrowRight.alpha = 0;
        }
        else {
            arrowLeft.alpha = 1;
            arrowRight.alpha = 1;
        }
        UI.updateStage();
    }

    arrowLeft.doFlip = true;
    arrowRight.doFlip = true;

    try {
        if (!PIXI.loader.resources[themeDir + pageData.helpImgUrl[0]]) {
            pageData.helpImgUrl.forEach(function (v) {
                PIXI.loader.add(themeDir + v, themeDir + v);
            });
            PIXI.loader.once('complete', function () {
                DBG_ERROR("operaTip helpImgUrl load complete");
                UI.updateStage();
            });
            PIXI.loader.load();
        }
    }
    catch (ex) {
        DBG_ERROR("optTip: " + ex.message);
    }
};