
UI.moduleBuilder['launcher']['selectFilter'] = function(){
    var selectFilterData = {
        selectFilter_bg: UI.btn_normal_bg,
        MCTitle: "[SE3667]"//Menu

    };

    var template = Util.readJson("module/launcher/selectFilter.json");
    var selectFilter = SubModule.create(selectFilterData, template);
    var MCList = UI.getItem(selectFilter, "MCList");
   // var crntChips = ["list0", "list1"];
    var allChips = ["ABC", "123"];

    function createselectFilterList() {

        try {
            MCList.removeAllChildren();
            var gridInfo = {
                template: "launcherfilter_select",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceY: 20,
                distanceX: 0,
                container: MCList
            };
            var allArray = [];
            for (var i = 0; i < allChips.length; i++) {
                allArray.push(
                    {
                        bgImg: UI.item_bg,
                        iconImg : "Epos/ic_radio_button_normal.png",
                        nameTxt: allChips[i],
                        name: allChips[i],
                        voiceStr : allChips[i]
                    }
                )
            }
            MCList.initSequence = [];
            Gird.create(allArray, gridInfo);
            UI.addMask(MCList, 1200, 628, 40, 10);
            UI.setView(MCList, 1200, 628);
        } catch(ex){
            DBG_ERROR(ex.message);
        }
    }
    selectFilter.onPush = function () {
        createselectFilterList();
        var storage=window.localStorage;
        launcher.currFileterSelect = storage.currFileterSelect;
        if(!launcher.currFileterSelect){
            launcher.currFileterSelect = "ABC";
        }
        refresh(launcher.currFileterSelect);
        selectFilter.currFocus = UI.getItem(MCList, launcher.currFileterSelect);
    };
    selectFilter.onFocus = function(focus) {
        if (focus.children[0].name == "shadow") {
            focus.children[0].alpha = 0;
        }
        if (GLOBAL.HICONTRAST) {
            UI.base.toHiContrast(focus);
        }
        if(GLOBAL.TTS){
            if (focus.voiceStr) {
                UI.callTTS(focus.voiceStr);
            } else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.NETFLIX) {
                UI.callTTS(APPNAME.NETFLIX);
            } else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.AMAZONRUBY) {
                UI.callTTS(APPNAME.AMAZONRUBY);
            }else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.AMAZON) {
                UI.callTTS(APPNAME.AMAZON);
            }else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.YOUTUBE) {
                UI.callTTS(APPNAME.YOUTUBE);
            }else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.VUDU) {
                UI.callTTS(APPNAME.VUDU);
            }
            else {
                UI.callTTS(UI.base.getVoiceStr(focus))
            }
        }
        UI.moveCursor(UI.adjustView());
        UI.getTween(focus.scale).to({x:1.05, y:1.05}, 500, UI.ease.quartOut);
        UI.getTween(UI.base.cursor, false).wait(200).to({alpha:1}, 300, UI.ease.quartOut);
        UI.moveTop(focus);

        UI.base.runText(focus);
        return false;
    };
    selectFilter.onNormal = function () {
        MCList.initSequence[0].data.voiceStr = null;
        return true;
    };

    selectFilter.onPop = function(){
        DBG_ONXX("selectFilter", "onPop");
        UI.getTween(UI.base.cursor, true).set({scaleX: 1, scaleY: 1, alpha: 0});
    };

    selectFilter.onkey_ENTER = function (focus) {
        var index = focus.name;
        if(launcher.currFileterSelect != index){
            var item = UI.getItem(MCList, launcher.currFileterSelect);
            UI.setImage(item.children[1], "Epos/ic_radio_button_normal.png");
            launcher.currFileterSelect = focus.name;
            UI.setImage(focus.children[1], "setting/" + GLOBAL.UI_BRAND + "/ic_radiobutton_focused.png");
            var storage = window.localStorage;
            storage.setItem("currFileterSelect",launcher.currFileterSelect);
        }
        DBG_INFO("launcher.currFileterSelect is:" + launcher.currFileterSelect);
    };
    selectFilter.onkey_BACKSPACE=function(){
        UI.popSubModule();
    };

    function refresh(selectindex) {
        for (var i = 0; i < MCList.initSequence.length; i++) {
            var item = MCList.initSequence[i];
            if (selectindex == MCList.initSequence[i].name) {
                UI.setImage(item.children[1], "setting/" + GLOBAL.UI_BRAND + "/ic_radiobutton_focused.png");
            } else {
                UI.setImage(item.children[1], "Epos/ic_radio_button_normal.png");
            }
        }
    }
};