/**
 * Created by Brad on 2016/5/11.
 */

UI.moduleBuilder['launcher']['pictureResourceB'] = function(){
    /*default data*/
    var template = Util.readJson("module/launcher/pictureResourceB.json");
    var pictureResourceAData = {
        pictureResourceA_bg: {color:0x0000}
    };

    var pictureResourceB = SubModule.create(pictureResourceAData, template);
    var pictureResourceB_bg = UI.getItem(pictureResourceB,"pictureResourceB_bg");

    var resData = null;

    var topHeight = 0;
    var contentHeight = 0;
    var panelHeight = 1008;

    pictureResourceB.onFocus = function (focus) {
        UI.base.cursor.alpha=0;
        return false;
    };
    pictureResourceB.currFocus = UI.getItem(pictureResourceB, "pictureResourceB_bg");
    pictureResourceB.onNormal = function (focus) {
        return false;
    };

    pictureResourceB.afterPush = function () {
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 0;
    };
    pictureResourceB.onPop = function () {
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI.base.cursor.alpha = 0;

    };
    pictureResourceB.onPush = function () {
        resData = g_pictureResourceB.data;
        showPictureResource();
    };

    pictureResourceB.onExit = function(){
        $("#picture_resource_page").html("");
        $("#picture_resource_page").css("display", "none");
    };

    pictureResourceB.onkey_BACKSPACE = function () {

        $("#picture_resource_page").html("");
        $("#picture_resource_page").css("display", "none");
        return true;
    };

    pictureResourceB.onkey_UP = function(){
        DBG_INFO("up:"+topHeight);
        if(0 == topHeight || topHeight<0) return;
        topHeight -= 0.1 * panelHeight;

        $("#pictureResourceB_bg").css("margin-top", (-topHeight) + "px");

    }

    pictureResourceB.onkey_DOWN = function(){
        DBG_INFO("down:"+contentHeight + " "+(topHeight+panelHeight));
        contentHeight = $("#pictureResourceB_bg").height();
        if(contentHeight <= panelHeight) return;
        if(topHeight + panelHeight >= contentHeight) return;
        topHeight += 0.1 * panelHeight;
//    topHeight = topHeight+270;

        $("#pictureResourceB_bg").css("margin-top", (-topHeight) + "px");
//    $("#pictureResourceB_bg").css("height", height);

    }

    function showPictureResource(){
        var all = '';
        for(var i = 0;i<resData.length;i++){
            var img = '<div class="pictureResourceB_img_div"><img  class="pictureResourceB_img" src='+resData[i].Icon+'></div>';
            var title = '<span class="pictureResourceB_text_title">'+resData[i].Name+'</span>';
            var txt = '<span class="pictureResourceB_text">'+resData[i].Detail+'</span>';

            all = all+img+title+txt;
        }
        var htmlStr;

        htmlStr = '<div id="pictureResourceB_bg" class="pictureResourceB_bg" >'+all+'</div>';
        $("#picture_resource_page").html(htmlStr);
        $("#picture_resource_page").css("display", "block");
        contentHeight = $("#pictureResourceB_bg").height();
        topHeight = 0;
    }


};