/**
 * Created by Brad on 2016/5/11.
 */

UI.moduleBuilder['launcher']['pictureResourceA'] = function(){
    /*default data*/
    var template = Util.readJson("module/launcher/pictureResourceA.json");
    var pictureResourceAData = {
        pictureResourceA_bg: {color:0x0000}
    };

    var pictureResourceA = SubModule.create(pictureResourceAData, template);
    var pictureResourceA_bg = UI.getItem(pictureResourceA,"pictureResourceA_bg");

    var resData = null;
    var showAll = false;
    var index = 0;


    pictureResourceA.onFocus = function (focus) {
        UI.base.cursor.alpha=0;
        return false;
    };
    pictureResourceA.currFocus = UI.getItem(pictureResourceA, "pictureResourceA_bg");
    pictureResourceA.onNormal = function (focus) {
        return false;
    };

    pictureResourceA.afterPush = function () {
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 0;
    };
    pictureResourceA.onPop = function () {
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI.base.cursor.alpha = 0;

    };
    pictureResourceA.onPush = function () {
        resData = g_pictureResource.data;
        showPictureResource();
    };

    pictureResourceA.onExit = function(){
        $("#picture_resource_page").html("");
        $("#picture_resource_page").css("display", "none");
    };

    pictureResourceA.onkey_BACKSPACE = function () {
//        if(showAll){
//            showAll = false;
//            $("#pictureResourceA_All").css("display", "none");
//            $("#pictureResourceA_text_bg").css("display", "block");
//            if(resData.length == 1){
//                $("#pictureResourceA_left_img").css("display", "none");
//                $("#pictureResourceA_right_img").css("display", "none");
//            }else{
//                $("#pictureResourceA_left_img").css("display", "block");
//                $("#pictureResourceA_right_img").css("display", "block");
//
//            }
//            return false;
//        }
        $("#picture_resource_page").html("");
        $("#picture_resource_page").css("display", "none");
        return true;
    };
    pictureResourceA.onkey_RIGHT = function(){
        DBG_INFO("pictureResourceA.onkey_RIGHT:"+resData.length);
        if(resData.length == 1){
            return;
        }
        if(index == resData.length-1){
            index = 0;
        }else{
            index++;
        }

        $("#pictureResourceA_img").attr("src",resData[index].Icon);
        $("#pictureResourceA_text_title").text(resData[index].Name);
        $("#pictureResourceA_text").text(resData[index].Detail);
        $("#pictureResourceA_All").css("display", "none");
        showAll = false;
        if(resData.length == 1){
            $("#pictureResourceA_left_img").css("display", "none");
            $("#pictureResourceA_right_img").css("display", "none");
        }else{
            $("#pictureResourceA_left_img").css("display", "block");
            $("#pictureResourceA_right_img").css("display", "block");

        }
        if(resData[index].Name.length == 0 && resData[index].Detail.length == 0){
            $("#pictureResourceA_text_bg").css("display", "none");
            $("#pictureResourceTextMask").css("display", "none");
        }else{
            $("#pictureResourceA_text_bg").css("display", "block");
            if(resData[index].Detail.length > 0){
                $("#pictureResourceTextMask").css("display", "block");
            }else{
                $("#pictureResourceTextMask").css("display", "none");
            }
        }

    }

    pictureResourceA.onkey_LEFT= function(){
        if(resData.length == 1){
            return;
        }
        if(index == 0 ){
            index = resData.length-1;
        }else{
            index--;
        }

        $("#pictureResourceA_img").attr("src",resData[index].Icon);
        $("#pictureResourceA_text_title").text(resData[index].Name);
        $("#pictureResourceA_text").text(resData[index].Detail);
        $("#pictureResourceA_All").css("display", "none");

        showAll = false;
        if(resData.length == 1){
            $("#pictureResourceA_left_img").css("display", "none");
            $("#pictureResourceA_right_img").css("display", "none");
        }else{
            $("#pictureResourceA_left_img").css("display", "block");
            $("#pictureResourceA_right_img").css("display", "block");

        }
        if(resData[index].Name.length == 0 && resData[index].Detail.length == 0){
            $("#pictureResourceA_text_bg").css("display", "none");
            $("#pictureResourceTextMask").css("display", "none");
        }else{
            $("#pictureResourceA_text_bg").css("display", "block");
            if(resData[index].Detail.length > 0){
                $("#pictureResourceTextMask").css("display", "block");
            }else{
                $("#pictureResourceTextMask").css("display", "none");
            }
        }
    }

    pictureResourceA.onkey_UP = function(){

    }

    pictureResourceA.onkey_DOWN = function(){
        if(!showAll){
            if(resData[index].Detail.length == 0){
                return;
            }
            showAll = true;
            $("#pictureResourceA_text_bg").css("display", "none");
            $("#pictureResourceA_All").css("display", "block");
            $("#pictureResourceA_All_title").text(resData[index].Name);
            $("#pictureResourceA_All_text").text(resData[index].Detail);
            $("#pictureResourceA_left_img").css("display", "none");
            $("#pictureResourceA_right_img").css("display", "none");
            $("#pictureResourceTextMask").css("display", "none");
        }
    }

    function showPictureResource(){
        var htmlStr;
        htmlStr = '<img id="pictureResourceA_img" class="pictureResourceA_img" />'+
            '<img id="pictureResourceA_left_img" class="pictureResourceA_left_img" src="../hisenseUI/assets/ThemeDefault/launcher/controlcenter/arrow_notification_left.png" />'+
            '<img id="pictureResourceA_right_img" class="pictureResourceA_right_img" src="../hisenseUI/assets/ThemeDefault/launcher/controlcenter/arrow_notification_right.png" />'+
            '<div id="pictureResourceA_text_bg" class="pictureResourceA_text_bg">'+
            '<span id="pictureResourceA_text_title" class="pictureResourceA_text_title">Title</span>'+
            '<span id="pictureResourceA_text" class="pictureResourceA_text">Title</span></div>'+
            '<div id="pictureResourceA_All" class="pictureResourceA_All">'+
            '<span id="pictureResourceA_All_title" class="pictureResourceA_All_title">Title</span>'+
            '<span id="pictureResourceA_All_text" class="pictureResourceA_All_text">Title</span></div></div>'+
            '<div id="pictureResourceTextMask" class="pictureResourceTextMask"></div>';
        $("#picture_resource_page").html(htmlStr);
        $("#picture_resource_page").css("display", "block");

        if(resData.length == 1){
            $("#pictureResourceA_left_img").css("display", "none");
            $("#pictureResourceA_right_img").css("display", "none");
        }else{
            $("#pictureResourceA_left_img").css("display", "block");
            $("#pictureResourceA_right_img").css("display", "block");

        }
        $("#pictureResourceA_img").attr("src",resData[0].Icon);
        $("#pictureResourceA_text_title").text(resData[0].Name);
        $("#pictureResourceA_text").text(resData[0].Detail);
        $("#pictureResourceA_All").css("display", "none");

        if(resData[0].Name.length == 0 && resData[0].Detail.length == 0){
            $("#pictureResourceA_text_bg").css("display", "none");
            $("#pictureResourceTextMask").css("display", "none");
        }else{
            $("#pictureResourceA_text_bg").css("display", "block");
            if(resData[0].Detail.length > 0){
                $("#pictureResourceTextMask").css("display", "block");
            }else{
                $("#pictureResourceTextMask").css("display", "none");
            }

        }

        index = 0;

    }


};