// Init
UI.moduleBuilder['launcher']['notifications'] = function(){

    var notificationData = {
        bgImg: UI.back_bg,
        clearBtnImg: UI.btn_normal_bg,
        emptyImg: "launcher/la_ic_empty_message.png",
        bgImg1 : {color : "0x7BBB36"},
        iconImg : "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_notifications_no.png",
        nameTxt : "[SE2970]",//Notifications
        emptyTxt:"[SE3664]",//There are no new Notifications to show

        redBtnImg : "launcher/ic_hotkey_red.png",
        yellowBtnImg : "launcher/ic_hotkey_yellow.png",
        greenBtnImg : "launcher/ic_hotkey_green.png",
        blueBtnImg : "launcher/ic_hotkey_blue.png",
        innerShadow:{color:"#000000"},

        toastBgImg : "toast/Toast_bg2.png",
        toastImg:"launcher/ic_warn.png"
    };
    if(GLOBAL.LAUNCHER_BRAND == "shp"){
        notificationData.bgImg = {color : "0x282425"};
        notificationData.bgImg1 = {color : "0x282425"};
    }
    else{
        if(GLOBAL.UI_BRAND == "tos"){
            // notificationData.bgImg = {color : "0x0F1839"};
            notificationData.bgImg1 = {color : "0x0F1839"};
        }else{
            notificationData.bgImg = UI.back_bg;
            notificationData.bgImg1 = {color : "0x7BBB36"};
        }

    }
    var template = Util.readJson("module/launcher/notifications.json");
    var notification = SubModule.create(notificationData, template);


    var notificationIcon = UI.getItem(notification, "notificationIcon");
    var notificationPanel = UI.getItem(notification, "notificationPanel");
    var notifyAnchor = UI.getItem(notificationPanel, "notifyAnchor");
    var msgPanel = UI.getItem(notification, "msgPanel");
    msgPanel.alpha = 0;
    notification.id = 0;
    notification.poster_type = 0;

    var redBtn = UI.getItem(notification, "redBtn");
    var yellowBtn = UI.getItem(notification, "yellowBtn");
    var greenBtn = UI.getItem(notification, "greenBtn");
    var blueBtn = UI.getItem(notification, "blueBtn");
    var innerShadow = UI.getItem(notificationPanel, "innerShadow");

    var titleTxt = UI.getItem(notificationPanel, "titleTxt");
    var empty = UI.getItem(notification, "empty");
    var clearBtn = UI.getItem(notification, "clearBtn");

    var Notifications = [];
    var  CloseReason=null;
    var ratingJson={};

//    function UTCToLocalDate(utc) {
//        var localDT1 = new Date(getLocalTimeByUTC(utc) * GLOBAL.MILLIBASE);
//        localDay1 = ('0' + localDT1.getUTCDate()).slice(-2) + "/" + ('0' + (localDT1.getUTCMonth() + 1)).slice(-2) + "/" + (localDT1.getFullYear());
//        return localDay1;
//    }
    function refreshNotification() {
        var array = [];
        for (var i = 0; i < Notifications.length; i++) {
            var d = UTCToLocalDate(parseInt(Notifications[i].date),false);
            var t = UTCToLocalTime(parseInt(Notifications[i].date), GLOBAL.TIME_FORMAT);
            if(Notifications[i].cmd == LauncherCMD.INPUT){
                for (var x = 0; x < launcher.allInputsData.length; x++) {
                    if (Notifications[i].data == launcher.allInputsData[x].id) {
                        Notifications[i].Name = launcher.allInputsData[x].name;
                        if(!!launcher.allInputsData[x].rename){
                            Notifications[i].Name = launcher.allInputsData[x].rename;
                        }
                        break;
                    }
                }
            }
            var data = {
                iconDefaultImg: "launcher/title/default.png",
                iconImg: Notifications[i].Icon,
                bgImg: UI.item_bg,
                titleTxt: Notifications[i].Name,
                contentTxt: Notifications[i].Detail,
                dateTxt:d,
                timeTxt:t,
                name: "notify" + i
            };
            array.push(data);
        }

        var info = {
            template: "launcher_tile_panel_5",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 1,
            distanceX: 12,
            distanceY: 24,
            container: notifyAnchor
        };
        if (Notifications.length == 0) {
            var iconImg = UI.getItem(notification, "iconImg");
            UI.setImage(iconImg,  "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_notifications_no.png");
            UI.focusTo(empty);
            notification.currFocus = empty;
            empty.alpha = 1;
            redBtn.alpha = 0.1;
            notifyAnchor.removeAllChildren();
        } else {
            notifyAnchor.removeAllChildren();
            Gird.create(array, info);
            UI.addMask(notifyAnchor, 1200, 922, 45, 25);
            UI.setView(notifyAnchor, 1200, 922);
//            notifyAnchor.upTo = "clearBtn";
            notifyAnchor.firstFocus = UI.getItem(notifyAnchor, "notify0");
            notifyAnchor.lastFocus = notification.firstFocus;
            var iconImg = UI.getItem(notification, "iconImg");
            UI.setImage(iconImg, "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_notifications_yes.png");
            UI.focusTo(notifyAnchor.firstFocus);
            notification.currFocus = UI.getItem(notifyAnchor, "notify0");
            empty.alpha = 0;
            redBtn.alpha = 1;
        }
    }

    notification.onShow = function () {
        clearBtn.alpha = 0;
        //notificationPanel.x = 1920 + notificationPanel.pivot.x;
        //UI.getTween(notificationPanel).to({x:notificationPanel.initPos.x}, 500, UI.ease.quartOut);
        try{
            ratingJson=getSystemRating();
            var param={
                PanelName:UI.getCurrSubModule().name,
                CloseReason:0
            };
            DBG_INFO("log report GTLauncherPanel "+param.PanelName+" is open");
            LGReport.GTLauncherPanelStart(param.PanelName,param.CloseReason);
            Notifications = getNotificationData();
            var text = Notifications.length + " [SE2970]";
            UI.setText(titleTxt, text);
            refreshNotification();
            setNotificationTimeStamp();
        }catch(ex){DBG_ERROR(ex.message);}
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.USB_DEVICE_CHANGED, notificationOnUsbChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SOURCE_DETECT_CHANGED, notificationSourceDetectChanged);
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 1;
        UI.base.cursor.visible = true;
        UI.updateStage();
    };
    notification.onPop = function() {
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.USB_DEVICE_CHANGED,notificationOnUsbChanged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SOURCE_DETECT_CHANGED,notificationSourceDetectChanged);
        try{

            var param={
                PanelName:"notifications",
                CloseReason:1
            };
            if(!!CloseReason){
                param.CloseReason = CloseReason;
                CloseReason = 1;
            }
            if(param.PanelName=="notifications"||param.PanelName=="allApps"||param.PanelName=="allInputs")
            {
                DBG_INFO("log report GTLauncherPanel "+param.PanelName+" is closed");
                LGReport.GTLauncherPanelClose(param.PanelName,param.CloseReason);
            }
        }catch(ex){DBG_ERROR(ex.message);}
    };
    notification.onkey_RED = function (){
        notifyAnchor.removeAllChildren();
        empty.alpha = 1;
        redBtn.alpha = 0.1;
        UI.focusTo(empty);
        notification.currFocus = empty;
        UIObserver.clearNotifications();
        clearNotificationApps();
        //clearAcrNotification();
        var text = 0 + " [SE2970]";
        UI.setText(titleTxt, text);
        var iconImg = UI.getItem(notification, "iconImg");
        UI.setImage(iconImg, "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_notifications_no.png");
        //UI.focusTo(empty);
        // UI.base.cursor.width = UI.base.cursor.width - 10;
        UI.updateStage();
    };

    notifyAnchor.onkey_ENTER = function (focus) {
        var index = notifyAnchor.initSequence.indexOf(focus);
        DBG_INFO("notifyAnchor!!!!" + index);
        DBG_INFO("notifyAnchor!!!!" + Notifications[index].cmd);
        try{
            var param={
                MsgType:'',
                MsgId:Notifications[index].Name,
                Where:2,
                Interaction:1
            };
            try{
                if (Notifications[index].cmd == LauncherCMD.HIMEDIA) {
                    launcher.popSelf(false);
                    param.MsgId="media";
                    //UI.pushSubModule("hiMedia", "deviceBrowser", true, null, {caller: "launcher"});
//                    UI.pushModule("hiMedia",  {caller:"launcher"});
                    startThirdPartyApp(null, APPNAME.HIMEDIA, CMDType.HISENSEPAGE, CMDMethod.MENU, false, 0xFFFFFF);
                    param.MsgType=1;
                } else if (Notifications[index].cmd == LauncherCMD.APP) {
                    UI.popAllModule();
                    param.MsgType=3;
                    startThirdPartyApp(null, Notifications[index].data.url, Notifications[index].data.urlType, CMDMethod.MENU, false, 0xFFFFFF,Notifications[index].Name,Notifications[index].data.storeType);
                } else if (Notifications[index].cmd == LauncherCMD.INPUT) {
                    //if (launcher.caller.name == "dlna" || launcher.caller.name == "hiMedia" || checkIsAppOn()) {
                    //    var msgTxt = UI.getItem(notificationPanel, "msgTxt");
                    //    var msgPanel = UI.getItem(notificationPanel, "msgPanel");
                    //    UI.setText(msgTxt, "Please exit app before change source.");
                    //    UI.getTween(msgPanel).to({alpha:1}, 400).wait(1000).to({alpha:0}, 400);
                    //    return;
                    //}
                    changeSourceTo(Notifications[index].data);
                    UI.popAllModule();
                    param.MsgType=1;
                    openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
              //  }else if (Notifications[index].cmd == LauncherCMD.ACRMSG) {
                 //   return;
                }else if (Notifications[index].cmd == LauncherCMD.ACRMSG) {
                    return;
                }
                else if (Notifications[index].cmd == LauncherCMD.SERVERMSG) {
                    DBG_ERROR(" "+objToString(Notifications[index].data));
                    if(Notifications[index].data.type == "video"){
                        var showPwd = isVideoLimitByRating(Notifications[index].data.parent_control);
                        DBG_ERROR("showPwd:"+showPwd);
                        if(Notifications[index].data.has_detail_page == 1){
                            notification.id = Notifications[index].data.id;
                            DBG_ERROR("is:"+notification.id);
                            notification.poster_type = Notifications[index].data.poster_type;
                            if(showPwd && GLOBAL.PARENTAL_LOCK_SWITCH){
                                UI.pushSubModule("launcher", "moviePasswordDialog", true, {caller: "hasDetail"});
                            }else{
                                UI.pushSubModule("launcher", "launcherMovieDetail", true);
                            }
//                            UI.pushSubModule("launcher", "launcherMovieDetail", true);
                        }else{
                            if(showPwd && GLOBAL.PARENTAL_LOCK_SWITCH){
                                notification.id = Notifications[index].data.id;
                                UI.pushSubModule("launcher", "moviePasswordDialog", true, {caller: "noDetail"});
                                return;
                            }
                            http_adapter.getVideoDetailById(Notifications[index].data.id,"notification",0,null,function (result,v) {
                                if(UI.getCurrSubModule().name!="notifications"){
                                    DBG_ERROR("notifications is on pop!!!!!! ");
                                    UI.endLoading();
                                    return;
                                }
                                if(!v){
                                    v = null;
                                }
                                if(v != null && result == 0){

                                    if(v.provider_list.length>=1){
                                        var storeType = 98;
//                                        hideForAppStorePlay(0);
                                        UI.popAllModule();
                                        var cmd = CMDMethod.MENU;
                                        var appName = v.provider_list[0].provider_name.toLowerCase().replace(" ", "");
                                        if(appName == "vudu" || appName == "amazon" ||
                                            appName == "youtube"){
                                            cmd = CMDMethod.COMMANDURL;
                                            storeType = StoreType.YOUTUBE;
                                        }else{
                                            appName = null;
                                        }
                                        startThirdPartyApp(appName,v.provider_list[0].deep_linking,37,cmd, false, 0xFFFFFF,v.title,storeType);
                                    }
                                }
                            });
                        }

                    }

                    return;
                }
                else if (Notifications[index].cmd == LauncherCMD.PICTURE) {
                    UI.pushSubModule("launcher", "pictureResourceA",true);
                }
                else if (Notifications[index].cmd == LauncherCMD.PICTURE_B) {
                    UI.pushSubModule("launcher", "pictureResourceB",true);
                }
            }catch(ex){DBG_ERROR(ex.message)}
            DBG_INFO("GTLauncherNOTDialogReport");
            LGReport.GTLauncherNOTDialogReport(param.MsgType,param.MsgId,param.Where,param.Interaction);
        }catch(ex){DBG_ERROR(ex.message)}

    };

    notification.onkey_BACKSPACE = function () {
        UI.inactiveKey();
        CloseReason=4;
        UI.popSubModule();
        //UI.getTween(notificationPanel)
        //    .to({x: 1920 + notificationPanel.pivot.x}, 500)
        //    .call(UI.popSubModule, [null]);
    };
    notificationPanel.onkey_LEFT = function(focus) {
        if (!focus.leftTo) {
            notification.onkey_BACKSPACE();
        } else {
            return true;
        }
    };
    notifyAnchor.onFocus = function (focus) {
        notifyAnchor.lastFocus = focus;
        clearBtn.lastFocus = focus;
        return true;
    };

    //clearBtn.onFocus = function () {
    //    if(Notifications.length>0){
    //        clearBtn.downTo = notifyAnchor.firstFocus.name;
    //    }
    //    return true;
    //};
   
    //clearBtn.onkey_ENTER = function () {
    //    notifyAnchor.removeAllChildren();
    //    empty.alpha = 1;
    //    UIObserver.clearNotifications();
    //    clearNotificationApps();
    //    //clearAcrNotification();
    //    var text = 0 + " [SE2970]";
    //    UI.setText(titleTxt, text);
    //    var iconImg = UI.getItem(notification, "iconImg");
    //    UI.setImage(iconImg, "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_notifications_no.png");
    //    UI.focusTo(clearBtn);
    //    //UI.base.cursor.width = UI.base.cursor.width - 10;
    //    UI.updateStage();
    //}

    notification.onFocus = function(focus) {
        if (GLOBAL.HICONTRAST) {
            UI.base.toHiContrast(focus);
        }
        if(GLOBAL.TTS){
            if (focus.voiceStr) {
                UI.callTTS(focus.voiceStr);
            } else {
                UI.callTTS(UI.base.getVoiceStr(focus))
            }
        }
        UI.moveCursor(UI.adjustView());
        UI.getTween(focus.scale).to({x:1.05, y:1.05}, 200, UI.ease.quartOut);
        UI.getTween(UI.base.cursor).to({alpha:1}, 500, UI.ease.quartOut);
        UI.moveTop(focus);
        UI.base.runText(focus);
    };

    notification.onNormal = function(focus) {
        if (GLOBAL.HICONTRAST) {
            UI.base.toNormalContrast(focus);
        }
        UI.getTween(focus.scale).to({x:1, y:1}, 500, UI.ease.quartOut);
        UI.getTween(UI.base.cursor).set({alpha:0});
        UI.base.stopText(focus);
    };
    function notificationOnUsbChanged(val){
        if (val[1].indexOf("FSL2") == -1 ) {
            return;
        }
        clearBtn.alpha = 0;
        try{
            Notifications = getNotificationData();
            if(notification){
                if(Notifications.length == "0"){
                    var iconImg = UI.getItem(notification, "iconImg");
                    UI.setImage(iconImg,"launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_notifications_no.png");
                }
                else{
                    var iconImg = UI.getItem(notification, "iconImg");
                    UI.setImage(iconImg, "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_notifications_yes.png");
                }
            }
            var text = Notifications.length + " [SE2970]";
            UI.setText(titleTxt, text);
            refreshNotification();
            setNotificationTimeStamp();
        }catch(ex){DBG_ERROR(ex.message);}

    }
    function notificationSourceDetectChanged(){
        clearBtn.alpha = 0;
        launcher.allInputNeedUpdate = true;
        try{
            Notifications = getNotificationData();
            if(notification){
                if(Notifications.length == "0"){
                    var iconImg = UI.getItem(notification, "iconImg");
                    UI.setImage(iconImg,"launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_notifications_no.png");
                }
                else{
                    var iconImg = UI.getItem(notification, "iconImg");
                    UI.setImage(iconImg, "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_notifications_yes.png");
                }
            }
            var text = Notifications.length + " [SE2970]";
            UI.setText(titleTxt, text);
            refreshNotification();
            setNotificationTimeStamp();
            setAlpha();
        }catch(ex){DBG_ERROR(ex.message);}
    }

    function setAlpha(){
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 1;
        UI.base.cursor.visible = true;
        UI.updateStage();
    }

    function getSystemRating(){
        var ratings = "\"{enable:0}\"";
        ratingsJson = JSON.parse(ratings);
        if(!tv){
            return null;
        }
        try {
            //get parameters from system
            ratings = JSON.stringify(UI_Hisense_GetParentControls());
            var ratingsJson = JSON.parse(ratings);
            if(ratingsJson.enable != 0 && ratingsJson.enable != 1){
                DBG_ERROR("Hisense_GetParentControls: ratings.enable = "+ratingsJson.enable);
                ratingsJson.enable = 0;
            }
        }catch(e){
            ratingsJson = JSON.parse(ratings);
            DBG_ERROR(e);
        }
        return ratingsJson;
    }

    function isVideoLimitByRating(video_parent_control){//true:limit, false:not
        if(!tv){
            return true;
        }
        if(ratingJson==null){
            ratingJson=getSystemRating();
        }
        if(ratingJson.enable == 0) {
            return false;//disabled rating function
        }else if(ratingJson.enable == 1) {
            if(ratingJson.Unrated != "OFF") {
                if(video_parent_control.toLowerCase() == ratingJson.Unrated.toLowerCase()){
                    return true;
                }
            }
            if(ratingJson.US_TV_Ratings != "OFF") {
                var kick = [];//the final array passed in
                switch(ratingJson.US_TV_Ratings) {
                    case "TV-G": {
                        kick = ["TV-G", "TV-PG", "TV-14", "TV-MA"];
                        break;
                    }
                    case "TV-PG": {
                        kick = ["TV-PG", "TV-14", "TV-MA"];
                        break;
                    }
                    case "TV-14": {
                        kick = ["TV-14", "TV-MA"];
                        break;
                    }
                    case "TV-MA": {
                        kick = ["TV-MA"];
                        break;
                    }
                }//end of switch
                for(var i in kick) {
                    if(video_parent_control.toLowerCase() === kick[i].toLowerCase()) {
                        return true;
                    }
                }
            }
            if(ratingJson.US_TV_Children_Ratings != "OFF") {
                kick = [];//the final array passed in
                switch(ratingJson.US_TV_Children_Ratings) {
                    case "TV-Y": {
                        kick = ["TV-Y", "TV-Y7", "TV-Y7-FV"];
                        break;
                    }
                    case "TV-Y7": {
                        kick = ["TV-Y7","TV-Y7-FV"];
                        break;
                    }
                    case "TV-Y7-FV": {
                        kick = ["TV-Y7-FV"];
                        break;
                    }
                }//end of switch
                for(var i in kick) {
                    if(video_parent_control.toLowerCase() === kick[i].toLowerCase()) {
                        return true;
                    }
                }
            }
            if(ratingJson.US_MOVIE_Ratings != "OFF") {
                kick = [];//the final array passed in
                switch(ratingJson.US_MOVIE_Ratings) {
                    case "G": {
                        kick = ["G", "PG", "PG-13", "R", "NR", "UR", "NC-17", "X", "XXX"];
                        break;
                    }
                    case "PG": {
                        kick = ["PG", "PG-13", "R", "NR", "UR", "NC-17", "X", "XXX"];
                        break;
                    }
                    case "PG-13": {
                        kick = ["PG-13", "R", "NR", "UR", "NC-17", "X", "XXX"];
                        break;
                    }
                    case "R": {
                        kick = ["R", "NR", "UR", "NC-17", "X", "XXX"];
                        break;
                    }
                    case "NC-17": {
                        kick = ["NC-17", "X", "XXX"];
                        break;
                    }
                    case "X": {
                        kick = ["X", "XXX"];
                        break;
                    }
                }//end of switch
                for(var i in kick) {
                    if(video_parent_control.toLowerCase() === kick[i].toLowerCase()) {
                        return true;
                    }
                }
            }
            if(ratingJson.Canadian_English_Ratings != "OFF") {
                kick = [];//the final array passed in
                switch(ratingJson.Canadian_English_Ratings) {
                    case "C": {
                        kick = ["C", "C8", "G", "PG", "14+", "18+"];
                        break;
                    }
                    case "C8": {
                        kick = ["C8", "G", "PG", "14+", "18+"];
                        break;
                    }
                    case "G": {
                        kick = ["G", "PG", "14+", "18+"];
                        break;
                    }
                    case "PG": {
                        kick = ["PG", "14+", "18+"];
                        break;
                    }
                    case "14+": {
                        kick = ["14+", "18+"];
                        break;
                    }
                    case "18+": {
                        kick = ["18+"];
                        break;
                    }
                }//end of switch
                for(var i in kick) {
                    if(video_parent_control.toLowerCase() === kick[i].toLowerCase()) {
                        return true;
                    }
                }
            }
            if(ratingJson.Canadian_French_Ratings != "OFF") {
                kick = [];//the final array passed in
                switch(ratingJson.Canadian_English_Ratings) {
                    case "G": {
                        kick = ["G", "8ANS+", "13ANS+", "16ANS+", "18ANS+"];
                        break;
                    }
                    case "8ANS+": {
                        kick = ["8ANS+", "13ANS+", "16ANS+", "18ANS+"];
                        break;
                    }
                    case "13ANS+": {
                        kick = ["13ANS+", "16ANS+", "18ANS+"];
                        break;
                    }
                    case "16ANS+": {
                        kick = ["16ANS+", "18ANS+"];
                        break;
                    }
                    case "18ANS+": {
                        kick = ["18ANS+"];
                        break;
                    }
                }//end of switch
                for(var i in kick) {
                    if(video_parent_control.toLowerCase() === kick[i].toLowerCase()) {
                        return true;
                    }
                }
            }
            return false;
        }
        return false;//no cc function set
    }
};