/**
 * Created by jiangbo1 on 2016/3/7.
 */

UI.moduleBuilder['common']['deviceConnected'] = function () {
    /*default data*/
    var template = Util.readJson("module/common/deviceConnected.json");
    var deviceConnectedData = {
        device_bg: UI.window_bg,
        deviceIcon: GLOBAL.IMAGE_LIST.DEVICE_USB,
        btn_no_bg: UI.item_bg,
        btn_yes_bg: UI.item_bg,
        deviceTip: "[DMP0173]",
        btn_no_text: "[GE0008]",
        btn_yes_text: "[BR0081]"
    };
    var deviceConnected = SubModule.create(deviceConnectedData, template);
    deviceConnected.protected = true;
    var BtnYes = UI.getItem(deviceConnected, "BtnYes");
    var BtnNo = UI.getItem(deviceConnected, "BtnNo");
    var deviceTip = UI.getItem(deviceConnected, "deviceTip");
    deviceConnected.currFocus = BtnYes;
    BtnYes.alpha = BtnNo.alpha = 0.6;
    UI.getItem(deviceConnected, "deviceTip").alpha = 0.6;
    var str = Config.language.DMP0173;
    if(!!GLOBAL.CURRENT_DEVICE_NAME) {
        str = str.replace(/\[.*?\]/g, GLOBAL.CURRENT_DEVICE_NAME);
    }else{
        str = str.replace(/\[.*?\]/g, "[SE2229]");
    }
    var device = UI.setString(str+"[BR0081]");
    UI.setText(deviceTip, str);
    var CALLMODE;
    deviceConnected.onPush = function () {
        //deviceConnected.currFocus = BtnYes;
        BtnYes.voiceStr = device;
        //UI.focusTo(BtnYes);
    };
    deviceConnected.onShow = function () {
        CALLMODE = true;
    };
    deviceConnected.onFocus = function (focus) {
        if (GLOBAL.HICONTRAST) {
            UI.base.toHiContrast(focus);
        }
        if (GLOBAL.TTS) {
            if (focus.voiceStr) {
                UI.callTTS(focus.voiceStr);
            } else {
                UI.callTTS(UI.base.getVoiceStr(focus))
            }
        }
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.moveCursor(UI.adjustView());
        UI.getTween(focus.scale).to({x: 1.05, y: 1.05}, 200, UI.ease.quartOut);
        UI.getTween(UI.base.cursor).to({alpha: 1}, 500, UI.ease.quartOut);
        UI.moveTop(focus);
        UI.base.runText(focus);
    };

    deviceConnected.afterPush = function () {
        UI.getTween(UI).wait(10000);
        try {
            UI.deleteFuncQueue(openMsgBox, MsgBoxType.DEVICE_CONNECTED);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    };

    deviceConnected.onNormal = function (focus) {
        if (GLOBAL.HICONTRAST) {
            UI.base.toNormalContrast(focus);
        }
        createjs.Tween.removeTweens(focus.scale);
        focus.scale.x = 1;
        focus.scale.y = 1;
        UI.base.stopText(focus);
    };
    BtnNo.onFocus = function (focus) {
        BtnYes.voiceStr = null;
        return true;
    }
    BtnYes.onkey_ENTER = function () {
        //UI.popSubModule();
        //open DMP module
        //UI.pushSubModule("hiMedia", "deviceBrowser", true);
        UI.popAllModule();
        UI.pushModule("hiMedia", {caller: "dialog"});
    };

    deviceConnected.onPop = function () {
        //UI.getTween(BtnYes, true).set({scaleX: 1, scaleY: 1});
        //UI.getTween(BtnNo, true).set({scaleX: 1, scaleY: 1});
        //UI.getTween(UI.base.cursor, true).set({scaleX: 1, scaleY: 1, alpha: 0});
        BtnYes.scale.x = 1;
        BtnYes.scale.y = 1;
        BtnNo.scale.x = 1;
        BtnNo.scale.y = 1;
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI.base.cursor.alpha = 0;
    }

    BtnNo.onkey_ENTER = deviceConnected.onkey_EXIT = deviceConnected.onkey_BACKSPACE = closeMsgBox;
};