/**
 * Created by Brad on 2016/5/11.
 */

UI.moduleBuilder['common']['installAppDialog'] = function(){
    /*default data*/
    var template = Util.readJson("module/common/installAppDialog.json");
    var commonDialogData = {
        common_bg: UI.window_bg,
        btn_left_bg: UI.item_bg,
        btn_right_bg: UI.item_bg
    };

    var commonDialog = SubModule.create(commonDialogData, template);
    var BtnRight = UI.getItem(commonDialog, "BtnRight");
    var BtnLeft = UI.getItem(commonDialog, "BtnLeft");
    commonDialog.currFocus = BtnLeft;
    BtnRight.alpha = BtnLeft.alpha = 0.6;

    UI.getItem(commonDialog, "commonContent").alpha = 0.6;
    var data = {
        "appId": 0,
        "appName": "",
        "appUrl": "",
        "appIcon":"",
        "startupMode": 95
    };
    var commonContent = UI.getItem(commonDialog, "commonContent");
    var btn_left_text = UI.getItem(commonDialog, "btn_left_text");
    var btn_right_text = UI.getItem(commonDialog, "btn_right_text");
    commonDialog.onPush = function() {
        if(!!commonDialog.param && commonDialog.param.caller.toString()){
            if(commonDialog.param.caller.toString()=="search"){
                var search = UI.getSubModule("search");
                data.appId = search.appInfo.id;
                data.appName = search.appInfo.nameTxt;
                data.appUrl = search.appInfo.appUrl;
                data.StoreType = 95;
                if(!!search.appInfo.startupMode){
                    data.startupMode = search.appInfo.startupMode;
                }
                data.appIcon = search.appInfo.icon;
            }else if(commonDialog.param.caller.toString()=="appStore"){
                var appStore = UI.getSubModule("appStore");
//                DBG_INFO("appStore.appInfo:"+objToString(appStore.appInfo));
                data.appId = appStore.appInfo.objectId;
                data.appName = appStore.appInfo.nameTxt;
                data.appUrl = appStore.appInfo.appUrl;
                data.startupMode = 95;
                if(!!appStore.appInfo.startupMode){
                    data.startupMode = appStore.appInfo.startupMode;
                }
                data.appIcon = appStore.appInfo.icon;
            }
            DBG_INFO("data:"+objToString(data));
        }

    };

    commonDialog.onPop = function () {

    };

    commonDialog.onFocus = function (focus) {
        onFocusLiveTVTarget(focus, 1.05, 500);
    };

    commonDialog.onNormal = function (focus) {
        onNormalLiveTVTarget(focus, 0.6, 500);
    };

    BtnRight.onkey_ENTER = function(focus) {
        UI.popSubModule();
    };

    BtnLeft.onkey_ENTER = function(focus) {
        UI.popSubModule();
        hideForAppStorePlay(0);
        var storeType =  data.startupMode;
        storeType = 95;
        setAddAppToOpera(data,true);
        startThirdPartyApp(null,data.appUrl,37, CMDMethod.MENU, false, 0xFFFFFF,data.appName,storeType);
    }

};