/**
 * Created by yangcheng on 2017-11-27.
 */
UI.moduleBuilder['common']['dlnaToast2'] = function(){

    var initData = {
        "ToastBgImg" : "toast/Toast_bg2.png",
        "ToastIcon":"setting/wifi/ic_not_connected.png"
    };
    var template = Util.readJson("module/common/dlnaToast2.json");
    var dlnaToast2 = SubModule.create(initData, template);
    var ToastTitle=UI.getItem(dlnaToast2,"ToastTitle");
    var ToastText=UI.getItem(dlnaToast2,"ToastText");
    var ToastBgImg=UI.getItem(dlnaToast2,"ToastBgImg");
    ToastBgImg.doFlip=true;
    ToastText.alpha = 0.6;
    var timer = null;
    dlnaToast2.onPush = function () {
        if(!!dlnaToast2.param.titleStr && dlnaToast2.param.textStr){
            var titleStr = dlnaToast2.param.titleStr;
            var textStr = dlnaToast2.param.textStr;
            UI.setText(ToastTitle,titleStr);
            UI.setText(ToastText,textStr);
        }
        UI.base.runText(ToastTitle);
        clearTimeout(timer);
        UI.refreshRTL(dlnaToast2);
        timer = setTimeout(function () {
            UI.popGhostModule("dlnaToast2");
        }, 5000);
    };
    dlnaToast2.onPop=function(){
        clearTimeout(timer);
        timer = null;
    }
};