/**
 * Created by Administrator on 2018/5/5.
 */

UI.moduleBuilder['common']['dlnaDialog2'] = function () {
    var template = Util.readJson("module/common/dlnaDialog2.json");
    var dlnaDialogData = {
        dlnaDialog_bg: UI.window_bg,
        btn_left_bg: UI.item_bg,
        btn_right_bg: UI.item_bg,
        btn_right_text: "[SE1205]",
        btn_left_text: "[SE1206]",
        dlnaDialogContent: "MAC Address:"
    };

    var dlnaDialog2 = SubModule.create(dlnaDialogData, template);
    var BtnRight = UI.getItem(dlnaDialog2, "BtnRight");
    var BtnLeft = UI.getItem(dlnaDialog2, "BtnLeft");
    var dlnaDialogContent = UI.getItem(dlnaDialog2, "dlnaDialogContent");
    dlnaDialog2.currFocus = BtnRight;
    BtnRight.alpha = BtnLeft.alpha = 0.6;
    dlnaDialogContent.alpha = 0.6;

    dlnaDialog2.protected = true;
    var dlnaDeviceMac = null;


    dlnaDialog2.onFocus = function (focus) {
        DBG_INFO("dlnaDialog_onFocus");
        onFocusLiveTVTarget(focus, 1.05, 500);
        return true;
    }

    dlnaDialog2.onNormal = function (focus) {
        DBG_INFO("dlnaDialog_onNormal");
        onNormalLiveTVTarget(focus, 0.6, 500);
        return true;
    }
    BtnRight.onkey_ENTER = function () {
        DBG_INFO("GLOBAL.DLNADEVICE_VOLUE" + GLOBAL.DLNADEVICE_VOLUE + "dlnaDialog2.param" + dlnaDialog2.param);
        UI.popSubModule();
        if(!!dlnaDialog2.param){
            if(GLOBAL.DLNADEVICE_VOLUE.length > 8){
                GLOBAL.DLNADEVICE_VOLUE = [];
            }
            GLOBAL.DLNADEVICE_VOLUE.push(dlnaDialog2.param.deviceMac);
            if(dlnaDialog2.param.Type == "Volume"){
                model.sound.setMainVolume(dlnaDialog2.param.Value);
            }else if(dlnaDialog2.param.Type == "Mute"){
                model.sound.setMainMute(dlnaDialog2.param.Value);
            }
        }
    }
    dlnaDialog2.onPush = function () {
        try {
            dlnaDeviceMac = !!dlnaDialog2.param ? dlnaDialog2.param.deviceMac : Config.language.SE1521;
            DBG_INFO("Device Mac Address" + dlnaDeviceMac);
            var str = Config.language.SE0181 + ":" + dlnaDeviceMac;
            UI.setText(dlnaDialogContent, str);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    dlnaDialog2.onPop = function () {
        BtnRight.scale.x = 1;
        BtnRight.scale.y = 1;
        BtnLeft.scale.x = 1;
        BtnLeft.scale.y = 1;
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI.base.cursor.alpha = 0;
    }

    function closedlnaDialog() {
        try {
            UI.popSubModule();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    BtnLeft.onkey_ENTER = dlnaDialog2.onkey_BACKSPACE = closedlnaDialog;
};