// Init
UI.moduleBuilder['common']['BluetoothRemoteFlow'] = function(){

    var BluetoothRemoteFlowData = {
        BluetoothRemoteImgBg: {color:0x2F344D},

        //demon page
        BluetoothRemoteDemonText1:"[SE3532]",
        BluetoothRemoteDemonText2:"",
        BluetoothRemoteDemonTVImg:"setting/bluetooth/remote_TV.png",
        BluetoothRemoteDemonHandImg1:"setting/bluetooth/remote_hand1.png",
        BluetoothRemoteDemonHandImg2:"setting/bluetooth/remote_hand2.png",
        BluetoothRemoteDemonMenuImg:"setting/bluetooth/remote_menu.png",
        BluetoothRemoteDemonMenuTitle:"MENU",

        //connecting page
        BluetoothRemoteConnectText:"[SE3494]",//connecting
        BluetoothRemoteConnectTVImg:"setting/bluetooth/remote_TV.png",
        BluetoothRemoteConnectingImg1:"setting/bluetooth/remote_Connect1.png",
        BluetoothRemoteConnectingImg2:"setting/bluetooth/remote_Connect2.png",
        BluetoothRemoteConnectingImg3:"setting/bluetooth/remote_Connect3.png",
        BluetoothRemoteConnectHandImg:"setting/bluetooth/remote_hand3.png",

        //success
        BluetoothRemoteSuccessImg:"setting/bluetooth/remote_success.png",
        BluetoothRemoteSuccessText:"[SE3505]",


        BluetoothRemoteFailImg:"setting/bluetooth/remote_failure.png",
        BluetoothRemoteFailText:"[SE3492]",
        BluetoothRemoteFailBtnImg:UI.btn_normal_bg,
        BluetoothRemoteFailBtnText:"[PI0019]"
    };

    var template = Util.readJson("module/common/BluetoothRemoteFlow.json");
    var BluetoothRemoteFlow = SubModule.create(BluetoothRemoteFlowData, template);
    //demon
    var BluetoothRemoteDemon = UI.getItem(BluetoothRemoteFlow, "BluetoothRemoteDemon");
    var BluetoothRemoteDemonText1 = UI.getItem(BluetoothRemoteDemon, "BluetoothRemoteDemonText1")
    var BluetoothRemoteDemonHandImg1 = UI.getItem(BluetoothRemoteDemon, "BluetoothRemoteDemonHandImg1");
    var BluetoothRemoteDemonHandImg2 = UI.getItem(BluetoothRemoteDemon, "BluetoothRemoteDemonHandImg2");
    var BluetoothRemoteDemonMenuTip = UI.getItem(BluetoothRemoteDemon, "BluetoothRemoteDemonMenuTip");

    //connect
    var BluetoothRemoteConnect = UI.getItem(BluetoothRemoteFlow, "BluetoothRemoteConnect");
    var BluetoothRemoteConnectText = UI.getItem(BluetoothRemoteConnect, "BluetoothRemoteConnectText");
    var BluetoothRemoteConnectingImg1 = UI.getItem(BluetoothRemoteConnect, "BluetoothRemoteConnectingImg1");
    var BluetoothRemoteConnectingImg2 = UI.getItem(BluetoothRemoteConnect, "BluetoothRemoteConnectingImg2");
    var BluetoothRemoteConnectingImg3 = UI.getItem(BluetoothRemoteConnect, "BluetoothRemoteConnectingImg3");

    //success
    var BluetoothRemoteSuccess = UI.getItem(BluetoothRemoteFlow, "BluetoothRemoteSuccess");
    var BluetoothRemoteSuccessText = UI.getItem(BluetoothRemoteSuccess, "BluetoothRemoteSuccessText");

    //fail
    var BluetoothRemoteFail = UI.getItem(BluetoothRemoteFlow, "BluetoothRemoteFail");
    var BluetoothRemoteFailBtn = UI.getItem(BluetoothRemoteFail, "BluetoothRemoteFailBtn");


    var BluetoothConnetingImgItems = [BluetoothRemoteConnectingImg1,BluetoothRemoteConnectingImg2,BluetoothRemoteConnectingImg3];

    var currPageFlow = BLUETOOTH_REMOTE_STATUS.NONE;
    var hideDemonMenuTimer = null;
    var connectingTimer = null;
    var successDisplayTimer = null;
    var successPageNeedClose = false;
    BluetoothRemoteFlow.onPush = function(){
        if(common.caller== "base" && checkIsAppOn()){
            registerKeyCodesForUI();
        }
        var desPage = BLUETOOTH_REMOTE_STATUS.NONE;
        if(!!BluetoothRemoteFlow.param && !!BluetoothRemoteFlow.param.open){
            desPage = BluetoothRemoteFlow.param.open.toString();
        }
        BluetoothRemoteFlow.changeBluetoothRemoteFlowPage(desPage);
    };
    BluetoothRemoteFlow.onShow = function(){
        if(successPageNeedClose){
            UI.popSubModule();
        }
    }
    function initBluetoothRemoteItem(){
        BluetoothRemoteDemon.alpha = 0;
        BluetoothRemoteConnect.alpha = 0;
        BluetoothRemoteSuccess.alpha = 0;
        BluetoothRemoteFail.alpha = 0;
        successPageNeedClose = false;
        initBluetoothRemoteDemoItem();
        initBluetoothRemoteConnectItem();
    }
    function initBluetoothRemoteDemoItem(){
        BluetoothRemoteDemonMenuTip.alpha = 0;
        BluetoothRemoteDemonHandImg2.alpha = 0;
        BluetoothRemoteDemonHandImg1.alpha = 1;
        BluetoothRemoteDemonHandImg1.y = 1080;
    }
    function initBluetoothRemoteConnectItem(){
        BluetoothRemoteConnectingImg1.alpha = 0;
        BluetoothRemoteConnectingImg2.alpha = 0;
        BluetoothRemoteConnectingImg3.alpha = 0;
    }
    BluetoothRemoteFlow.changeBluetoothRemoteFlowPage = function(des){
        DBG_ALWAYS("changeBluetoothRemoteFlowPage:open page is "+des);
        initBluetoothRemoteItem();
        var from = currPageFlow;
        switch (currPageFlow){
            case BLUETOOTH_REMOTE_STATUS.DEMON:
                closeBluetoothRemoteDemon(from,des);
                break;
            case BLUETOOTH_REMOTE_STATUS.CONNECT:
                closeBluetoothRemoteConnect(from,des);
                break;
            case BLUETOOTH_REMOTE_STATUS.SUCESS:
                closeBluetoothRemoteSuccess(from,des);
                break;
            case BLUETOOTH_REMOTE_STATUS.FAIL:
                closeBluetoothRemoteFail(from,des);
                break;
            default :
                break;
        }
        switch (des){
            case BLUETOOTH_REMOTE_STATUS.DEMON:
                openBluetoothRemoteDemon(from,des);
                break;
            case BLUETOOTH_REMOTE_STATUS.CONNECT:
                openBluetoothRemoteConnect(from,des);
                break;
            case BLUETOOTH_REMOTE_STATUS.SUCESS:
                openBluetoothRemoteSuccess(from,des);
                break;
            case BLUETOOTH_REMOTE_STATUS.FAIL:
                openBluetoothRemoteFail(from,des);
                break;
            default :
                break;
        }
    }
    function openBluetoothRemoteDemon(from,to){
        BluetoothRemoteDemon.alpha = 1;
        BluetoothRemoteFlow.currFocus = BluetoothRemoteDemonText1;
        UI.callTTS("[SE3532]");
        UI.getTween(BluetoothRemoteDemonHandImg1,false).to({y: 891}, 2000, UI.ease.quartOut).call(function(){
            UI.getTween(BluetoothRemoteDemonMenuTip, true).to({alpha: 1}, 1000, UI.ease.quartOut).call(function () {
                var hideDemonMenuTimer = setTimeout(function(){
                    BluetoothRemoteDemonMenuTip.alpha = 0;
                    BluetoothRemoteDemonHandImg1.alpha = 0;
                    BluetoothRemoteDemonHandImg2.alpha = 1;
                    UI.setImage(BluetoothRemoteDemonHandImg2,"setting/bluetooth/remote_hand2.png");
                    if(!tv){
                        setTimeout(function(){
                            BluetoothRemoteFlow.changeBluetoothRemoteFlowPage(BLUETOOTH_REMOTE_STATUS.CONNECT);
                        },3000);
                    }
                },1000);
            });
        });
        currPageFlow = BLUETOOTH_REMOTE_STATUS.DEMON;
    }
    function closeBluetoothRemoteDemon(from,to){
        BluetoothRemoteDemon.alpha = 0;
        UI.base.cursor.alpha = 1;
        createjs.Tween.removeTweens(BluetoothRemoteDemonHandImg1);
        createjs.Tween.removeTweens(BluetoothRemoteDemonMenuTip);
        initBluetoothRemoteDemoItem();
        clearTimeout(hideDemonMenuTimer);
    }
    function openBluetoothRemoteConnect(from,to){
        BluetoothRemoteConnect.alpha = 1;
        BluetoothRemoteFlow.currFocus = UI.getItem(BluetoothRemoteFlow, "BluetoothRemoteConnectText");
        UI.callTTS("[SE3494]");
        doConnectingAnimation(0);
        currPageFlow = BLUETOOTH_REMOTE_STATUS.CONNECT;
        if(!tv){
            setTimeout(function(){
                BluetoothRemoteFlow.changeBluetoothRemoteFlowPage(BLUETOOTH_REMOTE_STATUS.FAIL);
            },3000);
        }else{
            clearTimeout(connectingTimer);
            connectingTimer = setTimeout(function(){
                DBG_ERROR("openBluetoothRemoteConnect:time out stop scan");
                BluetoothRemoteFlow.changeBluetoothRemoteFlowPage(BLUETOOTH_REMOTE_STATUS.FAIL);
            },10000);
        }
        function doConnectingAnimation(startIndex) {
            if(startIndex > BluetoothConnetingImgItems.length - 1) startIndex = 0;
            BluetoothConnetingImgItems[startIndex].alpha = 1;
            UI.getTween(BluetoothConnetingImgItems[startIndex], true).to({alpha: 1}, 500, UI.ease.quartOut).call(function (nextIndex) {
                BluetoothConnetingImgItems[startIndex].alpha = 0;
                doConnectingAnimation(nextIndex);
            }, [startIndex + 1]);
        }
    }
    function closeBluetoothRemoteConnect(from,to){
        BluetoothRemoteConnect.alpha = 0;
        UI.base.cursor.alpha = 1;
        createjs.Tween.removeTweens(BluetoothRemoteConnectingImg1);
        createjs.Tween.removeTweens(BluetoothRemoteConnectingImg2);
        createjs.Tween.removeTweens(BluetoothRemoteConnectingImg3);
        clearTimeout(connectingTimer);
        initBluetoothRemoteConnectItem();
    }
    function openBluetoothRemoteSuccess(from,to){
        BluetoothRemoteSuccess.alpha = 1;
        BluetoothRemoteFlow.currFocus = UI.getItem(BluetoothRemoteFlow, "BluetoothRemoteSuccessText");
        UI.callTTS("[SE3505]");
        UI.updateStage();
        currPageFlow = BLUETOOTH_REMOTE_STATUS.SUCESS;
        clearTimeout(successDisplayTimer);
        successDisplayTimer = setTimeout(function(){
            DBG_ERROR("openBluetoothRemoteSuccess:UI.getCurrSubModule().name:"+UI.getCurrSubModule().name);
            if(UI.getCurrSubModule().name == "BluetoothRemoteFlow"){
                UI.popSubModule();
                BluetoothRemoteFlowReleaseFocus();
            }else{
                successPageNeedClose = true;
            }

        },3000);
    }
    function closeBluetoothRemoteSuccess(from,to){
        BluetoothRemoteSuccess.alpha = 0;
        UI.base.cursor.alpha = 1;
        clearTimeout(successDisplayTimer);
    }
    function openBluetoothRemoteFail(from,to){
        BluetoothRemoteFail.alpha = 1;
        UI.base.cursor.alpha = 1;
        BluetoothRemoteFlow.currFocus = UI.getItem(BluetoothRemoteFlow, "BluetoothRemoteFailBtn");
        UI.focusTo(BluetoothRemoteFlow.currFocus);
        UI.getTween(UI.base.cursor).set({alpha : 1});
        UI.callTTS("[SE3492] [PI0019]");
        currPageFlow = BLUETOOTH_REMOTE_STATUS.FAIL;
    }

    function closeBluetoothRemoteFail(from,to){
        BluetoothRemoteFail.alpha = 0;
    }
    BluetoothRemoteFailBtn.onkey_ENTER = function(){
        BluetoothRemoteFlow.changeBluetoothRemoteFlowPage(BLUETOOTH_REMOTE_STATUS.DEMON);
    }
    BluetoothRemoteDemonText1.onFocus = function(){
        UI.base.cursor.alpha = 0;
        UI.getTween(UI.base.cursor).set({alpha : 0});
    }
    BluetoothRemoteConnectText.onFocus = function(){
        UI.base.cursor.alpha = 0;
        UI.getTween(UI.base.cursor).set({alpha : 0});
    }
    BluetoothRemoteSuccessText.onFocus = function(){
        UI.base.cursor.alpha = 0;
        UI.getTween(UI.base.cursor).set({alpha : 0});
    }
//    BluetoothRemoteFlow.onFocus = function (focus) {
//        DBG_INFO("BluetoothRemote_onNormal");
//        onNormalLiveTVTarget(focus, 0.6, 500);
//    }

//    BluetoothRemoteFlow.onNormal = function (focus) {
//        DBG_INFO("BluetoothRemote_onNormal");
//        onNormalLiveTVTarget(focus, 0.6, 500);
//    }
    BluetoothRemoteFlow.onPop = function () {
        BluetoothRemoteFlow.changeBluetoothRemoteFlowPage(BLUETOOTH_REMOTE_STATUS.NONE);
    }
    BluetoothRemoteFlow.onkey_BACKSPACE = function(){
        UI.popSubModule();
        BluetoothRemoteFlowReleaseFocus();
    }
    function BluetoothRemoteFlowReleaseFocus(){
        if (common.caller== "base") {
            if (checkIsAppOn()) {
                registerKeyCodesForApp();
            } else {
                openLiveTVModule([Msg.INFO, 0]);
            }
        } else if (common.caller== "hiMedia") {
            hiMedia.changeByLauncher("resume");
        }
        else if (common.caller== "launcher") {
            UI.showModule(launcher);
            return true;
        }
    }
}

