
UI.moduleBuilder['accuweather']['accuweatherMain'] = function(){
    var accuweather_Data = {
        arrow_left:"accuweather/leftarrow.png",
        arrow_right:"accuweather/rightarrow.png",
        default_home_pic:"accuweather/defaultcityfocus.png",
        Del_pic:'accuweather/red.png',
        Add_pic:'accuweather/green.png',
        temp_pic:'accuweather/yellow.png',
        cityList_pic:'accuweather/blue.png',
        ok_pic:'accuweather/ok.png',
        Wind_speed_pic:'accuweather/windspeed.png',
        Wind_direction_pic:'accuweather/winddirection.png',
        upadate_pic:'accuweather/update.png',
        accw_bg:'accuweather/daytime.png',
        middle_panel_bg:'accuweather/Transparent_sheet.png',
        accu_logo:'accuweather/logo.png',
        breakline_pic: "accuweather/vertical.png",
        Add_txt:'[WE0002]',//Add a city
        Del_txt:"[LA0079]",//Delete a city
        cityList_txt:'[WE0004]',//City list
        Set_df_txt:'[WE0005]',//Set_df_txt,
        accu_cw_img:"accuweather/icon_390x400/1.png"
    };
    var template = Util.readJson("module/accuweather/accuweatherMain.json");
    var accuweatherMain = SubModule.create(accuweather_Data, template);
    accuweatherMain.currFocus = UI.getItem(accuweatherMain, "default_home_pic");
    accuweather.initfocus=UI.getItem(accuweatherMain, "default_home_pic");
    var isFirst = true, isEmpty = false;
//    curent:  http://api.accuweather.com/currentconditions/v1/106573.json?language=en-us&apikey=5f7afc280da94a37a8a4cef4930c48d8&details=true
//    forcast: http://api.accuweather.com/forecasts/v1/daily/5day/106573?language=en-us&apikey=5f7afc280da94a37a8a4cef4930c48d8&metric=false
//    search:  http://api.accuweather.com/locations/v1/search?language=en-us&apikey=5f7afc280da94a37a8a4cef4930c48d8&metric=false&q="
    var apiKey = '5f7afc280da94a37a8a4cef4930c48d8',
        langcode = 'en',
        userCities =  {"defInd": 0, "cityList": [{"timeZone": 1.0, "locId": "47601", "unit": "Metric", "locCountry": "Centre", "locName": "Yaounde"}]},
        pageInd = 0,
        citylistPath ='weather/cities',
        readAll = false,
        canChangeUnit = true;
    var langMap = {
        eng: "en", fre: "fr", spa: "es", ger: "de", ita: "it", por: "pt",
        nor: "no", swe: "sv", dan: "da", fin: "fi", chi: "zh", cze: "cs",
        slk: "sk", pol: "pl", hun: "hu", bgr: "bg", tur: "tr", uzb: "uz",
        ara: "ar", rus: "ru", tha: "th", per: "fa", hin: "hi", heb: "he",
        ukr: "uk", vie: "vi", bur: "en", ind: "id", mal: "ms", bul: "bg",
        hrv: "hr", mac: "mk", alb: "en", srp: "sr", lav: "lv", est: "et",
        lit: "lt", slv: "sl", dut: "nl" ,kur: "en" ,rum: "ro", hbr: "he",
        zho: "zh-tw"
    };
    var unit = [
        {
            Metric: '°C',
            Imperial: '°F'
        },
        {
            Metric: 'km/h',
            Imperial: 'mi/h'
        }
    ];
    var cUnit = 'Imperial', cWeather = {}, fWeather = {};
    var newAddLocId = '', newWeatherUpdated = [0, 0, 0, 0], updateTime = 0;
    var dayMap =['[GE0027]','[GE0021]','[GE0022]','[GE0023]','[GE0024]','[GE0025]','[GE0026]'];
    //['Sunday', 'Monday','Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
    var colorMap = '°C/°F';
    var imgList = {
        small: 'accuweather/icon_170x170/',
        big: 'accuweather/icon_390x400/',
        color: [
            'accuweather/red.png',
            'accuweather/green.png',
            'accuweather/yellow.png',
            'accuweather/blue.png'
        ],
        homeFocus: 'accuweather/defaultcityfocus.png',
        homeUnfocus: 'accuweather/transparent.png',
        dayTime: 'accuweather/daytime.png',
        nightTime: 'accuweather/nighttime.png'
    }
    var newWeatherWookRoot = 1;    var tdIndex = 0;
    var oprtData={};
    var pageData = {
        accu_cw_img: {Data: ''},
        accu_cw_city: {Data: ''},
        accu_cw_txt: {Data: ''},
        accu_cw_temp: {Data: ''},
        accu_cw_wspeed_txt: {Data:''},//'Wind Speed'
        accu_cw_wspeed_speed: {Data: ''},
        accu_cw_wdirection_txt: {Data:''},//'Wind Direction'
        accu_cw_wdirection_direction: {Data: ''},
        accu_cw_update_txt: {Data: ''},
        accu_fw_panel: {Data: []},
        current:{},
        forecast:{}
    };
    //yellow bnt txt begin
    var yellow_txt=UI.getItem(accuweatherMain,"temp_txt");
    UI.setText(yellow_txt,colorMap);
    //yellow bnt txt end
    try{
        AccuWeatherData.defCityList = readFileFromNative("hisenseUI/data/weather/cities",2);//3rd_rw/
        DBG_INFO("init defCityList"+AccuWeatherData.defCityList);
    }catch(ex){DBG_ERROR("AccuWeatherData.defCityList is error:"+ex.message)}

//    function URLType() {
//    }
//
//    URLType.CURRENT = 0;
//    URLType.FORECAST = 1;
//    URLType.SEARCH = 2;

    function ArrowType() {

    }

    ArrowType.SHOWLEFT = 0;
    ArrowType.SHOWRIGHT = 1;
    ArrowType.SHOWDOUBLE = 2;
    function networkConnected() {
        try {
            var cnnct = tv ? model.network.getEnumNetworkAvailable() : 1;
            return (1 == cnnct);
        }
        catch (ex) {
            DBG_INFO(ex.message, DebugLevel.ERROR);
            return false;
        }
    }
    function rewritePageData() {
        if(!oprtData.current || null == userCities) {
            return;
        }
        var middle_panel=UI.getItem(accuweatherMain,"middle_panel");
        var ceil_panel=UI.getItem(accuweatherMain,"ceil_panel");
        middle_panel.alpha=1;
        ceil_panel.alpha=1;
        cUnit = userCities.cityList[pageInd].unit;
        cWeather = readAll ? oprtData.current[pageInd] : oprtData.current;
        fWeather = readAll ? oprtData.forecast[pageInd].DailyForecasts : oprtData.forecast.DailyForecasts;
        if(!cWeather || 0 == cWeather.length || "string" == typeof(cWeather) || !fWeather) {
            DBG_ERROR("current weather error");
            return;
        }
        updateTime = cWeather.EpochTime;
        pageData.accu_cw_img = {Data: imgList.big + cWeather.WeatherIcon + '.png'};
        pageData.accu_cw_city = {
            Data: userCities.cityList[pageInd].locName +
           ", " + userCities.cityList[pageInd].locCountry
        };
        pageData.accu_cw_txt = {Data: cWeather.WeatherText};
        var cTemperature = cWeather.Temperature[cUnit];
        pageData.accu_cw_temp = {Data: (cTemperature.Value + unit[0][cUnit])};
        var cWindDirection = cWeather.Wind.Direction;
        var cWindSpeed = cWeather.Wind.Speed;
        pageData.accu_cw_wspeed_txt = {Data: '[WE0010]'};//wind speed
        pageData.accu_cw_wspeed_speed = {Data: cWindSpeed[cUnit].Value+ unit[1][cUnit]};
        pageData.accu_cw_wdirection_txt = {Data: '[LA0003]'};//wind direction

        pageData.accu_cw_wdirection_direction = {Data: cWindDirection.Localized};
        var tz = parseInt(userCities.cityList[pageInd].timeZone);
        if(!tz && 0 != tz) {
            DBG_INFO("time zone is error", DebugLevel.ERROR);
            userCities.cityList[pageInd].timeZone = 0;
            tz = 0;
        }
        var localDate = (new Date((updateTime + tz * 3600) * 1000));
        var td = localDate.getUTCDay();
        pageData.accu_cw_update_txt = {Data:(localDate.getUTCMonth() + 1) + "/" + localDate.getUTCDate() + " " +
            ('0' + localDate.getUTCHours()).slice(0, 2) + ":" + ('0' + localDate.getUTCMinutes()).slice(0, 2) +
            " " +"[LA0030]" }//UPdate
        ;
        //getCurrentContentLanguage("SA" == InitArea ? "update" : "Update")
        pageData.accu_fw_panel = {Data: [], SelectedIndex:0};
        for(var i = 0; i < fWeather.length; i++) {
            var dayItem = {};
            //var ind = (new Date(fWeather[i].Date)).getDay();
            var ind = (new Date((fWeather[i].EpochDate + tz * 3600) * 1000)).getUTCDay();
            if(ind == td) tdIndex = i;
            dayItem.accu_fw_date = (ind == td) ? "[GE0017]" : dayMap[ind];//Today
            dayItem.accu_fw_img = imgList.small + fWeather[i].Day.Icon + '.png';
            dayItem.accu_fw_txt = fWeather[i].Day.IconPhrase;
            var minTemp = fWeather[i].Temperature.Minimum.Value;
            var maxTemp = fWeather[i].Temperature.Maximum.Value;
            dayItem.accu_fw_temp = minTemp + unit[0][cUnit] + ' - ' + maxTemp + unit[0][cUnit];
            dayItem.accu_fw_bg = UI.bg_tranparent;
            pageData.accu_fw_panel.Data.push(dayItem);
        }
        var list=UI.getItem(accuweatherMain,"weather_anchor");
        // Gird的配置信息JSON
        var info = {
            // 每个图标使用的模板名
            template : "WeatherBar",
            // V表示竖向排列，H表示横向排列
            direction : CONST.GIRD_DIRECTION.H,
            // 每隔几个图标就换行
            breakNum : 5,
            // 每隔图标之间的距离
            distanceX : 48,
            distanceY: 0,
            // 要将此Gird添加到哪个锚点位置上
            container : list
        };
        // 向allList中添加Gird
        // 声明一个初始化用数组，将数据配置好
        //Gird.resetNavigation(pageData.accu_fw_panel.Data, info);
        info.container.removeAllChildren(true);
        Gird.create(pageData.accu_fw_panel.Data, info);
        setImageOrTextStyle(pageData);
        for (var idx = 0; idx < list.initSequence.length; idx++) {
            var txt = UI.getItem(list.initSequence[idx], 'accu_fw_txt');
            UI.setText(txt, fWeather[idx].Day.IconPhrase);
        }
        UI.updateStage();
    }
    function setImageOrTextStyle(pagedata){
        try{
            for(var drop in pagedata){
                if('forecast'==drop||'current'==drop){continue;}
                if('accu_fw_panel'==drop){
                    break;
                }
                if(-1!=drop.toString().indexOf("_img")){
                    var accu_cw_img=UI.getItem(accuweatherMain,drop.toString());
                    UI.setImage(accu_cw_img,pageData[drop].Data);
                }else{
                    var temp=UI.getItem(accuweatherMain,drop.toString());
                    UI.setText(temp,pageData[drop].Data);
                }
            }
        }catch(e){DBG_ERROR("setImageOrTextStyle is error:"+ e.message)}
    }

    accuweather.sendMsg=function(msg){
         accuweather.msg=msg;
    }
    accuweather.setIsFirst = function(val){
        isFirst = val;
    }
    accuweather.initAccuweather = function() {
        try {
            try{
                if(typeof accuweather != "undefined"){
                    accuweather.setIsFirst(true);
                }
                DBG_INFO("initAccuweather");
                userCities = readFileFromNative(citylistPath,1);//appdata
                DBG_INFO ("userCities: "+JSON.stringify(userCities));
            }catch(ex){
                DBG_ERROR("citylistPath is eror:"+ex.message);
            }
            if(isFirst || null == userCities || pageInd != userCities.defInd) {
                if(null == userCities && (null == hisenseUIConfig || !hisenseUIConfig["DefaultCity"])) {
                    if(null == hisenseUIConfig) hisenseUIConfig = {};
//                    var defCityKey = tv ? model.basicSetting.getTvsetLocation() + "City" : "CHNCity";
//                  start: modified to get current country by manli1 20170208
                    var curCountryList = GetSysCountryList(GLOBAL.CURRENT_AREA,GLOBAL.CURRENT_SUB_AREA);
                    var tmp = tv ? model.basicSetting.getTvsetLocation(): 80;
                    DBG_INFO("model.basicSetting.getTvsetLocation(): " + tmp);
                    var curCountryListId = _getIndexByNum(curCountryList, tmp);
                    DBG_INFO("curCountryListId: " + curCountryListId);
                    DBG_INFO("curCountryList: " + curCountryList);
                    var defCityKey = curCountryList[curCountryListId].code + "City";
//                  end  to get current country
                    DBG_INFO("use default city [" + defCityKey + "]");
                    if(!!AccuWeatherData.defCityList[defCityKey]) {
                        userCities = $.extend({}, AccuWeatherData.defCityList[defCityKey]);
                    }
                    else {
                        DBG_INFO("can not find this default city[" + defCityKey + "]", DebugLevel.ERROR);
                        defCityKey = "CHNCity";
                        userCities = $.extend({}, AccuWeatherData.defCityList["CHNCity"]);
                    }
                    pageInd = userCities.defInd;
                    var locId = userCities.cityList[pageInd].locId;
                    var cityPath = {
                        current: "hisenseUI/data/weather/current/" + locId,
                        forecast: "hisenseUI/data/weather/forecast/" + locId
                    };
                    var tempCurrent = readFileFromNative(cityPath.current,2);
                    var tempForecast = readFileFromNative(cityPath.forecast,2);
                    if(null == tempCurrent) {
                        DBG_INFO("can not find this default city[" + defCityKey + "]", DebugLevel.ERROR);
                        return;
                    }
                    oprtData.current = tempCurrent[0];
                    oprtData.forecast = tempForecast;
                    hisenseUIConfig["DefaultCity"] = true;
                    writeFileToNative("weather/current/" + locId, objToString(tempCurrent),1);
                    writeFileToNative("weather/forecast/" + locId, objToString(tempForecast),1);
                    writeFileToNative(citylistPath, objToString(userCities),1);
                    writeFileToNative("weather/accuWeather_config.ini", objToString(hisenseUIConfig),1);
                }
                else if(null == userCities || 0 == userCities.cityList.length) {
                    DBG_INFO("before set emptyCity");
                    setEmptyCity();
                    return;
                }
                else {
                    pageInd = userCities.defInd;
                    if(!resetWeatherOperateData()) {
                        return;
                    }
                }
                rewritePageData();
                isFirst = false;
            }
            else {
                rewritePageData();
            }
            if(!(null == userCities || 0 == userCities.cityList.length)) {
                tv && getLatestWeather(userCities.cityList[pageInd].locId, userCities.cityList[pageInd].unit);
                setSpecialStyle();
            }
        }
        catch(ex) {
            DBG_ERROR(ex.message);
        }
    }
    accuweatherMain.onFocus=function(){
        accuweather.ShowCursor(false);
    };
    accuweatherMain.onShow=function(){
        UI.popGhostModule("volumeCtrl");
        return true;
    };
    accuweatherMain.onPush=function(){
        accuweather.initAccuweather();
        try{
            pubStateApp("AccuWeather", "accuweather");
        }catch (ex){
            DBG_ERROR(ex.message);
        }
        setDefaultPic();
    }
    accuweather.getCityList = function() {
        var list = [];
        cloneObj(userCities.cityList, list);
        return list;
    }

    accuweather.getDefaultCityId = function() {
        return userCities.defInd;
    }

    accuweather.getCityListPath = function() {
        return citylistPath;
    }

    accuweather.getSearchUrl = function(city) {
        return setUrl(city, URLType.SEARCH, cUnit);
    }

    accuweather.getSearchPath = function() {
        return setPath('', URLType.SEARCH);
    }

    accuweather.needRefreshWhenDelete = function(locId) {
        try {
            var crntLocId = userCities.cityList[pageInd].locId;
            deleteNativeFile(setPath(locId, URLType.CURRENT), 1);
            deleteNativeFile(setPath(locId, URLType.FORECAST), 1);

            if(locId != crntLocId && locId != userCities.cityList[userCities.defInd].locId) {
                userCities = readFileFromNative(citylistPath, 1);
                if(null == userCities || !userCities.cityList.length || 0 == userCities.cityList.length) {
                    pageInd = 0;
                }
                else {
                    for(var i = 0; i < userCities.cityList.length; i++) {
                        if(crntLocId == userCities.cityList[i].locId){
                            pageInd = i;
                            break;
                        }
                    }
                }
                setSpecialStyle();
                return;
            }

            userCities = readFileFromNative(citylistPath, 1);
            if(null == userCities || !userCities.cityList.length || 0 == userCities.cityList.length) {
                pageInd = 0;
                oprtData.current = null;
                oprtData.forecast = null;
                DBG_INFO('set empty city', DebugLevel.WARNING);
                setEmptyCity();
                return;
            }
            var ind = userCities.defInd;
            pageInd = ind;
            rewriteCurrentWeatherData();
            //if(g_launcherBrand != "VIDAALite")
            {
                accuweather.refreshHomeWeather(
                    userCities.cityList[pageInd].locName,
                    fWeather[0].Temperature,
                    userCities.cityList[pageInd].unit,
                    cWeather.WeatherText,
                    cWeather.WeatherIcon,
                    cWeather.Temperature);
            }
        }
        catch(ex) {
            DBG_ERROR(ex.message);
        }
    }
    accuweather.backToMain=function(){
        for(;UI.getCurrSubModule().name!="accuweatherMain";){
            UI.popSubModule();
        }

    }
    accuweather.changeByLauncher = function (value) {
        DBG_INFO("accuweather.changeByLauncher is called :" + value);
        if("pause" == value){
            UI._callBubble(UI.getCurrFocus(), "onNormal", UI.getCurrFocus());
        }
    };
    function getLatestWeather(locId, itemUnit) {
        if(!networkConnected()) {
            DBG_INFO("network is not ok");
            return;
        }
        canChangeUnit = false;
        var currentPath = setTempPath(locId, URLType.CURRENT),
            forecastPath = setTempPath(locId, URLType.FORECAST);

        var currentURL = setUrl(locId, URLType.CURRENT, itemUnit),
            forecastURL = setUrl(locId, URLType.FORECAST, itemUnit);

        newWeatherUpdated = [0, 0, 0, 0];

        if(downloadFileToNative(currentURL, currentPath, newWeatherWookRoot, 10)) {
            checkDownloadState(currentPath, newWeatherWookRoot, getLatestWeatherCallback, currentPath);
        }
        else {
            canChangeUnit = true;
        }

        if(downloadFileToNative(forecastURL, forecastPath, newWeatherWookRoot, 10)) {
            checkDownloadState(forecastPath, newWeatherWookRoot, getLatestWeatherCallback, forecastPath);
        }
        else {
            canChangeUnit = true;
        }
    }
    function getLatestWeatherCallback(obj, identify) {
        canChangeUnit = (2 == (++newWeatherUpdated[3]));
        if(null == obj || "string" == typeof(obj)) {
            DBG_INFO('get new weather failed');
            if(UI.getCurrModule().name=="accuweather"&& 0 == newWeatherUpdated[2] && !!newAddLocId) {
                newWeatherUpdated[2] = 1;
                accuweather.sendMsg("[LA0072]");//accuweather.sendMsg("Request timed out");
                UI.pushSubModule("accuweather","Msgbox");
            }
            if("string" == typeof(obj)) {
                deleteNativeFile(identify, newWeatherWookRoot);
            }
            return;
        }
        var destPath = '', locId = '';
        DBG_INFO('getLatestWeatherCallback identify = ' + identify);
        if(identify.indexOf('current') > -1) {
            locId = identify.split('current')[1];
            destPath = setPath(locId, URLType.CURRENT);
            newWeatherUpdated[0] = 1;
        }
        else if(identify.indexOf('forecast') > -1) {
            locId = identify.split('forecast')[1];
            destPath = setPath(locId, URLType.FORECAST);
            newWeatherUpdated[1] = 1;
        }
        if('' != destPath) {
            moveNativeFile(destPath, identify, 1, newWeatherWookRoot);
            if(newWeatherUpdated[0] + newWeatherUpdated[1] < 2) return;
            canChangeUnit = true;
            if(locId == newAddLocId) {
                if(!newAddedCityItem.alreadyContain) {
                    userCities.cityList.push({
                        locId: newAddedCityItem.locId,
                        locName: newAddedCityItem.locName,
                        locCountry: newAddedCityItem.locCountry,
                        timeZone: newAddedCityItem.timeZone,
                        unit: newAddedCityItem.unit
                    });
                    writeFileToNative(citylistPath, objToString(userCities), 1);
                }else{
                    accuweather.sendMsg("[SE3740]");//accuweather.sendMsg("Request timed out");
                    UI.pushSubModule("accuweather","Msgbox");
                }
                for(var i = userCities.cityList.length - 1; i >= 0; i--) {
                    if(newAddLocId == userCities.cityList[i].locId) {
                        pageInd = i;
                        DBG_INFO('refresh new added city: ' + locId);
                        break;
                    }
                }
                if(!resetWeatherOperateData()) {
                    newAddLocId = '';
                    return;
                }
                if(isEmpty) {
                    rewritePageData();
                    isEmpty = false;
                }
                setSpecialStyle();
                newAddLocId = '';
            }
            else if(locId == userCities.cityList[pageInd].locId) {
                if(!resetWeatherOperateData()) {
                    return;
                }
                if(oprtData.current.EpochTime == updateTime && pageInd != userCities.defInd) {
                    DBG_INFO("do not need update:" + updateTime);
                    return;
                }
                if(isEmpty) {
                    rewritePageData();
                    isEmpty = false;
                }
                setSpecialStyle();
            }
            else {
                DBG_INFO('not current weather');
            }
            try {
                //refresh hom epage
                if(locId == userCities.cityList[userCities.defInd].locId) {
                    //if(g_launcherBrand != "VIDAALite")
                    {
                        accuweather.refreshHomeWeather(
                            userCities.cityList[pageInd].locName,
                            fWeather[0].Temperature,
                            userCities.cityList[pageInd].unit,
                            cWeather.WeatherText,
                            cWeather.WeatherIcon,
                            cWeather.Temperature);
                    }
                }
            }
            catch (ex){
                DBG_ERROR(ex.message);
            }
        }

    }
    function resetWeatherOperateData() {
        //全部读出来还是只读一个默认的？
        if(readAll) {// not use
            oprtData.current = null;
            oprtData.forecast = null;
            for(var i = 0; i < userCities.cityList.length; i++) {
                oprtData.current[i] = readFileFromNative(setPath(userCities.cityList[i].locId, URLType.CURRENT), 1)[0];
                oprtData.forecast[i] = readFileFromNative(setPath(userCities.cityList[i].locId, URLType.FORECAST), 1);
            }
        }
        else {
            var tempCurrent = readFileFromNative(setPath(userCities.cityList[pageInd].locId, URLType.CURRENT), 1);
            var tempForecast = readFileFromNative(setPath(userCities.cityList[pageInd].locId, URLType.FORECAST), 1);
            //下载不成功，删除索引
            if(null == tempCurrent
                || null == tempForecast
                || "string" == typeof (tempCurrent)
                || "string" == typeof (tempForecast)) {
                DBG_INFO("read weather failed: " + userCities.cityList[pageInd].locId + "; reset", DebugLevel.ERROR);
                userCities.cityList.splice(pageInd, 1);
                userCities.defInd = 0;
                pageInd = 0;
                writeFileToNative("weather/cities", objToString(userCities), 1);
                if(userCities.cityList.length == 0) {
                    pageInd = 0;
                    oprtData.current = null;
                    oprtData.forecast = null;
                    DBG_INFO('set empty city', DebugLevel.WARNING);
                    setEmptyCity();
                    return false;
                }
                else {
                    // read again
                    DBG_INFO("retry");
                    return resetWeatherOperateData();
                }
            }
            else {
                oprtData.current = tempCurrent[0];
                oprtData.forecast = tempForecast;
                rewritePageData();
                return true;
            }
        }
    }
    function rewriteCurrentWeatherData() {
        if(!readAll) {
            if(!resetWeatherOperateData()) {
                return;
            }
        }
        DBG_INFO('refresh current city: ' + objToString(userCities.cityList[pageInd]));
        if(isEmpty) {
            rewritePageData();
            isEmpty = false;
        }
        tv && getLatestWeather(userCities.cityList[pageInd].locId, userCities.cityList[pageInd].unit);
        setSpecialStyle();
    }
    function setUrl(key, urlType, itemUnit) {
        var url = '';
        try {
            var langcode = !!GLOBAL.CURRENT_LANGUAGE ? langMap[GLOBAL.CURRENT_LANGUAGE] : "en";
        } catch (ex) {
            langcode = "en";
            DBG_ERROR(ex.message);
        }
        var params = '?language=' + langcode+ '&apikey=' + apiKey + '&metric=' + (itemUnit == 'Metric');
        switch(urlType) {
            case URLType.CURRENT:
                url = 'http://api.accuweather.com/currentconditions/v1/' + key + '.json' + params + '&details=true';
                break;
            case URLType.FORECAST:
                url = 'http://api.accuweather.com/forecasts/v1/daily/5day/' + key + params
                break;
            case URLType.SEARCH:
                url = 'http://api.accuweather.com/locations/v1/search' + params + "&q=" + key
                break;
            default :
                DBG_INFO('url type error', DebugLevel.ERROR);
                break;
        }
        //DBG_INFO(url, DebugLevel.INFO);
        return encodeURI(url);
    }
//    function setPath(key, urlType) {
//        var path = 'weather/';
//        switch(urlType) {
//            case URLType.CURRENT:
//                path += ('current/' + key);
//                break;
//            case URLType.FORECAST:
//                path += ('forecast/' + key);
//                break;
//            case URLType.SEARCH:
//                path += 'searchlist';
//                break;
//            default :
//                DBG_INFO('url type error', DebugLevel.ERROR);
//                path += 'error';
//                break;
//        }
//        return path;
//    }
//    function setTempPath(key, urlType) {
//        var path = '';
//        switch(urlType) {
//            case URLType.CURRENT:
//                path += ('current' + key);
//                break;
//            case URLType.FORECAST:
//                path += ('forecast' + key);
//                break;
//            default :
//                DBG_INFO('url type error', DebugLevel.ERROR);
//                path += 'error';
//                break;
//        }
//        return path;
//    }
    function setImageOrTextStyleCommon(name,url,flag,text){
        try{
                if(flag=="img"){
                    var accu_cw_img=UI.getItem(accuweatherMain,name);
                    UI.setImage(accu_cw_img,url);
                }else{
                    var temp=UI.getItem(accuweatherMain,name);
                    UI.setText(temp,text);
                }
        }catch(e){DBG_ERROR("setImageOrTextStyleCommon is error:"+ e.message)}
    }
    function setSpecialStyle() {
        try{
            if(isEmpty==false){
                var imgsrc = cWeather.IsDayTime ? imgList.dayTime : imgList.nightTime;
                setImageOrTextStyleCommon("accw_bg",imgsrc,"img");
                DBG_ERROR("pageInd:"+pageInd+"userCities.defInd:"+userCities.defInd);
                if (pageInd == userCities.defInd){
                    setDefaultPic();
                }else{
                    setImageOrTextStyleCommon("default_home_pic",imgList.homeUnfocus,"img");
                }
            }
            //$($('#accu_fw_panel > li')[tdIndex]).attr('class', 'focus');
            //$('#accu_cw_temp').css('color', 'white');
            //$('#accu_cw_city').css('color', 'white');
            if(userCities.cityList.length > 1) {
                if(0 == pageInd) {
                    showArrow(ArrowType.SHOWRIGHT);
                }
                else if(userCities.cityList.length - 1 == pageInd) {
                    showArrow(ArrowType.SHOWLEFT);
                }
                else {
                    showArrow(ArrowType.SHOWDOUBLE);
                }
            }
            else {
                showArrow();
            }
            UI.updateStage();
        }catch(ex){DBG_ERROR(ex.message)}

    }
    function setEmptyCity() {
        try{
            isEmpty = true;
            userCities = {
                defInd: 0,
                cityList: []
            };
            if(pageData!=null){
                for(var prop in pageData){
                    pageData[prop]={};
                }
            }
            var middle_panel=UI.getItem(accuweatherMain,"middle_panel");
            var ceil_panel=UI.getItem(accuweatherMain,"ceil_panel");
            middle_panel.alpha=0;
            ceil_panel.alpha=0;
            try{
                if(UI.getCurrSubModule().name!=null){
                    while(UI.getCurrSubModule().name!="accuweatherMain"){
                        UI.popSubModule();
                    }
                }
            }catch(ex){DBG_ERROR(ex.message)}
            setSpecialStyle();
            setImageOrTextStyleCommon("accw_bg",'accuweather/nocity.png',"img");
            DBG_INFO("set EmptyCity");
        }catch(ex){DBG_ERROR(ex.message)}

    }
    function toDecimal(x, n) {
        n = !n ? 0.1 : n;
        var f = parseFloat(x);
        if(isNaN(f)) {
            return;
        }
        f = Math.round(x * 10 * n) / (10 * n);
        return f;
    }
    function fahrenheitToCelsius(fahrenheit) {
        var celsius = (parseFloat(fahrenheit) - 32) * 5 / 9;
        return toDecimal(celsius, 1);
    }
    function celsiusToFahrenheit(celsius) {
        var fahrenheit = parseFloat(celsius) * 9 / 5 + 32;
        return toDecimal(fahrenheit, 1);
    }

    if(tv){
        accuweatherMain.onkey_RED=openDeleteCityPage;
        accuweatherMain.onkey_GREEN=openAddCityPage;
        accuweatherMain.onkey_YELLOW=changeCurrentCityUnit;
        accuweatherMain.onkey_BLUE=openCityListPage;
    }else
    {
        accuweatherMain.onkey_ONE=openDeleteCityPage;
        accuweatherMain.onkey_TWO=openAddCityPage;
        accuweatherMain.onkey_THREE=changeCurrentCityUnit;
        accuweatherMain.onkey_FOUR=openCityListPage;
    }

    function openDeleteCityPage() {
        try {
            if(userCities.cityList.length == 0) {
                DBG_INFO('can not find any city.', DebugLevel.ERROR);
            }
            else {
                DBG_INFO('delete city: ' + objToString(userCities.cityList[pageInd]));
                UI.pushSubModule("accuweather","accuweatherDeleteCity",true);
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    function openAddCityPage() {
        try {
            if(userCities.cityList.length > 9) {
                accuweather.sendMsg("[WE0008]");//accuweather.sendMsg("Your list is full, please delete an existing entry.");
                UI.pushSubModule("accuweather","Msgbox");
            }
            else {
                UI.pushSubModule('accuweather','accuweatherAddCity',true);
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function changeCurrentCityUnit () {

        if(isEmpty || !canChangeUnit) {
            DBG_INFO("empty city or unit change is false");
            return;
        }
        var units = ["Metric", "Imperial"];
        var unitsType = [
            {
                Unit: "C",
                UnitType: 17
            },
            {
                Unit: "F",
                UnitType: 18
            }
        ]
        var idx = units.indexOf(cUnit);
        var fToc = (idx == 1);
        userCities.cityList[pageInd].unit = units[1 - idx];
        changeForecastUnit(userCities.cityList[pageInd].locId, oprtData.forecast, fToc, unitsType[1 - idx]);
        rewritePageData();
        setSpecialStyle();
        changeAllCityUnit(fToc, unitsType[1 - idx]);
        var defCurrent = readFileFromNative(setPath(userCities.cityList[userCities.defInd].locId, URLType.CURRENT), 1)[0];
        var defForecast = readFileFromNative(setPath(userCities.cityList[userCities.defInd].locId, URLType.FORECAST), 1);
        try {
            //if(g_launcherBrand != "VIDAALite")
            {
                accuweather.refreshHomeWeather(
                    userCities.cityList[userCities.defInd].locName,
                    defForecast.DailyForecasts[0].Temperature,
                    userCities.cityList[userCities.defInd].unit,
                    defCurrent.WeatherText,
                    defCurrent.WeatherIcon,
                    defCurrent.Temperature);
                }
        }
        catch(ex) {
            DBG_INFO(ex.message, DebugLevel.ERROR);
        }
    }
    accuweather.refreshHomeWeather = function(name, temp, unit, txt, icon, currentT) {
        var units = {
            Metric: '&deg;C',
            Imperial: '&deg;F'
        }
        //var minTemp = temp.Minimum.Value;
        //var maxTemp = temp.Maximum.Value;

        var wthrData = {
            name: name,
            degree: currentT[unit].Value + units[unit],//minTemp + units[unit] + ' - ' + maxTemp + units[unit],
            txt: txt,
            icon: ('0' + icon).slice(-2)
        }
        var Data={};
        Data.accu_cw_img={Data: imgList.big + wthrData.icon + '.png'};
        Data.accu_cw_city={Data:wthrData.name};
        Data.accu_cw_txt={Data:wthrData.txt};
        Data.accu_cw_temp={Data:wthrData.degree};
        refreshHomeStyle(Data);
    }
    function refreshHomeStyle(data){
        setImageOrTextStyle(data);
    }
    function changeAllCityUnit(fToc, newUnits) {
        var u = (18 == newUnits.UnitType ? "Imperial" : "Metric");
        for(var i = 0; i < userCities.cityList.length; i++) {
            if(u == userCities.cityList[i].unit) {
                DBG_INFO("do not change unit: " + userCities.cityList[i].locId);
            }
            else {
                userCities.cityList[i].unit = u;
                var tempCity = readFileFromNative(setPath(userCities.cityList[i].locId, URLType.FORECAST), 1);
                changeForecastUnit(userCities.cityList[i].locId, tempCity, fToc, newUnits);
            }
        }
        writeFileToNative(citylistPath, objToString(userCities), 1);
    }
    function changeForecastUnit(locId, forecast, fToc, newUnits) {
        var frcst = forecast.DailyForecasts;
        for(var i = 0; i < frcst.length; i++) {
            var valMin = frcst[i].Temperature.Minimum.Value;
            var valMax = frcst[i].Temperature.Maximum.Value;
            if(fToc) {
                frcst[i].Temperature.Minimum.Value = fahrenheitToCelsius(valMin);
                frcst[i].Temperature.Maximum.Value = fahrenheitToCelsius(valMax);
            }
            else {
                frcst[i].Temperature.Minimum.Value = celsiusToFahrenheit(valMin);
                frcst[i].Temperature.Maximum.Value = celsiusToFahrenheit(valMax);
            }
            frcst[i].Temperature.Minimum.Unit = newUnits.Unit;
            frcst[i].Temperature.Minimum.UnitType = newUnits.UnitType;
            frcst[i].Temperature.Maximum.Unit = newUnits.Unit;
            frcst[i].Temperature.Maximum.UnitType = newUnits.UnitType;
        }
        DBG_INFO("locId[" + locId + "] unit changed:" + newUnits.Unit);
        writeFileToNative(setPath(locId, URLType.FORECAST), objToString(forecast), 1);
    }

    function openCityListPage() {
        if(isEmpty) return;
        UI.pushSubModule('accuweather','accuweatherCityList',true);
    }
    //accuweatherMain.onkey_FIVE=function(){
    //    accuweather.sendMsg( "Network connection failed.");
    //    UI.pushSubModule("accuweather","Msgbox");
    //}
    //accuweather.onkey_SIX=
    accuweather.startLoading=function(loadingIcon) {
            UI.inactiveKey();
//            loadingIcon = new createjs.Bitmap();
//            loadImage(themeDir + "accuweather/loading.png", loadingIcon);
//            loadingIcon.pivot.x = 470/2;
//            loadingIcon.pivot.y = 470/2;
//            loadingIcon.x = 960;
//            loadingIcon.y = 550;
//            loadingIcon.name = "loadingIcon";

//            for (var i = 0; i < UI.frontStage.children.length; i++) {
//                if (UI.frontStage.children[i].name == "loadingIcon") {
//                    UI.frontStage.children[i].alpha = 0;
//                    createjs.Tween.removeTweens(UI.frontStage.children[i]);
//                    break;
//                }
//            }
//            UI.frontStage.addChild(loadingIcon);
//            UI.getTween(loadingIcon, true, true).to({rotation:360}, 10000);

            UI.setImage(loadingIcon,"accuweather/loading.png");
            UI.getTween(loadingIcon, true, true).to({rotation: loadingIcon.rotation + Math.PI*2}, 3000);
            loadingIcon.alpha = 1;
//            setTimeout(function(){UI.setImage(networkTestImg,img);},100);



            //$("#backgroundLayer").css("background-color", "black");
//            UI.getCurrSubModule().alpha=0.6;
            accuweather.endLoading=function(){
                UI.activeKey();
//                    //$("#backgroundLayer").css("background-color", "green");
//                    UI.frontStage.removeChild(loadingIcon);
//                    createjs.Tween.removeTweens(loadingIcon);
////                    UI.getCurrSubModule().alpha=1;
                createjs.Tween.removeTweens(loadingIcon);
                loadingIcon.rotation = 0;
                loadingIcon.alpha = 0;
                    UI.updateStage();
                }
        }
    var newAddedCityItem = {};
    accuweather.addNewCityAndRefresh = function(city) {
        DBG_INFO('city = ' + objToString(city));
        if(tv){
            newAddedCityItem = {};
            newAddedCityItem.locId = city.Key;
            newAddedCityItem.locName = city.LocalizedName;
            newAddedCityItem.locCountry = city.AdministrativeArea.LocalizedName;//city.Country.LocalizedName;
            newAddedCityItem.timeZone = city.TimeZone.GmtOffset;
            newAddedCityItem.unit = cUnit;
            newAddLocId = city.Key;
        }
        try {
            //var cntn = false;
            newAddedCityItem.alreadyContain = false;
            for(var i = 0; i < userCities.cityList.length; i++) {
                if(userCities.cityList[i].locId == newAddedCityItem.locId) {
                    newAddedCityItem.unit = userCities.cityList[i].unit;
                    //cntn = true;
                    newAddedCityItem.alreadyContain = true;
                    break;
                }
            }
            getLatestWeather(newAddLocId, newAddedCityItem.unit);
        }
        catch(ex) {
            DBG_INFO(objToString(userCities), DebugLevel.ERROR);
            DBG_INFO(ex.message, DebugLevel.ERROR);
        }
    }
    accuweatherMain.onkey_LEFT= function turnToLeft() {
        if(isEmpty) return;
        if(pageInd <= 0) {
            pageInd = 0;
            return;
        }
        pageInd--;
        rewriteCurrentWeatherData();
    }
    accuweatherMain.onkey_RIGHT=function turnToRight() {
        if(isEmpty) return;
        if(pageInd >= userCities.cityList.length - 1) {
            pageInd = userCities.cityList.length - 1;
            return;
        }
        pageInd++;
        rewriteCurrentWeatherData();
    }
    function setDefaultPic(){
        //---------set default pic position according city text's length------//
        var get_city=UI.getItem(accuweatherMain,"accu_cw_city");
        var default_home_pic=UI.getItem(accuweatherMain,"default_home_pic");
        //var global_defaultHome_pic=(parseInt(get_city.localToGlobal(0,0).x+get_city.children[0].getBounds().width)+80);
        //default_home_pic.x=default_home_pic.parent.globalToLocal(global_defaultHome_pic,default_home_pic.parent.y).x;
        var cityNameWidth=(get_city.children[0].getBounds().width+80);
        DBG_INFO("cityNameWidth:"+cityNameWidth);
        if(cityNameWidth>1160){
            default_home_pic.x=1160;
        }else{
            default_home_pic.x=(get_city.children[0].getBounds().width+80);
        }
        UI.setImage(default_home_pic,'accuweather/defaultcityfocus.png');
        //---------set default pic position according city text's length------//
    }
    accuweatherMain.onkey_ENTER=function setDefaultCity() {
        if(isEmpty || pageInd == userCities.defInd) return;
        userCities.defInd = pageInd;
        setDefaultPic();
        writeFileToNative(citylistPath, objToString(userCities), 1);
        //if(g_launcherBrand != "VIDAALite")
         {
            accuweather.refreshHomeWeather(
                userCities.cityList[pageInd].locName,
                fWeather[0].Temperature,
                userCities.cityList[pageInd].unit,
                cWeather.WeatherText,
                cWeather.WeatherIcon,
                cWeather.Temperature);
            }
    }
    accuweather.setCurrentWeatherByLocId = function(locId) {
        for(var i = 0; i < userCities.cityList.length; i++) {
            if(locId == userCities.cityList[i].locId) {
                pageInd = i;
                rewriteCurrentWeatherData();
                break;
            }
        }
    }
    var arrow_left=UI.getItem(accuweatherMain,"arrow_left");
    var arrow_right=UI.getItem(accuweatherMain,"arrow_right");
    function showArrow(arrowType) {
        switch(arrowType) {
            case ArrowType.SHOWLEFT:
                arrow_left.alpha=1;
                arrow_right.alpha=0;
                break;
            case ArrowType.SHOWRIGHT:
                arrow_left.alpha=0;
                arrow_right.alpha=1;
                break;
            case ArrowType.SHOWDOUBLE:
                arrow_left.alpha=1;
                arrow_right.alpha=1;
                break;
            default:
                arrow_left.alpha=0;
                arrow_right.alpha=0;
                break;
        }
    }
    accuweather.ShowCursor=function(flag){
        if(flag==true){
            UI.getTween(UI.base.cursor).set({alpha:1});
        }
        if(flag==false){
            UI.getTween(UI.base.cursor).set({alpha:0});
        }
    }
    //accuweather.initAccuweather();
    //setDefaultPic();
};
