UI.moduleBuilder['FTE']['fte_userMode'] = function() {
    var userModeData = {
        titleImg: "FTE/fte_hd_ic_tv_usage.png",
        title: "[SE0807]",//Usage Mode
        helpText: "[FTE0101]",//Home Mode uses less energy. Select Store Mode if the TV will be on display in a retail setting.
        tilesBgImg: UI.list_bg
    };
    var template = Util.readJson("module/FTE/fte_userMode.json");
    var userMode = SubModule.create(userModeData, template);
    var tiles = UI.getItem(userMode, "tiles");
    userMode.storeModeActBySingalNumTimer = null;
    userMode.num = 3;



    var array = [];
    for (var i = 0; i < userMode.num; i++) {
        array.push({});
        array[i].name = "fteUserMode" + i;
        array[i].bgImg = UI.item_bg;
        array[i].selectImg = "FTE/fte_checkmark.png";
    }
    array[0].text = "[SE0244]";     //"Home Mode";
    array[1].text = "[SE0809]";     //"Store Mode";
    array[2].text = "[SE3187]";     //"Store Mode (Video Demo Only)";

    var info = {
        template: "fte_userMode_item",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 1,
        distanceX: 0,
        distanceY: 6,
        container: tiles
    };
    Gird.create(array, info);

    //隐藏所有选项前面代表选中的对勾
    for (var i = 0; i < userMode.num; i++) {
        tiles.children[i].children[1].alpha = 0;
    }

    userMode.currFocus = tiles.children[0];

    var background = UI.getSubModule("fte_background");

    var homeModeBtn = tiles.children[0];
    var storeModeBtn = tiles.children[1];
    var storeDemoOnly = tiles.children[2];


    userMode.onPush = function () {
        var currUsemodeIdx = tv ? model.system.getUserMode() : 1; //0: home mode; 1: store mode 2:only
        DBG_INFO("FTE user mode is " + currUsemodeIdx);
//        var selectIndex = (currUsemodeIdx == 0) ? 0 : 1;
        tiles.DataSelected = tiles.initSequence[currUsemodeIdx];
        fteDefaultSelect(tiles);
        userMode.currFocus = tiles.DataSelected;
    };

    userMode.onShow = function () {
        background.open();
    };

    userMode.onPop =function(){
        clearStoreModeActBySingalNumTimer();
    }
    homeModeBtn.onkey_ENTER = function () {
        fteGirdSelect(tiles, function(){});
        chooseHomeMode();
    };

    storeModeBtn.onkey_ENTER = function () {
        DBG_INFO(" storeMode ");
        fteGirdSelect(tiles, function(){});
        clearStoreModeActBySingalNumTimer();
        userMode.storeModeActBySingalNumTimer = setTimeout(function () {
            writeFileToNative('hisenseUI/eposmode.txt', "videosignal", 1);
            storeModeActBySingalNum(1);
        }, 200);
    };

    storeDemoOnly.onkey_ENTER = function(){
        DBG_ERROR(" storeDemoOnly ");
        fteGirdSelect(tiles, function(){});
        clearStoreModeActBySingalNumTimer();
        userMode.storeModeActBySingalNumTimer = setTimeout(function () {
            writeFileToNative('hisenseUI/eposmode.txt', "video", 1);
            storeModeActBySingalNum(2);
        }, 200);
    };


    tiles.onkey_LEFT = function () {
        fteUpdate(-1);
    };

    tiles.onkey_RIGHT = function () {
        try{
            var currUsemodeIdx = tv? model.system.getUserMode(): 0; //0: home mode; 1: store mode; 2:4k mode
            if(currUsemodeIdx == 0){
                chooseHomeMode();
            }else{
                clearStoreModeActBySingalNumTimer();
                userMode.storeModeActBySingalNumTimer = setTimeout(function () {
                    if(currUsemodeIdx == 1){
                        writeFileToNative('hisenseUI/eposmode.txt', "videosignal", 1);
                    }else if(currUsemodeIdx == 2){
                        writeFileToNative('hisenseUI/eposmode.txt', "video", 1);
                    }
                    storeModeActBySingalNum(currUsemodeIdx);
                }, 200);
            }
        }catch(ex){
            DBG_ERROR(ex.message);
        }
    };

    function storeModeActBySingalNum(modeIndex) {
        background.alpha = 0;
        userMode.alpha = 0;
        FTE.isOpenLiveTV = false;
        FTE.isResumeDtv = false;
        var inputsData = initAllInputsData();
        DBG_ERROR("inputsData is " + objToString(inputsData));
        var signalNum = inputsData.signalSourceList.length;
        DBG_ERROR("signalNum is " + signalNum);
        if (signalNum == 0) {
            storeModePlayEpos(modeIndex);
        } else if (signalNum == 1) {
            changeSourceTo(parseInt(inputsData.signalSourceList));
            storeModePlayEpos(modeIndex);
        } else {
            UI.popSubModule();
            UI.pushSubModule("FTE", "fte_source", true, {modeIndex: modeIndex});
        }
    }

    function storeModePlayEpos(modeIndex) {
        FTE.play4kVideo(function() {
            try{
                model.system.setUserMode(modeIndex);
            }catch(e){
                DBG_ERROR(e.message);
            }
            UI.setEposMenuTimeout(startRetailmodeTimer,retailmodeTimeout);
            startePos(true);
        });
    }

    function clearStoreModeActBySingalNumTimer(){
        if(!!userMode.storeModeActBySingalNumTimer){
            clearTimeout(userMode.storeModeActBySingalNumTimer);
        }
        userMode.storeModeActBySingalNumTimer = null;
    }

    function chooseHomeMode(){
        UI.inactiveKey();
        setTimeout(function() {
            if(tv) model.system.setUserMode(0);
            UI.clearEposMenuTimeout();
            fteUpdate(1);
            UI.activeKey();
        }, 200);
    }
}