UI.moduleBuilder['FTE']['fte_network'] = function() {
        var networkData = {
            loadingImg: "FTE/loading.png",
            titleImg: "FTE/fte_hd_ic_network.png",
            skipFrameText: "[SE3081]",//You will need Internet connectivity to access apps like below. Are you sure you want to skip the network setup process?
            skipFrameImg1: "FTE/fte_app_ic_ntflx.png",
            skipFrameImg2: "FTE/fte_app_ic_ytb.png",
            skipFrameImg3: "FTE/fte_app_ic_amzn.png",
            OKBtnImg: UI.item_bg,
            title: "[SE0157]",//Network Setup
            btnSkipHint1Text: "[SE3077]",//Connect to network
            btnSkipHint2Text: "[SE3078]",//Finish without network
//            ethBtnSkip1Text: "[FTE0031]",       //"Skip network setup",
//            ethBtnSkip2Text: "[SE3079]",//IP settings
            ethBtnNoConnect1Text: "[SE3879]",//Change IP settings
            ethBtnNoConnect2Text: "[SE3878]",//Use another network
            ethBtnNoConnect3Text: "[PI0019]",  //Try again
//            wifiBtnSkip1Text: "[FTE0031]",      //"Skip network setup",
            mainBtnText:"[SE2642]",
            rightArrow: "FTE/fte_arrow_right.png",
            rightArrowText:"[SE1673]"
        };
        var template = Util.readJson("module/FTE/fte_network.json");
        var network = SubModule.create(networkData, template);

        var DataEthBtnFinish = "[SE3883]";//Successfully connected to the network.
        var DataEthBtnFinishSubText = "[SE3884]";//If you have any problem using online services, please contact your internet provider.
        var DataEthBtnNoConnect = "[SE3873]";//Wired LAN is not connected.
        var DataEthBtnNoConnectSubText = "[SE3874]";//Please try wireless connection, or check your IP settings.
        var DataWifiBtnSuccess = "Successfully connected to ";
        var DataBtnSkipHint = "[SE3081]";//You will need Internet connectivity to access apps like below. Are you sure you want to skip the network setup process?
        var DataEther = "[SE3075]";//Ethernet connection.
        var DataWifi = "[SE3084]";//Wireless connection:
        var DataNoEther = "[SE3076]";//No Ethernet connectivity is found.
        var DataExit = "[SE3085]";//You are about to exit the setup process.


        network.isEthernetConnected = 1;            //0��û�м�⵽���ߣ�1����⵽����
        network.netType = NetWorkType.ETHER;    //0�����ߣ�1��wifi
        network.ipPageMode = 0;     //0: ����������ҳ�����, 1: ������ʧ��ҳ�����
        network.ipWifiPageMode = 0;//0:wifi connect fail 1: wifi password error
        network.pageData = {    //wifi���
            "operateData": {
                "wifiApSearchTimeOutTimer": 0,      //��ʱ��ʱ��
                "wifiApSearchHoldTimer": 0,         //������ɶ�ʱ��
                "wifiSearState": 0                  //wifi״̬�� 0��δ������ 1���������
            }
        };
        network.ethernetData = {    //���������
            "operateData": {
                "connectResult": 0, //0:fail, 1:sucess
                "ethSearchTimeOutTimer": 0,
                "ethSearchHoldTimer": 0,
                "Interval": 0
            },
            "etherConnectInterval": 0
        };

        var background = UI.getSubModule("fte_background");
        var mainFrame = UI.getItem(network, "mainFrame");

        var loadingImg = UI.getItem(network, "loadingImg");
        var mainText = UI.getItem(mainFrame, "mainText");
        var mainSubText = UI.getItem(mainFrame, "mainSubText");

        var hintFrame = UI.getItem(network, "hintFrame");
        var skipFrame = UI.getItem(network, "skipFrame");
        var btnFrame = UI.getItem(network, "btnFrame"); //all button


        var mainBtn = UI.getItem(network, "mainBtn");
        var ethBtnNoConnect1 = UI.getItem(network, "ethBtnNoConnect1");
        var ethBtnNoConnect2 = UI.getItem(network, "ethBtnNoConnect2");
        var ethBtnNoConnect3 = UI.getItem(network, "ethBtnNoConnect3");

        var wifiBtnNoConnect1 = UI.getItem(network, "wifiBtnNoConnect1");  //try again
        var wifiBtnNoConnect2 = UI.getItem(network, "wifiBtnNoConnect2");  //ip setting
        var wifiBtnNoConnect3 = UI.getItem(network, "wifiBtnNoConnect3");  //skip


        var btnSkipHint1 = UI.getItem(network, "btnSkipHint1");   //connect to network
        var btnSkipHint2 = UI.getItem(network, "btnSkipHint2");   //finish
        var loadingImgText = UI.getItem(network, "loadingImgText");
        var rightArrow = UI.getItem(network, "rightArrow");
        var rightArrowText = UI.getItem(network, "rightArrowText");
        network.currFocus = loadingImg;


        network.onPush = function() {
            network.currFocus = loadingImg;
//             btnFrame.y = mainText.y + mainText.children[0].getBounds().height + 48;
            btnFrame.y = 256 + 48 * 3 + 48;
            hideAllBtn();
            var countryCode = tv ? model.basicSetting.getTvsetLocation() : "USA";
            if (countryCode == "CAN" || countryCode == "MEX") {
                var img = UI.getItem(network, "skipFrameImg3");
                UI.setImage(img, "FTE/fte_app_ic_brsw.png");
            }
            else if (countryCode == "USA") {
                var img = UI.getItem(network, "skipFrameImg3");
                UI.setImage(img, "FTE/fte_app_ic_amzn.png");
            }

            initNetwork();
            if (network.isEthernetConnected == 1 || network.isEthernetConnected == 3) {
                DBG_ERROR("Ethernet is connected, use ethernet");
                network.searchEthernet();
            } else {
                DBG_ERROR("Ethernet is not connected, use wifi");
                network.searchWifi();
            }
            if (tv) {
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ETHERNET_CHANGED, onEtherConChanged);
            }

        }

        function initNetwork(){
            if (tv) {
                try {
                    //get current status//
                    network.isEthernetConnected = model.network.getEthernetConnected(); //0:no port;1:wired only;2:wireless only;3:wired and wireless
                    DBG_ERROR("network.isEthernetConnected: " + network.isEthernetConnected);
                    if (network.isEthernetConnected == 1 || network.isEthernetConnected == 3 ) {
                        model.network.setEnumNetworking(1); //0:Ehternet, 1:Wireless
                        model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                        model.network.WiredSet();
                    }else{
                        if (model.network.getEnumNetworking()!= 2) {   //��ֹ�������ӷ�ʽʹwifi�ϵ�
                            model.network.setEnumNetworking(2);
                            model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                            model.network.WirelessSet();
                        }
                    }
                } catch (ex) {
                    DBG_ERROR("initNetwork: " + ex.message);
                }
            }

        }
        network.onShow  = function(){
            background.open();
            showSkipEleOrNot(1);
            hideNavbarOrNot(1);
        };

        function onEtherConChanged() {
            var newEtherStatus = model.network.getEthernetConnected();
            if ((network.isEthernetConnected == 0 && newEtherStatus == 1) || (network.isEthernetConnected == 2 && newEtherStatus == 3)) {  //�����߱�Ϊ����
                DBG_INFO("network.isEthernetConnected changed old is " + network.isEthernetConnected);
                DBG_INFO("network.isEthernetConnected changed new is " + newEtherStatus);
                FTE.networkEndLoading();
                popSubModuleUntil("fte_network");
                hideAllBtn();
                fteSearchWifiCancel();
                network.searchEthernet();
            }
            network.isEthernetConnected = newEtherStatus;

        }

        network.onFocus = function(){
            if(UI.getCurrSubModule().name == "fte_network" && (network.currFocus.name == "loadingImg"||network.currFocus.name =="mainText")){
                UI.base.cursor.alpha = 0;
                UI.getTween(UI.base.cursor).set({alpha: 0});
            }else{
                UI.base.cursor.alpha = 1;
                UI.getTween(UI.base.cursor).set({alpha: 1});
                return true;
            }
            UI.updateStage();

        };
        loadingImg.onkey_RIGHT = function(){
            if(network.currFocus.name == "loadingImg"){
                skipNetwork();
            }
        };
        loadingImg.onkey_LEFT = function(){
            fteSearchEthernetCancel();
            fteSearchWifiCancel();
            fteUpdate(-1);
        };

        loadingImg.onkey_ENTER =function(){
            return false;
         };

        network.onPop = function () {
            fteSearchWifiCancel();
            fteSearchEthernetCancel();
            FTE.networkEndLoading("network.onPop");
        };

        network.onkey_BACKSPACE = function() {
            fteSearchEthernetCancel();
            fteSearchWifiCancel();
            fteUpdate(-1);
         };


        network.searchEthernet = function () {
            DBG_INFO("FTE network.searchEthernet()");
            changeNetworkHelpText(DataEther);
            UI.setText(loadingImgText,"[FTE0066]...");//Connecting Ethernet
            networkLoading(1);
//            ethBtnSkip1.alpha = 1;
//            ethBtnSkip2.alpha = 1;
           /* if (!!UI.getCurrSubModule()) {  //第一次进入的时候currSubModule是null
                UI.focusTo(ethBtnSkip1);
            }*/
            UI.updateStage();
            fteNetSearchEthernet();

        };

        network.searchWifi = function () {
            DBG_INFO("FTE network.searchWifi()");
            changeNetworkHelpText(DataNoEther);
            UI.setText(loadingImgText,"[SE0603]\n\n[SE3882]" );//Searching networks... \n\nMake sure your router is within 10 feet.
            networkLoading(1);
           /* wifiBtnSkip1.alpha = 1;
            if (!!UI.getCurrSubModule()) {  //第一次进入的时候currSubModule是null
                UI.focusTo(wifiBtnSkip1);
            }*/
            UI.updateStage();
            fteNetSearchWifi();
        };

        network.showEthBtnFinishPage = function () {
            DBG_INFO("[ethernet connect] success");
            popSubModuleUntil("fte_network");
            showSkipEleOrNot(0);
            hintFrame.alpha = 1;
            mainBtn.alpha = 1;
            UI.setText(mainText, DataEthBtnFinish);
            UI.setText(mainSubText,DataEthBtnFinishSubText);
            changeNetworkHelpText(DataEther);
            UI.focusTo(mainBtn);
            UI.updateStage();
        };
        network.showEthBtnNoConnectPage = function () {
            popSubModuleUntil("fte_network");
            DBG_INFO("[ethernet connect] fail");
            ethBtnNoConnect1.alpha = 1;
            ethBtnNoConnect2.alpha = 1;
            ethBtnNoConnect3.alpha = 1;
            hintFrame.alpha = 1;
            mainBtn.alpha = 0;
            UI.setText(mainSubText,DataEthBtnNoConnectSubText);
            UI.setText(mainText, DataEthBtnNoConnect);
            UI.focusTo(ethBtnNoConnect1);
            changeNetworkHelpText(DataEther);

        };

        ethBtnNoConnect3.onkey_RIGHT = function(){
            skipNetwork();
        }

        wifiBtnNoConnect3.onkey_RIGHT = function(){
            skipNetwork();
        }

        network.showWifiBtnSuccessPage = function () {
            DBG_INFO("[ethernet connect] success");
            var wifiName = tv? model.network.getSsid() :"wifi";
            changeNetworkHelpText(DataWifi + wifiName);
            popSubModuleUntil("fte_network");
            showSkipEleOrNot(0);
            hintFrame.alpha = 1;
            mainBtn.alpha = 1;
            UI.setText(mainText, "[SE3887]", null, null, null, null, [wifiName]);
            UI.setText(mainSubText,DataEthBtnFinishSubText);
            UI.focusTo(mainBtn);
            UI.updateStage();
        };


        network.skipNetworkSet = function () {
            fteUpdate(1);
        };

        network.hideWifiSkipPage = function () {
            networkLoading(0);
//            wifiBtnSkip1.alpha = 0;
        };

       /* ethBtnSkip1.onkey_ENTER = function () {
            fteSearchEthernetCancel();
            networkLoading(0);
            ethBtnSkip1.alpha = 0;
            ethBtnSkip2.alpha = 0;
            openNetSkipPage();
        };
        ethBtnSkip2.onkey_ENTER = function () {
            fteSearchEthernetCancel();
            networkLoading(0);
            ethBtnSkip1.alpha = 0;
            ethBtnSkip2.alpha = 0;
            network.netType = NetWorkType.ETHER;
            network.ipPageMode = 0;
            UI.pushSubModule("FTE", "fte_netIpSet", true);
        };*/
        mainBtn.onkey_ENTER = function(){
            if(mainBtn.alpha == 1){
                fteUpdate(1);
            }
        };

        ethBtnNoConnect1.onkey_ENTER = function () {
            ethBtnNoConnect1.alpha = 0;
            ethBtnNoConnect2.alpha = 0;
            ethBtnNoConnect3.alpha = 0;
            hintFrame.alpha = 0;
            network.netType = NetWorkType.ETHER;
            network.ipPageMode = 1;
            UI.pushSubModule("FTE", "fte_netIpSet", true);
        };
        ethBtnNoConnect2.onkey_ENTER = function () {
            ethBtnNoConnect1.alpha = 0;
            ethBtnNoConnect2.alpha = 0;
            ethBtnNoConnect3.alpha = 0;
            hintFrame.alpha = 0;
            network.searchWifi();
        };
        ethBtnNoConnect3.onkey_ENTER = function () {
            ethBtnNoConnect1.alpha = 0;
            ethBtnNoConnect2.alpha = 0;
            ethBtnNoConnect3.alpha = 0;
            hintFrame.alpha = 0;
            network.searchEthernet();
        };


        btnSkipHint1.onkey_ENTER = function () {
            skipFrame.alpha = 0;
            hintFrame.alpha = 0;
            btnSkipHint1.alpha = 0;
            btnSkipHint2.alpha = 0;
            DBG_ERROR("btnSkipHint1.onkey_ENTER, search network again...");
            UI.focusTo(loadingImg);
            initNetwork();
            if (network.isEthernetConnected == 1 || network.isEthernetConnected == 3) {
                DBG_ERROR("Ethernet is connected, use ethernet");
                network.searchEthernet();
            } else {
                DBG_ERROR("Ethernet is not connected, use wifi");
                network.searchWifi();
            }
        };
        btnSkipHint2.onkey_ENTER = function () {
            fteUpdate(1);
//            network.openFteSourcePage();
//        stopAcrServer("FTE");//ACR置灰
        };

        network.exitNetworkPage = function () {
            popSubModuleUntil("fte_network");
            fteUpdate(-1);
        };
        mainBtn.onkey_LEFT = network.exitNetworkPage;
        ethBtnNoConnect1.onkey_LEFT = network.exitNetworkPage;
//        wifiBtnSkip1.onkey_LEFT = network.exitNetworkPage;
        btnSkipHint1.onkey_LEFT = network.exitNetworkPage;

        function hideAllBtn() {
            hintFrame.alpha = 0;
            networkLoading(0);
            /*ethBtnSkip1.alpha = 0;
            ethBtnSkip2.alpha = 0;*/
            ethBtnNoConnect1.alpha = 0;
            ethBtnNoConnect2.alpha = 0;
            ethBtnNoConnect3.alpha = 0;
//            wifiBtnSkip1.alpha = 0;
            wifiBtnNoConnect1.alpha = 0;
            wifiBtnNoConnect2.alpha = 0;
            wifiBtnNoConnect3.alpha = 0;
            btnSkipHint1.alpha = 0;
            btnSkipHint2.alpha = 0;
            skipFrame.alpha = 0;
        }

        function networkLoading(flag) {
            if (flag) {
                loadingImg.alpha = 1;
                loadingImgText.alpha = 1;
                UI.getTween(loadingImg, true, true).to({rotation: loadingImg.rotation + Math.PI*2}, 1000);
            }
            else {
                loadingImg.alpha = 0;
                loadingImgText.alpha = 0;
                createjs.Tween.removeTweens(loadingImg);
            }

        }

        function openNetSkipPage() {
            DBG_INFO("openNetSkipPage()");
            changeNetworkHelpText(DataExit);
            skipFrame.alpha = 1;
            btnSkipHint1.alpha = 1;
            btnSkipHint2.alpha = 1;
            ethBtnNoConnect1.alpha = 0;
            ethBtnNoConnect2.alpha = 0;
            ethBtnNoConnect3.alpha = 0;
            hintFrame.alpha = 0;
            UI.setText(mainText, DataBtnSkipHint);
            UI.focusTo(btnSkipHint1);
        }

        network.openFteSourcePage = function () {    //todo 这个函数改个名字 for ACR
            DBG_ERROR("network.openFteSourcePage()" + !acrflag);
            if (!acrflag) {
                UI.popSubModule();
                DBG_INFO("network.openFteSourcePage()");
                UI.pushSubModule("FTE", "fte_source", true);
            } else {
                if (g_acrSwitch.GlobalSwitch == AcrSwitch.OFF || (tv ? model.system.getUserMode() != 0 : true)
                    || isTtsPlay()) {
                    UI.popSubModule();
                    DBG_INFO("network.openFteSourcePage()");
                    UI.pushSubModule("FTE", "fte_source", true);
                }
                else {
                    fteUpdate(1);
                }
            }
        };

    function fteNetSearchWifi() {
        var data = network.pageData;

        if (tv) {
            clearTimeout(data.operateData.wifiApSearchTimeOutTimer);
            data.operateData.wifiApSearchTimeOutTimer = setTimeout(fteWifiSearchTimeOutHandler, 18000); //��ʱ��Ϊ15��
            clearTimeout(data.operateData.wifiApSearchHoldTimer);
            data.operateData.wifiApSearchHoldTimer = setTimeout(fteNetSetStartSearchWifi, 2000);
        }else {  //Ϊ��pc�ϲ��Է���
            data.operateData.wifiApSearchTimeOutTimer = setTimeout(fteWifiSearchTimeOutHandler, 150);
            data.operateData.wifiApSearchHoldTimer = setTimeout(fteNetSetStartSearchWifi, 0);
        }

        function fteNetSetStartSearchWifi() {
            try{
                if(tv == false){
                    data.operateData.wifiSearState = 1;
                }else{
                    if(model.network.getEnumNetworking()!=2){
                        model.network.setEnumNetworking(2);
                        model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                        model.network.WirelessSet();
                    }
                    var searchState = model.network.getEnumAccess_pointsSearch();/* 0:off,1: wait,2: found,3:not found*/
                    DBG_ERROR("FTE wifi searchState: " + searchState);
                    if(searchState != 1){
                        //���¿�ʼ����
                        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED, fteNetSetSearWifiStateCallBack);
                        model.network.setEnumAccess_pointsSearch(1);//1:��ʼ, 0:ֹͣ
                    }
                    data.operateData.wifiSearState = 1;
                }
            }catch (ex){
                DBG_INFO("fteNetSetStartSearchWifi" + ex.message);
            }
        }
        //��ʼ����wifi
        //fteNetSetStartSearchWifi();
    }
    
    function fteNetSetSearWifiStateCallBack(searchState) {
        var data = network.pageData;
        try{
            DBG_INFO("fteNetSetSearWifiStateCallBack searchState = " + searchState);
            switch (searchState) {
                case 1://wait
                    data.operateData.wifiSearState = 1;
                    break;
                case 2://accesspoint found
                    //���ٹ��ѵ�wifi
                    if (tv) {
                        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED, fteNetSetSearWifiStateCallBack);
                    }
                    data.operateData.wifiSearState = 2;
                    //��wifi���ҳ��
                    fteNetworkSetCreateWifiSetPage();
                    break;
                case 3://not found
                    data.operateData.wifiSearState = 2;
                    fteNetworkSetCreateWifiSetPage();
                    break;
                case 4://wifi not plugin???
                    DBG_INFO("fteNetSetSearWifiStateCallBack searchState = " + searchState);
                    data.operateData.wifiSearState = 2;
                    //todo wifi not plugin
                    //boeNetSetCreateWifiNotPluginDialog();
                    break;
                default://other
                    if (model.network.getEnumAccess_pointsSearch() == searchState) {//for the first time searchState is a random ,so add this condition
                        data.operateData.wifiSearState = 0;
                        if (tv) {
                            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED, fteNetSetSearWifiStateCallBack);
                        }
                        fteNetworkSetCreateWifiSetPage();
                    }
                    break;
            }

        }catch (ex){
            DBG_ERROR("fteNetSetSearWifiStateCallBack: " + ex.message);
        }
    }

    function fteWifiSearchTimeOutHandler() {
        try{
            DBG_INFO("FTE wifi search time out!!");
            if(tv == true){
                if(model.network.getEnumAccess_pointsSearch() == 1){
                    model.network.setEnumAccess_pointsSearch(0);    //��ʱʱ�䵽���ر�wifi����
                }
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED, fteNetSetSearWifiStateCallBack);
            }
            //��wifi���ҳ��
            fteNetworkSetCreateWifiSetPage();
        }catch (ex){
            DBG_ERROR("fteWifiSearchTimeOutHandler: " + ex.message);
        }

    }

    function fteNetworkSetCreateWifiSetPage() {
        try{
            DBG_INFO("FTE open wifi result page.");
            var data = network.pageData;
            clearTimeout(data.operateData.wifiApSearchTimeOutTimer);
            clearTimeout(data.operateData.wifiApSearchHoldTimer);
            network.hideWifiSkipPage();
            UI.pushSubModule("FTE", "fte_netWifiResult", true);
        }catch (ex){
            DBG_ERROR("fteNetworkSetCreateWifiSetPage: " + ex.message);
        }
    }

    function fteSearchWifiCancel() {
        DBG_INFO("cancel wifi search");
        var data = network.pageData;
        clearTimeout(data.operateData.wifiApSearchTimeOutTimer);
        clearTimeout(data.operateData.wifiApSearchHoldTimer);
        if(tv == true){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED, fteNetSetSearWifiStateCallBack);
            /*if(model.network.getEnumAccess_pointsSearch() == 1){
                DBG_INFO("fteSearchWifiCancel: model.network.setEnumAccess_pointsSearch(0)");
                model.network.setEnumAccess_pointsSearch(0);
            }*/
        }
    }

    /*------------------------���������Ӻ���----------------------------------*/
    function fteNetSearchEthernet(){
        try{
            if (tv) {
                if(model.network.getEnumNetworking()!=1){
                    model.network.setEnumNetworking(1);//0:Ehternet,1:Wireless  ���л������ߣ���
                    model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                    model.network.WiredSet();
                }
            }
            var data = network.ethernetData;
            if (tv) {
                clearTimeout(data.operateData.ethSearchTimeOutTimer);
                data.operateData.ethSearchTimeOutTimer = setTimeout(fteEthernetSearTimeOutHandler, 15000);
                clearTimeout(data.operateData.ethSearchHoldTimer);
                data.operateData.ethSearchHoldTimer = setTimeout(fteEthernetSearHoldHandler, 2000);
            }else {
                data.operateData.ethSearchTimeOutTimer = setTimeout(fteEthernetSearTimeOutHandler, 15000);
                data.operateData.ethSearchHoldTimer = setTimeout(fteEthernetSearHoldHandler, 3000);
            }
        }catch (ex){
            DBG_ERROR("fteNetSearchEthernet: "+ ex.message);

        }
    }

    function fteEthernetSearTimeOutHandler(){
        var data = network.ethernetData;
        try{
            DBG_INFO("fteEthernetSearTimeOutHandler: time out!!");
//            clearInterval(data.operateData.Interval);
            fteNetworkSetCreateEtherentResultPage();
        }catch (ex){
            DBG_ERROR("fteEthernetSearTimeOutHandler: "+ex.message);
        }

    }

    function fteEthernetSearHoldHandler()
    {
        try{
            DBG_INFO("fte start search ethernet!");
            fteNetSetStartSearchEthernet();
        }catch (ex){
            DBG_ERROR("fteEthernetSearHoldHandler: " + ex.message);
        }
    }

    function fteNetSetStartSearchEthernet(){
        var data = network.ethernetData;
        try{
            if(tv == false){
                fteNetworkSetCreateEtherentResultPage();
            }else{
//                model.network.setEnumNetworkConfig(1);  //0:�ر�����, 1:������
//                model.network.setEnumIp_config(0);  //IP��ȡ��ʽ��0���Զ��� 1���ֶ�
                if(model.network.getEnumNetworking() != 1){
                    model.network.setEnumNetworking(1);
                    model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                    model.network.WiredSet();
                }
                var ethSearState = model.network.getEnumNetworkAvailable(); //1��success, 0��fail
                DBG_ERROR("[FTE ethernet] ethSearState is " + ethSearState);
                if(ethSearState != 1){
                    //���¿�ʼ����
//                    data.operateData.Interval = setInterval("getEthernetResult()", 1000);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, getEthernetResult);
                }else{
                    fteNetworkSetCreateEtherentResultPage();
                }
            }
        }catch (ex){
            DBG_ERROR("fteNetSetStartSearchEthernet: " + ex.message);
        }        
    }

    function getEthernetResult(val){

//        var ethSearState = model.network.getEnumNetworkAvailable();
//        DBG_INFO("[FTE ethernet] ethSearState interval is " + ethSearState);
        DBG_INFO("[FTE ethernet] ethSearState interval is " + val);
        if(val == 1)
        {
            fteNetworkSetCreateEtherentResultPage();
        }
    }

    function fteNetworkSetCreateEtherentResultPage(){
        try{
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, getEthernetResult);
            DBG_INFO("fteNetworkSetCreateEtherentResultPage: create Ethernet connect result page!!");
            var data = network.ethernetData;
            clearTimeout(data.operateData.ethSearchTimeOutTimer);
            clearTimeout(data.operateData.ethSearchHoldTimer);
            
            if (tv) {                
                data.operateData.connectResult = model.network.getEnumNetworkAvailable();
                DBG_INFO("[FTE ethernet] result is " + data.operateData.connectResult);
            }

            networkLoading(0);
           /*  ethBtnSkip1.alpha = 0;
                ethBtnSkip2.alpha = 0;*/
            hintFrame.alpha = 1;    //�Ƿ�ɹ�����ʾ��Ϣ
            if (data.operateData.connectResult == 1)
            {
                network.showEthBtnFinishPage();  //success
            }
            else                                     //failed
            {
                network.showEthBtnNoConnectPage();
            }
            
        }catch (ex){
            DBG_ERROR("fteNetworkSetCreateEtherentResultPage: " + ex.message);
        }
    }

    function fteSearchEthernetCancel() {
        DBG_INFO("cancel ethernet search");
        var data = network.ethernetData;
//        clearInterval(data.operateData.Interval);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, getEthernetResult);
        clearTimeout(data.operateData.ethSearchTimeOutTimer);
        clearTimeout(data.operateData.ethSearchHoldTimer);
        if(tv == true){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ETHERNET_CHANGED, onEtherConChanged);
        }
    }

    function skipNetwork(){
        fteSearchEthernetCancel();
        fteSearchWifiCancel();
        networkLoading(0);
        fteUpdate(1);
    }

};


function changeNetworkTitleImg(newTitleImg) {
    var network = UI.getSubModule("fte_network");
    var titleImg = UI.getItem(network, "titleImg");
    UI.setImage(titleImg, newTitleImg);
}
function changeNetworkTitle(newTitle) {
    var network = UI.getSubModule("fte_network");
    var title = UI.getItem(network, "title");
    UI.setText(title, newTitle);
}
function changeNetworkHelpText(newHelpText, color) {
    var network = UI.getSubModule("fte_network");   //onPush��ʱ���ȡ����������
    var helpText = UI.getItem(network, "helpText");
    UI.setText(helpText, newHelpText);
    if (!!color) {
        UI.setTextColor(helpText, color);
    }
    else {
        UI.setTextColor(helpText, 0xFFFFFF);
    }
}
function networkLoading(flag) {
    DBG_ERROR("networkLoading flag is " + flag);
    var network = UI.getSubModule("fte_network");   //onPush��ʱ���ȡ����������
    var loadingImg = UI.getItem(network, "loadingImg");
    if (flag) {
        loadingImg.alpha = 1;
        UI.getTween(loadingImg, true, true).to({rotation: loadingImg.rotation  + Math.PI*2}, 1000);
    }
    else {
        loadingImg.alpha = 0;
        createjs.Tween.removeTweens(loadingImg);
    }
    UI.updateStage();
}
function showSkipEleOrNot(flag){
    var network = UI.getSubModule("fte_network");
    var rightArrow = UI.getItem(network, "rightArrow");
    var rightArrowText = UI.getItem(network, "rightArrowText");
    rightArrow.alpha = flag;
    rightArrowText.alpha = flag;
}

