UI.moduleBuilder['FTE']['fte_netWifiResult'] = function() {
    var netWifiResultData = {
        addWifiBtnImg: UI.item_bg,
        tilesBgImg: UI.list_bg,
        reloadBtnImg: UI.item_bg,
        mainText: "[SE3871]",//Wireless nerwork is not connected.
        mainSubText:"[SE3872]",//Make sure your router is within 10 feet or use a wired LAN connection.
        OKBtnImg: UI.item_bg,
        addWifiBtnText: "[SE3091]",//Add a hidden network
        tiles1Hint: "[SE4002]",//No networks are found. Make sure your router is within 10 feet.
        reloadBtnText: "[SE1301]",//Refresh
//        skipBtnText: "[FTE0031]",//Skip network setup
        wifiBtnNoConnect1Text: "[SE3879]",//Change IP settings
        wifiBtnNoConnect2Text: "[SE3878]",//Use another network
        wifiBtnNoConnect3Text: "[PI0019]"  //Try again

    };
    var template = Util.readJson("module/FTE/fte_netWifiResult.json");
    var netWifiResult = SubModule.create(netWifiResultData, template);

    var DataWifiConnectFail = "[SE3086]";//"No Internet connectivity is detected. Plug in an Ethernet cable or use a wireless network. "
    var DataPasswordError = "[SE3087]";//Incorrect password.
    var DataSuccessConnect = "[SE3090]";//You are successfully connected to the internet


    netWifiResult.pageData = {
        "fteNetworkWifiAutoResultUl":{
            "Data":[
                {
                    "fteNetworkWifiName":{"Data":"HIPM"},
                    "fteNetworkWifiConnState":{"Data":"connected"}, //�Ƿ�������
                    "fteNetworkWifiSecType":{"Data":"WPA-WPA2-PSK"},
                    "fteNetworkWifiSecImg":{"Data":"img/network/wifilock.png"},
                    "fteNetworkWifiStateImg":{"Data":"img/network/wifi/wifi-1.png"}     //wifi�ź�ǿ��
                }
            ],
            "SelectedIndex":0,
            "DataSelectedIndex":0,
            "disable": false
        },
        "operateData":{
            "clearPassword": true,
            "autoSearchWifiNetNum":0,
            "autoSearchWifiNetResult":[],
            "wifiSetType":0,
            "wifiSecurityType":[" ","WEP", "WPA", "WPA2", "WEP SHARED", "WPA AES", "WPA2 TKIP","802.1x"],
            "currBeginIdx":0,
            "currIdx":0,
            "currState":0,  //�Ƿ�������
            "currSSIDName":"",
            "currSecType":0,
            "currAuthType":0,
            "currSingnal":100,
            "currPassword":"",
            "connWifiPara":{
                "connState":0,
                "connSSID":"",
                "connAuthType":0,
                "connSecType":0,
                "connPassword":""
            }
        }
    };

    netWifiResult.connectData = {
        "operateData":{
            "wifiConnectTimeOutTimer": 0,
            "connectState": 0, //0:connected, 1:applying setting, 2:connecting, 3:login fail, 4:access point not fond, 5:not connected, 6:general error
            "wifiConnTimer":"",
            "SSID":"",
            "secType":"",
            "authType":"",
            "password":""
        }
    };

    var tiles1 = UI.getItem(netWifiResult, "tiles1");


//})();

    /*-------------------------------------Actions-------------------------------------------*/
//(function(){
    var background = UI.getSubModule("fte_background");
    var network = UI.getSubModule("fte_network");
    var wifiListFrame = UI.getItem(netWifiResult, "wifiListFrame");
    var hintFrame = UI.getItem(netWifiResult, "hintFrame");
    var addWifiBtn = UI.getItem(netWifiResult, "addWifiBtn");
    var tiles1Hint = UI.getItem(netWifiResult, "tiles1Hint");
    var tiles1First = UI.getItem(tiles1, "wifiName0");
    var tiles1Last = UI.getItem(tiles1, "wifiName" + (tiles1.children.length - 1));
    var reloadBtn = UI.getItem(netWifiResult, "reloadBtn");


    netWifiResult.onPush = function () {
        var searchState = tv ? model.network.getEnumAccess_pointsSearch() : 2;
        if (searchState == 2) {
            hintFrame.alpha = 0;
            changeNetworkHelpText(DataWifiConnectFail);
            tiles1Hint.alpha = 0;
//        reloadBtn.children[1].x = -36 + reloadBtn.children[2].x - reloadBtn.children[2].children[0].getBounds().width / 2;
//        skipBtn.children[1].x = -36 + skipBtn.children[2].x - skipBtn.children[2].children[0].getBounds().width / 2;
            wifiListFrame.alpha = 1;
            addWifiBtn.alpha = 0;
            fteNetCreateWifiList();
            elementShow(netWifiResult);
            UI.focusTo(tiles1First);
        } else {
            elementShow(netWifiResult);

            wifiListFrame.alpha = 1;
            hintFrame.alpha = 0;
            tiles1.alpha = 0;
            if (!!tiles1.scroll) {
                UI.removeScrollbar(tiles1);
            }
            netWifiResult.showNoWifiHint();
        }
    }

    netWifiResult.afterPush = function(){
        DBG_ERROR("-------netWifiResult.afterPush");
        networkLoading(0);
    };

    netWifiResult.onShow = function() {
        changeNetworkHelpText(DataWifiConnectFail);
    };

    netWifiResult.onExit = function() {
        if (tv) {
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, fteWifiLinkChangeCallBack);
        }
        clearTimeout(netWifiResult.connectData.operateData.wifiConnectTimeOutTimer);
    };

    netWifiResult.onkey_BACKSPACE = function() {
        popSubModuleUntil("fte_network");
        fteUpdate(-1);
    };

    netWifiResult.showNoWifiHint = function () {
        addWifiBtn.y = 198;
        addWifiBtn.alpha = 1;
        tiles1Hint.alpha = 1;
        UI.updateStage();
        UI.focusTo(addWifiBtn);

        addWifiBtn.onkey_DOWN = function () {
            UI.focusTo(reloadBtn);
        };
        reloadBtn.onkey_UP = function () {
            UI.focusTo(addWifiBtn);
        };

    };

    tiles1.onkey_RIGHT = function(){
        //跳过网络设置
        UI.popSubModule();
        var netStatus = tv? model.network.getEnumNetworkAvailable(): 0;
        if (1 == netStatus) {
            fteUpdate(1);
        }
        else {
            network.skipNetworkSet();
        }
    };

    addWifiBtn.onkey_RIGHT =function(){
        UI.popSubModule();
        network.skipNetworkSet();
    };

    tiles1.onkey_ENTER = function () {
        var data = netWifiResult.pageData;
        DBG_INFO(UI.getCurrFocus().name);
        var wifiListSelected = tiles1.initSequence.indexOf(UI.getCurrFocus());
        DBG_INFO("wifiListSelected is " + wifiListSelected);
        if(wifiListSelected == 0){
            addWifiBtn.onkey_ENTER();
        }else{
            var selectWifiPare = data.operateData.autoSearchWifiNetResult[wifiListSelected];
            if (tv) {
                var currSSID = model.network.getSsid();
                var netAvailableFlag = model.network.getEnumNetworkAvailable();
                if (currSSID == selectWifiPare.wifiName && netAvailableFlag == 1) {
                    data.operateData.clearPassword = false;
                }
                else {
                    data.operateData.clearPassword = true;
                }
            }
            netWifiResult.fteWifiSetPageDataConnPare(selectWifiPare.wifiName, selectWifiPare.wifiSecType, selectWifiPare.wifiAuthType, selectWifiPare.wifiState);
            elementHide(netWifiResult);
            if (selectWifiPare.wifiSecType == 0) {
                DBG_INFO("tiles1.onkey_ENTER: wifi type is open!!");
                netWifiResult.fteSetNetSetWifiConnPara(getfteNetSetWifiPageConnPare());
                netWifiResult.fteNetSetWifiStartConnNetwork();
            }
            else {
                UI.pushSubModule("FTE", "fte_netWifiInput", true);
            }
        }

    };

    addWifiBtn.onkey_ENTER = function () {
        elementHide(netWifiResult);
        UI.pushSubModule("FTE", "fte_netAddWifi", true);
    };
    reloadBtn.onkey_ENTER = function () {
        //ˢ��wifi�б�
        UI.popSubModule();
        network.searchWifi();
    };


    addWifiBtn.onkey_DOWN = function () {
        UI.focusTo(tiles1First);
    };
    reloadBtn.onkey_UP = function () {
        UI.focusTo(tiles1Last);
    };

    addWifiBtn.onkey_LEFT = network.exitNetworkPage;
    reloadBtn.onkey_LEFT = network.exitNetworkPage;
    tiles1.onkey_LEFT = network.exitNetworkPage;


    function fteNetCreateWifiList() {
        try {
            DBG_INFO("netWifiResult create wifi list...");
            var data = netWifiResult.pageData;
            data.operateData.autoSearchWifiNetResult = [];
            var autoSearchWifiNetNum;
            if (!tv) {
                data.operateData.autoSearchWifiNetNum = 20;
                autoSearchWifiNetNum = data.operateData.autoSearchWifiNetNum;
                for (var i = 0; i < autoSearchWifiNetNum && i < 5; i++) {
                    var itemData;
                    if (i == 0){
                         itemData = {
                            "wifiName": "[SE3091]",
                            "wifiConnState": true,
                            "wifiSecType": 1,
                            "wifiState": 30
                        };
                    }else{
                        itemData = {
                            "wifiName": "aaaaaaaaaaaaa",
                            "wifiConnState": true,
                            "wifiSecType": 1,
                            "wifiState": 30
                        };
                    }
                    data.operateData.autoSearchWifiNetResult.push(itemData);
                }
                for(var i = 6;i < autoSearchWifiNetNum;i++){
                    var itemData = {
                        "wifiName":"bbbbbbbbbbbbbbbbbb",
                        "wifiConnState":true,
                        "wifiSecType":0,
                        "wifiState":66
                    };
                    data.operateData.autoSearchWifiNetResult.push(itemData);
                }
                data.operateData.autoSearchWifiNetNum = data.operateData.autoSearchWifiNetResult.length;
                data.operateData.currState = 1;
                data.operateData.currIdx = 6;
                data.operateData.currBeginIdx = 20;

            }else{
                data.operateData.autoSearchWifiNetNum = 0;
                data.operateData.currState = 0;
                data.operateData.currIdx = 0;
                data.operateData.currBeginIdx = 0;
                data.operateData.connWifiPara.connState = 0;
                    netWifiResult.netAvailableFlag = model.network.getEnumNetworkAvailable();
                    var wifiSSIDArray = model.network.getAccess_pointsSsid();
                    var SSIDArray,authArray,signalArray;
                    if(wifiSSIDArray!=null && wifiSSIDArray.length>0){
                        autoSearchWifiNetNum = wifiSSIDArray.length;
                    }
                    DBG_ERROR("fte_netwifiresult:SSIDArray="+JSON.stringify(wifiSSIDArray));
                    if(autoSearchWifiNetNum > 0){
                        var addItemName = ["[SE3091]"];
                        var addItemSecType = [""];
                        var addItemSignal = ["100"];
                        wifiSSIDArray = addItemName.concat(wifiSSIDArray);
                        SSIDArray = wifiSSIDArray;
                        authArray = addItemSecType.concat(model.network.getAccess_pointsEncrypted());
                        signalArray = addItemSignal.concat(model.network.getAccess_pointsSignal());
                        if(netWifiResult.netAvailableFlag == NetWorkConnect.CONNECT){
                            data.operateData.connWifiPara.connSSID = SSIDArray[0];
//                networkConfigPanel.connWifiPara.connAuthType = securityArray[0];
                            data.operateData.connWifiPara.connAuthType = authArray[0];
                            data.operateData.connWifiPara.connSecType =  authArray[0];
                            data.operateData.connWifiPara.connPassword = model.network.getEncryptionPassphrase();
                        }
                        for(var i = 0; i < autoSearchWifiNetNum; i++){
                            if(SSIDArray[i].length > 0){
                                var itemData = {
                                    "wifiName":"",
                                    "wifiSecType":1,
                                    "wifiAuthType":0,
                                    "wifiSignal":1
                                }
                                itemData.wifiName = SSIDArray[i];
//                    itemData.wifiSecType = securityArray[i];
                                itemData.wifiSecType = authArray[i];
                                itemData.wifiAuthType = authArray[i];
                                itemData.wifiSignal = signalArray[i];
                                DBG_ERROR("fte_netwifiresult:"+itemData.wifiName+","+itemData.wifiSecType+","+itemData.wifiAuthType+","+itemData.wifiSignal);
                                if(netWifiResult.netAvailableFlag == NetWorkConnect.CONNECT && data.operateData.connWifiPara.connSSID == itemData.wifiName){
                                    data.operateData.autoSearchWifiNetResult.unshift(itemData);
                                }else{
//                                    networkConfigPanel.WifiList.push(itemData);
                                    data.operateData.autoSearchWifiNetResult.push(itemData);
                                }
                            }else{
                                DBG_ERROR("settingInitNetSetWifiSetPage:search num is 0");

                            }
                        }
                        data.operateData.autoSearchWifiNetNum = data.operateData.autoSearchWifiNetResult.length;
                        DBG_INFO("netWifiResult: data.operateData.autoSearchWifiNetNum = " + data.operateData.autoSearchWifiNetNum);
            }
            }


            if (data.operateData.autoSearchWifiNetNum == 0) {
                netWifiResult.showNoWifiHint();
            }

        }catch (ex){
            DBG_ERROR("fteNetCreateWifiList: "+ex.message);
        }
        fteRewriteWifiSetPage();

    }

    function fteRewriteWifiSetPage(){
        var data = netWifiResult.pageData;
        try{
            var WifiAutoResultUl = data.fteNetworkWifiAutoResultUl;
            if(data.operateData.autoSearchWifiNetNum == 0){
                DBG_INFO("netWifiResult: wifi num is 0!!");
                WifiAutoResultUl.Data = [];
                WifiAutoResultUl.disable = true;
            }else{
                WifiAutoResultUl.disable = false;
                try{
                    if(WifiAutoResultUl.Data.length > data.operateData.autoSearchWifiNetNum){
                        WifiAutoResultUl.Data.splice(data.operateData.autoSearchWifiNetNum);
                    }else if(WifiAutoResultUl.Data.length < data.operateData.autoSearchWifiNetNum){
                        while(WifiAutoResultUl.Data.length < data.operateData.autoSearchWifiNetNum){
                            var itemData ={
                                "fteNetworkWifiName":{"Data":""},
                                "fteNetworkWifiConnState":{"Data":""},
                                "fteNetworkWifiSecType":{"Data":""},
                                "fteNetworkWifiStateImg":{"Data":""},
                                "fteNetworkWifiSecImg":{"Data":""}
                            };
                            WifiAutoResultUl.Data.push(itemData);
                        }
                    }
                }catch (ex){
                    DBG_ERROR("FTE netWifiResult: " + ex.message);
                }

                $.each(data.operateData.autoSearchWifiNetResult, function(idx, item){
                    try{
                        itemData = WifiAutoResultUl.Data[idx];
                        itemData.fteNetworkWifiName.Data = item.wifiName;
                    }catch (ex){
                        DBG_ERROR("netWifiResult: " + ex.message);
                    }

                    itemData.fteNetworkWifiConnState.Data = "";
                    itemData.fteNetworkWifiSecType.Data = data.operateData.wifiSecurityType[item.wifiSecType];
                    itemData.fteNetworkWifiSecImg.Data = item.wifiSecType == 0 ? "FTE/fte_blank.png":"FTE/fte_wireless_security.png";
                    if(item.wifiSignal <= 25){
                        itemData.fteNetworkWifiStateImg.Data ="FTE/fte_wireless_signal_1_small.png";
                    }else if(item.wifiSignal > 25 && item.wifiSignal <= 50){
                        itemData.fteNetworkWifiStateImg.Data ="FTE/fte_wireless_signal_2_small.png";
                    }else if(item.wifiSignal > 50 && item.wifiSignal <= 75){
                        itemData.fteNetworkWifiStateImg.Data ="FTE/fte_wireless_signal_3_small.png";
                    }else{
                        itemData.fteNetworkWifiStateImg.Data ="FTE/fte_wireless_signal_4_small.png";
                    }
                });


//                WifiAutoResultUl.SelectedIndex = data.operateData.currIdx;
                WifiAutoResultUl.DataSelectedIndex = data.operateData.currIdx;

                //�����ݣ�ˢ���б�
                var network = UI.getSubModule("fte_network");

                var tiles1 = UI.getItem(netWifiResult, "tiles1");
                while (tiles1.children.length != 0) {
                    tiles1.children.pop();
                }
                var array = [];
                for (var i=0; i < WifiAutoResultUl.Data.length; i++) {
                    array.push({});
                    array[i].name = "wifiName" + i;
                    array[i].bgImg = UI.item_bg;
                    array[i].wifiName = WifiAutoResultUl.Data[i].fteNetworkWifiName.Data;
                    array[i].type = WifiAutoResultUl.Data[i].fteNetworkWifiSecImg.Data;
                    array[i].signal = WifiAutoResultUl.Data[i].fteNetworkWifiStateImg.Data;
                }
                var info = {
                    template: "fte_wifiResult_item",
                    direction: CONST.GIRD_DIRECTION.H,
                    breakNum: 1,
                    distanceX: 0,
                    distanceY: 6,
                    container: tiles1
                };

                if (tiles1.y != 150.5) {
                    tiles1.y = 888;
                }
                Gird.create(array, info);
                UI.addMask(tiles1, 1152, 810, 80, 3);
                UI.setView(tiles1, 1152, 810, 0, 0);
                if (!tiles1.scroll) {
                    UI.addScrollbar(tiles1, -3);
                }

                var tiles1First = UI.getItem(tiles1, "wifiName0");
                tiles1First.children[1].alpha = 0;
                tiles1First.children[3].alpha = 0;
                var tiles1Last = UI.getItem(tiles1, "wifiName" + (tiles1.children.length - 1));
                var addWifiBtn = UI.getItem(netWifiResult, "addWifiBtn");
                var reloadBtn = UI.getItem(netWifiResult, "reloadBtn");
                var skipBtn = UI.getItem(netWifiResult, "skipBtn");
                reloadBtn.onkey_UP = function () {
                    UI.focusTo(tiles1Last);
                };
                netWifiResult.currFocus = UI.getItem(netWifiResult, "wifiName0");
                DBG_INFO("netWifiResult.currFocus-----------focus OK!!!");


                fteNetWifiResultGetInfo();
            }
        }catch (ex){
            DBG_ERROR("fteRewriteWifiSetPage: " + ex.message);
        }

    }

    function fteNetWifiResultGetInfo()
    {
        DBG_INFO("fteNetWifiResultGetInfo!!");
        try{
            var data = netWifiResult.pageData;

            if(tv == true){
                var networkAvailable = model.network.getEnumNetworkAvailable();
                var currWifiState = model.network.getEnumLink();
                DBG_INFO("fteNetWifiResultGetInfo: currWifiState= "+currWifiState + ", networkAvailable = " + networkAvailable);
                if(networkAvailable == 1){
                    var connSSID = model.network.getSsid();
                    var connSecType = model.network.getEnumEncryption();
                    var connAuthType = model.network.getEnumEncryption();
                    var connPassword = model.network.getEncryptionPassphrase();
                    DBG_INFO("fteNetWifiResultGetInfo: "+connSSID+", "+connSecType+", "+connAuthType+", "+connPassword);
                    data.operateData.currState = 1;
                    data.operateData.connWifiPara.connState = 1;
                    data.operateData.connWifiPara.connSSID = connSSID;
                    data.operateData.connWifiPara.connAuthType = connAuthType;
                    data.operateData.connWifiPara.connSecType = connSecType;
                    data.operateData.connWifiPara.connPassword = connPassword;
                    for(var i = 0; i < data.operateData.autoSearchWifiNetNum;i++){
                        if(connSSID == data.operateData.autoSearchWifiNetResult[i].wifiName){
                            DBG_INFO("fteNetWifiResultGetInfo: currIdx = "+i);
                            data.operateData.currIdx = i;
                            break;
                        }
                    }

                    if (data.operateData.currState == 1) {
                        DBG_INFO("netWifiResult: data.operateData.currState == 1");
                        UI.setImage( tiles1.children[data.operateData.currIdx].children[3],"FTE/fte_checkmark.png");
//                        tiles1.children[data.operateData.currIdx].children[1].alpha = 1;
                        UI.updateStage();
                    }
                }else{
                    DBG_INFO("netWifiResult: no connect");
                    //model.network.onEnumLinkChaged = fteNetSetWifiLinkChangeCallBack;   //wifi����״̬�ı�ص�
                }
            }

            /*var selectWifiPare = data.operateData.autoSearchWifiNetResult[data.operateData.currIdx];
             fteWifiSetPageDataConnPare(selectWifiPare.wifiName,selectWifiPare.wifiSecType,selectWifiPare.wifiAuthType,selectWifiPare.wifiState);*/

        }catch (ex){
            DBG_ERROR("fteNetWifiResultGetInfo: " + ex.message);
        }
    }

    function fteNetSetWifiLinkChangeCallBack(state) {
        DBG_INFO("fteNetSetWifiLinkChangeCallBack: state = " + state);
        if(state == 0) {
            var data = netWifiResult.pageData;
            var connSSID = model.network.getSsid();
            var connSecType = model.network.getEnumEncryption();
            var connAuthType = model.network.getEnumEncryption();
            var connPassword = model.network.getEncryptionPassphrase();
            DBG_INFO("fteNetSetWifiLinkChangeCallBack: "+connSSID+", "+connSecType+", "+connAuthType+", "+connPassword);
            data.operateData.connWifiPara.connState = 1;
            data.operateData.connWifiPara.connSSID = connSSID;
            data.operateData.connWifiPara.connAuthType = connAuthType;
            data.operateData.connWifiPara.connSecType = connSecType;
            data.operateData.connWifiPara.connPassword = connPassword;
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, fteWifiLinkChangeCallBack);
        }
    }

    function getfteNetSetWifiPageConnPare(){
        try{
            var data = netWifiResult.pageData;
            var wifiConnPare ={
                "SSID":"",
                "secType":0,
                "authType":0,
                "password":""
            };
            wifiConnPare.SSID = data.operateData.currSSIDName;
            wifiConnPare.secType = data.operateData.currSecType;
            wifiConnPare.authType = data.operateData.currAuthType;
            /*if(data.operateData.currState == 1 && data.operateData.connWifiPara.connSSID == data.operateData.currSSIDName){

                if((data.operateData.connWifiPara.connPassword == "") && (model.network.getEnumNetworkAvailable() == 1))
                {
                    data.operateData.connWifiPara.connPassword = model.network.getEncryptionPassphrase();


                }
                wifiConnPare.password = data.operateData.connWifiPara.connPassword;
            }else{
                wifiConnPare.password = "";
            }*/
            wifiConnPare.password = data.operateData.connWifiPara.connPassword;
            DBG_INFO("[zhangnaiyun] wifiConnPare.SSID is " + wifiConnPare.SSID);
            DBG_INFO("[zhangnaiyun] wifiConnPare.secType is " + wifiConnPare.secType);
            DBG_INFO("[zhangnaiyun] wifiConnPare.authType is " + wifiConnPare.authType);
            DBG_INFO("[zhangnaiyun] wifiConnPare.password is " + wifiConnPare.password);

            return wifiConnPare;

        }catch (ex){
            DBG_INFO("getSettingNetSetWifiPageConnPare:"+ex.message);
        }
    }

    //����pageData
    netWifiResult.fteWifiSetPageDataConnPare = function(SSID, secType, authType, signal) {
        DBG_INFO("fteWifiSetPageDataConnPare:"+SSID+","+secType+","+authType);
        var data = netWifiResult.pageData;
        data.operateData.currSSIDName = SSID;
        data.operateData.currSecType = secType;
        data.operateData.currAuthType = authType;
        data.operateData.currSingnal = signal;
    };

    //����connectData
    netWifiResult.fteSetNetSetWifiConnPara = function(wifiConnPara) {
        try{
            DBG_INFO("netWifiResult.fteSetNetSetWifiConnPara: \nwifiConnPara.SSID: "+wifiConnPara.SSID+",\nwifiConnPara.secType: "+wifiConnPara.secType+",\nwifiConnPara.authType: "+ wifiConnPara.authType+",\nwifiConnPara.password: "+wifiConnPara.password);
            var data = netWifiResult.connectData;
            data.operateData.SSID = wifiConnPara.SSID;
            data.operateData.secType = wifiConnPara.secType;
            data.operateData.password = wifiConnPara.password;
            data.operateData.authType = wifiConnPara.authType;
        }catch (ex){
            DBG_INFO("netWifiResult.fteSetNetSetWifiConnPara: " + ex.message);
        }

    };

    netWifiResult.showWifiBtnNoConnectPage = function() {
        popSubModuleUntil("fte_netWifiResult");
        var wifiBtnNoConnect1 = UI.getItem(netWifiResult, "wifiBtnNoConnect1");
        var wifiBtnNoConnect2 = UI.getItem(netWifiResult, "wifiBtnNoConnect2");
        var wifiBtnNoConnect3 = UI.getItem(netWifiResult, "wifiBtnNoConnect3");
        DBG_INFO("[wifi connect] fail");
        wifiListFrame.alpha = 0;
        netWifiResult.alpha = 1;
        hintFrame.alpha = 1;
        UI.focusTo(wifiBtnNoConnect1);
        changeNetworkHelpText(DataWifiConnectFail);

        wifiBtnNoConnect1.onkey_LEFT = network.exitNetworkPage;
        wifiBtnNoConnect1.onkey_BACKSPACE = function() {
            hintFrame.alpha = 0;
            wifiListFrame.alpha = 1;
            UI.updateStage();
            var tiles1First = UI.getItem(tiles1, "wifiName0");
            UI.focusTo(tiles1First);
        };
        wifiBtnNoConnect2.onkey_BACKSPACE = wifiBtnNoConnect1.onkey_BACKSPACE;
        wifiBtnNoConnect3.onkey_BACKSPACE = wifiBtnNoConnect1.onkey_BACKSPACE;

        wifiBtnNoConnect1.onkey_ENTER = function () {
            //ip set
            hintFrame.alpha = 0;
            network.netType = NetWorkType.WIRELESS;
            network.ipWifiPageMode = 0;
            UI.pushSubModule("FTE", "fte_netIpSet", true);
        };
        wifiBtnNoConnect2.onkey_ENTER = function () {
            popSubModuleUntil("fte_network");
            network.searchEthernet();
        };
        wifiBtnNoConnect3.onkey_ENTER = function () {
            hintFrame.alpha = 0;
            netWifiResult.fteNetSetWifiStartConnNetwork();
//            UI.popSubModule();
//            network.skipNetworkSet();
        };
    };

    netWifiResult.fteNetSetWifiStartConnNetwork = function(netType) {
        FTE.networkStartLoading("netWifiInput", 15000);
        DBG_INFO("netWifiResult.fteNetSetWifiStartConnNetwork!!!!!!!!");
        try{
            if (netType == undefined) {
                netType = 0;
            }
            var data = netWifiResult.connectData;
            var connState = 0;
            if(tv == false){
                data.operateData.connectState = 2;
                data.operateData.wifiConnectTimeOutTimer = setTimeout(wifiConnectTimeOut, 1000);
                fteWifiLinkChangeCallBack(data.operateData.connectState);
            }else{
                /*model.network.setEnumIp_config(0);
                model.network.setSsid(data.operateData.SSID);
                model.network.setEnumEncryption(parseInt(data.operateData.secType));
                model.network.setEncryptionPassphrase(data.operateData.password);
                model.network.setEnumAuthentication(parseInt(data.operateData.authType));*/

                data.operateData.wifiConnectTimeOutTimer = setTimeout(wifiConnectTimeOut, 15000);
//                model.network.setEnumIp_config(0);
                model.network.setSsid(data.operateData.SSID);
                model.network.setEnumEncryption(parseInt(data.operateData.authType));
                model.network.setEncryptionPassphrase(data.operateData.password);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, fteWifiLinkChangeCallBack);
                model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                model.network.WirelessSet();
//                model.network.WirelessSet(netType, data.operateData.SSID, data.operateData.password, parseInt(data.operateData.secType), parseInt(data.operateData.authType));
            }
        }catch (ex){
            DBG_INFO("fteNetSetWifiStartConnNetwork:"+ex.message);
        }
    };

    function wifiConnectTimeOut() {
        try{
            if(tv){
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, fteWifiLinkChangeCallBack);
                model.network.WirelessCancel();
            }
            DBG_INFO("wifiConnectTimeOut: time out!!!");
            FTE.networkEndLoading();
            netWifiResult.showWifiBtnNoConnectPage();
        }catch(ex){
            DBG_ERROR(ex.message);
        }
    }

    function fteWifiLinkChangeCallBack(LinkState){
        DBG_INFO("fteWifiLinkChangeCallBack: LinkState = " + LinkState);
        switch (LinkState){
            case 1://applying setting
            case 2://connecting
                DBG_INFO("fteWifiLinkChangeCallBack: Wifi connecting...");
                break;
            case 10: //success
                if (tv) {
                    UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, fteWifiLinkChangeCallBack);
                    var networkAvailable = model.network.getEnumNetworkAvailable();
                    DBG_INFO("fteWifiLinkChangeCallBack: networkAailable = " + networkAvailable);
                }
                clearTimeout(netWifiResult.connectData.operateData.wifiConnectTimeOutTimer);

                FTE.networkEndLoading();
                popSubModuleUntil("fte_network");
                //��ʾ�ɹ���Ϣ
                network.showWifiBtnSuccessPage();
                DBG_INFO("fteWifiLinkChangeCallBack: Wifi successfully!!!");
                break;
            case 3://password error

                clearTimeout(netWifiResult.connectData.operateData.wifiConnectTimeOutTimer);
                if (tv) {
                    UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, fteWifiLinkChangeCallBack);
                }
                if (tv) {
                    model.network.WirelessCancel();
                }
                FTE.networkEndLoading();
                popSubModuleUntil("fte_netWifiResult");
                UI.pushSubModule("FTE","fte_netPasswordError",true);
                break;
            default :
                break;
        }

    }

};
