UI.moduleBuilder['FTE']['fte_language2'] = function(){
    //加载配置信息
    var languageData = {
        buttonText1: "[SE0190]",//Language
        buttonText2: "[SE0103]",//Region
        buttonText3: "[SE0646]"//Time Zone
    };
    var template = Util.readJson("module/FTE/fte_language2.json");
    var language = SubModule.create(languageData, template);

    language.pageData = {
        "currLanguageIndex": 0,
        "currCountryNum":97,
        "currLocationIndex": 0,
        "currTimeZoneIndex": 0
    };

    var tiles1 = UI.getItem(language, "tiles1");
    var tiles2 = UI.getItem(language, "tiles2");
    var tiles3 = UI.getItem(language, "tiles3");

    language.langMapList = GetSysOSDLanguageMapList(GLOBAL.CURRENT_AREA, GLOBAL.CURRENT_SUB_AREA);
    if(GLOBAL.UI_BRAND == "tos"){
        language.countryMapList = [{
            "number": 82,
            "name": "[SE0644]",//"Mexico",
            "code": "MEX"
        }]
    }else{
        language.countryMapList = GetSysCountryList(GLOBAL.CURRENT_AREA, GLOBAL.CURRENT_SUB_AREA);

    }
    language.countryToTimeZoneMapList = getSysCountryZoneList(GLOBAL.CURRENT_AREA, GLOBAL.CURRENT_SUB_AREA);


    //创建语言列表
    var arrayLanguage = [];
    for (var i = 0; i < language.langMapList.length; i++) {
        arrayLanguage.push({});
        arrayLanguage[i].name = language.langMapList[i].code;//eng
        arrayLanguage[i].bgImg = UI.item_bg;
        arrayLanguage[i].selectImg = "FTE/fte_checkmark.png";
        arrayLanguage[i].text = language.langMapList[i].name;//English
    }
    var info = {
        template: "fte_language2_ul_item",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 1,
        distanceX: 0,
        distanceY: 6,
        container: tiles1
    };
    Gird.create(arrayLanguage, info);
    UI.addMask(tiles1, 544, 808, 50, 3);
    UI.setView(tiles1, 544, 808);
    UI.addScrollbar(tiles1);

    //创建国家列表
    var arrayLocation = [];
    for (var i = 0; i < language.countryMapList.length; i++) {
        arrayLocation.push({});
        arrayLocation[i].name = language.countryMapList[i].code;//USA
        arrayLocation[i].bgImg = UI.item_bg;
        arrayLocation[i].selectImg = "FTE/fte_checkmark.png";
        arrayLocation[i].text = language.countryMapList[i].name;//USA
    }
    info.container = tiles2;
    Gird.create(arrayLocation, info);
    UI.addMask(tiles2, 544, 808, 50, 3);
    UI.setView(tiles2, 544, 808);
    UI.addScrollbar(tiles2, -10);
    function getTimezoneIndexByCountry(){
        var countryIndex = _getIndexByNum(language.countryMapList, language.pageData.currCountryNum);
        if(countryIndex == -1){
            countryIndex = 0;
        }
        var index = _getIndexByCode(language.countryToTimeZoneMapList, language.countryMapList[countryIndex].code);
        if(index == -1){
            index = 0;
        }
        return index;
    }

    function initLanguage() {
        var languageNumber = tv ? model.language.getOsd() : 1;
        var languageIndex = _getIndexByNum(language.langMapList, languageNumber);
        if (languageIndex == -1) {
            model.language.setOsd(language.langMapList[0].number);
            writeFileToNative('hisenseUI/hasSetLanguage.txt', "hasSetLanguage", 1);
            languageIndex = 0;
            DBG_ERROR("get languageIndex error, reset languageNumber to " + language.langMapList[0].number);
        }
        DBG_ERROR("current languageNumber is " + languageNumber + ", language code is " + language.langMapList[languageIndex].code);
        if(tv){
            model.language.setOsd(languageNumber);
            writeFileToNative('hisenseUI/hasSetLanguage.txt', "hasSetLanguage", 1);
        }
        var ttsCode = language.langMapList[languageIndex].code;
        if (ttsCode != "eng" && ttsCode != "spa") {
            ttsCode = "eng";
        }
        DBG_ERROR("gww 3");
        setTTsLanguage(ttsCode);
        DBG_ERROR("gww 4");
        language.pageData.currLanguageIndex = languageIndex;
        tiles1.DataSelected = tiles1.initSequence[languageIndex];
        fteDefaultSelect(tiles1);
    }

    function initCountry() {
        language.pageData.currCountryNum = tv ? model.basicSetting.getTvsetLocation() : 8;
        DBG_ERROR("fte_language2: language.pageData.currCountryNum is " + language.pageData.currCountryNum);
        var countryIndex = _getIndexByNum(language.countryMapList, language.pageData.currCountryNum);
        if (countryIndex == -1) {
            countryIndex = 0;
            language.pageData.currCountryNum = language.countryMapList[countryIndex].number;
            model.basicSetting.setTvsetLocation(language.pageData.currCountryNum);
            DBG_ERROR("get countryIndex error, reset countryCode to " + language.countryMapList[0].number);
        }
        if(tv){
            model.basicSetting.setTvsetLocation(language.pageData.currCountryNum);
        }
        language.pageData.currLocationIndex = countryIndex;
        tiles2.DataSelected = tiles2.initSequence[countryIndex];
        fteDefaultSelect(tiles2);
    }

    var background = UI.getSubModule("fte_background");
    var group1 = UI.getItem(language, "group1");
    var group2 = UI.getItem(language, "group2");
    var group3 = UI.getItem(language, "group3");

    language.onPush = function() {
        if (FTE.langPageInitDone == false) {
            initLanguage();
            initCountry();
            fteRefreshTimeZoneList();
            language.currFocus = tiles1.DataSelected;
            FTE.langPageInitDone = true;
        }
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_LANGUAGE_CHANGED, onLanguageChanged);//取消订阅
    };
    language.onPop = function() {
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_LANGUAGE_CHANGED, onLanguageChanged);
    };

    language.onShow = function () {
        background.open();
        hideNavbarOrNot(0);
    };

    language.afterPush = function(){
        UI.focusTo(tiles1.DataSelected);
        UI.getTween(UI).wait(10000);
    };

    tiles1.onkey_ENTER = function() {
        fteGirdSelect(tiles1, function() {
            //设置语言
        });

        var selectedIndex = tiles1.initSequence.indexOf(UI.getCurrFocus());
        var number = language.langMapList[selectedIndex].number;
        DBG_INFO("FTE set language " + language.langMapList[selectedIndex].code);
        language.pageData.currLanguageIndex = selectedIndex;
        try {
            if (tv) {
                model.language.setOsd(number);
                writeFileToNative('hisenseUI/hasSetLanguage.txt', "hasSetLanguage", 1);
                DBG_INFO("model.language.setOsd(" + number + ")");
            }
        } catch (e) {
            DBG_ERROR("fte_language tiles1.onkey_ENTER: " + e.message);
        }
        UI.lockAllKeys();
        var type = language.langMapList[selectedIndex].code + (GLOBAL.UI_BRAND == "shp"? "_shp" : "");
        $LAB.setOptions({AllowDuplicates:true})
            .script("language/language_" + type +".js")
            .wait(function(){
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.LANGUAGE_CHANGUAGE_COMPLETE, true);
                if(language.langMapList[selectedIndex].code=="ara"||language.langMapList[selectedIndex].code=="per"||language.langMapList[selectedIndex].code=="hbr") {
                    UI.switchRTL(true);
                } else {
                    UI.switchRTL(false);
                }
                UI.setupLanguage(UI.getCurrModule());
                UI.refreshRTL(UI.getCurrModule());
                UI.setupLanguage(UI.base);
                UI.refreshRTL(UI.base);
                UI.updateStage();
                UI.focusTo(tiles2.DataSelected);

                var ttsCode = language.langMapList[selectedIndex].code;
                if (ttsCode != "eng" && ttsCode != "spa") {
                    ttsCode = "eng";
                }
                setTTsLanguage(ttsCode);
                UI.unlockAllKeys();

            });
    };

    tiles2.onkey_ENTER = function() {
        fteGirdSelect(tiles2, function() {
            //设置国家
        });
        var selectedIndex = tiles2.initSequence.indexOf(UI.getCurrFocus());
        language.pageData.currCountryNum = language.countryMapList[selectedIndex].number;
        DBG_INFO("FTE set country " + language.pageData.currCountryNum);
        language.pageData.currLocationIndex = selectedIndex;
        try {
            if (tv) {
                model.basicSetting.setTvsetLocation(language.pageData.currCountryNum);
                DBG_INFO("model.basicSetting.setTvsetLocation(" + language.pageData.currCountryNum + ")");
            }
        }
        catch (e) {
            DBG_ERROR("fte_language tiles2.onkey_ENTER: " + e.message);
        }

        fteRefreshTimeZoneList();
        UI.focusTo(tiles3.DataSelected);
    };
    tiles3.onkey_ENTER = function () {
        fteGirdSelect(tiles3, function () {
            //设置时区
        });
        var zoneCodeList = language.countryToTimeZoneMapList[getTimezoneIndexByCountry()].zoneCodeList;
        var selectedIndex = tiles3.initSequence.indexOf(UI.getCurrFocus());
        language.pageData.currTimeZoneIndex = selectedIndex;
        try {
            if (tv) {
                model.datetime.setTimeZone(zoneCodeList[selectedIndex]);
                DBG_INFO("model.datetime.setTimeZone(" + zoneCodeList[selectedIndex] + ")");
            }
        } catch (ex) {
            DBG_ERROR("fte_language2 tiles3.onkey_ENTER: " + ex.message);
        }

        UI.inactiveKey();
        setTimeout(function () {
            fteUpdate(1);
            UI.activeKey();
        }, 200);
    };

    tiles1.onkey_RIGHT = function () {
        UI.focusTo(tiles2.DataSelected);
    };
    tiles2.onkey_LEFT = function () {
        UI.focusTo(tiles1.DataSelected);
    };
    tiles2.onkey_RIGHT = function () {
        UI.focusTo(tiles3.DataSelected);
    };
    tiles3.onkey_LEFT = function () {
        UI.focusTo(tiles2.DataSelected);
    };
    tiles3.onkey_RIGHT = function () {
        fteUpdate(1);
    };

    function fteRefreshTimeZoneList() {
        while (tiles3.children.length > 0) {
            tiles3.children.pop();
        }
        var info = {
            template: "fte_language2_ul_item",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 1,
            distanceX: 0,
            distanceY: 6,
            container: tiles3
        };
        //创建时区列表
        var arrayTimeZone = [];
        var zoneIndex = getTimezoneIndexByCountry();
        for (var i=0; i < language.countryToTimeZoneMapList[zoneIndex].osdList.length; i++) {
            arrayTimeZone.push({});
            arrayTimeZone[i].name = language.countryToTimeZoneMapList[zoneIndex].zoneCodeList[i];
            arrayTimeZone[i].bgImg = UI.item_bg;
            arrayTimeZone[i].selectImg = "FTE/fte_checkmark.png";
            arrayTimeZone[i].text = language.countryToTimeZoneMapList[zoneIndex].osdList[i];
        }
        info.container = tiles3;
        Gird.create(arrayTimeZone, info);
        UI.addMask(tiles3, 544, 808, 50, 3);
        UI.setView(tiles3, 544, 808, 0, 0);
        if(!tiles3.scroll){
            UI.addScrollbar(tiles3, -10);
        }
        if(tiles3.children.length <= 8){
            tiles3.scroll.alpha = 0;
        }else{
            tiles3.scroll.alpha = 1;
        }
        UI.updateStage();
        //重设默认时区
//        var zoneIndex = getTimezoneIndexByCountry();
        var zoneNumber = tv ? model.datetime.getTimeZone(): 0/*language.countryToTimeZoneMapList[zoneIndex].zoneCodeList[0]*/;
        DBG_ERROR("zoneNumber is " + zoneNumber);
        for(i = 0; i < language.countryToTimeZoneMapList[zoneIndex].zoneCodeList.length; i++){
            if( zoneNumber == language.countryToTimeZoneMapList[zoneIndex].zoneCodeList[i]){
                language.pageData.currTimeZoneIndex = i;
                break;
            }
        }
        if(i > language.countryToTimeZoneMapList[zoneIndex].zoneCodeList.length -1 ){
            model.datetime.setTimeZone(language.countryToTimeZoneMapList[zoneIndex].zoneCodeList[language.countryToTimeZoneMapList[zoneIndex].defzone]);
            language.pageData.currTimeZoneIndex = language.countryToTimeZoneMapList[zoneIndex].defzone;
            DBG_ERROR("get currTimeZoneIndex error, reset  " );
        }
        DBG_INFO("current zoneNumber is " + zoneNumber + ", zoneIndex is " + zoneIndex + "language.pageData.currTimeZoneIndex is " + language.pageData.currTimeZoneIndex);
        tiles3.DataSelected = tiles3.initSequence[language.pageData.currTimeZoneIndex];
        fteDefaultSelect(tiles3);
    }
};

