function TvserviceModelDefines() {
}
{
    TvserviceModelDefines.TVAPI_VSTR_TVSERVICE_PLAY_MAIN = "de.loewe.sl2.vstr.tvservice.play.main";
    TvserviceModelDefines.TVAPI_VSTR_TVSERVICE_PLAY_MAIN_AIR = "de.loewe.sl2.vstr.tvservice.play.main.air";
    TvserviceModelDefines.TVAPI_VSTR_TVSERVICE_PLAY_MAIN_CABLE = "de.loewe.sl2.vstr.tvservice.play.main.cable";
    TvserviceModelDefines.TVAPI_ACTION_TVSERVICE_PLAY = "de.loewe.sl2.action.tvservice.play";
    TvserviceModelDefines.TVAPI_ACTION_TVSERVICE_STOP = "de.loewe.sl2.action.tvservice.stop";
    TvserviceModelDefines.TVAPI_I32_TVSERVICE_NO_SIGNAL_MAIN = "de.loewe.sl2.i32.tvservice.nosignal.main";
    TvserviceModelDefines.TVAPI_VSTR_TVSERVICE_UNLOCK_PLAY = "tvapi.action.tvservice.unlock.play";
    TvserviceModelDefines.SL2_TVAPI_STR_TVSERVICE_VIDEO_FORMAT_INFO = "tvapi.str.tvservice.video.format.info";

    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_EIT_MAIN_NOW = "de.loewe.sl2.vstr.tvservice.eit.main-now";
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_EIT_MAIN_NEXT = "de.loewe.sl2.vstr.tvservice.eit.main-next";

    TvserviceModelDefines.SL2_TVAPI_STR_TVSERVICE_SOURCE_VIDEO_FORMAT_INFO = "tvapi.str.tvservice.source.video.format.info";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_PLAYED_SUCCESS_LIVETV = "de.loewe.sl2.i32.tvservice.played.success.livetv";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_PLAY_FAV_CHANNEL_LIST = "tvapi.i32.tvservice.play.fav.channel.list";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_LIST_UPDATE = "de.loewe.sl2.i32.tvservice.list.update";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_LIST_NAME_UPDATE = "tvapi.i32.tvservice.list.name.update";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_LIST_SAVED = "tvapi.i32.tvservice.list.saved";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_LOCK_STATUS = "tvapi.i32.tvservice.lock.status";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_TUNER_SIGNAL_RFLEVEL = "de.loewe.sl2.vint.tunerinfo.signal.rflevel";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_TUNER_SIGNAL_CN = "de.loewe.sl2.vint.tunerinfo.signal.cn";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_PLAY_MAIN_PAUSE = "de.loewe.sl2.tvservice.play.main.pause";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_URI_MAIN = "de.loewe.sl2.tvservice.uri.main";

    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_UUID_FOLDER   = 0;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_UUID_SERVICE  = 1;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_FIELD_NO      = 2;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_ITEM_TYPE     = 3;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_ITEM_SUB_TYPE = 4;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_SERVICE_NAME  = 5;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_ACTIVE        = 6;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_LOCATOR       = 7;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_ATTRIBUTES    = 8;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_SILENT        = 9;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_APPLICATION   = 10;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_SVC_FLAGS     = 11;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_REMOTE_TV_UUID = 12;
    TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_PLAY_SIZE           = 13;


    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_WINDOW            = 0;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_TYPE              = 1;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_START_TIME_UTC    = 2;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_STOP_TIME_UTC     = 3;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_TITLE             = 4;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_SHORT_DESCRIPTION = 5;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_LONG_DESCRIPTION  = 6;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_FEATURE_FLAGS     = 7;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_PARENTAL_RATING   = 8;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_EVENT_ID          = 9;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_EPG_THEMES        = 10;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_LINKAGE           = 11;
    TvserviceModelDefines.ENUM_TVSERVICE_EIT_FIELD_SIZE              = 12;


    TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_ID  =  0;
    TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_NAME  =  1;
    TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_ISO639  =  2;
    TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_TYPE  =  3;
    TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_PURPOSE  =  4;
    TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_TRACK  =  5;

    TvserviceModelDefines.SL2_TVAPI_TVSERVICE_AUDIO_TABLE= "de.loewe.sl2.tvservice.audio.table";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_AUDIO_INDEX= "de.loewe.sl2.i32.tvservice.audio.index";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_AUDIO_LAST_INDEX= "de.loewe.sl2.i32.tvservice.audio.last.index";
    TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_AUDIO_EXIST = "de.loewe.sl2.i32.tvservice.audio.exist";


    TvserviceModelDefines.SL2_TVAPI_VINT_TUNERINFO_SIGNAL_PERCENTAGE  = 0;
    TvserviceModelDefines.SL2_TVAPI_VINT_TUNERINFO_SIGNAL_POOR_VALUE  = 1;
    TvserviceModelDefines.SL2_TVAPI_VINT_TUNERINFO_SIGNAL_FAIR_VALUE  = 2
}
function TvserviceModel(e) {
    SubModel.call(this, e, TvserviceModelDefines);
        this.registerStringVectorObject(TvserviceModelDefines.TVAPI_VSTR_TVSERVICE_PLAY_MAIN, "getMainPlay", null, "onMainPlayChanged", null, null);
        this.registerStringVectorObject(TvserviceModelDefines.TVAPI_VSTR_TVSERVICE_PLAY_MAIN_AIR, "getMainPlayAir", null, "onMainPlayAirChanged", null, null);
        this.registerStringVectorObject(TvserviceModelDefines.TVAPI_VSTR_TVSERVICE_PLAY_MAIN_CABLE, "getMainPlayCable", null, "onMainPlayCableChanged", null, null);
        this.registerIntegerObject(TvserviceModelDefines.TVAPI_I32_TVSERVICE_NO_SIGNAL_MAIN, "getNoSignalMain", "setNoSignalMain", "onNoSignalMainChanged", null, null);
        this.registerIntegerObject(TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_PLAY_FAV_CHANNEL_LIST, "getPlayFavChannelList", "setPlayFavChannelList", "onPlayFavChannelListChanged", null, null);
        this.registerIntegerObject(TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_PLAYED_SUCCESS_LIVETV, "getPlaySuccessLiveTV", "setPlaySuccessLiveTV", "onPlaySuccessLiveTVChanged", null, null);
        this.registerIntegerObject(TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_LOCK_STATUS, "getLockStatus", "setLockStatus", "onLockStatusChanged", null, null);
        this.registerIntegerObject(TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_LIST_SAVED, "getChannelListSaved", "setChannelListSaved", "onChannelListSavedChanged", null, null)


        this.registerActionObject(TvserviceModelDefines.TVAPI_ACTION_TVSERVICE_PLAY, [{
            name: "playChannel",
            method: function (e, i, t) {
                return e.invoke(i, t)
            }
        }], "onPlayResult");
        this.registerActionObject(TvserviceModelDefines.TVAPI_ACTION_TVSERVICE_STOP, [{
            name: "stopChannel",
            method: function (e) {
                return e.invoke()
            }
        }], "onStopResult");
        this.registerActionObject(TvserviceModelDefines.TVAPI_VSTR_TVSERVICE_UNLOCK_PLAY, [{
            name: "unLockPlayChannel",
            method: function (e, i) {
                return e.invoke(i)
            }
        }], "onPlayResult");

        // Eit Main Now
        this.registerStringVectorObject(
            TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_EIT_MAIN_NOW,
            "getEitMainNow", null, "onEitMainNowChanged",
            null, null );

        // Eit Main Next
        this.registerStringVectorObject(
            TvserviceModelDefines.SL2_TVAPI_VSTR_TVSERVICE_EIT_MAIN_NEXT,
            "getEitMainNext", null, "onEitMainNextChanged",
            null, null );
        // AudioTable
        this.registerTableObject(
            TvserviceModelDefines.SL2_TVAPI_TVSERVICE_AUDIO_TABLE,
            "creatAudioTableIterator");
        // AudioIndex
        this.registerIntegerObject(
            TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_AUDIO_INDEX,
            "getAudioIndex", "setAudioIndex", "onAudioIndexChanged",
            null, null );
        // AudioLastIndex
        this.registerIntegerObject(
            TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_AUDIO_LAST_INDEX,
            "getAudioLastIndex", "setAudioLastIndex", "onAudioLastIndexChaged",
            null, null );
        // AudioExist
        this.registerIntegerObject(
            TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_AUDIO_EXIST,
            "getAudioExist", "setAudioExist", "onAudioExistChaged",
            null, null );

        // Tuner signal rflevel
        this.registerStringVectorObject(
            TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_TUNER_SIGNAL_RFLEVEL,
            "getSignalMainLevels", null, "onSignalMainLevelChanged",
            null, null );

        // Tuner signal CN
        this.registerStringVectorObject(
            TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_TUNER_SIGNAL_CN,
            "getSignalMainCns", null, "onSignalMainCnsChanged",
            null, null );
        //dtv pause resume
        this.registerIntegerObject(
            TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_PLAY_MAIN_PAUSE,
            "getPlayMainPause", "setPlayMainPause", "onPlayMainPauseChanged",
            null, null );

        this.registerIntegerObject(
            TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_URI_MAIN,
            "getUriMain", "setUriMain", "onUriMainChanged",
            null, null );
        this.registerStringObject(TvserviceModelDefines.SL2_TVAPI_STR_TVSERVICE_VIDEO_FORMAT_INFO, "getMainPlayVideoFormatInfo", null, "onMainPlayVideoFormatInfoChanged", null, null);

        this.registerStringObject(TvserviceModelDefines.SL2_TVAPI_STR_TVSERVICE_SOURCE_VIDEO_FORMAT_INFO, "getCurrentSourceVideoFormat", "setCurrentSourceVideoFormat", "onCurrentSourceVideoFormatChanged", null, null);
        this.registerIntegerObject(TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_LIST_UPDATE, "getChannelListUpdate", "setChannelListUpdate", "onChannelListUpdate", null, null);
        this.registerIntegerObject(TvserviceModelDefines.SL2_TVAPI_I32_TVSERVICE_LIST_NAME_UPDATE, "getChannelListNameUpdate", "setChannelListNameUpdate", "onChannelListNameUpdate", null, null);


}
TvserviceModel.prototype = new SubModel;
TvserviceModel.prototype.constructor = TvserviceModel;
{
    SubModel.registerStaticConstants(TvserviceModel, TvserviceModelDefines, [{
        groupPrefix: "SL2_TVAPI_VSTR_TVSERVICE_PLAY_",
        stripPrefix: "SL2_TVAPI_VSTR_TVSERVICE_"
    },
        {
            groupPrefix: "SL2_TVAPI_VINT_TUNERINFO_SIGNAL_",
            stripPrefix: "SL2_TVAPI_VINT_"
        },{
            groupPrefix: "ENUM_TVSERVICE_EIT_FIELD_",
            stripPrefix: "ENUM_TVSERVICE_"
        }, {groupPrefix: "ENUM_TVSERVICE_AUDIO_", stripPrefix: "ENUM_TVSERVICE_"}])
}
