/**
 * Created by jiangbo1 on 2016/5/9.
 */
(function () {

    var epgDetailData = {
        epg_detail_shadow_bg: {color: "#000000"},
        epg_detail_bg: {color: "#363e5b"},
        epg_detail_border: {color: "#3c435b"},
        epgDetailBtnBack: "Press BACK button to exit"
    };
    var template = Util.readJson("module/EPG/epgDetail.json");
    var epgDetail = SubModule.create(epgDetailData, template);
    var contentHeight = 0, panelHeight = 750, topHeight = 0, scrollHeight = 0, ratio = 0.1, scrollTop = 0;
    var epgBtn = UI.getItem(epgDetail, "epgDetailBtnBack");
    epgDetail.currFocus = epgBtn;

    function initEPGDetail() {
        UI.getItem(epgDetail, "epg_detail_shadow_bg").alpha = 0.8;
        UI.getItem(epgDetail, "epg_detail_bg").alpha = 0.9;
        UI.getItem(epgDetail, "epgDetailBtnBack").alpha = 0.6;
    }

    function setScrollbarPostion(dir) {
        if (contentHeight <= panelHeight) return;
        if (KEYDIRECTION.DOWN == dir) {
            if (topHeight + panelHeight >= contentHeight) return;
            topHeight += ratio * panelHeight;
        }
        else if (KEYDIRECTION.UP == dir) {
            if (0 == topHeight) return;
            topHeight -= ratio * panelHeight;
        }
        else {
            scrollHeight = Math.round(panelHeight * panelHeight / contentHeight);
            $("#epg_detail_scroll").css("height", scrollHeight + "px");
        }

        topHeight = Math.max(0, Math.min(contentHeight - panelHeight, topHeight));
        scrollTop = Math.round((panelHeight - scrollHeight) * topHeight / (contentHeight - panelHeight));
        $("#epg_detail_scroll").css("margin-top", scrollTop + "px");
        $(".epgDetailPanel").css("margin-top", (-topHeight) + "px");
    }

    epgBtn.onkey_DOWN = function () {
        setScrollbarPostion(KEYDIRECTION.DOWN);
    }

    epgBtn.onkey_UP = function () {
        setScrollbarPostion(KEYDIRECTION.UP);
    }

    epgDetail.onPush = function () {
        if (null == epgDetail.param) {
            DBG_ERROR("program is null");
        }
        else {
            var prgrm = epgDetail.param;
            setLiveTVText(UI.getItem(epgDetail, "epgDetailProgramName"), prgrm.title);
            setLiveTVText(UI.getItem(epgDetail, "epgDetailProgramTime"),
                getProgramLocalTime(prgrm.startTime, prgrm.endTime, 4));

            var htmlStr;
            if (prgrm.guidance) {
                htmlStr = '<div class="epgDetailPanel">' +
                '<span id="epg_guidance_title" class="epgDetailTitle">' + "Guidance" + '</span>' +
                '<span id="epg_guidance_content" class="epgDetailContent">' + prgrm.guidance + '</span>' +
                '<span id="epg_detail_title" class="epgDetailTitle">' + "Detail" + '</span>' +
                '<span id="epg_detail_content" class="epgDetailContent">' + prgrm.detail + '</span>' +
                '</div>' +
                '<div id="epg_detail_scroll" class="epgDetailScroll"></div>';
            }
            else {
                htmlStr = '<div class="epgDetailPanel">' +
                '<span id="epg_detail_content" class="epgDetailContent">' + prgrm.detail + '</span>' +
                '</div>' +
                '<div id="epg_detail_scroll" class="epgDetailScroll"></div>';
            }
            $("#epg_detail_page").html(htmlStr);
            $("#epg_detail_page").css("display", "block");
            contentHeight = parseInt($(".epgDetailPanel").css("height"));
            setScrollbarPostion(null);
        }
    }

    epgDetail.onPop = function () {
        epgDetail.param = null;
        $("#epg_detail_page").empty();
        $("#epg_detail_page").removeAttr("style");
    }

    epgDetail.onFocus = function () {
        UI.getTween(UI.base.cursor, true).set({
            scaleX: 1,
            scaleY: 1,
            alpha: 0
        });
    }
    initEPGDetail();

})();