/**
 * Created by jiangbo1 on 2016/5/10.
 */
(function () {

    var epgColorData = {
        epg_color_shadow_bg: {color: "#000000"},
        epg_color_list_bg: {color: "#363e5b"},
        epg_color_green_bg: GLOBAL.IMAGE_LIST.EPG_GREEN,
        epg_color_purple_bg: GLOBAL.IMAGE_LIST.EPG_PURPLE,
        epg_color_red_bg: GLOBAL.IMAGE_LIST.EPG_RED,
        epgColorGreenLeftArrow: GLOBAL.IMAGE_LIST.EPG_LEFT_ARROW,
        epgColorGreenRightArrow: GLOBAL.IMAGE_LIST.EPG_RIGHT_ARROW,
        epgColorPurpleLeftArrow: GLOBAL.IMAGE_LIST.EPG_LEFT_ARROW,
        epgColorPurpleRightArrow: GLOBAL.IMAGE_LIST.EPG_RIGHT_ARROW,
        epgColorRedLeftArrow: GLOBAL.IMAGE_LIST.EPG_LEFT_ARROW,
        epgColorRedRightArrow: GLOBAL.IMAGE_LIST.EPG_RIGHT_ARROW,
        epgColorGreenText: "",
        epgColorPurpleText: "",
        epgColorRedText: ""
    };
    var template = Util.readJson("module/EPG/epgColor.json");
    var epgColor = SubModule.create(epgColorData, template);
    var epgColorPanel = UI.getItem(epgColor, "epgColorPanel");
    var themeText = [], themeIndex, rowIndex = 0, colIndex = [0, 0, 0];
    var epgColorList = [
        UI.getItem(epgColorPanel, "epgColorGreenList"),
        UI.getItem(epgColorPanel, "epgColorPurpleList"),
        UI.getItem(epgColorPanel, "epgColorRedList")
    ];
    var epgColorText = [
        UI.getItem(epgColorPanel, "epgColorGreenText"),
        UI.getItem(epgColorPanel, "epgColorPurpleText"),
        UI.getItem(epgColorPanel, "epgColorRedText")
    ];

    function setCurrFocus(row, col) {
        epgColor.currFocus = UI.getItem(epgColorList[row], "COLOR_" + row + "_" + col);
    }

    function setSelectedItem(row, col) {
        var oriItem = UI.getItem(epgColorList[row], "COLOR_" + row + "_" + themeIndex[row]);
        var crntItem = UI.getItem(epgColorList[row], "COLOR_" + row + "_" + col);
        setLiveTVImage(oriItem.children[1], GLOBAL.IMAGE_LIST.NONE);
        setLiveTVImage(crntItem.children[1], GLOBAL.IMAGE_LIST.EPG_COLOR_SELECTED);
        setLiveTVText(epgColorText[row], themeText[col]);
        for (var i = 0; i < epgColorList.length; i++) {
            var oriDisableItem = [
                UI.getItem(epgColorList[i], "COLOR_" + i + "_" + themeIndex[(i + 1) % 3]),
                UI.getItem(epgColorList[i], "COLOR_" + i + "_" + themeIndex[(i + 2) % 3])
            ];
            oriDisableItem[0].disable = oriDisableItem[1].disable = false;
            oriDisableItem[0].children[2].alpha = oriDisableItem[1].children[2].alpha = 1;
        }
    }

    function setDisableItem() {
        for (var i = 0; i < epgColorList.length; i++) {
            var crntDisableItem = [
                UI.getItem(epgColorList[i], "COLOR_" + i + "_" + themeIndex[(i + 1) % 3]),
                UI.getItem(epgColorList[i], "COLOR_" + i + "_" + themeIndex[(i + 2) % 3])
            ];
            if (colIndex[i] == themeIndex[(i + 1) % 3] || colIndex[i] == themeIndex[(i + 2) % 3]) {
                colIndex[i] = themeIndex[i];
            }
            crntDisableItem[0].disable = crntDisableItem[1].disable = true;
            crntDisableItem[0].children[2].alpha = crntDisableItem[1].children[2].alpha = 0.2;
        }
    }

    epgColor.onkey_DOWN = function () {
        rowIndex = Math.min(2, rowIndex + 1);
        setCurrFocus(rowIndex, colIndex[rowIndex]);
        UI.focusTo(epgColor.currFocus);
    }
    epgColor.onkey_UP = function () {
        rowIndex = Math.max(0, rowIndex - 1);
        setCurrFocus(rowIndex, colIndex[rowIndex]);
        UI.focusTo(epgColor.currFocus);
    }

    epgColor.onkey_ENTER = function () {
        setSelectedItem(rowIndex, colIndex[rowIndex]);
        themeIndex[rowIndex] = colIndex[rowIndex];
        setDisableItem();
        UI.updateStage();
    }

    epgColor.onPush = function () {
        themeIndex = EPG.getCurrentThemeIndex();
        colIndex = copyObj(themeIndex);
        rowIndex = 0;
        for (var i = 0; i < epgColorList.length; i++) {
            var crntDisableItem = [
                UI.getItem(epgColorList[i], "COLOR_" + i + "_" + themeIndex[(i + 1) % 3]),
                UI.getItem(epgColorList[i], "COLOR_" + i + "_" + themeIndex[(i + 2) % 3])
            ];
            crntDisableItem[0].disable = crntDisableItem[1].disable = true;
            crntDisableItem[0].children[2].alpha = crntDisableItem[1].children[2].alpha = 0.2;
            setLiveTVText(epgColorText[i], themeText[themeIndex[i]]);
        }
        setCurrFocus(rowIndex, colIndex[rowIndex]);
    };

    epgColor.onPop = function () {
        if (Config.tv) model.epg.setThemsColor(themeIndex);
        EPG.refreshEPGColorTheme(themeIndex);
    }

    epgColor.onFocus = function (target) {
        onFocusLiveTVTarget(target, 1, 500, false, 1);
        //moveFocusBar(target);
        colIndex[rowIndex] = epgColorList[rowIndex].initSequence.indexOf(target);
    };

    epgColor.onNormal = function (target) {
        onNormalLiveTVTarget(target, 1, 500, false, 0);
    };

    function initEPGColor() {
        themeText = EPG.getColorTheme();
        themeIndex = EPG.getCurrentThemeIndex();
        var listInfo = {
            template: "themeTile",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 100,
            distanceY: 0,
            distanceX: 0
        }, i, j;

        for (i = 0; i < epgColorList.length; i++) {
            listInfo.container = epgColorList[i];
            var allArray = [];
            for (j = 0; j < themeText.length; j++) {
                allArray.push(
                    {
                        name: "COLOR_" + i + "_" + j,
                        theme_border: GLOBAL.IMAGE_LIST.EPG_COLOR_BORDER,
                        theme_bg: themeIndex[i] == j ? GLOBAL.IMAGE_LIST.EPG_COLOR_SELECTED : GLOBAL.IMAGE_LIST.NONE,
                        theme_name: themeText[j]
                    }
                );
            }
            removeLiveTVShape(listInfo.container);
            listInfo.container.removeAllChildren();
            listInfo.container.initSequence = [];
            Gird.create(allArray, listInfo);
            UI.setView(listInfo.container, 872, 78, 0, 0);
            UI.addMask(listInfo.container, 872, 72, 0, 0);
        }
        UI.getItem(epgColor, "epg_color_shadow_bg").alpha = 0.8;
    }

    initEPGColor();
})();
