UI.moduleBuilder['Alexa']['register_language'] = function() {
    var languageData = {
        title: "[ALX0014]",
        helpText: "[ALX0015]",
        titleImg:"Alexa/register/logo_alexa.png",
        loadingImg:"Alexa/register/loading.png"
    };
    var template = Util.readJson("module/Alexa/register_language.json");
    var register_language = SubModule.create(languageData, template);
    var tiles = UI.getItem(register_language, "tiles");
    var title = UI.getItem(register_language, "title");
    var MainFrame = UI.getItem(register_language,"MainFrame");
    var loadingImg = UI.getItem(register_language, "loadingImg");
    var ConnectionTimeOut = true; //连接超时
    register_language.languageList = [];
    var hide = 0;
    var show = 1;

    var info = {
        template: "alexa_register_item",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 1,
        distanceX: 0,
        distanceY: 20,
        container: tiles
    };
    var list = [];
    for (var i = 0; i <  register_language.languageList.length; i++) {
        var element = {
            bgImg: UI.item_bg,
            text:  register_language.languageList[i],
            name: "tiles" + i
        }
        list.push(_cloneObj(element));
    }
    Gird.create(list, info);
    UI.addMask(tiles, 960, 547, 50, 3);
    UI.setView(tiles, 960, 547, 0, 0);
    UI.addScrollbar(tiles, 7);
    if(!tiles.scroll){
        UI.addScrollbar(tiles, -10);
    }

    function initLanguageList(array) {
        register_language.languageList = array;
        if(register_language.languageList.length != 0){
            while (tiles.children.length != 0) {
                tiles.children.pop();
            }
            var list = [];
            for (var i = 0; i <  register_language.languageList.length; i++) {
                var element = {
                    bgImg: UI.item_bg,
                    text:  register_language.languageList[i].languageDesc,
                    name: "tiles" + i
                }
                list.push(_cloneObj(element));
            }
            Gird.create(list, info);
            UI.addMask(tiles, 960, 547, 50, 3);
            UI.setView(tiles, 960, 547, 0, 0);
            if(register_language.languageList.length > 5){
                UI.addScrollbar(tiles, 10);
            }
            if(register_language.languageList.length <= 3){
                tiles.y = 200;
                UI.updateStage();
            }
        }
        DBG_ERROR(AvsModelDefines.TV_API_AVS_CTRL_ACTION_TYPE_GET_LANG_LOCALE);
        AVSClient.register.getAlexaLanguageCode();
    }

    register_language.onPush = function(){
        //UI.startLoading();
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONCULANGUAGE,getAlexaLanguage);
        displayPageMsg(show,hide);
        register_language.currFocus = title;
        var arr = AVSClient.register.getLanguageList();
        initLanguageList(arr);
        setTimeout(function(){
            if(ConnectionTimeOut){
                getAlexaLanguage(0);
            }
        },5000);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONSETALEXALANGUAGERESULT, onAlexaLanguageChange);
    };

    function  getAlexaLanguage(result) {
        //UI.endLoading();
        if(!!result.toLowerCase().replace(' ', '')) {
        ConnectionTimeOut = false;
        DBG_ERROR("languageList IS" + register_language.languageList);
        var index = _getIndexByLocale(register_language.languageList, result);
        DBG_ERROR("result is " + result + "index is " + index);
        if(index == -1){
            DBG_ERROR("error ui reset");
            index = 0;
        }
        UI.focusTo(tiles.initSequence[index]);
        displayPageMsg(hide,show);
        }
    }

    register_language.onPop = function(){
        displayPageMsg(hide,hide);
        //UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AVS_LANGUAGELIST, initLanguageList);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONSETALEXALANGUAGERESULT, onAlexaLanguageChange);
    };

    register_language.onFocus = function(){
        if(UI.getCurrFocus().name == "title"){
            UI.base.cursor.alpha = 0;
            UI.getTween(UI.base.cursor).set({alpha: 0});
            return false;
        }else{
            return true;
        }
    }

    function onAlexaLanguageChange(result){
        DBG_ERROR("ALEXA_CHANGE_OVER!!!!!!!!!!!!!!!");
        DBG_ERROR("result is " + result );
        if(result == 0) registerUpdate(1);
    }

    tiles.onkey_ENTER = function(){
        var selectedIndex = tiles.initSequence.indexOf(UI.getCurrFocus());
        DBG_ERROR("register_language.languageList[selectedIndex].code " + register_language.languageList[selectedIndex].locale);
        AVSClient.register.setAlexaLanguageCode(register_language.languageList[selectedIndex].locale);
    }

    function _getIndexByLocale(a, b){
        if (!a) {
            return -1;
        }
        for (var i = 0; i < a.length; i++) {
            if (a[i].locale == b) {
                return i;
            }
        }
        return -1;
    }
    function displayPageMsg(a,b){
        registerLoading(a);
        MainFrame.alpha = b;
        UI.updateStage();
    }
    function registerLoading(a) {
        if (a) {
            loadingImg.alpha = 1;
            UI.getTween(loadingImg, true, true).to({rotation: loadingImg.rotation + Math.PI*2}, 1000);
        }
        else {
            loadingImg.alpha = 0;
            createjs.Tween.removeTweens(loadingImg);
        }

    }
}
