UI.moduleBuilder['Alexa']['register_rename'] = function() {
    var HIDE = 0;
    var SHOW = 1;
    var renameData = {
        title: "[SE0323]",
        helpText: "[SE3953]",
        networkToastBgImg : "toast/Toast_bg2.png",
        networkToastImg:"setting/wifi/ic_not_connected.png"
    };
    var template = Util.readJson("module/Alexa/register_rename.json");
    var register_rename = SubModule.create(renameData, template);
    var tiles = UI.getItem(register_rename, "tiles");
    var networkToast = UI.getItem(register_rename, "networkToast");
    var networkToastImg = UI.getItem(networkToast, "networkToastImg");
    var networkToastText = UI.getItem(networkToast, "networkToastText");
    register_rename.showTimeout = 0;
    register_rename.currTvName = "";
    register_rename.currSelect = 0;
    register_rename.tvNameList = ["Smart TV", "Living Room TV", "Bedroom TV", "Kitchen TV"];//["[SE0635]", "[SE0636]", "[SE0637]", "[SE0638]"]
    register_rename.undefineName = "[SE0010]";//Custom
    register_rename.protected = true;


    function registerNameInit(){
        try {
            register_rename.currTvName = tv?model.system.getMachinename():"Smart TV";
            var index = _getIndex(register_rename.tvNameList, register_rename.currTvName);
            if (index >= 0) {
                register_rename.curselect = index;
            }
            else {
                register_rename.curselect = register_rename.tvNameList.length;
            }
            DBG_ERROR(" register_rename.currTvName is " +  register_rename.currTvName + "register_rename.curselect is " + register_rename.curselect);
        }
        catch (e) {
            DBG_ERROR(e.message)
        }
    }

    var info = {
        template: "alexa_register_item",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 1,
        distanceX: 0,
        distanceY: 20,
        container: tiles
    };
    var tvNameList = [];
    for (var i = 0; i < register_rename.tvNameList.length; i++) {
        var element = {
            bgImg: UI.item_bg,
            text: register_rename.tvNameList[i],
            name: "tiles" + i
        }
        tvNameList.push(_cloneObj(element));
    }
    tvNameList.push({
        bgImg: UI.item_bg,
        text: register_rename.undefineName,
        name: "tiles"+register_rename.tvNameList.length

    })
    Gird.create(tvNameList, info);

    register_rename.currFocus = UI.getItem(tiles, "tiles" + register_rename.curselect);

    register_rename.onPush = function(){
        showWifiConnectToast(HIDE,null,null);
        registerNameInit();
        register_rename.currFocus = UI.getItem(tiles, "tiles" + register_rename.curselect);
        //notify remote app
        if(tv){
            try{
                pubAvsTVRename();
            }catch(ex){
                DBG_ERROR(ex.message);
            }
        }
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONHISENSEDEVICEREPORTRESULT, onDeviceReportChanged);
    }


    function onDeviceReportChanged(val){
        DBG_ERROR("onDeviceReportChanged val is "  + val);//0(OK);1(dup_name);2(Failed)
        var dupText = "Your Hisense account has a TV with the same name.Please rename it and try again.";
        var noNetText = "[SE3954]";
        if(val == 0){
            if(UI.getCurrSubModule().name == "register_rename"){
                registerUpdate(1);
            }
        }else if(val == 1){
            // showWifiConnectToast(SHOW,dupText);
            openMsgBox(MsgBoxType.AVS_DEVICE_DUPLICATE);
        }else{
            showWifiConnectToast(SHOW,noNetText);
        }

    }
    register_rename.onShow = function(){

    }


    register_rename.onPop = function(){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONHISENSEDEVICEREPORTRESULT, onDeviceReportChanged);
    };


    tiles.onkey_ENTER = function(focus){
        var index = tiles.initSequence.indexOf(focus);
        if(index==4){
            UI.pushSubModule("Alexa", "register_editName", true);
        }else{
            if(!tv){
                onDeviceReportChanged(0);
            }
            register_rename.curselect = index;
            setTvName(register_rename.tvNameList[register_rename.curselect]);
        }
    }

    function showWifiConnectToast(alpha,text,img){
        networkToast.alpha = alpha;
        if(img!=null){
            UI.setImage(networkToastImg,img);
        }
        if(text!=null){
            UI.setText(networkToastText,text);
        }
        UI.updateStage();
        clearTimeout(register_rename.showTimeout);
        if(alpha == SHOW){
            if(GLOBAL.TTS){
                UI.callTTS(text);
            }
            register_rename.showTimeout = setTimeout(function(){showWifiConnectToast(HIDE,null,null)},3000);
        }
    }
}

