// parse directive
function directiveParse(){

    this.parse = function(msg){
        try{
            return JSON.parse(msg);
        }catch(e){
            DBG_ERROR("failed to parse msg");
        }
    };

    this.parseHeader = function(json){
        var actualJSON = json, type = typeof json;
        if(type == "string"){
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse header");
            }
        }
        if(actualJSON.directive){
            return "directive";
        }else if(actualJSON.voiceChrome){
            return "voiceChrome";
        }else if(actualJSON.network){
            return "network";
        }else if(actualJSON.PlayController){
            return "PlayController";
        }
    };

    this.parseNameSpace = function(json){
        var actualJSON = json, type = typeof json;
        if(type == "string"){
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse nameSpace");
            }
        }
        if (!actualJSON.directive || !actualJSON.directive.header || !actualJSON.directive.header.namespace) {
            return null;
        }
        return actualJSON.directive.header.namespace;
    };

    this.parseName = function(json){
        var actualJSON = json, type = typeof json;
        if(type == "string"){
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse name");
            }
        }
        if (!actualJSON.directive || !actualJSON.directive.header || !actualJSON.directive.header.name) {
            return null;
        }
        return actualJSON.directive.header.name;
    };

    this.parseDialogRequestId = function(json){
        var actualJSON = json, type = typeof json;
        if(type == "string"){
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse DialogRequestId");
            }
        }
        if (!actualJSON.directive || !actualJSON.directive.header || !actualJSON.directive.header.dialogRequestId) {
            return "";
        }
        return actualJSON.directive.header.dialogRequestId;
    };

    this.parseAudioItemId = function(json){
        var actualJSON = json, type = typeof json;
        if(type == "string"){
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse audioItemId");
            }
        }
        if("Play" == actualJSON.directive.header.name){
            if (!actualJSON.directive || !actualJSON.directive.payload || !actualJSON.directive.payload.audioItem ||
                !actualJSON.directive.payload.audioItem.audioItemId) {
                return "";
            }else{
                return actualJSON.directive.payload.audioItem.audioItemId;
            }
        }else if("RenderPlayerInfo" == actualJSON.directive.header.name){
            if (!actualJSON.directive || !actualJSON.directive.payload || !actualJSON.directive.payload.audioItemId){
                return "";
            }else{
                return actualJSON.directive.payload.audioItemId;
            }
        }else{
            return "";
        }
    };

    this.parsePlayBehaviour = function(json){
        var actualJSON = json, type = typeof json;
        if(type == "string"){
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse playBehaviour");
            }
        }
        if (!actualJSON.directive || !actualJSON.directive.payload || !actualJSON.directive.payload.playBehavior) {
            return "";
        }
        return actualJSON.directive.payload.playBehavior;
    };

    this.parsePlayDirectiveInfo = function(json){
        var actualJSON = json, type = typeof json;
        if(type == "string"){
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse playDirectiveInfo");
            }
        }
        if(!actualJSON.directive.payload){
            return null;
        }
        var playDInfo = {};
        playDInfo.playBehavior = "";
        playDInfo.url = "";
        playDInfo.streamFormat = "";
        playDInfo.offsetInMilliseconds = 0;
        playDInfo.expiryTime = "";
        playDInfo.token = "";
        playDInfo.expectedPreviousToken = "";
        playDInfo.delayMSeconds = 0;
        playDInfo.intervalMSeconds = 0;
        if(actualJSON.directive.payload.playBehavior){
            playDInfo.playBehavior = actualJSON.directive.payload.playBehavior;
        }
        if(actualJSON.directive.payload.audioItem && actualJSON.directive.payload.audioItem.stream){
            if(actualJSON.directive.payload.audioItem.stream.url){
                playDInfo.url = actualJSON.directive.payload.audioItem.stream.url;
            }
            if(actualJSON.directive.payload.audioItem.stream.streamFormat){
                playDInfo.streamFormat = actualJSON.directive.payload.audioItem.stream.streamFormat;
            }
            if(actualJSON.directive.payload.audioItem.stream.offsetInMilliseconds){
                playDInfo.offsetInMilliseconds = actualJSON.directive.payload.audioItem.stream.offsetInMilliseconds;
            }
            if(actualJSON.directive.payload.audioItem.stream.expiryTime){
                playDInfo.expiryTime = actualJSON.directive.payload.audioItem.stream.expiryTime;
            }
            if(actualJSON.directive.payload.audioItem.stream.token){
                playDInfo.token = actualJSON.directive.payload.audioItem.stream.token;
            }
            if(actualJSON.directive.payload.audioItem.stream.expectedPreviousToken){
                playDInfo.expectedPreviousToken = actualJSON.directive.payload.audioItem.stream.expectedPreviousToken;
            }
            if(actualJSON.directive.payload.audioItem.stream.progressReport){
                if(actualJSON.directive.payload.audioItem.stream.progressReport.progressReportDelayInMilliseconds){
                    playDInfo.delayMSeconds = actualJSON.directive.payload.audioItem.stream.progressReport.progressReportDelayInMilliseconds;
                }
                if(actualJSON.directive.payload.audioItem.stream.progressReport.progressReportIntervalInMilliseconds){
                    playDInfo.intervalMSeconds = actualJSON.directive.payload.audioItem.stream.progressReport.progressReportIntervalInMilliseconds;
                }
            }
        }
        return playDInfo;
    };

    this.parseStopDirectiveInfo = function(json){
        return null;
    };

    this.parseClearQueueInfo = function(json){
        var actualJSON = json, type = typeof json;
        if(type == "string"){
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse ClearQueueInfo");
            }
        }
        if(!actualJSON.directive.payload){
            return null;
        }
        var clearQueueDInfo = {};
        clearQueueDInfo.clearBehavior = "";
        if(actualJSON.directive.payload.clearBehavior){
            clearQueueDInfo.clearBehavior = actualJSON.directive.payload.clearBehavior;
        }
        return clearQueueDInfo;
    };

    this.parseRenderPlayerInfo = function(json){
        var actualJSON = json, type = typeof json;
        if(type == "string"){
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse renderPlayerInfo");
            }
        }
        if(!actualJSON.directive.payload){
            return null;
        }
        var renderPlayerInfo = {};
        renderPlayerInfo.header = "";
        renderPlayerInfo.title = "";
        renderPlayerInfo.titleSubtext1 = "";
        renderPlayerInfo.titleSubtext2 = "";
        renderPlayerInfo.lengthMSeconds = "";
        renderPlayerInfo.artSource = [];
        renderPlayerInfo.providerName = "";
        renderPlayerInfo.logo = [];
        renderPlayerInfo.controls = [];

        if(actualJSON.directive.payload.content){
            if(actualJSON.directive.payload.content.header){
                renderPlayerInfo.header = actualJSON.directive.payload.content.header;
            }
            if(actualJSON.directive.payload.content.title){
                renderPlayerInfo.title = actualJSON.directive.payload.content.title;
            }
            if(actualJSON.directive.payload.content.titleSubtext1){
                renderPlayerInfo.titleSubtext1 = actualJSON.directive.payload.content.titleSubtext1;
            }
            if(actualJSON.directive.payload.content.titleSubtext2){
                renderPlayerInfo.titleSubtext2 = actualJSON.directive.payload.content.titleSubtext2;
            }
            if(actualJSON.directive.payload.content.mediaLengthInMilliseconds){
                renderPlayerInfo.lengthMSeconds = actualJSON.directive.payload.content.mediaLengthInMilliseconds;
            }
            if(actualJSON.directive.payload.content.art &&  actualJSON.directive.payload.content.art.sources){
                for(var i=0; i<actualJSON.directive.payload.content.art.sources.length; i++){
                    renderPlayerInfo.artSource[i] = {};
                    renderPlayerInfo.artSource[i].size = actualJSON.directive.payload.content.art.sources[i].size;
                    renderPlayerInfo.artSource[i].url = actualJSON.directive.payload.content.art.sources[i].url;
                }
            }
            if(actualJSON.directive.payload.content.provider){
                if(actualJSON.directive.payload.content.provider.name){
                    renderPlayerInfo.providerName = actualJSON.directive.payload.content.provider.name;
                }
                if(actualJSON.directive.payload.content.provider.logo && actualJSON.directive.payload.content.provider.logo.sources){
                    for(i=0; i<actualJSON.directive.payload.content.provider.logo.sources.length; i++){
                        renderPlayerInfo.logo[i] = {};
                        renderPlayerInfo.logo[i].url = actualJSON.directive.payload.content.provider.logo.sources[i].url;
                    }
                }
            }
        }
        if(actualJSON.directive.payload.controls){
            for(i=0; i<actualJSON.directive.payload.controls.length; i++){
                renderPlayerInfo.controls[i] = {};
                renderPlayerInfo.controls[i].type = actualJSON.directive.payload.controls[i].type;
                renderPlayerInfo.controls[i].name = actualJSON.directive.payload.controls[i].name;
                renderPlayerInfo.controls[i].enabled = actualJSON.directive.payload.controls[i].enabled;
                renderPlayerInfo.controls[i].selected = actualJSON.directive.payload.controls[i].selected;
            }
        }
        return renderPlayerInfo;
    }
}