// Init
UI.moduleBuilder['setting']['wifiPwdInput'] = function(){

    var mainPanelData = {
        wifiPwdInputDialogBgImg:UI['bg_overlay'],
        wifiPwdInputBgImg:UI.window_bg,
        wifiPwdInputBarPWD:"setting/wifi/wifi_input_normal.png",
        wifiPwdInputChkBox:"setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_check_box_focused.png",
        wifiPwdInputCancelImg:UI.item_bg,
        wifiPwdInputConnectImg:UI.item_bg,
        wifiPwdInputTxtChk:"[OT0019]",//"Show the password"
        noPwdTextHint:"[SE3014]",//"Press OK open the keyboard"
        wifiPwdInputCancelText:"[GE0008]",//Cancel
        wifiPwdInputConnectText:"[SE0187]"//Connect

    };
    var template = Util.readJson("module/setting/wifiPwdInput.json");
    var wifiPwdInput = SubModule.create(mainPanelData, template);
    var wifiPwdInputConnectBtn = UI.getItem(wifiPwdInput, "wifiPwdInputConnectBtn");
    var wifiPwdInputGrpPWD = UI.getItem(wifiPwdInput, "wifiPwdInputGrpPWD");
    var wifiPwdInputPWD = UI.getItem(wifiPwdInputGrpPWD, "wifiPwdInputPWD");

//    wifiPwdInput.showPwd = false;
    wifiPwdInput.pwd = "";
    wifiPwdInput.SSID = "";
    wifiPwdInput.secType = 0;
    wifiPwdInput.authType = 0;
    wifiPwdInput.password = "";
    wifiPwdInput.text = "";
    wifiPwdInput.noAutoClose = true;

    wifiPwdInput.currFocus = UI.getItem(wifiPwdInput, "wifiPwdInputGrpPWD");


    var wifiPwdInputName = UI.getItem(wifiPwdInput, "wifiPwdInputName");
    var wifiPwdInputCancelBtn = UI.getItem(wifiPwdInput, "wifiPwdInputCancelBtn");
    var wifiPwdInputBarPWD = UI.getItem(wifiPwdInput, "wifiPwdInputBarPWD");
    var noPwdTextHint = UI.getItem(wifiPwdInputGrpPWD, "noPwdTextHint");
    var checkboxBar = UI.getItem(wifiPwdInput, "wifiPwdInputCheckboxBar");
    var checkboxComp = UI.getItem(checkboxBar, "wifiPwdInputChkBox");
    Checkbox.create(checkboxComp, false);

    var textInfo = {
        initVal : "",
        maxLength : 64,
        maxWidth : 760,
        fontSize : 36,
        isPwd : true,
        showPwd:false,
        color : 0xFFFFFF,
        TextName:Config.language["SE0606"]
    };
    TextBox.create(wifiPwdInputPWD, textInfo, onPwdTextChanged);

    wifiPwdInput.onPush =  function(){
        try{
//            wifiPwdInputConnectBtn.disable = true;
//            wifiPwdInputConnectBtn.alpha = 0.6;
//            wifiPwdInput.showPwd = false;
            var networkConfigPanel = UI.getSubModule("networkConfigPanel");
            wifiPwdInput.SSID = networkConfigPanel.connWifiPara.SSID;
            wifiPwdInput.secType = networkConfigPanel.connWifiPara.secType;
            wifiPwdInput.authType = networkConfigPanel.connWifiPara.authType;
            wifiPwdInput.password = networkConfigPanel.connWifiPara.connPassword;
            wifiPwdInput.text = networkConfigPanel.connWifiPara.connPassword;
            var lastSSID = "";
            var lastPassword = "";
            var currSSID = "";
            var currPassword = "";
            var networkAvailable = 0;
            if(tv){
                lastSSID = model.network.getLastAccessPointSsid();
                lastPassword = model.network.getLastAccessPointPassword();
                currSSID = model.network.getSsid();
                currPassword =  model.network.getEncryptionPassphrase();
                networkAvailable = model.network.getEnumNetworkAvailable();
                DBG_ERROR("lastSSID:"+lastSSID+",lastPassword:"+lastPassword);
            }
            DBG_ERROR("wifiPwdInput.SSID:"+wifiPwdInput.SSID);
            if(wifiPwdInput.SSID == currSSID){
                if(networkAvailable == 1){
                    DBG_ERROR('wifiPwdInput networkAvailable == 1 && wifiPwdInput.SSID == currSSID');
                    wifiPwdInput.password = currPassword;
                    wifiPwdInput.text = currPassword;
                }else{
                    var linkState = model.network.getEnumLink();
                    DBG_ERROR('wifiPwdInput networkAvailable == 0 && linkState'+linkState);
                    if(linkState != 3){
                        ////3 password error
                        wifiPwdInput.password = currPassword;
                        wifiPwdInput.text = currPassword;
                    }else{
                        wifiPwdInput.password = "";
                        wifiPwdInput.text = "";
                    }
                }
            }else if(wifiPwdInput.SSID == lastSSID){
                DBG_ERROR('wifiPwdInput.SSID == lastSSID');
                wifiPwdInput.password = lastPassword;
                wifiPwdInput.text = lastPassword;
            }else{
                wifiPwdInput.password = "";
                wifiPwdInput.text = "";
            }

            initWifiPwdConnectBtn();
            wifiPwdInputPWD.setText(wifiPwdInput.text);
            wifiPwdInputPWD.children[0].realValue = wifiPwdInput.text;
            wifiPwdInputPWD.children[0].text = wifiPwdInput.text;
            wifiPwdInputPWD.children[0].showPwd = false;
            if(wifiPwdInput.text.length>0){
                for(var i=0;i<wifiPwdInput.text.length;i++){
                    wifiPwdInputPWD.cursorRight();
                }
                noPwdTextHint.alpha = 0;
            }else{
                noPwdTextHint.alpha = 0.5;
                UI.callTTS("[SE3014]");
                wifiPwdInputPWD.cursorLeft();
            }
            UI.setImage(checkboxComp,"setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_check_box_focused.png");
            UI.focusTo(wifiPwdInputGrpPWD);
            UI.setText(wifiPwdInputName,wifiPwdInput.SSID);
            UI.setImage(wifiPwdInputBarPWD,"setting/wifi/"+GLOBAL.LAUNCHER_BRAND+"/wifi_input_focused.png");
            wifiPwdInput.currFocus = UI.getItem(wifiPwdInput, "wifiPwdInputGrpPWD");
            UI.updateStage();

        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    };

    function initWifiPwdConnectBtn(){
        if(parseInt(wifiPwdInput.secType) == 1 || parseInt(wifiPwdInput.secType) == 4){
            if(wifiPwdInput.password.length > 4){
                setConnectBtnDisable(false);
            }else{
                setConnectBtnDisable(true);
            }
        }else{
            if(wifiPwdInput.password.length > 7){
                setConnectBtnDisable(false);
            }else{
                setConnectBtnDisable(true);
            }
        }
        if(wifiPwdInput.password.length>0){
            noPwdTextHint.alpha = 0;
        }

    }

    function setConnectBtnDisable(disable){
        wifiPwdInputConnectBtn.disable = disable;
        if(disable){
            wifiPwdInputConnectBtn.alpha = 0.3;
        }else{
            wifiPwdInputConnectBtn.alpha = 1;
        }
        UI.updateStage();
    }


    wifiPwdInputGrpPWD.onFocus = function(){
        UI.base.cursor.alpha = 0;
        UI.getTween(UI.base.cursor).set({alpha: 0});
        UI.setImage(wifiPwdInputBarPWD,"setting/wifi/"+GLOBAL.LAUNCHER_BRAND+"/wifi_input_focused.png");
        wifiPwdInputPWD.active();
        return false;
//
    };

    wifiPwdInputGrpPWD.onNormal = function(){
        UI.setImage(wifiPwdInputBarPWD,"setting/wifi/wifi_input_normal.png");
        UI.base.cursor.alpha = 1;
        UI.getTween(UI.base.cursor).set({alpha: 1});
        wifiPwdInputPWD.inactive();
        return true;

    };

    function onPwdTextChanged(txt,aa,Keyboard) {
        DBG_INFO("!!!!!!!!!!!!!!!!!!!"+txt.realValue);
        wifiPwdInput.password = txt.realValue;
        wifiPwdInput.text = wifiPwdInput.password;
//        wifiPwdInput.text = txt.text;
        initWifiPwdConnectBtn();
//        wifiPwdInputPWD.setText(wifiPwdInput.text);
//        wifiPwdInputPWD.cursorRight();
        if(!!Keyboard) return;
        if(!wifiPwdInputConnectBtn.disable){
            var networkConfigPanel = UI.getSubModule("networkConfigPanel");
            if(networkConfigPanel.openFromPwd ==0){
                networkConfigPanel.openFromPwd = 2;
            }
            networkConfigPanel.currPassword = wifiPwdInput.password;
            UI.popSubModule();
        }

    }

    function refreshShowText(){
        setTimeout(function (){UI.updateStage();},300)
    }
    wifiPwdInputGrpPWD.onkey_LEFT = function(){
        wifiPwdInputPWD.cursorLeft();
    }

    wifiPwdInputGrpPWD.onkey_RIGHT = function(){
        wifiPwdInputPWD.cursorRight();
    }

    wifiPwdInputGrpPWD.onkey_ENTER = function (){
        DBG_INFO(" wifiPwdInputGrpPWD.onkey_ENTER !!!!!!!!!!!!!!!!!!!");
        wifiPwdInputPWD.showKeyBoard();
    };

    wifiPwdInputGrpPWD.onkey_ZERO = function (){
//        wifiPwdInput.password = wifiPwdInput.password+'0';
        wifiPwdInput.password = wifiPwdInputPWD.makeText(0);
        wifiPwdInput.text = wifiPwdInput.password;
        initWifiPwdConnectBtn();
        wifiPwdInputPWD.setText(wifiPwdInput.text);
        wifiPwdInputPWD.cursorRight();
        UI.callTTS("0");
//        refreshShowText();
        UI.updateStage();
    };
    wifiPwdInputGrpPWD.onkey_ONE = function (){
//        wifiPwdInput.password = wifiPwdInput.password+'1';
        wifiPwdInput.password = wifiPwdInputPWD.makeText(1);
        wifiPwdInput.text = wifiPwdInput.password;
        initWifiPwdConnectBtn();
        wifiPwdInputPWD.setText(wifiPwdInput.text);
        wifiPwdInputPWD.cursorRight();
        UI.callTTS("1");
        UI.updateStage();
    };
    wifiPwdInputGrpPWD.onkey_TWO = function (){
//        wifiPwdInput.password = wifiPwdInput.password+'2';
        wifiPwdInput.password = wifiPwdInputPWD.makeText(2);
        wifiPwdInput.text = wifiPwdInput.password;
        initWifiPwdConnectBtn();
        wifiPwdInputPWD.setText(wifiPwdInput.text);
        wifiPwdInputPWD.cursorRight();
        UI.callTTS("2");
        UI.updateStage();
    };
    wifiPwdInputGrpPWD.onkey_THREE = function (){
//        wifiPwdInput.password = wifiPwdInput.password+'3';
        wifiPwdInput.password = wifiPwdInputPWD.makeText(3);
        wifiPwdInput.text = wifiPwdInput.password;
        initWifiPwdConnectBtn();
        wifiPwdInputPWD.setText(wifiPwdInput.text);
        wifiPwdInputPWD.cursorRight();
        UI.callTTS("3");
        UI.updateStage();
    };
    wifiPwdInputGrpPWD.onkey_FOUR = function (){
//        wifiPwdInput.password = wifiPwdInput.password+'4';
        wifiPwdInput.password = wifiPwdInputPWD.makeText(4);
        wifiPwdInput.text = wifiPwdInput.password;
        initWifiPwdConnectBtn();
        wifiPwdInputPWD.setText(wifiPwdInput.text);
        wifiPwdInputPWD.cursorRight();
        UI.callTTS("4");
        UI.updateStage();
    };
    wifiPwdInputGrpPWD.onkey_FIVE = function (){
//        wifiPwdInput.password = wifiPwdInput.password+'5';
        wifiPwdInput.password = wifiPwdInputPWD.makeText(5);
        wifiPwdInput.text = wifiPwdInput.password;
        initWifiPwdConnectBtn();
        wifiPwdInputPWD.setText(wifiPwdInput.text);
        wifiPwdInputPWD.cursorRight();
        UI.callTTS("5");
        UI.updateStage();
    };
    wifiPwdInputGrpPWD.onkey_SIX = function (){
//        wifiPwdInput.password = wifiPwdInput.password+'6';
        wifiPwdInput.password = wifiPwdInputPWD.makeText(6);
        wifiPwdInput.text = wifiPwdInput.password;
        initWifiPwdConnectBtn();
        wifiPwdInputPWD.setText(wifiPwdInput.text);
        wifiPwdInputPWD.cursorRight();
        UI.callTTS("6");
        UI.updateStage();
    };
    wifiPwdInputGrpPWD.onkey_SEVEN = function (){
//        wifiPwdInput.password = wifiPwdInput.password+'7';
        wifiPwdInput.password = wifiPwdInputPWD.makeText(7);
        wifiPwdInput.text = wifiPwdInput.password;
        initWifiPwdConnectBtn();
        wifiPwdInputPWD.setText(wifiPwdInput.text);
        wifiPwdInputPWD.cursorRight();
        UI.callTTS("7");
        UI.updateStage();
    };
    wifiPwdInputGrpPWD.onkey_EIGHT = function (){
//        wifiPwdInput.password = wifiPwdInput.password+'8';
        wifiPwdInput.password = wifiPwdInputPWD.makeText(8);
        wifiPwdInput.text = wifiPwdInput.password;
        initWifiPwdConnectBtn();
        wifiPwdInputPWD.setText(wifiPwdInput.text);
        wifiPwdInputPWD.cursorRight();
        UI.callTTS("8");
        UI.updateStage();
    };
    wifiPwdInputGrpPWD.onkey_NINE = function (){
//        wifiPwdInput.password = wifiPwdInput.password+'9';
        wifiPwdInput.password = wifiPwdInputPWD.makeText(9);
        wifiPwdInput.text = wifiPwdInput.password;
        initWifiPwdConnectBtn();
        wifiPwdInputPWD.setText(wifiPwdInput.text);
        wifiPwdInputPWD.cursorRight();
        UI.callTTS("9");
        UI.updateStage();
    };


//    //checkboxBar.updateCache();
//    UI.updateStage();
//    checkboxBar.onFocus = function(focus) {
//        checkboxComp.onFocus();
//        return true;
//    };
//    checkboxBar.onNormal = function(focus) {
//        checkboxComp.onNormal();
//        return true;
//    };
    checkboxBar.onkey_ENTER = function(focus) {
        //checkboxBar.updateCache();
//        wifiPwdInput.showPwd = !wifiPwdInput.showPwd;
        if(wifiPwdInputPWD.children[0].showPwd){
            DBG_INFO("!!!!!!!!!!!!!!!!!!!"+wifiPwdInput.password);
            UI.setImage(checkboxComp,"setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_check_box_focused.png");

            wifiPwdInputPWD.children[0].showPwd = false;
            wifiPwdInputPWD.setText(wifiPwdInput.text);
            for(var i=0;i<wifiPwdInput.text.length;i++){
                wifiPwdInputPWD.cursorRight();
            }
        }else{
            UI.setImage(checkboxComp,"setting/ic_check_box_normal.png");
            wifiPwdInputPWD.setText(wifiPwdInput.text);

            wifiPwdInputPWD.children[0].showPwd = true;
//            wifiPwdInputPWD.setText(wifiPwdInputPWD.children[0].realValue);
            wifiPwdInputPWD.setText(wifiPwdInput.text);
            for(var i=0;i<wifiPwdInput.text.length;i++){
                wifiPwdInputPWD.cursorRight();
            }
        }

        UI.updateStage();
    };

    checkboxBar.onkey_DOWN = function(){
        if(!wifiPwdInputConnectBtn.disable){
            UI.focusTo(wifiPwdInputConnectBtn);
        }else{
            UI.focusTo(wifiPwdInputCancelBtn);
        }
    };
    wifiPwdInputConnectBtn.onkey_ENTER = function(focus) {
        DBG_INFO("!!!!!!!!!!!!!!!!!!!PWD:"+wifiPwdInput.password);
//        wifiPwdInput.password = "12345678";
        var networkConfigPanel = UI.getSubModule("networkConfigPanel");
        if(networkConfigPanel.openFromPwd ==0 ){
            networkConfigPanel.openFromPwd = 2;
        }
        networkConfigPanel.currPassword = wifiPwdInput.password;
        UI.popSubModule();
    };
    wifiPwdInputCancelBtn.onkey_ENTER = function(focus) {
        var networkConfigPanel = UI.getSubModule("networkConfigPanel");
        networkConfigPanel.openFromPwd = 1;
        UI.popSubModule();
    };
    wifiPwdInput.onkey_BACKSPACE = function() {
        var networkConfigPanel = UI.getSubModule("networkConfigPanel");
        networkConfigPanel.openFromPwd = 1;
        UI.popSubModule();
    };
    wifiPwdInput.onPop = function(){
        var networkConfigPanel = UI.getSubModule("networkConfigPanel");
        DBG_ALWAYS("wifiPwdInput  onPop  !!!!!!!!!!!!!!!"+networkConfigPanel.openFromPwd );
        if(networkConfigPanel.openFromPwd ==2){
            networkConfigPanel.openFromPwd = 2;
        }else if(networkConfigPanel.openFromPwd ==3){
            networkConfigPanel.openFromPwd = 3;
        }
        else{
            networkConfigPanel.openFromPwd = 1;
        }
    }

};

