UI.moduleBuilder['setting']['storeModeMallLogo'] = function(){

    var mallLogoData = {
        mallLogoBgImg: UI.window_bg,
        mallLogoText:"[OT0320]"
    };
    var template = Util.readJson("module/setting/storeModeMallLogo.json");
    var storeModeMallLogo = SubModule.create(mallLogoData, template, "setting");
    var mallLogoText = UI.getItem(storeModeMallLogo, "mallLogoText");
    var logoAnchor = UI.getItem(storeModeMallLogo, "logoAnchor");
    var allMallLogos = [];
    var currLogoIdx = 0;
    try{
        var storeModeSettingMenu = UI.getSubModule("storeModeSettingMenu");
        storeModeSettingMenu.alpha = 0;
    }catch (ex){
        DBG_ERROR(ex);
    }
    storeModeMallLogo.onPush = function () {
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_STOREMODE_COPY_RETURN_CODE,upgradeMallLogoRetCodeChanged);
        initMainLogPageData();
        refreshMallLogo();
    };
    function getMallLogoPath(){
        try{
            var mallLogoPath = readFileFromNative('hisenseUI/storeModeMallLogo.txt', 1);
            DBG_INFO("getMallLogoPath:"+mallLogoPath);
            return mallLogoPath;
        }catch (ex){
            DBG_ERROR("getMallLogoPath:"+ex.message);
        }

        return mallLogoPath;
    }
    function setMallLogoPath(name){
        try{

            if(name == "0"){
                Hisense.File.delete('hisenseUI/storeModeMallLogo.txt',1);
            }else if(name == "mallLogo.png"){
                var path = "file:///var/local/mallLogo/"+name;
                writeFileToNative('hisenseUI/storeModeMallLogo.txt', path, 1);
            }else{
                var path = "file:///usr/local/opt/hisenseUI/html/hisenseUI/assets/ThemeDefault/Epos/mallLogo/"+name;
                writeFileToNative('hisenseUI/storeModeMallLogo.txt', path, 1);
            }
        }catch (ex){
            DBG_ERROR("setMallLogoPath:"+ex.message);
        }
        if(checkIsAppOn() && appControl.getCurrentAPPName() == APPNAME.EPOS){
            appControl.stopCurrentApp();
        }
    }
    function initMainLogPageData(){
        currLogoIdx = 0;
        allMallLogos = [];
        var mallLogoName = "0";
        var mallLogoPath = getMallLogoPath();
        if(mallLogoPath != null){
            var arr = mallLogoPath.split("/");
            mallLogoName = arr[arr.length -1];
        }
        allMallLogos.push({
            path: UI.btn_normal_bg,
            name:"[SE0275]",
            saveName:"0"
        });
        if(tv && Hisense.File.exists("mallLogo/mallLogo.png", 3)){
            allMallLogos.push({
                path: "/var/local/mallLogo/mallLogo.png?"+new Date(),
                name:"",//
                saveName:"mallLogo.png"
            });
            if(!!mallLogoName && mallLogoName == allMallLogos[allMallLogos.length - 1].saveName){
                currLogoIdx = allMallLogos.length - 1;
            }
        }
        var logNameArray = readAllMallLogo();
        for(var i = 0 ; i < logNameArray.length; i++){
            allMallLogos.push({
                path: "Epos/mallLogo/"+logNameArray[i],
                name:"",
                saveName:logNameArray[i]
            });
            if(!!mallLogoName && mallLogoName == allMallLogos[allMallLogos.length - 1].saveName){
                currLogoIdx = allMallLogos.length - 1;
            }
        }
        allMallLogos.push({
            path: UI.btn_normal_bg,
            name:"",
            saveName:""
        });
    }
    function refreshMallLogo() {
        try {
            logoAnchor.removeAllChildren();
            var gridInfo = {
                template: "mallLogoTemplate",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 4,
                distanceY: 30,
                distanceX: 30,
                container: logoAnchor
            };
            var allArray = [];
            for (var i = 0; i < allMallLogos.length; i++) {
                allArray.push(
                    {
                        chip_bg: allMallLogos[i].path,
                        chipText:allMallLogos[i].name,
                        chipImg : i == allMallLogos.length-1 ? "Epos/icon_add.png":"setting/blank.png",
                        chipImg2: currLogoIdx == i ?"Epos/ic_radio button_focuse.png":"setting/blank.png",
                        name: "item"+i,
                        voiceStr : allMallLogos[i].name
                    }
                )
            }
            Gird.create(allArray, gridInfo);
            UI.addMask(logoAnchor, 1680, 920, 60, 30);
            UI.setView(logoAnchor, 1680, 920);
            storeModeMallLogo.currFocus = logoAnchor.initSequence[currLogoIdx];
            if(UI.getCurrSubModule().name == "storeModeMallLogo"){
                UI.focusTo(logoAnchor.initSequence[currLogoIdx]);
            }
        } catch(ex){
            DBG_ERROR(ex.message);
        }

    }
    logoAnchor.onkey_ENTER = function(focus){
        var index = logoAnchor.initSequence.indexOf(focus);
        if(index == 0){
            for(var i = 0; i < logoAnchor.initSequence.length;i++){
                UI.setImage(logoAnchor.children[i].children[3],"setting/blank.png");
            }
            UI.setImage(storeModeMallLogo.currFocus.children[3],"Epos/ic_radio button_focuse.png");
            setMallLogoPath(allMallLogos[0].saveName);

        }else if(index == allMallLogos.length - 1){ // add
//            if(DiskList.length > 0){
//
//            }else{
//                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.NOUSBTIP;
//                UI.pushGhostModule("setting", "SettingSysToast");
//            }
            if(tv){
                try{
                    model.system.setUpgradeBuiltInVideoCopy("ML##mallLogo.png");
                }catch (ex){
                    DBG_ERROR("logoAnchor.onkey_ENTER:"+ex.message);
                }
            }else{
                upgradeMallLogoRetCodeChanged(2);
            }
        }else{
            for(var i = 0; i < logoAnchor.initSequence.length;i++){
                UI.setImage(logoAnchor.children[i].children[3],"setting/blank.png");
            }
            UI.setImage(storeModeMallLogo.currFocus.children[3],"Epos/ic_radio button_focuse.png");
            setMallLogoPath(allMallLogos[index].saveName);
        }

    }
    function readAllMallLogo(){
        var fileList = [];
        var fileStr = "";
        try{
            if(tv && Hisense.File.exists("hisenseUI/assets/ThemeDefault/Epos/mallLogo", 2)){
                fileStr =  Hisense.File.readdir("hisenseUI/assets/ThemeDefault/Epos/mallLogo", 2);
                //return is ".;..;"
                DBG_ERROR("readAllMallLogo:"+fileStr);
                fileList = fileStr.split(";");
                fileList.splice(0,2);
                fileList.pop();
            }
        }catch (ex){
            DBG_ERROR("readAllMallLogo:"+ex.message);
        }

//        else{
//            fileList = ["fte_app_ic_amzn.png","fte_app_ic_brsw.png","fte_app_ic_ntflx.png","fte_app_ic_ytb.png"]
//        }

        return fileList;
    }
    function upgradeMallLogoRetCodeChanged(code){
        DBG_INFO("upgradeMallLogoRetCodeChanged:"+code);
        switch (code){
            case 0://success
                if(UI.getCurrSubModule().name == 'storeModeMallLogoTipDialog'){
                    UI.popSubModule();
                }

                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.STORE_MODE_MALL_LOGO_SUCCESS;
                UI.pushGhostModule("setting", "SettingSysToast");
                setMallLogoPath("mallLogo.png");
                var mallLogoName = "mallLogo.png";
                if(tv && Hisense.File.exists("mallLogo/mallLogo.png", 3)){
                    for(var i = 0; i < allMallLogos.length;i++){
                        if(allMallLogos[i].saveName == mallLogoName){
                            allMallLogos.splice(i,1);
                            break;
                        }
                    }
                    var item = {
                        path: "/var/local/mallLogo/mallLogo.png?"+new Date(),
                        name:"",
                        saveName:"mallLogo.png"
                    }
                    allMallLogos.splice(allMallLogos.length-1,0,item);
                    currLogoIdx = allMallLogos.length - 2;
                    refreshMallLogo();
                }
                break;
            case 1://no usb
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.STORE_MODE_NO_USB_TIP;
                UI.pushGhostModule("setting", "SettingSysToast");
                break;
            case 2:
                UI.pushSubModule("setting", "storeModeMallLogoTipDialog", true,{"errorType":code});
                break;
            case 4:
                UI.pushSubModule("setting", "storeModeMallLogoTipDialog", true,{"errorType":code});
                break;
            default :
                break;
        }
    }
    storeModeMallLogo.onkey_BACKSPACE=function(){
        UI.popSubModule();
        storeModeSettingMenu.alpha = 1;
    };
    storeModeMallLogo.onPop = function(){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_STOREMODE_COPY_RETURN_CODE,upgradeMallLogoRetCodeChanged);
    };
};