// Init

UI.moduleBuilder['setting']['picWteBal10PotAdjust'] = function(){
    try {
        var initData = {
            percentBG: UI["liveTV_bg"],

            UpArrow: "setting/pic/card_wheel/UpArrow.png",
            DownArrow: "setting/pic/card_wheel/DownArrow.png",
            cardWheelBg: {color: getCardWheelColor()},
            cardWheelShadow: "setting/pic/card_wheel/shadow_top.png",
            cardWheelIcon_0: "setting/pic/card_wheel/level.png",
            cardWheelIcon_1: "setting/pic/card_wheel/red.png",
            cardWheelIcon_2: "setting/pic/card_wheel/green.png",
            cardWheelIcon_3: "setting/pic/card_wheel/blue.png"
        };
        var template = Util.readJsonObject("module/setting/picWteBal10PotAdjust.json");

        var pctCmpVec = ['Level', 'Red', 'Green', 'Blue'];
        var pctCmpLanVec = ['[SE0515]', '[SE0517]', '[SE0519]', '[SE0521]'];//专门为多语言添加
        var pctCmpDescriptionVec = ['[SE0516]', '[SE0518]', '[SE0520]', '[SE0522]'];

        for (var i = 0; i < pctCmpVec.length; i++) {
            template.picWteBal10PotAdjust.items[pctCmpVec[i]] = getObjCopy(Util.readJsonObject("templates/percentSingle.json")).percentBar;
            template.picWteBal10PotAdjust.items[pctCmpVec[i]].position.y = 0;
            template.picWteBal10PotAdjust.items[pctCmpVec[i]].items.title.value = pctCmpLanVec[i];
            template.picWteBal10PotAdjust.items[pctCmpVec[i]].items.description.value = pctCmpDescriptionVec[i];
            template.picWteBal10PotAdjust.items[pctCmpVec[i]].navigation =
            {
                "leftTo": null,
                "rightTo": null,
                "upTo": pctCmpVec[i - 1 >= 0 ? i - 1 : 3],
                "downTo": pctCmpVec[i + 1 <= 3 ? i + 1 : 0]
            };
            //"picWteBal10PotLevel"
            if (pctCmpVec[i] != PictureConfig.PicWteBal10PotSign.substr(14)) {
                template.picWteBal10PotAdjust.items[pctCmpVec[i]].position.y = 2000;
            }
        }

        var cardWheel = {
            "type": 0,
            "position": {
                "x": -250,
                "y": 20
            },
            "items": {}
        };

        var cardWheelItem = {
            "type": 0,
            "position": {
                "x": 0,
                "y": 124
            },
            "navigation": {
                "leftTo": null,
                "rightTo": null,
                "upTo": null,
                "downTo": null
            },
            "items": {
                "cardWheelBg": {
                    "type": 7,
                    "bound": {
                        "w": 230,
                        "h": 160
                    },
                    "position": {
                        "x": 0,
                        "y": 0
                    }
                },
                "cardWheelShadow": {
                    "type": 7,
                    "bound": {
                        "w": 280,
                        "h": 200
                    },
                    "position": {
                        "x": -30,
                        "y": -20
                    }
                },
                "cardWheelIcon": {
                    "type": 7,
                    "bound": {
                        "w": 72,
                        "h": 72
                    },
                    "position": {
                        "x": 79,
                        "y": 44
                    }
                }
            }
        };


        // 20 50 150 200 0
        //位置不准确，缩放为中心缩放
        var cardWheelItemIndexVec = [{y: 0}, {y: 95}, {y: 190}, {y: 95}];

        for (var i = 0; i < cardWheelItemIndexVec.length; i++) {
            var cardWheelItemTemp = getObjCopy(cardWheelItem);
            cardWheelItemTemp.position.y = cardWheelItemIndexVec[i].y;
            cardWheelItemTemp.items['cardWheelIcon_' + i] = getObjCopy(cardWheelItemTemp.items.cardWheelIcon);
            delete (cardWheelItemTemp.items.cardWheelIcon);
            cardWheel.items["cardWheel_" + i] = cardWheelItemTemp;
        }

        template.picWteBal10PotAdjust.items['cardWheel'] = cardWheel;

        var picWteBal10PotAdjust = SubModule.create(initData, template);
        picWteBal10PotAdjust.noAutoClose = true;
        //picPQAdjust.currFocus = UI.getItem(picPQAdjust, "ContrastPercentBar");


        var PicWteBal10PotAdjustPageData = {
            is20PointSupport: 1,
            LevelValTextVec: [5, 10, 15, 20, 25, 30, 35, 40, 45,
                50,55, 60, 65, 70, 75, 80, 85, 90, 95, 100],
            LevelVal: 0,
            RedVal: 0,
            GreenVal: 0,
            BlueVal: 0
        };
        PicWteBal10PotAdjustPageData.is20PointSupport = tv ? model.video.getwbfeature() : 1; //0:10point, 1:20point
        DBG_INFO("model.video.getwbfeature(): " + PicWteBal10PotAdjustPageData.is20PointSupport);

        DBG_INFO("PicTunerStep.HueStep: "+getPicHueStep());
        picWteBal10PotAdjust.onPush = function () {
            try {
                var CmpVec = [Level, Red, Green, Blue];

                for (var i = 0; i < CmpVec.length; i++) {
                    CmpVec[i].alpha = 0;
                    CmpVec[i].y = 0;
                }

                cardWheelObj.init();

                picWteBal10PotAdjust.currFocus = UI.getItem(picWteBal10PotAdjust, PictureConfig.PicWteBal10PotSign.substr(14));

                PicWteBal10PotAdjustPageInit();

                for (var i = 0; i < pctCmpVec.length; i++) {
                    var bar = eval(pctCmpVec[i]);
                    var cmp = UI.getItem(eval(pctCmpVec[i]), "percentBarLine");
                    setOnkeyLeftRightFunc(bar, cmp, eval('PicWteBal10PotAdjustPageData.' + pctCmpVec[i] + "Val"));
                }

                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        picWteBal10PotAdjust.onShow = function () {

            var normalCfg = {y: 0 + 175, alpha: 1};
            UI.getItem(picWteBal10PotAdjust, PictureConfig.PicWteBal10PotSign.substr(14)).alpha = 1;
            UI.getItem(picWteBal10PotAdjust, PictureConfig.PicWteBal10PotSign.substr(14)).y = normalCfg.y;
            UI.hideCursor();
        };

        function PicWteBal10PotAdjustPageInit() {
            try {
                if(PicWteBal10PotAdjustPageData.is20PointSupport) {
                    var LevelValTemp = tv ? model.video.get20pointwhitebalanceLevel() : 3;
                    DBG_INFO('model.video.get20pointwhitebalanceLevel(): ' + LevelValTemp);
                    PicWteBal10PotAdjustPageData.LevelVal = PicWteBal10PotAdjustPageData.LevelValTextVec[LevelValTemp];
                    UI.getItem(eval(pctCmpVec[0]), "percentBarLine").setPercentNoVoice(PicWteBal10PotAdjustPageData.LevelVal);


                    PicWteBal10PotAdjustPageData.RedVal = tv ? model.video.get20pintRed() : 0;
                    DBG_INFO('model.video.get20pintRed(): ' + PicWteBal10PotAdjustPageData.RedVal);
                    PicWteBal10PotAdjustPageData.RedVal=Math.round(PicWteBal10PotAdjustPageData.RedVal/PicTunerStep.HueStep);
                    UI.getItem(eval(pctCmpVec[1]), "percentBarLine").setPercentNoVoice(PicWteBal10PotAdjustPageData.RedVal);

                    PicWteBal10PotAdjustPageData.GreenVal = tv ? model.video.get20pintGreen() : 0;
                    DBG_INFO('model.video.get20pintGreen(): ' + PicWteBal10PotAdjustPageData.GreenVal);
                    PicWteBal10PotAdjustPageData.GreenVal=Math.round(PicWteBal10PotAdjustPageData.GreenVal/PicTunerStep.HueStep);
                    UI.getItem(eval(pctCmpVec[2]), "percentBarLine").setPercentNoVoice(PicWteBal10PotAdjustPageData.GreenVal);

                    PicWteBal10PotAdjustPageData.BlueVal = tv ? model.video.get20pintBlue() : 0;
                    DBG_INFO('model.video.get20pintBlue(): ' + PicWteBal10PotAdjustPageData.BlueVal);
                    PicWteBal10PotAdjustPageData.BlueVal=Math.round(PicWteBal10PotAdjustPageData.BlueVal/PicTunerStep.HueStep);
                    UI.getItem(eval(pctCmpVec[3]), "percentBarLine").setPercentNoVoice(PicWteBal10PotAdjustPageData.BlueVal);
                    var index=pctCmpVec.indexOf(PictureConfig.PicWteBal10PotSign.substr(14));
                    TTSCall(index);
                } else {
                    PicWteBal10PotAdjustPageData.LevelValTextVec = [10, 20, 30, 40, 50, 60, 70, 80, 90, 100];

                    var LevelValTemp = tv ? model.video.getLevel() : 3;
                    DBG_INFO('model.video.getLevel(): ' + LevelValTemp);
                    PicWteBal10PotAdjustPageData.LevelVal = PicWteBal10PotAdjustPageData.LevelValTextVec[LevelValTemp];
                    UI.getItem(eval(pctCmpVec[0]), "percentBarLine").setPercentNoVoice(PicWteBal10PotAdjustPageData.LevelVal);


                    PicWteBal10PotAdjustPageData.RedVal = tv ? model.video.getRed() : 0;
                    DBG_INFO('model.video.getRed(): ' + PicWteBal10PotAdjustPageData.RedVal);
                    PicWteBal10PotAdjustPageData.RedVal=Math.round(PicWteBal10PotAdjustPageData.RedVal/PicTunerStep.HueStep);
                    UI.getItem(eval(pctCmpVec[1]), "percentBarLine").setPercentNoVoice(PicWteBal10PotAdjustPageData.RedVal);

                    PicWteBal10PotAdjustPageData.GreenVal = tv ? model.video.getGreen() : 0;
                    DBG_INFO('model.video.getGreen(): ' + PicWteBal10PotAdjustPageData.GreenVal);
                    PicWteBal10PotAdjustPageData.GreenVal=Math.round(PicWteBal10PotAdjustPageData.GreenVal/PicTunerStep.HueStep);
                    UI.getItem(eval(pctCmpVec[2]), "percentBarLine").setPercentNoVoice(PicWteBal10PotAdjustPageData.GreenVal);

                    PicWteBal10PotAdjustPageData.BlueVal = tv ? model.video.getBlue() : 0;
                    DBG_INFO('model.video.getBlue(): ' + PicWteBal10PotAdjustPageData.BlueVal);
                    PicWteBal10PotAdjustPageData.BlueVal=Math.round(PicWteBal10PotAdjustPageData.BlueVal/PicTunerStep.HueStep);
                    UI.getItem(eval(pctCmpVec[3]), "percentBarLine").setPercentNoVoice(PicWteBal10PotAdjustPageData.BlueVal);
                    var index=pctCmpVec.indexOf(PictureConfig.PicWteBal10PotSign.substr(14));
                    TTSCall(index);
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function TTSCall(index){
            UI.callTTS(pctCmpLanVec[index]+eval("PicWteBal10PotAdjustPageData."+PictureConfig.PicWteBal10PotSign.substr(14)+"Val") + " ");
            DBG_INFO("UI.callTTS: "+ eval("PicWteBal10PotAdjustPageData."+PictureConfig.PicWteBal10PotSign.substr(14)+"Val"));
        }

        var Level = UI.getItem(picWteBal10PotAdjust, "Level");
        var Red = UI.getItem(picWteBal10PotAdjust, "Red");
        var Green = UI.getItem(picWteBal10PotAdjust, "Green");
        var Blue = UI.getItem(picWteBal10PotAdjust, "Blue");

        function CardWheelFunc() {

            var self = this;
            var cardWheelVec = [];
            self.cardWheelVec = cardWheelVec;
            var cardWheelLength = 4;

            for (var i = 0; i < cardWheelLength; i++) {
                self.cardWheelVec.push(UI.getItem(picWteBal10PotAdjust, "cardWheel_" + i));
            }
            var posYVec = [0 + 80, 95 + 80, 190 + 80, 95 + 80];
            var DelayTimeData = {
                Time_0: 0,
                Time_400: 400
            };
            var ToVecNumeber = {
                Vec0: 0,
                Vec1: 1,
                Vec2: 2
            };
            var ToYPosition = {
                Y_57: 57,
                Y_80: 80,
                Y_105: 105
            };

            //初始化，0位于最高的一个，当前哪个元素应该是Vector第一个
            self.setHeadIdx = function (idx) {
                try {
                    DBG_INFO('self.setHeadIdx: ' + idx);
                    //var concatPosYVec = posYVec.concat(posYVec);
                    for (var i = 0; i < idx; i++) {
                        cardWheelVec.unshift(cardWheelVec.pop());
                    }
                    getTweenTime(ToVecNumeber.Vec1,DelayTimeData.Time_0,ToYPosition.Y_80);
                    switchLayer(cardWheelVec)
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };


            //在onShow 函数里面调用init，太早会有问题
            self.init = function () {
                var PicWteBal10PotSignVec = ['picWteBal10PotLevel', 'picWteBal10PotRed', 'picWteBal10PotGreen', 'picWteBal10PotBlue'];
                var idx = PicWteBal10PotSignVec.indexOf(PictureConfig.PicWteBal10PotSign);

                cardWheelVec = [];
                for (var i = 0; i < cardWheelLength; i++) {
                    cardWheelVec.push(UI.getItem(picWteBal10PotAdjust, "cardWheel_" + i));
                    var cardWheelShadow = UI.getItem(cardWheelVec[cardWheelVec.length - 1], "cardWheelShadow");
                    cardWheelShadow.doFlip = true;
                }
                self.setHeadIdx(({0: 1, 1: 0, 2: 3, 3: 2}[idx]));
            };

            function switchLayer(cardWheelVec) {
                UI.moveTo(cardWheelVec[1], 3);
                UI.moveTo(cardWheelVec[2], 2);
                UI.moveTo(cardWheelVec[3], 1);
                UI.moveTo(cardWheelVec[0], 0);
            }


            self.keyUp = function () {
                cardWheelVec.unshift(cardWheelVec.pop());
                getTweenTime(ToVecNumeber.Vec0,DelayTimeData.Time_400,ToYPosition.Y_57);
            };

            self.keyDown = function () {
                cardWheelVec.push(cardWheelVec.shift());
                getTweenTime(ToVecNumeber.Vec2,DelayTimeData.Time_400,ToYPosition.Y_105);
            };

            function getTweenTime(number,time,position) {
                DBG_INFO('posYVec['+number + '] ' + 'delayTime:' + time + ' toPosition:' + position);
                UI.getTween(cardWheelVec[1]).to({y: posYVec[number], alpha: 1}, time/2, UI.ease.quadOut).call(switchLayer, [cardWheelVec]).to({
                    y: posYVec[1]
                }, time/2, UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10))).to({y: position}, time/2,UI.ease.quadOut).to({y:ToYPosition.Y_80,alpha: 1},time/2,UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10)).scale).to({x: 1, y: 1});

                UI.getTween(cardWheelVec[2]).to({y: posYVec[2], alpha: 0.8}, time);
                UI.getTween(UI.getItem(cardWheelVec[2],"cardWheelIcon_"+cardWheelVec[2].name.substr(10))).to({y: 105, alpha: 0.8}, 100);
                UI.getTween(UI.getItem(cardWheelVec[2],"cardWheelIcon_"+cardWheelVec[2].name.substr(10)).scale).to({x: 0.67, y: 0.67});
                UI.getTween(cardWheelVec[0]).to({y: posYVec[0], alpha: 0.8}, time);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10))).to({y: 57, alpha: 0.8}, 100);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10)).scale).to({x: 0.67, y: 0.67});


                UI.getTween(cardWheelVec[3]).to({y: posYVec[3], alpha: 0}, 0);
                UI.getTween(UI.getItem(cardWheelVec[3],"cardWheelIcon_"+cardWheelVec[3].name.substr(10))).to({y: 80, alpha: 0}, 100);
                UI.getTween(UI.getItem(cardWheelVec[3],"cardWheelIcon_"+cardWheelVec[3].name.substr(10)).scale).to({x: 1, y: 1});
            }

        }

        var cardWheelObj = new CardWheelFunc();


        function CreatePercent(cmp, cmpTxt, val) {
            try {
                if (cmp.parent.name == 'Level') {
                    if (PicWteBal10PotAdjustPageData.is20PointSupport) {
                        Percent.create(cmp, cmpTxt, val, 5, 100);
                    } else {
                        Percent.create(cmp, cmpTxt, val, 10, 100);
                    }
                } else {
                    Percent.create(cmp, cmpTxt, val, ColorTunerData.HueValMin, ColorTunerData.HueValMax);
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        Level.setRGBValue = function(){
            if (PicWteBal10PotAdjustPageData.is20PointSupport) {
                PicWteBal10PotAdjustPageData.RedVal = tv ? model.video.get20pintRed() : 0;
                DBG_INFO('model.video.get20pintRed(): ' + PicWteBal10PotAdjustPageData.RedVal);
                PicWteBal10PotAdjustPageData.RedVal=Math.round(PicWteBal10PotAdjustPageData.RedVal/PicTunerStep.HueStep);
                UI.getItem(eval(pctCmpVec[1]), "percentBarLine").setPercent(PicWteBal10PotAdjustPageData.RedVal);

                PicWteBal10PotAdjustPageData.GreenVal = tv ? model.video.get20pintGreen() : 0;
                DBG_INFO('model.video.get20pintGreen(): ' + PicWteBal10PotAdjustPageData.GreenVal);
                PicWteBal10PotAdjustPageData.GreenVal=Math.round(PicWteBal10PotAdjustPageData.GreenVal/PicTunerStep.HueStep);
                UI.getItem(eval(pctCmpVec[2]), "percentBarLine").setPercent(PicWteBal10PotAdjustPageData.GreenVal);

                PicWteBal10PotAdjustPageData.BlueVal = tv ? model.video.get20pintBlue() : 0;
                DBG_INFO('model.video.get20pintBlue(): ' + PicWteBal10PotAdjustPageData.BlueVal);
                PicWteBal10PotAdjustPageData.BlueVal=Math.round(PicWteBal10PotAdjustPageData.BlueVal/PicTunerStep.HueStep);
                UI.getItem(eval(pctCmpVec[3]), "percentBarLine").setPercent(PicWteBal10PotAdjustPageData.BlueVal);
            } else {
                PicWteBal10PotAdjustPageData.RedVal = tv ? model.video.getRed() : 0;
                DBG_INFO('model.video.getRed(): ' + PicWteBal10PotAdjustPageData.RedVal);
                PicWteBal10PotAdjustPageData.RedVal=Math.round(PicWteBal10PotAdjustPageData.RedVal/PicTunerStep.HueStep);
                UI.getItem(eval(pctCmpVec[1]), "percentBarLine").setPercent(PicWteBal10PotAdjustPageData.RedVal);

                PicWteBal10PotAdjustPageData.GreenVal = tv ? model.video.getGreen() : 0;
                DBG_INFO('model.video.getGreen(): ' + PicWteBal10PotAdjustPageData.GreenVal);
                PicWteBal10PotAdjustPageData.GreenVal=Math.round(PicWteBal10PotAdjustPageData.GreenVal/PicTunerStep.HueStep);
                UI.getItem(eval(pctCmpVec[2]), "percentBarLine").setPercent(PicWteBal10PotAdjustPageData.GreenVal);

                PicWteBal10PotAdjustPageData.BlueVal = tv ? model.video.getBlue() : 0;
                DBG_INFO('model.video.getBlue(): ' + PicWteBal10PotAdjustPageData.BlueVal);
                PicWteBal10PotAdjustPageData.BlueVal=Math.round(PicWteBal10PotAdjustPageData.BlueVal/PicTunerStep.HueStep);
                UI.getItem(eval(pctCmpVec[3]), "percentBarLine").setPercent(PicWteBal10PotAdjustPageData.BlueVal);
            }

            for (var i = 1; i < pctCmpVec.length; i++) {
                var bar = eval(pctCmpVec[i] );
                var cmp = UI.getItem(eval(pctCmpVec[i]), "percentBarLine");
                setOnkeyLeftRightFunc(bar, cmp, eval('PicWteBal10PotAdjustPageData.' + pctCmpVec[i] + "Val"));
            }
        };

        function setModelValue(name, val) {
            try {
                switch (name) {
                    case "Level":
                        var valTemp;
                        if (PicWteBal10PotAdjustPageData.is20PointSupport) {
                            valTemp = (val / 5) - 1;
                            tv && model.video.set20pointwhitebalanceLevel(valTemp);
                            DBG_INFO("model.video.set20pointwhitebalanceLevel(" + valTemp + ")");
                        } else {
                            valTemp = (val / 10) - 1;
                            tv && model.video.setLevel(valTemp);
                            DBG_INFO("model.video.setLevel(" + valTemp + ")");
                        }
                        Level.setRGBValue();
                        break;
                    case "Red":
                        var botValRed;
                        if (PicWteBal10PotAdjustPageData.is20PointSupport) {
                            botValRed = val*PicTunerStep.HueStep;
                            tv && model.video.set20pintRed(botValRed);
                            DBG_INFO("model.video.set20pintRed(" + botValRed + ")");
                        } else {
                            botValRed = val * PicTunerStep.HueStep;
                            tv && model.video.setRed(botValRed);
                            DBG_INFO("model.video.setRed(" + botValRed + ")");
                        }
                        break;
                    case "Green":
                        var botValGreen;
                        if (PicWteBal10PotAdjustPageData.is20PointSupport) {
                            botValGreen = val*PicTunerStep.HueStep;
                            tv && model.video.set20pintGreen(botValGreen);
                            DBG_INFO("model.video.set20pintGreen(" + botValGreen + ")");
                        } else {
                            botValGreen = val * PicTunerStep.HueStep;
                            tv && model.video.setGreen(botValGreen);
                            DBG_INFO("model.video.setGreen(" + botValGreen + ")");
                        }
                        break;
                    case "Blue":
                        var botValBlue;
                        if (PicWteBal10PotAdjustPageData.is20PointSupport) {
                            botValBlue = val*PicTunerStep.HueStep;
                            tv && model.video.set20pintBlue(botValBlue);
                            DBG_INFO("model.video.set20pintBlue(" + botValBlue + ")");
                        } else {
                            botValBlue = val * PicTunerStep.HueStep;
                            tv && model.video.setBlue(botValBlue);
                            DBG_INFO("model.video.setBlue(" + botValBlue + ")");
                        }
                        break;
                    default:
                        DBG_ERROR('name error');
                        break;
                }
                eval("PicWteBal10PotAdjustPageData."+name+"Val"+"=val");
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function setOnkeyLeftRightFunc(bar, comp, val) {

            bar.onkey_LEFT = function () {
                DBG_INFO(bar.name + "onkey_LEFT");
                var minVal = 0;
                if ('Level' == bar.name) {
                    if (PicWteBal10PotAdjustPageData.is20PointSupport) {
                        val -= 5;
                        minVal = 5;
                    } else {
                        val -= 10;
                        minVal = 10;
                    }
                } else {
                    val -= 1;
                    minVal = -10;
                }

                val < minVal && (val = minVal);
                comp.setPercent(val);
                setModelValue(bar.name, val);
            };
            bar.onkey_RIGHT = function () {
                DBG_INFO(bar.name + "onkey_RIGHT");
                var maxVal = 0;
                if ('Level' == bar.name) {
                    if (PicWteBal10PotAdjustPageData.is20PointSupport) {
                        val += 5;
                        maxVal = 100;
                    } else {
                        val += 10;
                        maxVal = 100;
                    }
                } else {
                    val += 1;
                    maxVal = 10;
                }

                val > maxVal && (val = maxVal);
                comp.setPercent(val);
                setModelValue(bar.name, val);
            };
            bar.onFocus = function () {
                return false;
            }
        }

        function setOnkeyUpDownFunc(cmpOri, cmpUpTo, cmpDownTo) {
            var topCfg = {y: -100 + 175, alpha: 0};
            var normalCfg = {y: 0 + 175, alpha: 1};
            var btmCfg = {y: 100 + 175, alpha: 0};

            cmpOri.onkey_UP = function (focus) {
                DBG_INFO(cmpOri.name + ".onkey_UP to " + cmpUpTo.name);
                UI.getTween(cmpOri).to(btmCfg, 300);
                UI.getTween(cmpUpTo).to(topCfg, 0).to(normalCfg, 400);
                picWteBal10PotAdjust.currFocus = UI.getItem(picWteBal10PotAdjust, focus.upTo);
                PictureConfig.PicWteBal10PotSign = "picWteBal10Pot"+cmpUpTo.name;
                DBG_INFO("PictureConfig.PicWteBal10PotSign: " + PictureConfig.PicWteBal10PotSign);
                var index=pctCmpVec.indexOf(PictureConfig.PicWteBal10PotSign.substr(14));
                TTSCall(index);
                cardWheelObj.keyUp();
            };

            cmpOri.onkey_DOWN = function (focus) {
                DBG_INFO(cmpOri.name + "onkey_DOWN");
                DBG_INFO(cmpDownTo.name + "onkey_DOWN");
                UI.getTween(cmpOri).to(topCfg, 300);
                UI.getTween(cmpDownTo).to(btmCfg, 0).to(normalCfg, 400);
                picWteBal10PotAdjust.currFocus = UI.getItem(picWteBal10PotAdjust, focus.downTo);
                PictureConfig.PicWteBal10PotSign = "picWteBal10Pot"+cmpDownTo.name;
                DBG_INFO("PictureConfig.PicWteBal10PotSign: " + PictureConfig.PicWteBal10PotSign);
                var index=pctCmpVec.indexOf(PictureConfig.PicWteBal10PotSign.substr(14));
                TTSCall(index);
                cardWheelObj.keyDown();
            };
        }

        function setOnkeyEnterFunc(cmp){
            cmp.onkey_ENTER = function (focus) {
                return false;
            }
        }
        setOnkeyEnterFunc(Level);
        setOnkeyEnterFunc(Red);
        setOnkeyEnterFunc(Green);
        setOnkeyEnterFunc(Blue);

        for (var i = 0; i < pctCmpVec.length; i++) {
            var bar = eval(pctCmpVec[i]);
            var cmp = UI.getItem(eval(pctCmpVec[i]), "percentBarLine");
            var cmpTxt = UI.getItem(eval(pctCmpVec[i]), "percentBarText");

            CreatePercent(cmp, cmpTxt, eval('PicWteBal10PotAdjustPageData.' + pctCmpVec[i] + "Val"));
            //setOnkeyLeftRightFunc(bar, cmp, eval('PicWteBal10PotAdjustPageData.' + pctCmpVec[i] + "Val")); //移到onPush里面去了，否则Val默认值变为0了
            setOnkeyUpDownFunc(bar, eval(pctCmpVec[i - 1 >= 0 ? i - 1 : i + 4 - 1]), eval(pctCmpVec[i + 1 <= 3 ? i + 1 : i - 4 + 1]));
        }

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};