// Init
UI.moduleBuilder['setting']['picPanelWhiteBalance'] = function(){
    try {
        var initImgData = {
            picPanelWhiteBalanceBg: UI.window_bg,
            picPanelBal2PotIcon:"setting/pic/linkage_point.png",
            picPanelWhiteBalanceSelectBar: UI.item_bg,
            picPanelBal2PotColorGamutBar: UI.item_bg,
            picPanelBal2PotROffsetBar: UI.item_bg,
            picPanelBal2PotGOffsetBar: UI.item_bg,
            picPanelBal2PotBOffsetBar: UI.item_bg,
            picPanelBal2PotRGainBar: UI.item_bg,
            picPanelBal2PotGGainBar: UI.item_bg,
            picPanelBal2PotBGainBar: UI.item_bg,
            picPanelBal2PotApplySelectBar: UI.item_bg,
            picPanelBal2PotResetBar: UI.item_bg,

            picPanelBal10PotIcon:"setting/pic/linkage_point.png",
            picPanelWhiteBalanceSelectArrowImg: 'setting/pic/select_down_arrow.png',
            picPanelBal10PotSwitchBar: UI.item_bg,
            picPanelBal10PotColorGamutBar: UI.item_bg,
            picPanelBal10PotLevelBar: UI.item_bg,
            picPanelBal10PotRedBar: UI.item_bg,
            picPanelBal10PotGreenBar: UI.item_bg,
            picPanelBal10PotBlueBar: UI.item_bg,
            picPanelBal10PotApplySelectBar: UI.item_bg,
            picPanelBal10PotResetBar: UI.item_bg
        };
        var template = Util.readJsonObject("module/setting/picPanelWhiteBalance.json");
        var picPanelWhiteBalance = SubModule.create(initImgData, template);
        picPanelWhiteBalance.noAutoClose = true;
        var picPanelWhiteBalanceGrp = UI.getItem(picPanelWhiteBalance, "picPanelWhiteBalanceGrp");
        var picPanelWhiteBalanceSelect = UI.getItem(picPanelWhiteBalanceGrp, "picPanelWhiteBalanceSelect");
        DBG_INFO("PicTunerStep.HueStep: "+getPicHueStep());
        UI.addMask(picPanelWhiteBalanceGrp, 850, 700, 80, 6);
        UI.setView(picPanelWhiteBalanceGrp, 850, 700);
        UI.addScrollbar(picPanelWhiteBalanceGrp, -6);

        var picWhtPageData = {
            pic2PotVec: ["ColorGamut","ROffset","GOffset","BOffset","RGain","GGain","BGain","Reset"],
            pic10PotVec: ["Switch","ColorGamut","Level","Red","Green","Blue","Reset"]
        };
        var WhiteBalanceFlag = {
            pot2:0,
            pot10:1
        };

        var PicPanelBal2PotPageData = {
            picPanelBal2PotColorGamutTextVec:['[GE0012]', '[SE2746]'],
            picPanelApplyWhiteBalanceTextVec: ["[SE3285]", "[SE3286]"],//["Current Picture Mode", "All Picture Mode"],
            ColorGamutExist: 0,
            picPanelBal2PotColorGamutVal: 0,
            picPanelBal2PotROffsetVal: 0,
            picPanelBal2PotGOffsetVal: 0,
            picPanelBal2PotBOffsetVal: 0,
            picPanelBal2PotRGainVal: 0,
            picPanelBal2PotGGainVal: 0,
            picPanelBal2PotBGainVal: 0,
            picPanelApplyWhiteBalanceVal: 0
        };
        var PicPanelBal10PotPageData = {
            is20PointSupport: 1,
            is10PointOn:0,
            ColorGamutExist: 0,
            picPanelBal10PotLevelTextVec: ["5", "10", "15", "20", "25", "30", "35", "40",
                "45", "50", "55", "60", "65", "70", "75", "80", "85", "90", "95", "100"],
            picPanelBal10PotColorGamutTextVec:['[GE0012]', '[SE2746]'],
            picPanelBal10PotApplySelectTextVec: ["[SE3285]", "[SE3286]"],

            picPanelBal10PotSwitchVal: 0,
            picPanelBal10PotColorGamutVal: 0,
            picPanelBal10PotLevelVal: 0,
            picPanelBal10PotRedVal: 0,
            picPanelBal10PotGreenVal: 0,
            picPanelBal10PotBlueVal: 0,
            picPanelBal10PotApplySelectVal: 0
        };
        PicPanelBal10PotPageData.is20PointSupport = tv ? model.video.getwbfeature() : 1; //1 : 20Point, 0 : 10Point
        DBG_INFO("model.video.getwbfeature(): " + PicPanelBal10PotPageData.is20PointSupport);

        picPanelWhiteBalance.onPush = function () {
            ModelNotifyInit();
            PictureConfig.PicOKOrCancelSign = PicSignDefine.PicOKOrCancelSign.PIC_CANCEL;
            PicPanelBal2PotPageInit();
            PicPanelBal10PotPageInit();
            setApplyHide2Pot();
            setApplyHide10Pot();
            picPanelWhiteBalance.currFocus = UI.getItem(picPanelWhiteBalance, "picPanelWhiteBalanceSelect");
//            model.video.onColorGamutChaged = onColorGamutChaged;
            UI.updateStage();
        };

        picPanelWhiteBalance.onShow = function () {
            var pot;
            if(PictureConfig.PicWteBalSign==PicSignDefine.PicWteBalSign.PIC_BALANCE_2_POT){
                pot=0;
            }else{
                pot=1;
            }
            if (PicPanelBal10PotPageData.is20PointSupport) {
                picPanelWhiteBalanceSelectCmp.changeValue(["[SE0496]", "[SE3565]"], pot);
            } else {
                picPanelWhiteBalanceSelectCmp.changeValue(["[SE0496]", "[SE0512]"], pot);
            }
            setPicWteBalHideOrShow(pot);
            ShowPicPanelBal();
        };

        function PicPanelBal2PotPageInit() {
            try {
                /*US market, ColorGamut is called color space in picture advanced*/
                PicPanelBal2PotPageData.ColorGamutExist = 0;//tv ? model.video.getColorSpaceExist() : 1;
                DBG_INFO("model.video.getColorSpaceExist(): " + PicPanelBal2PotPageData.ColorGamutExist);
                if(PicPanelBal2PotPageData.ColorGamutExist == 1){
                    PicPanelBal2PotPageData.picPanelBal2PotColorGamutVal = tv ? model.video.getColorSpace() : 1;//model.video.getColorSpace()
                    DBG_INFO('model.video.getColorSpace(): ' + PicPanelBal2PotPageData.picPanelBal2PotColorGamutVal);
                    onColorGamutChaged(PicPanelBal2PotPageData.picPanelBal2PotColorGamutVal);
                }else{
                    setColorGamutHide2Pot()
                }

                PicPanelBal2PotPageData.picPanelBal2PotROffsetVal = tv ? model.video.getRoffset() : 0;
                DBG_INFO('model.video.getRoffset(): ' + PicPanelBal2PotPageData.picPanelBal2PotROffsetVal);
                onRoffsetChaged(PicPanelBal2PotPageData.picPanelBal2PotROffsetVal);

                PicPanelBal2PotPageData.picPanelBal2PotGOffsetVal = tv ? model.video.getGoffset() : 1;
                DBG_INFO('model.video.getGoffset(): ' + PicPanelBal2PotPageData.picPanelBal2PotGOffsetVal);
                onGoffsetChaged(PicPanelBal2PotPageData.picPanelBal2PotGOffsetVal);

                PicPanelBal2PotPageData.picPanelBal2PotBOffsetVal = tv ? model.video.getBoffset() : 2;
                DBG_INFO('model.video.getBoffset(): ' + PicPanelBal2PotPageData.picPanelBal2PotBOffsetVal);
                onBoffsetChaged(PicPanelBal2PotPageData.picPanelBal2PotBOffsetVal);

                PicPanelBal2PotPageData.picPanelBal2PotRGainVal = tv ? model.video.getRgain() : 3;
                DBG_INFO('model.video.getRgain(): ' + PicPanelBal2PotPageData.picPanelBal2PotRGainVal);
                onRgainChaged(PicPanelBal2PotPageData.picPanelBal2PotRGainVal);

                PicPanelBal2PotPageData.picPanelBal2PotGGainVal = tv ? model.video.getGgain() : 4;
                DBG_INFO('model.video.getGgain(): ' + PicPanelBal2PotPageData.picPanelBal2PotGGainVal);
                onGgainChaged(PicPanelBal2PotPageData.picPanelBal2PotGGainVal);

                PicPanelBal2PotPageData.picPanelBal2PotBGainVal = tv ? model.video.getBgain() : 5;
                DBG_INFO('model.video.getBgain(): ' + PicPanelBal2PotPageData.picPanelBal2PotBGainVal);
                onBgainChaged(PicPanelBal2PotPageData.picPanelBal2PotBGainVal);

                PicPanelBal2PotPageData.picPanelApplyWhiteBalanceVal = tv ? model.video.getApply2p_wb() : 0;
                DBG_INFO("model.video.getApply2p_wb()" + PicPanelBal2PotPageData.picPanelApplyWhiteBalanceVal);
//                onApply2p_wbChaged(PicPanelBal2PotPageData.picPanelApplyWhiteBalanceVal);

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function PicPanelBal10PotPageInit() {
            try {
                if (PicPanelBal10PotPageData.is20PointSupport) {
                    // 20 point white balance
                    var pic10PointValue = UI.getItem(picPanelBal10PotSwitch, "picPanelBal10PotSwitchText");
                    pic10PointValue.alpha = 0;

                    PicPanelBal10PotPageData.picPanelBal10PotSwitchVal = tv ? model.video.getWhite_balance20Point() : 0;
                    DBG_INFO('model.video.getWhite_balance20Point(): ' + PicPanelBal10PotPageData.picPanelBal10PotSwitchVal);
                    onWhite_balance10PointChaged(PicPanelBal10PotPageData.picPanelBal10PotSwitchVal);

                    /*US market, ColorGamut is called color space in picture advanced*/
                    PicPanelBal10PotPageData.ColorGamutExist = 0;//tv ? model.video.getColorSpaceExist() : 1;
                    DBG_INFO("model.video.getColorSpaceExist(): " + PicPanelBal10PotPageData.ColorGamutExist);
                    if(PicPanelBal10PotPageData.ColorGamutExist == 1){
                        PicPanelBal10PotPageData.picPanelBal10PotColorGamutVal = tv ? model.video.getColorSpace() : 1;
                        DBG_INFO('model.video.getColorSpace(): ' + PicPanelBal10PotPageData.picPanelBal10PotColorGamutVal);
                        onColorGamutChaged(PicPanelBal10PotPageData.picPanelBal10PotColorGamutVal);
                    }else{
                        setColorGamutHide10Pot();
                    }

                    var picPanelBal10PotLevelValTemp = tv ? model.video.get20pointwhitebalanceLevel() : 1;
                    DBG_INFO('model.video.get20pointwhitebalanceLevel(): ' + picPanelBal10PotLevelValTemp);
                    PicPanelBal10PotPageData.picPanelBal10PotLevelVal = PicPanelBal10PotPageData.picPanelBal10PotLevelTextVec[picPanelBal10PotLevelValTemp];
                    onLevelChaged(picPanelBal10PotLevelValTemp);

                    PicPanelBal10PotPageData.picPanelBal10PotRedVal = tv ? model.video.get20pintRed() : 1;
                    DBG_INFO('model.video.get20pintRed(): ' + PicPanelBal10PotPageData.picPanelBal10PotRedVal);
                    onRedChaged(PicPanelBal10PotPageData.picPanelBal10PotRedVal);

                    PicPanelBal10PotPageData.picPanelBal10PotGreenVal = tv ? model.video.get20pintGreen() : 2;
                    DBG_INFO('model.video.get20pintGreen(): ' + PicPanelBal10PotPageData.picPanelBal10PotGreenVal);
                    onGreenChaged(PicPanelBal10PotPageData.picPanelBal10PotGreenVal);

                    PicPanelBal10PotPageData.picPanelBal10PotBlueVal = tv ? model.video.get20pintBlue() : 3;
                    DBG_INFO('model.video.get20pintBlue(): ' + PicPanelBal10PotPageData.picPanelBal10PotBlueVal);
                    onBlueChaged(PicPanelBal10PotPageData.picPanelBal10PotBlueVal);

                    PicPanelBal10PotPageData.picPanelBal10PotApplySelectVal = tv ? model.video.getApply20p_wb() : 0;
                    DBG_INFO("model.video.getApply20p_wb()" + PicPanelBal10PotPageData.picPanelBal10PotApplySelectVal);
                } else {
                    // 10 point white balance
                    PicPanelBal10PotPageData.picPanelBal10PotLevelTextVec = ["10", "20", "30", "40", "50", "60", "70", "80", "90", "100"];
                    var pic20PointValue = UI.getItem(picPanelBal10PotSwitch, "picPanelBal20PotSwitchText");
                    pic20PointValue.alpha = 0;

                    PicPanelBal10PotPageData.picPanelBal10PotSwitchVal = tv ? model.video.getWhite_balance10Point() : 0;
                    DBG_INFO('model.video.getWhite_balance10Point(): ' + PicPanelBal10PotPageData.picPanelBal10PotSwitchVal);
                    onWhite_balance10PointChaged(PicPanelBal10PotPageData.picPanelBal10PotSwitchVal);

                    /*US market, ColorGamut is called color space in picture advanced*/
                    PicPanelBal10PotPageData.ColorGamutExist = 0;//tv ? model.video.getColorSpaceExist() : 1;
                    DBG_INFO("model.video.getColorSpaceExist(): " + PicPanelBal10PotPageData.ColorGamutExist);
                    if(PicPanelBal10PotPageData.ColorGamutExist == 1){
                        PicPanelBal10PotPageData.picPanelBal10PotColorGamutVal = tv ? model.video.getColorSpace() : 1;
                        DBG_INFO('model.video.getColorSpace(): ' + PicPanelBal10PotPageData.picPanelBal10PotColorGamutVal);
                        onColorGamutChaged(PicPanelBal10PotPageData.picPanelBal10PotColorGamutVal);
                    }else{
                        setColorGamutHide10Pot();
                    }

                    var picPanelBal10PotLevelValTemp = tv ? model.video.getLevel() : 1;
                    DBG_INFO('model.video.getLevel(): ' + picPanelBal10PotLevelValTemp);
                    PicPanelBal10PotPageData.picPanelBal10PotLevelVal = PicPanelBal10PotPageData.picPanelBal10PotLevelTextVec[picPanelBal10PotLevelValTemp];
                    onLevelChaged(picPanelBal10PotLevelValTemp);

                    PicPanelBal10PotPageData.picPanelBal10PotRedVal = tv ? model.video.getRed() : 1;
                    DBG_INFO('model.video.getRed(): ' + PicPanelBal10PotPageData.picPanelBal10PotRedVal);
                    onRedChaged(PicPanelBal10PotPageData.picPanelBal10PotRedVal);

                    PicPanelBal10PotPageData.picPanelBal10PotGreenVal = tv ? model.video.getGreen() : 2;
                    DBG_INFO('model.video.getGreen(): ' + PicPanelBal10PotPageData.picPanelBal10PotGreenVal);
                    onGreenChaged(PicPanelBal10PotPageData.picPanelBal10PotGreenVal);

                    PicPanelBal10PotPageData.picPanelBal10PotBlueVal = tv ? model.video.getBlue() : 3;
                    DBG_INFO('model.video.getBlue(): ' + PicPanelBal10PotPageData.picPanelBal10PotBlueVal);
                    onBlueChaged(PicPanelBal10PotPageData.picPanelBal10PotBlueVal);

                    PicPanelBal10PotPageData.picPanelBal10PotApplySelectVal = tv ? model.video.getApply10p_wb() : 0;
                    DBG_INFO("model.video.getSource()" + PicPanelBal10PotPageData.picPanelBal10PotApplySelectVal);
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function setPicWteBalHideOrShow(val){
            if(val==WhiteBalanceFlag.pot2){
                for (var i= 0; i<picWhtPageData.pic2PotVec.length; i++){
                    eval("picPanelBal2Pot"+picWhtPageData.pic2PotVec[i]).alpha=1;
                    eval("picPanelBal2Pot"+picWhtPageData.pic2PotVec[i]).disable=false;
                }
                for (var i= 0; i<picWhtPageData.pic10PotVec.length; i++){
                    eval("picPanelBal10Pot"+picWhtPageData.pic10PotVec[i]).alpha=0;
                    eval("picPanelBal10Pot"+picWhtPageData.pic10PotVec[i]).disable=true;
                }
                setColorGamutHide2Pot();
                setColorGamutHide10Pot();
            }else if(val == WhiteBalanceFlag.pot10){
                for (var i= 0; i<picWhtPageData.pic2PotVec.length; i++){
                    eval("picPanelBal2Pot"+picWhtPageData.pic2PotVec[i]).alpha=0;
                    eval("picPanelBal2Pot"+picWhtPageData.pic2PotVec[i]).disable=true;
                }
                for (var i= 0; i<picWhtPageData.pic10PotVec.length; i++){
                    eval("picPanelBal10Pot"+picWhtPageData.pic10PotVec[i]).alpha=1;
                    eval("picPanelBal10Pot"+picWhtPageData.pic10PotVec[i]).disable=false;
                }
                setColorGamutHide2Pot();
                setColorGamutHide10Pot();
                SetBal10PotEnable(PicPanelBal10PotPageData.picPanelBal10PotSwitchVal);
            }
            UI.updateStage();
        }
        function setColorGamutHide2Pot(){
            try {
                picPanelBal2PotColorGamut.disable = true;
                picPanelBal2PotColorGamut.alpha = 0;
                if(picPanelBal2PotROffset.y == picPanelBal2PotColorGamut.y) return;
                picPanelBal2PotROffset.y = picPanelBal2PotColorGamut.y;
                var pic2PotVec = ["ROffset","GOffset","BOffset","RGain","GGain","BGain","Reset"];
                for (var i= 1; i<pic2PotVec.length; i++){
                    eval("picPanelBal2Pot"+pic2PotVec[i]).y  = eval("picPanelBal2Pot"+pic2PotVec[i-1]).y + 116;
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function setColorGamutHide10Pot(){
            try {
                picPanelBal10PotColorGamut.disable = true;
                picPanelBal10PotColorGamut.alpha = 0;
                if(picPanelBal10PotLevel.y == picPanelBal10PotColorGamut.y) return;
                picPanelBal10PotLevel.y = picPanelBal10PotColorGamut.y;
                var pic10PotVec = ["Level","Red","Green","Blue","Reset"];
                for (var i= 1; i<pic10PotVec.length; i++){
                    eval("picPanelBal10Pot"+pic10PotVec[i]).y  = eval("picPanelBal10Pot"+pic10PotVec[i-1]).y + 116;
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function setApplyHide2Pot(){
            picPanelBal2PotApplySelect.alpha=0;
            picPanelBal2PotApplySelect.disable=true;
//            picPanelBal2PotReset.y=picPanelBal2PotApplySelect.y;
//            UI.updateStage();
        }
        function setApplyHide10Pot(){
            picPanelBal10PotApplySelect.alpha=0;
            picPanelBal10PotApplySelect.disable=true;
//            picPanelBal10PotReset.y=picPanelBal10PotApplySelect.y;
//            UI.updateStage();
        }
        function SetBal10PotEnable(val) {
            DBG_INFO('SetBal10PotEnable: ' + val);
            var CmpLabelVec = [picPanelBal10PotColorGamut, picPanelBal10PotLevel, picPanelBal10PotRed, picPanelBal10PotGreen, picPanelBal10PotBlue];
            if(PicPanelBal10PotPageData.ColorGamutExist == 0){
                CmpLabelVec = [picPanelBal10PotLevel, picPanelBal10PotRed, picPanelBal10PotGreen, picPanelBal10PotBlue];
                picPanelBal10PotColorGamut.alpha=0;
                picPanelBal10PotColorGamut.disable=true;
            }else{
                picPanelBal10PotColorGamut.alpha=1;
                picPanelBal10PotColorGamut.disable=false;
            }
            if (false == val) {
                for (var i = 0; i < CmpLabelVec.length; i++) {
                    CmpLabelVec[i].alpha = 0.3;
                    CmpLabelVec[i].disable = true;
                }
//                picPanelBal10PotApplySelect.alpha = 0.3;
//                picPanelBal10PotApplySelect.disable =true;
                picPanelBal10PotReset.alpha = 0.3;
                picPanelBal10PotReset.disable =true;
            } else {
                for (var i = 0; i < CmpLabelVec.length; i++) {
                    CmpLabelVec[i].alpha = 1;
                    CmpLabelVec[i].disable = false;
                }
//                picPanelBal10PotApplySelect.alpha = 1;
//                picPanelBal10PotApplySelect.disable =false;
                picPanelBal10PotReset.alpha = 1;
                picPanelBal10PotReset.disable =false;
            }
            UI.updateStage();
        }
        function setColorGamutHide(){
            try {
                picPanelBal2PotColorGamut.disable = true;
                picPanelBal2PotColorGamut.alpha = 0;
                picPanelBal10PotColorGamut.disable = true;
                picPanelBal10PotColorGamut.alpha = 0;
                if(picPanelBal2PotROffset.y == picPanelBal2PotColorGamut.y
                    &&picPanelBal10PotLevel.y == picPanelBal10PotColorGamut.y) return;
                picPanelBal2PotROffset.y = picPanelBal2PotColorGamut.y;
                var pic2PotVec = ["ROffset","GOffset","BOffset","RGain","GGain","BGain","ApplySelect","Reset"];
                for (var i= 1; i<pic2PotVec.length; i++){
                    eval("picPanelBal2Pot"+pic2PotVec[i]).y  = eval("picPanelBal2Pot"+pic2PotVec[i-1]).y + 116;
                }
                picPanelBal10PotLevel.y = picPanelBal10PotColorGamut.y;
                var pic10PotVec = ["Level","Red","Green","Blue","ApplySelect","Reset"];
                for (var i= 1; i<pic10PotVec.length; i++){
                    eval("picPanelBal10Pot"+pic10PotVec[i]).y  = eval("picPanelBal10Pot"+pic10PotVec[i-1]).y + 116;
                }

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var picPanelWhiteBalanceSelectCmp = UI.getItem(picPanelWhiteBalanceSelect, "picPanelWhiteBalanceSelectCmp");
        var picPanelBal2PotColorGamut = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal2PotColorGamut");
        var picPanelBal2PotROffset = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal2PotROffset");
        var picPanelBal2PotGOffset = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal2PotGOffset");
        var picPanelBal2PotBOffset = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal2PotBOffset");
        var picPanelBal2PotRGain = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal2PotRGain");
        var picPanelBal2PotGGain = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal2PotGGain");
        var picPanelBal2PotBGain = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal2PotBGain");
        var picPanelBal2PotApplySelect = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal2PotApplySelect");
        var picPanelBal2PotApplySelectCmp = UI.getItem(picPanelBal2PotApplySelect, "picPanelBal2PotApplySelectCmp");
        var picPanelBal2PotReset = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal2PotReset");

        var picPanelBal10PotSwitch = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal10PotSwitch");
        var picPanelBal10PotColorGamut = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal10PotColorGamut");
        var picPanelBal10PotLevel = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal10PotLevel");
        var picPanelBal10PotRed = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal10PotRed");
        var picPanelBal10PotGreen = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal10PotGreen");
        var picPanelBal10PotBlue = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal10PotBlue");
        var picPanelBal10PotApplySelect = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal10PotApplySelect");
        var picPanelBal10PotApplySelectCmp = UI.getItem(picPanelBal10PotApplySelect, "picPanelBal10PotApplySelectCmp");
        var picPanelBal10PotReset = UI.getItem(picPanelWhiteBalanceGrp, "picPanelBal10PotReset");

        PointSelect(picPanelWhiteBalanceSelect,picPanelWhiteBalanceSelectCmp);
        function PointSelect(label, labelCmp){
            try{
                if(PicPanelBal10PotPageData.is20PointSupport) {
                    Select.create(labelCmp, ["[SE0496]", "[SE3565]"]);
                    labelCmp.changeValue(["[SE0496]", "[SE3565]"], 0);
                } else {
                    Select.create(labelCmp, ["[SE0496]", "[SE0512]"]);
                    labelCmp.changeValue(["[SE0496]", "[SE0512]"], 0);
                }
//                label.onFocus = function (focus) {
//                    labelCmp.onFocus();
////                    UI.setTextColor(labelCmp, "0xFFFFFF");
//                    return true;
//                };
                label.onkey_RIGHT = function () {
                    SetPointRightLeft();
                };
                label.onkey_LEFT = function () {
                    SetPointRightLeft();
                };
                label.onkey_ENTER = function () {
                    PictureConfig.picApplyModeSign = PicSignDefine.PicApplyModeSign.PIC_WHT_BAL_2POT_10POT;
                    UI.pushSubModule("setting", "picApplyMode", true);
                };
                function SetPointRightLeft(){
                    labelCmp.selectNext();
                    var index = labelCmp.values.indexOf(labelCmp.selected);
                    tv && model.video.setWhiteBalanceTenTwoPointsMode(index);
                    DBG_INFO('model.video.setWhiteBalanceTenTwoPointsMode(): '+index);
                    if(index==0){
                        PictureConfig.PicWteBalSign=PicSignDefine.PicWteBalSign.PIC_BALANCE_2_POT;
                    }else{
                        PictureConfig.PicWteBalSign=PicSignDefine.PicWteBalSign.PIC_BALANCE_10_POT;
                    }

                    setPicWteBalHideOrShow(index);
                }

            }catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

//        ApplySelectCommon(picPanelBal2PotApplySelect, picPanelBal2PotApplySelectCmp,WhiteBalanceFlag.pot2);
//        ApplySelectCommon(picPanelBal10PotApplySelect, picPanelBal10PotApplySelectCmp,WhiteBalanceFlag.pot10);
        function ApplySelectCommon(label, labelCmp,flag){
            try{
                Select.create(labelCmp, ["Current Picture Mode", "All Picture Mode"]);
//                label.onFocus = function (focus) {
//                    labelCmp.onFocus();
////                    UI.setTextColor(labelCmp, "0xFFFFFF");
//                    return true;
//                };
                label.onkey_RIGHT = function () {
                    SetApplyRightLeft(labelCmp);
                };
                label.onkey_LEFT = function () {
                    SetApplyRightLeft(labelCmp)
                };
                label.onkey_ENTER = function () {
                    if(flag==WhiteBalanceFlag.pot2){
                        PictureConfig.picApplyModeSign = PicSignDefine.PicApplyModeSign.PIC_APPLY_2P_WHITE_BALANCE;
                    }else{
                        PictureConfig.picApplyModeSign = PicSignDefine.PicApplyModeSign.PIC_APPLY_10P_WHITE_BALANCE;
                    }

                    UI.pushSubModule("setting", "picApplyMode", true);
                };
                function SetApplyRightLeft(labelCmp){
                    if(flag==WhiteBalanceFlag.pot2){
                        labelCmp.selectNext();
                        var index = labelCmp.values.indexOf(labelCmp.selected);
                        tv && model.video.setApply2p_wb(index);
                        DBG_INFO('model.video.setApply2p_wb(' + index + ')');
                    }else if(flag==WhiteBalanceFlag.pot10){
                        if(!!PicPanelBal10PotPageData.is10PointOn) {
                            labelCmp.selectNext();
                            var index = labelCmp.values.indexOf(labelCmp.selected);
                            if(PicPanelBal10PotPageData.is20PointSupport) {
                                tv && model.video.setApply20p_wb(index);
                                DBG_INFO('model.video.setApply20p_wb(' + index + ')');
                            } else {
                                tv && model.video.setApply10p_wb(index);
                                DBG_INFO('model.video.setApply10p_wb(' + index + ')');
                            }
                        }
                    }
                    UI.updateStage();

                }
            }catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        CreateSwitchBar();
        function CreateSwitchBar() {
            try {
                var switchComp = UI.getItem(picPanelBal10PotSwitch, "picPanelBal10PotSwitchOnOff");

                Switch.create(switchComp, ({0: false, 1: true}[PicPanelBal10PotPageData.picPanelBal10PotSwitchVal]));
                UI.updateStage();

                //picPanelBal10PotSwitch.onFocus = function (focus) {
                //    switchComp.onFocus();
                //    return true;
                //};
                //picPanelBal10PotSwitch.onNormal = function (focus) {
                //    switchComp.onNormal();
                //    return true;
                //};
                picPanelBal10PotSwitch.onkey_LEFT = function () {
                    SetSwitch();
                };
                picPanelBal10PotSwitch.onkey_RIGHT = function (focus) {
                    SetSwitch();
                };
                picPanelBal10PotSwitch.onkey_ENTER = function (focus) {
                    SetSwitch();
                };
                function SetSwitch(){
                    if(PicPanelBal10PotPageData.is20PointSupport) {
                        tv && model.video.setWhite_balance20Point(({false: 0, true: 1}[!switchComp.flag]));
                    } else {
                        tv && model.video.setWhite_balance10Point(({false: 0, true: 1}[!switchComp.flag]));
                    }
                    DBG_INFO('picPanelBal10PotSwitch.onkey_ENTER model.video.setWhite_balance10Point(' + ({false: 0, true: 1}[!switchComp.flag]) + ')');
                    switchComp.setSwitch(!switchComp.flag);
                    SetBal10PotEnable(!!switchComp.flag);
                    PicPanelBal10PotPageData.is10PointOn = switchComp.flag;
                    PicPanelBal10PotPageData.picPanelBal10PotSwitchVal = switchComp.flag;
                    switchComp.onFocus();
//                    SetRecentUse("[SE0512]", "Picture", "Advanced");
                    UI.updateStage();
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function ModelNotifyInit() {
            try {
//                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_GAMUT, onColorGamutChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_ROFFSET, onRoffsetChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GOFFSET, onGoffsetChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BOFFSET, onBoffsetChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_RGAIN, onRgainChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GGAIN, onGgainChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BGAIN, onBgainChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_APPLY_2POINT, onApply2p_wbChaged);

                if(PicPanelBal10PotPageData.is20PointSupport) {
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_20POINT, onWhite_balance10PointChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_20POINT_LEVEL, onLevelChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_20POINT_RED, onRedChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_20POINT_GREEN, onGreenChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_20POINT_BLUE, onBlueChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_APPLY_20POINT, onApply10p_wbChaged);
                } else {
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_10POINT, onWhite_balance10PointChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_LEVEL, onLevelChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_RED, onRedChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_GREEN, onGreenChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_BLUE, onBlueChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_APPLY_10POINT, onApply10p_wbChaged);
                }

//                model.video.onColorGamutChaged = onColorGamutChaged;
//                model.video.onRoffsetChaged = onRoffsetChaged;
//                model.video.onGoffsetChaged = onGoffsetChaged;
//                model.video.onBoffsetChaged = onBoffsetChaged;
//                model.video.onRgainChaged = onRgainChaged;
//                model.video.onGgainChaged = onGgainChaged;
//                model.video.onBgainChaged = onBgainChaged;
//                model.video.onApply2p_wbChaged = onApply2p_wbChaged;
//
//                model.video.onColorGamutChaged = onColorGamutChaged;
//                model.video.onWhite_balance10PointChaged = onWhite_balance10PointChaged;
//                model.video.onLevelChaged = onLevelChaged;
//                model.video.onRedChaged = onRedChaged;
//                model.video.onGreenChaged = onGreenChaged;
//                model.video.onBlueChaged = onBlueChaged;
//                model.video.onApply10p_wbChaged = onApply10p_wbChaged;
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var onColorGamutChaged = function (val) {
            try {
                DBG_INFO("onGamutChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotColorGamutVal = PicPanelBal2PotPageData.picPanelBal2PotColorGamutTextVec[val];
                UILabelSetVal(picPanelBal2PotColorGamut,0);

                PicPanelBal10PotPageData.picPanelBal10PotColorGamutVal = PicPanelBal10PotPageData.picPanelBal10PotColorGamutTextVec[val];
                UILabelSetVal(picPanelBal10PotColorGamut,1);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onRoffsetChaged = function (val) {
            try {
                DBG_INFO("onRoffsetChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotROffsetVal = val;
                UILabelSetVal(picPanelBal2PotROffset,0);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onGoffsetChaged = function (val) {
            try {
                DBG_INFO("onGoffsetChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotGOffsetVal = val;
                UILabelSetVal(picPanelBal2PotGOffset,0);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onBoffsetChaged = function (val) {
            try {
                DBG_INFO("onBoffsetChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotBOffsetVal = val;
                UILabelSetVal(picPanelBal2PotBOffset,0);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onRgainChaged = function (val) {
            try {
                DBG_INFO("onRgainChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotRGainVal = val;
                UILabelSetVal(picPanelBal2PotRGain,0);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onGgainChaged = function (val) {
            try {
                DBG_INFO("onGgainChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotGGainVal = val;
                UILabelSetVal(picPanelBal2PotGGain,0);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onBgainChaged = function (val) {
            try {
                DBG_INFO("onBgainChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotBGainVal = val;
                UILabelSetVal(picPanelBal2PotBGain,0);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onApply2p_wbChaged = function (val){
            try {
                DBG_INFO("onApply2p_wbChaged: " + val);
                picPanelBal2PotApplySelectCmp.changeValue(PicPanelBal2PotPageData.picPanelApplyWhiteBalanceTextVec, val);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        var onWhite_balance10PointChaged = function (val) {
            try {
                DBG_INFO('onWhite_balance10PointChaged: ' + val);
                PicPanelBal10PotPageData.picPanelBal10PotSwitchVal = val;
                var switchComp = UI.getItem(picPanelBal10PotSwitch, "picPanelBal10PotSwitchOnOff");
                switchComp.setSwitch(({0: false, 1: true}[val]));
                PicPanelBal10PotPageData.is10PointOn = switchComp.flag;
                DBG_INFO("PicPanelBal10PotPageData.is10PointOn: " + PicPanelBal10PotPageData.is10PointOn);
                if( (PictureConfig.PicOKOrCancelSign == PicSignDefine.PicOKOrCancelSign.PIC_OK)
                    && (!PicPanelBal10PotPageData.picPanelBal10PotSwitchVal)){
                    DBG_INFO("PictureConfig.PicOKOrCancelSign: " + PictureConfig.PicOKOrCancelSign);
                    UI.focusTo(UI.getItem(picPanelWhiteBalanceGrp, "picPanelWhiteBalanceSelect"));
                    PictureConfig.PicOKOrCancelSign = PicSignDefine.PicOKOrCancelSign.PIC_CANCEL;
                }
                SetBal10PotEnable(PicPanelBal10PotPageData.picPanelBal10PotSwitchVal);
                UI.updateStage();

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onLevelChaged = function (val) {
            try {
                DBG_INFO("onLevelChaged: " + val);
                PicPanelBal10PotPageData.picPanelBal10PotLevelVal = PicPanelBal10PotPageData.picPanelBal10PotLevelTextVec[val];
                PicPanelBal10PotPageData.picPanelBal10PotLevelVal = PicPanelBal10PotPageData.picPanelBal10PotLevelVal + '%';
                UILabelSetVal(picPanelBal10PotLevel,1);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onRedChaged = function (val) {
            try {
                DBG_INFO("onRedChaged: " + val);
                val=Math.round(val/PicTunerStep.HueStep);
                PicPanelBal10PotPageData.picPanelBal10PotRedVal = val;
                UILabelSetVal(picPanelBal10PotRed,1);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onGreenChaged = function (val) {
            try {
                DBG_INFO("onGreenChaged: " + val);
                val=Math.round(val/PicTunerStep.HueStep);
                PicPanelBal10PotPageData.picPanelBal10PotGreenVal = val;
                UILabelSetVal(picPanelBal10PotGreen,1);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onBlueChaged = function (val) {
            try {
                DBG_INFO("onBlueChaged: " + val);
                val=Math.round(val/PicTunerStep.HueStep);
                PicPanelBal10PotPageData.picPanelBal10PotBlueVal = val;
                UILabelSetVal(picPanelBal10PotBlue,1);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onApply10p_wbChaged = function (val) {
            try {
                DBG_INFO("onApply10p_wbChaged: " + val);
                picPanelBal10PotApplySelectCmp.changeValue(PicPanelBal10PotPageData.picPanelBal10PotApplySelectTextVec, val);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        function UILabelSetVal(label,flag) {
            try {
                if(flag==WhiteBalanceFlag.pot2){
                    UI.getItem(label, "textLabelValue").setValue(eval('PicPanelBal2PotPageData.' + label.name + "Val"));
                }else if(flag==WhiteBalanceFlag.pot10){
                    UI.getItem(label, "textLabelValue").setValue(eval('PicPanelBal10PotPageData.' + label.name + "Val"));
                }
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function CreateLabelFunc(label, labelStr,flag) {
            try {
                var fontSize = "36px SourceSansPro-Light";
                var cmpValue = UI.getItem(label, "textLabelValue");
                LabelValue.create(cmpValue, labelStr, fontSize);
                if(flag==WhiteBalanceFlag.pot2){
                    cmpValue.setValue(eval('PicPanelBal2PotPageData.' + label.name + "Val").toString());
                    label.onkey_ENTER = function () {
                        DBG_INFO(label.name + ".onkey_ENTER");
                        PictureConfig.PicWteBalSign=PicSignDefine.PicWteBalSign.PIC_BALANCE_2_POT;
                        if(label.name == "picPanelBal2PotColorGamut"){
                            PictureConfig.picModeSign = "picBalColorGamut";
                            DBG_INFO('PictureConfig.picModeSign: ' + PictureConfig.picModeSign);
                            UI.pushSubModule("setting", "picMode", true);
                        }else{
                            PictureConfig.PicWteBal2PotSign = 'picWte' + label.name.substr(8);
                            DBG_INFO('PictureConfig.PicWteBal2PotSign: ' + PictureConfig.PicWteBal2PotSign);
                            UI.pushSubModule("setting", "picWteBal2PotAdjust", true);
                        }
                        HidePicPanelBal();
                    };
                }else if(flag==WhiteBalanceFlag.pot10){
                    cmpValue.setValue(eval('PicPanelBal10PotPageData.' + label.name + "Val").toString());
                    label.onkey_ENTER = function () {
                        PictureConfig.PicWteBalSign=PicSignDefine.PicWteBalSign.PIC_BALANCE_10_POT;
                        if(!PicPanelBal10PotPageData.picPanelBal10PotSwitchVal){
                            UI.showSimpleTip("[SE3264]");//Please open main feature first
                        }else if(label.name == "picPanelBal10PotColorGamut") {
                            PictureConfig.picModeSign = "picBalColorGamut";
                            DBG_INFO('PictureConfig.picModeSign: ' + PictureConfig.picModeSign);
                            UI.pushSubModule("setting", "picMode", true);
                            HidePicPanelBal();
                        }else{
                            PictureConfig.PicWteBal10PotSign = 'picWte' + label.name.substr(8);
                            DBG_INFO('PictureConfig.PicWteBal10PotSign: ' + PictureConfig.PicWteBal10PotSign);
                            HidePicPanelBal();
                            UI.pushSubModule("setting", "picWteBal10PotAdjust", true);
                        }
                        DBG_INFO(label.name + ".onkey_ENTER");
                    };
                }
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        CreateLabelFunc(picPanelBal2PotColorGamut, "[SE2745] ",0);
        CreateLabelFunc(picPanelBal2PotROffset, "[SE0497] ",0);
        CreateLabelFunc(picPanelBal2PotGOffset, "[SE0499] ",0);
        CreateLabelFunc(picPanelBal2PotBOffset, "[SE0501] ",0);
        CreateLabelFunc(picPanelBal2PotRGain, "[SE0503] ",0);
        CreateLabelFunc(picPanelBal2PotGGain, "[SE0505] ",0);
        CreateLabelFunc(picPanelBal2PotBGain, "[SE0507] ",0);

        CreateLabelFunc(picPanelBal10PotColorGamut, "[SE2745] ",1);
        CreateLabelFunc(picPanelBal10PotLevel, "[SE0515] ",1);
        CreateLabelFunc(picPanelBal10PotRed, "[SE0517] ",1);
        CreateLabelFunc(picPanelBal10PotGreen, "[SE0519] ",1);
        CreateLabelFunc(picPanelBal10PotBlue, "[SE0521] ",1);


        picPanelBal2PotReset.onkey_ENTER = function () {
            DBG_INFO('picPanelBal2PotReset.onkey_ENTER');
            HidePicPanelBal();
            PictureConfig.PicWteBalSign=PicSignDefine.PicWteBalSign.PIC_BALANCE_2_POT;
            PictureConfig.PicResetSign = PicSignDefine.PicResetSign.PIC_BALANCE_2_POT_RESET;
            UI.pushSubModule("setting", "picReset", true);
        };

        picPanelBal10PotReset.onkey_ENTER = function () {
            DBG_INFO('picPanelBal10PotReset.onkey_ENTER');
            HidePicPanelBal();
            PictureConfig.PicWteBalSign=PicSignDefine.PicWteBalSign.PIC_BALANCE_10_POT;
            if(!PicPanelBal10PotPageData.picPanelBal10PotSwitchVal){
                UI.showSimpleTip("[SE3264]");//Please open main feature first
            }else {
                PictureConfig.PicResetSign = PicSignDefine.PicResetSign.PIC_BALANCE_10_POT_RESET;
                UI.pushSubModule("setting", "picReset", true);
            }
        };

        function HidePicPanelBal() {
            picPanelWhiteBalance.alpha = 0;
        }
        function ShowPicPanelBal() {
            picPanelWhiteBalance.alpha = 1;
        }
        picPanelWhiteBalance.onPop = function(){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_ROFFSET, onRoffsetChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GOFFSET, onGoffsetChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BOFFSET, onBoffsetChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_RGAIN, onRgainChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GGAIN, onGgainChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BGAIN, onBgainChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_APPLY_2POINT, onApply2p_wbChaged);

            if(PicPanelBal10PotPageData.is20PointSupport) {
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_20POINT, onWhite_balance10PointChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_20POINT_LEVEL, onLevelChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_20POINT_RED, onRedChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_20POINT_GREEN, onGreenChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_20POINT_BLUE, onBlueChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_APPLY_20POINT, onApply10p_wbChaged);
            } else {
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_10POINT, onWhite_balance10PointChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_LEVEL, onLevelChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_RED, onRedChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_GREEN, onGreenChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_BLUE, onBlueChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_APPLY_10POINT, onApply10p_wbChaged);
            }
        }

    } catch (ex) {
        DBG_ERROR(ex.message);
    }


};
