// Init
UI.moduleBuilder['setting']['picPanelBal2Pot'] = function(){
    try {
        var initImgData = {
            picPanelBal2PotBg: UI.window_bg,
            picPanelBal2PotSelectArrowImg: 'setting/pic/select_down_arrow.png',
            picWteBalPointIcon:"setting/pic/linkage_point.png",
            picPanelBal2PotSelectBar: UI.item_bg,
            picPanelBal2PotROffsetBar: UI.item_bg,
            picPanelBal2PotGOffsetBar: UI.item_bg,
            picPanelBal2PotBOffsetBar: UI.item_bg,
            picPanelBal2PotRGainBar: UI.item_bg,
            picPanelBal2PotGGainBar: UI.item_bg,
            picPanelBal2PotBGainBar: UI.item_bg,
            picPanelBal2PotResetBar: UI.item_bg
        };
        var template = Util.readJsonObject("module/setting/picPanelBal2Pot.json");
        var picPanelBal2Pot = SubModule.create(initImgData, template);
        var picPanelBal2PotGrp = UI.getItem(picPanelBal2Pot, "picPanelBal2PotGrp");
        UI.addMask(picPanelBal2PotGrp, 850, 700, 80, 6);
        UI.setView(picPanelBal2PotGrp, 850, 700);
        UI.addScrollbar(picPanelBal2PotGrp, -6);
        picPanelBal2Pot.noAutoClose = true;

        var PicPanelBal2PotPageData = {
            picPanelBal2PotROffsetVal: 0,
            picPanelBal2PotGOffsetVal: 0,
            picPanelBal2PotBOffsetVal: 0,
            picPanelBal2PotRGainVal: 0,
            picPanelBal2PotGGainVal: 0,
            picPanelBal2PotBGainVal: 0
        };

        picPanelBal2Pot.onPush = function () {
            PicPanelBal2PotPageInit();
            UI.getCurrModule().currFocus = picPanelBal2Pot.currFocus = UI.getItem(picPanelBal2Pot, "picPanelBal2PotSelect");
            UI.updateStage();
        };

        picPanelBal2Pot.onShow = function () {
            picPanelBal2Pot.alpha = 1;
        };

        function PicPanelBal2PotPageInit() {
            try {
                PicPanelBal2PotPageData.picPanelBal2PotROffsetVal = tv ? model.video.getRoffset() : 0;
                DBG_INFO('model.video.getRoffset(): ' + PicPanelBal2PotPageData.picPanelBal2PotROffsetVal);
                onRoffsetChaged(PicPanelBal2PotPageData.picPanelBal2PotROffsetVal);

                PicPanelBal2PotPageData.picPanelBal2PotGOffsetVal = tv ? model.video.getGoffset() : 1;
                DBG_INFO('model.video.getGoffset(): ' + PicPanelBal2PotPageData.picPanelBal2PotGOffsetVal);
                onGoffsetChaged(PicPanelBal2PotPageData.picPanelBal2PotGOffsetVal);

                PicPanelBal2PotPageData.picPanelBal2PotBOffsetVal = tv ? model.video.getBoffset() : 2;
                DBG_INFO('model.video.getBoffset(): ' + PicPanelBal2PotPageData.picPanelBal2PotBOffsetVal);
                onBoffsetChaged(PicPanelBal2PotPageData.picPanelBal2PotBOffsetVal);

                PicPanelBal2PotPageData.picPanelBal2PotRGainVal = tv ? model.video.getRgain() : 3;
                DBG_INFO('model.video.getRgain(): ' + PicPanelBal2PotPageData.picPanelBal2PotRGainVal);
                onRgainChaged(PicPanelBal2PotPageData.picPanelBal2PotRGainVal);

                PicPanelBal2PotPageData.picPanelBal2PotGGainVal = tv ? model.video.getGgain() : 4;
                DBG_INFO('model.video.getGgain(): ' + PicPanelBal2PotPageData.picPanelBal2PotGGainVal);
                onGgainChaged(PicPanelBal2PotPageData.picPanelBal2PotGGainVal);

                PicPanelBal2PotPageData.picPanelBal2PotBGainVal = tv ? model.video.getBgain() : 5;
                DBG_INFO('model.video.getBgain(): ' + PicPanelBal2PotPageData.picPanelBal2PotBGainVal);
                onBgainChaged(PicPanelBal2PotPageData.picPanelBal2PotBGainVal);


            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var picPanelBal2PotSelect = UI.getItem(picPanelBal2Pot, "picPanelBal2PotSelect");
        var picPanelBal2PotROffset = UI.getItem(picPanelBal2Pot, "picPanelBal2PotROffset");
        var picPanelBal2PotGOffset = UI.getItem(picPanelBal2Pot, "picPanelBal2PotGOffset");
        var picPanelBal2PotBOffset = UI.getItem(picPanelBal2Pot, "picPanelBal2PotBOffset");
        var picPanelBal2PotRGain = UI.getItem(picPanelBal2Pot, "picPanelBal2PotRGain");
        var picPanelBal2PotGGain = UI.getItem(picPanelBal2Pot, "picPanelBal2PotGGain");
        var picPanelBal2PotBGain = UI.getItem(picPanelBal2Pot, "picPanelBal2PotBGain");
        var picPanelBal2PotReset = UI.getItem(picPanelBal2Pot, "picPanelBal2PotReset");


        var picPanelBal2PotSelectText = UI.getItem(picPanelBal2PotSelect, "picPanelBal2PotSelectText");
        var picPanelBal2PotSelectCmp = UI.getItem(picPanelBal2PotSelect, "picPanelBal2PotSelectCmp");
        Select.create(picPanelBal2PotSelectCmp, ["[SE0496]", "[SE0512]"]);
        picPanelBal2PotSelectCmp.changeValue(["[SE0496]", "[SE0512]"], 0);
        picPanelBal2PotSelect.onFocus = function (focus) {
            picPanelBal2PotSelectCmp.onFocus();
            //UI.setTextColor(picPanelBal2PotSelectText, "#FFFFFF");
//            UI.setTextColor(picPanelBal2PotSelectCmp, "rgba(255,255,255,0.6)");
            return true;
        };
//        picPanelBal2PotSelect.onNormal = function (focus) {
//            //picPanelBal2PotSelectCmp.onNormal();
//            //UI.setTextColor(picPanelBal2PotSelectText, "#CCCCCC");
//            UI.setTextColor(picPanelBal2PotSelectCmp, "rgba(255,255,255,0.4)");
//            return true;
//        };
        picPanelBal2PotSelect.onkey_RIGHT = function () {
            tv && model.video.setWhiteBalanceTenTwoPointsMode(1);
            DBG_INFO('model.video.setWhiteBalanceTenTwoPointsMode(1)');
            UI.popSubModule();
            UI.getSubModule("picExpert").alpha = 0;
            UI.pushSubModule("setting", "picPanelBal10Pot", true);
            //picPanelBal2PotSelectCmp.selectNext();
            //UI.updateStage();
        };
        picPanelBal2PotSelect.onkey_LEFT = function () {
            tv && model.video.setWhiteBalanceTenTwoPointsMode(1);
            DBG_INFO('model.video.setWhiteBalanceTenTwoPointsMode(1)');
            UI.popSubModule();
            UI.getSubModule("picExpert").alpha = 0;

            UI.pushSubModule("setting", "picPanelBal10Pot", true);
            //picPanelBal2PotSelectCmp.selectPrev();
            //UI.updateStage();
        };

        picPanelBal2PotSelect.onkey_ENTER = function () {
            UI.pushSubModule("setting", "picBal2Pot10Pot", true);
        };

        function ModelNotifyInit() {
            try {
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_ROFFSET, onRoffsetChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GOFFSET, onGoffsetChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BOFFSET, onBoffsetChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_RGAIN, onRgainChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GGAIN, onGgainChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BGAIN, onBgainChaged);

//                model.video.onRoffsetChaged = onRoffsetChaged;
//                model.video.onGoffsetChaged = onGoffsetChaged;
//                model.video.onBoffsetChaged = onBoffsetChaged;
//                model.video.onRgainChaged = onRgainChaged;
//                model.video.onGgainChaged = onGgainChaged;
//                model.video.onBgainChaged = onBgainChaged;
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var onRoffsetChaged = function (val) {
            try {
                DBG_INFO("onRoffsetChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotROffsetVal = val;
                UILabelSetVal(picPanelBal2PotROffset);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onGoffsetChaged = function (val) {
            try {
                DBG_INFO("onGoffsetChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotGOffsetVal = val;
                UILabelSetVal(picPanelBal2PotGOffset);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onBoffsetChaged = function (val) {
            try {
                DBG_INFO("onBoffsetChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotBOffsetVal = val;
                UILabelSetVal(picPanelBal2PotBOffset);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onRgainChaged = function (val) {
            try {
                DBG_INFO("onRgainChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotRGainVal = val;
                UILabelSetVal(picPanelBal2PotRGain);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onGgainChaged = function (val) {
            try {
                DBG_INFO("onGgainChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotGGainVal = val;
                UILabelSetVal(picPanelBal2PotGGain);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onBgainChaged = function (val) {
            try {
                DBG_INFO("onBgainChaged: " + val);
                PicPanelBal2PotPageData.picPanelBal2PotBGainVal = val;
                UILabelSetVal(picPanelBal2PotBGain);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        function UILabelSetVal(label) {
            try {
                UI.getItem(label, "textLabelValue").setValue(eval('PicPanelBal2PotPageData.' + label.name + "Val"));
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function CreateLabelFunc(label, labelStr) {
            try {

                var fontSize = "36px SourceSansPro-Light";
                var cmpValue = UI.getItem(label, "textLabelValue");
                LabelValue.create(cmpValue, labelStr, fontSize);

                cmpValue.setValue(eval('PicPanelBal2PotPageData.' + label.name + "Val").toString());

                //label.updateCache();
                UI.updateStage();
                label.onkey_ENTER = function () {
                    //picPanelBal2PotROffset            //picWteBal2PotROffset
                    PictureConfig.PicWteBal2PotSign = 'picWte' + label.name.substr(8);
                    DBG_INFO('PictureConfig.PicWteBal2PotSign: ' + PictureConfig.PicWteBal2PotSign);
                    HidePicPanelBal2Pot();

                    UI.pushSubModule("setting", "picWteBal2PotAdjust", true);
                    DBG_INFO(label.name + ".onkey_ENTER");
                };
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        CreateLabelFunc(picPanelBal2PotROffset, "[SE0497]");
        CreateLabelFunc(picPanelBal2PotGOffset, "[SE0499]");
        CreateLabelFunc(picPanelBal2PotBOffset, "[SE0501]");
        CreateLabelFunc(picPanelBal2PotRGain, "[SE0503]");
        CreateLabelFunc(picPanelBal2PotGGain, "[SE0505]");
        CreateLabelFunc(picPanelBal2PotBGain, "[SE0507]");


        picPanelBal2PotReset.onkey_ENTER = function () {
            DBG_INFO('picPanelBal2PotReset.onkey_ENTER');
            //HidePicPanelBal2Pot();
            PictureConfig.PicResetSign = PicSignDefine.PicResetSign.PIC_BALANCE_2_POT_RESET;
            UI.pushSubModule("setting", "picReset", true);
        };

        function HidePicPanelBal2Pot() {
            picPanelBal2Pot.alpha = 0;
        }

        ModelNotifyInit();
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};
