UI.moduleBuilder['setting']['picPanelBal10Pot'] = function(){
    try {
        var initImgData = {
            picPanelBal10PotBg: UI.window_bg,
            picWteBalPointIcon:"setting/pic/linkage_point.png",
            picPanelBal10PotSelectBar: UI.item_bg,
            picPanelBal10PotSwitchBar: UI.item_bg,
            picPanelBal10PotLevelBar: UI.item_bg,
            picPanelBal10PotRedBar: UI.item_bg,
            picPanelBal10PotGreenBar: UI.item_bg,
            picPanelBal10PotBlueBar: UI.item_bg,
            picPanelBal10PotResetBar: UI.item_bg
        };
        var template = Util.readJsonObject("module/setting/picPanelBal10Pot.json");
        var picPanelBal10Pot = SubModule.create(initImgData, template);
        var picPanelBal10PotGrp = UI.getItem(picPanelBal10Pot, "picPanelBal10PotGrp");
        UI.addMask(picPanelBal10PotGrp, 850, 700, 80, 6);
        UI.setView(picPanelBal10PotGrp, 850, 700);
        UI.addScrollbar(picPanelBal10PotGrp, -6);
        picPanelBal10Pot.noAutoClose = true;
        picPanelBal10Pot.currFocus = UI.getItem(picPanelBal10Pot, "picPanelBal10PotSelect");

        picPanelBal10Pot.onPush = function () {
            PictureConfig.PicOKOrCancelSign = PicSignDefine.PicOKOrCancelSign.PIC_CANCEL;
            PicPanelBal10PotPageInit();
            UI.getCurrModule().currFocus = picPanelBal10Pot.currFocus = UI.getItem(picPanelBal10Pot, "picPanelBal10PotSelect");
            UI.updateStage();
        };

        picPanelBal10Pot.onShow = function () {
            picPanelBal10Pot.alpha = 1;
        };

        var PicPanelBal10PotPageData = {
            picPanelBal10PotLevelTextVec: ["10", "20", "30", "40", "50", "60", "70", "80", "90", "100"],
            picPanelBal10PotSwitchVal: 0,
            picPanelBal10PotLevelVal: 0,
            picPanelBal10PotRedVal: 0,
            picPanelBal10PotGreenVal: 0,
            picPanelBal10PotBlueVal: 0
        };
        DBG_INFO("PicTunerStep.HueStep: "+getPicHueStep());

        function PicPanelBal10PotPageInit() {
            try {
                PicPanelBal10PotPageData.picPanelBal10PotSwitchVal = tv ? model.video.getWhite_balance10Point() : 1;
                DBG_INFO('model.video.getWhite_balance10Point(): ' + PicPanelBal10PotPageData.picPanelBal10PotSwitchVal);
                onWhite_balance10PointChaged(PicPanelBal10PotPageData.picPanelBal10PotSwitchVal);

                var picPanelBal10PotLevelValTemp = tv ? model.video.getLevel() : 1;
                DBG_INFO('model.video.getLevel(): ' + picPanelBal10PotLevelValTemp);
                PicPanelBal10PotPageData.picPanelBal10PotLevelVal = PicPanelBal10PotPageData.picPanelBal10PotLevelTextVec[picPanelBal10PotLevelValTemp];
                onLevelChaged(picPanelBal10PotLevelValTemp);

                PicPanelBal10PotPageData.picPanelBal10PotRedVal = tv ? model.video.getRed() : 1;
                DBG_INFO('model.video.getRed(): ' + PicPanelBal10PotPageData.picPanelBal10PotRedVal);
//                PicPanelBal10PotPageData.picPanelBal10PotRedVal=Math.round(PicPanelBal10PotPageData.picPanelBal10PotRedVal/PicTunerStep.HueStep);
                onRedChaged(PicPanelBal10PotPageData.picPanelBal10PotRedVal);

                PicPanelBal10PotPageData.picPanelBal10PotGreenVal = tv ? model.video.getGreen() : 2;
                DBG_INFO('model.video.getGreen(): ' + PicPanelBal10PotPageData.picPanelBal10PotGreenVal);
//                PicPanelBal10PotPageData.picPanelBal10PotGreenVal=Math.round(PicPanelBal10PotPageData.picPanelBal10PotGreenVal/PicTunerStep.HueStep);
                onGreenChaged(PicPanelBal10PotPageData.picPanelBal10PotGreenVal);

                PicPanelBal10PotPageData.picPanelBal10PotBlueVal = tv ? model.video.getBlue() : 3;
                DBG_INFO('model.video.getBlue(): ' + PicPanelBal10PotPageData.picPanelBal10PotBlueVal);
//                PicPanelBal10PotPageData.picPanelBal10PotBlueVal=Math.round(PicPanelBal10PotPageData.picPanelBal10PotBlueVal/PicTunerStep.HueStep);
                onBlueChaged(PicPanelBal10PotPageData.picPanelBal10PotBlueVal);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }


        var picPanelBal10PotSelect = UI.getItem(picPanelBal10Pot, "picPanelBal10PotSelect");
        var picPanelBal10PotSwitch = UI.getItem(picPanelBal10Pot, "picPanelBal10PotSwitch");
        var picPanelBal10PotLevel = UI.getItem(picPanelBal10Pot, "picPanelBal10PotLevel");
        var picPanelBal10PotRed = UI.getItem(picPanelBal10Pot, "picPanelBal10PotRed");
        var picPanelBal10PotGreen = UI.getItem(picPanelBal10Pot, "picPanelBal10PotGreen");
        var picPanelBal10PotBlue = UI.getItem(picPanelBal10Pot, "picPanelBal10PotBlue");
        var picPanelBal10PotReset = UI.getItem(picPanelBal10Pot, "picPanelBal10PotReset");


        var picPanelBal10PotSelectText = UI.getItem(picPanelBal10PotSelect, "picPanelBal10PotSelectText");
        var picPanelBal10PotSelectCmp = UI.getItem(picPanelBal10PotSelect, "picPanelBal10PotSelectCmp");
        Select.create(picPanelBal10PotSelectCmp, ["[SE0496]", "[SE0512]"]);
        picPanelBal10PotSelectCmp.changeValue(["[SE0496]", "[SE0512]"], 1);
        picPanelBal10PotSelect.onFocus = function (focus) {
            picPanelBal10PotSelectCmp.onFocus();
            return true;
        };
        picPanelBal10PotSelect.onkey_RIGHT = picPanelBal10PotSelect.onkey_LEFT = function () {
            PointSelectHandler();
        };
        picPanelBal10PotSelect.onkey_ENTER = function () {
            UI.pushSubModule("setting", "picBal2Pot10Pot", true);
        };
        function PointSelectHandler(){
            try {
                tv && model.video.setWhiteBalanceTenTwoPointsMode(0);
                DBG_INFO('model.video.setWhiteBalanceTenTwoPointsMode(0)');
                UI.popSubModule();
                UI.getSubModule("picExpert").alpha = 0;
                UI.pushSubModule("setting", "picPanelBal2Pot", true);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function CreateSwitchBar() {
            try {
                var switchComp = UI.getItem(picPanelBal10PotSwitch, "picPanelBal10PotSwitchOnOff");
                Switch.create(switchComp, ({0: false, 1: true}[PicPanelBal10PotPageData.picPanelBal10PotSwitchVal]));
                UI.updateStage();

                picPanelBal10PotSwitch.onFocus = function (focus) {
                    switchComp.onFocus();
                    return true;
                };
                picPanelBal10PotSwitch.onNormal = function (focus) {
                    switchComp.onNormal();
                    return true;
                };
                picPanelBal10PotSwitch.onkey_LEFT = picPanelBal10PotSwitch.onkey_RIGHT
                    = picPanelBal10PotSwitch.onkey_ENTER = function (focus) {
                    Point10Switch()
                };
                function Point10Switch(){
                    try {
                        tv && model.video.setWhite_balance10Point(({false: 0, true: 1}[!switchComp.flag]));
                        DBG_INFO('model.video.setWhite_balance10Point(' + ({false: 0, true: 1}[!switchComp.flag]) + ')');
                        switchComp.switch();
                        SetBal10PotEnable(!!switchComp.flag);
                        switchComp.onFocus();
                        UI.updateStage();
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        CreateSwitchBar();

        function SetBal10PotEnable(val) {
            DBG_INFO('SetBal10PotEnable: ' + val);
            var CmpLabelVec = [picPanelBal10PotLevel, picPanelBal10PotRed, picPanelBal10PotGreen, picPanelBal10PotBlue];
            if (false == val) {
                for (var i = 0; i < CmpLabelVec.length; i++) {
                    UI.getItem(picPanelBal10Pot, CmpLabelVec[i].name).disable = true;
                    UI.getItem(picPanelBal10Pot, CmpLabelVec[i].name).alpha = 0.3;
                }
                picPanelBal10PotReset.disable = true;
                UI.getItem(picPanelBal10Pot, 'picPanelBal10PotReset').alpha = 0.3;
            } else {
                for (var i = 0; i < CmpLabelVec.length; i++) {
                    UI.getItem(picPanelBal10Pot, CmpLabelVec[i].name).disable = false;
                    UI.getItem(picPanelBal10Pot, CmpLabelVec[i].name).alpha = 1;
                }
                picPanelBal10PotReset.disable = false;
                UI.getItem(picPanelBal10Pot, 'picPanelBal10PotReset').alpha = 1;
            }
        }

        function CreateLabelFunc(label, labelStr) {
            try {
                var fontSize = "36px SourceSansPro-Light";
                var cmpValue = UI.getItem(label, "textLabelValue");
                LabelValue.create(cmpValue, labelStr, fontSize);
                cmpValue.setValue(eval('PicPanelBal10PotPageData.' + label.name + "Val").toString());
                UI.updateStage();
                label.onkey_ENTER = function () {
                    PictureConfig.PicWteBal10PotSign = 'picWte' + label.name.substr(8);
                    DBG_INFO('PictureConfig.PicWteBal10PotSign: ' + PictureConfig.PicWteBal10PotSign);
                    HidePicPanelBal10Pot();
                    UI.pushSubModule("setting", "picWteBal10PotAdjust", true);
                    DBG_INFO(label.name + ".onkey_ENTER");
                };
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        CreateLabelFunc(picPanelBal10PotLevel, "[SE0515]");
        CreateLabelFunc(picPanelBal10PotRed, "[SE0517]");
        CreateLabelFunc(picPanelBal10PotGreen, "[SE0519]");
        CreateLabelFunc(picPanelBal10PotBlue, "[SE0521]");

        picPanelBal10PotReset.onkey_ENTER = function () {
            DBG_INFO('picPanelBal10PotReset.onkey_ENTER');
            PictureConfig.PicResetSign = PicSignDefine.PicResetSign.PIC_BALANCE_10_POT_RESET;
            UI.pushSubModule("setting", "picReset", true);
            UI.updateStage();
        };


        function ModelNotifyInit() {
            try {
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_10POINT, onWhite_balance10PointChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_LEVEL, onLevelChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_RED, onRedChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_GREEN, onGreenChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BALANCE_BLUE, onBlueChaged);

//                model.video.onWhite_balance10PointChaged = onWhite_balance10PointChaged;
//                model.video.onLevelChaged = onLevelChaged;
//                model.video.onRedChaged = onRedChaged;
//                model.video.onGreenChaged = onGreenChaged;
//                model.video.onBlueChaged = onBlueChaged;
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var onWhite_balance10PointChaged = function (val) {
            try {
                DBG_INFO('onWhite_balance10PointChaged: ' + val);
                PicPanelBal10PotPageData.picPanelBal10PotSwitchVal = val;
                var switchComp = UI.getItem(picPanelBal10PotSwitch, "picPanelBal10PotSwitchOnOff");
                switchComp.setSwitch(({0: false, 1: true}[val]));
                if( (PictureConfig.PicOKOrCancelSign == PicSignDefine.PicOKOrCancelSign.PIC_OK)
                    && (!PicPanelBal10PotPageData.picPanelBal10PotSwitchVal)){
                    DBG_INFO("PictureConfig.PicOKOrCancelSign: " + PictureConfig.PicOKOrCancelSign);
                    UI.focusTo(UI.getItem(picPanelBal10Pot, "picPanelBal10PotSelect"));
                    PictureConfig.PicOKOrCancelSign = PicSignDefine.PicOKOrCancelSign.PIC_CANCEL;
                }
                SetBal10PotEnable(PicPanelBal10PotPageData.picPanelBal10PotSwitchVal);
                UI.updateStage();

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onLevelChaged = function (val) {
            try {
                DBG_INFO("onLevelChaged: " + val);
                PicPanelBal10PotPageData.picPanelBal10PotLevelVal = PicPanelBal10PotPageData.picPanelBal10PotLevelTextVec[val];
                UILabelSetVal(picPanelBal10PotLevel);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onRedChaged = function (val) {
            try {
                DBG_INFO("onRedChaged: " + val);
                val=Math.round(val/PicTunerStep.HueStep);
                PicPanelBal10PotPageData.picPanelBal10PotRedVal = val;
                UILabelSetVal(picPanelBal10PotRed);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onGreenChaged = function (val) {
            try {
                DBG_INFO("onGreenChaged: " + val);
                val=Math.round(val/PicTunerStep.HueStep);
                PicPanelBal10PotPageData.picPanelBal10PotGreenVal = val;
                UILabelSetVal(picPanelBal10PotGreen);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onBlueChaged = function (val) {
            try {
                DBG_INFO("onBlueChaged: " + val);
                val=Math.round(val/PicTunerStep.HueStep);
                PicPanelBal10PotPageData.picPanelBal10PotBlueVal = val;
                UILabelSetVal(picPanelBal10PotBlue);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        function UILabelSetVal(label) {
            try {
                UI.getItem(label, "textLabelValue").setValue(eval('PicPanelBal10PotPageData.' + label.name + "Val"));
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        ModelNotifyInit();//This function must be put after the define of onChanged function.

        function HidePicPanelBal10Pot() {
            picPanelBal10Pot.alpha = 0;
        }

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};
