// Init
UI.moduleBuilder['setting']['picColorTunerAdjust'] = function(){
    try {
        // 初始化子模块
        var initImgData = {
//            bg: UI.window_bg,
            percentBG: UI["liveTV_bg"],
            UpArrow: "setting/pic/card_wheel/UpArrow.png",
            DownArrow: "setting/pic/card_wheel/DownArrow.png",
            cardWheelBg: {color: getCardWheelColor()},
            cardWheelShadow: "setting/pic/card_wheel/shadow_top.png",
            cardWheelIcon_0: "setting/pic/card_wheel/color_tuner.png",
            cardWheelIcon_1: "setting/pic/card_wheel/hue.png",
            cardWheelIcon_2: "setting/pic/card_wheel/saturation.png",
            cardWheelIcon_3: "setting/pic/card_wheel/brightness.png"
        };
        var template = Util.readJsonObject("module/setting/picColorTunerAdjust.json");

        var picColorTunerDataCfg = {
            picColorTunerColor:{
                title: '[SE1833]',
                description: '[SE2890]',
                array: [
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/red.png", tileTxt: "[SE0517]", Info:"[SE2890]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/green.png", tileTxt: "[SE0519]", Info:"[SE2890]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/blue.png", tileTxt: "[SE0521]", Info:"[SE2890]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/yellow.png", tileTxt: "[SE0536]", Info:"[SE2890]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/cyan.png", tileTxt: "[SE0537]", Info:"[SE2890]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/magenta.png", tileTxt: "[SE0538]", Info:"[SE2890]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/flesh_tone.png", tileTxt: "[SE2532]", Info:"[SE2890]"}
                ]
            }
        };
        template.picColorTunerAdjust.items.colorTunerColor.items.title.value = picColorTunerDataCfg.picColorTunerColor.title;
        template.picColorTunerAdjust.items.colorTunerColor.items.description.value = picColorTunerDataCfg.picColorTunerColor.description;
        template.picColorTunerAdjust.items.colorTunerHue.position.y = 1500;
        template.picColorTunerAdjust.items.colorTunerSaturation.position.y = 1500;
        template.picColorTunerAdjust.items.colorTunerBrightness.position.y = 1500;

        template.picColorTunerAdjust.items["c" + PictureConfig.PicColorTunerSign.substr(4)].position.y = 0;

        var cardWheel = {
            "type": 0,
            "position": {
                "x": 40,
                "y": 20
            },
            "items": {}
        };

        var cardWheelItem = {
            "type": 0,
            "position": {
                "x": -10,
                "y": 124
            },
            "navigation": {
                "leftTo": null,
                "rightTo": null,
                "upTo": null,
                "downTo": null
            },
            "items": {
                "cardWheelBg": {
                    "type": 7,
                    "bound": {
                        "w": 230,
                        "h": 160
                    },
                    "position": {
                        "x": 0,
                        "y": 0
                    }
                },
                "cardWheelShadow": {
                    "type": 7,
                    "bound": {
                        "w": 280,
                        "h": 200
                    },
                    "position": {
                        "x": -30,
                        "y": -20
                    }
                },
                "cardWheelIcon": {
                    "type": 7,
                    "bound": {
                        "w": 72,
                        "h": 72
                    },
                    "position": {
                        "x": 79,
                        "y": 44
                    }
                }
            }
        };


        // 20 50 150 200 0
        //位置不准确，缩放为中心缩放
        var cardWheelItemIndexVec = [{y: 0},  {y: 95}, {y: 190}, {y: 95}];

        for (var i = 0; i < cardWheelItemIndexVec.length; i++) {
            var cardWheelItemTemp = getObjCopy(cardWheelItem);
            cardWheelItemTemp.position.y = cardWheelItemIndexVec[i].y;
            cardWheelItemTemp.items['cardWheelIcon_' + i] = getObjCopy(cardWheelItemTemp.items.cardWheelIcon);
            delete (cardWheelItemTemp.items.cardWheelIcon);
            cardWheel.items["cardWheel_" + i] = cardWheelItemTemp;
        }
        template.picColorTunerAdjust.items['cardWheel'] = cardWheel;

        var picColorTunerAdjust = SubModule.create(initImgData, template);
        picColorTunerAdjust.noAutoClose = true;

        var colorTunerColor = UI.getItem(picColorTunerAdjust, "colorTunerColor");
        var colorTunerColorGrid = UI.getItem(colorTunerColor, "grid");
        var colorTunerColorArray = [];
        var colorTunerColorInfo = {
            template: "picModeNewTile",
            direction: CONST.GIRD_DIRECTION.V,
            breakNum: 1,
            distanceX: 20,
            distanceY: 0,
            container: colorTunerColorGrid
        };
        for (var i = 0; i < picColorTunerDataCfg.picColorTunerColor.array.length; i++) {
            colorTunerColorArray.push({tileBg: picColorTunerDataCfg.picColorTunerColor.array[i].tileBg,
                tileImg: picColorTunerDataCfg.picColorTunerColor.array[i].tileImg,
                tileTxt: picColorTunerDataCfg.picColorTunerColor.array[i].tileTxt,
                name: "Color" + i
            });
        }
        // 调用Grid.create方法生成Gird并添加到锚点位置上
        Gird.create(colorTunerColorArray, colorTunerColorInfo);
        UI.addMask(colorTunerColorGrid, 1520, 180, 40, 30);
        UI.setView(colorTunerColorGrid, 1520, 180);


        picColorTunerAdjust.onPush = function () {
            try {
                DBG_INFO('picColorTunerAdjust.onPush');
                var CmpVec = [colorTunerColor, colorTunerHue, colorTunerSaturation, colorTunerBrightness];

                for (var i = 0; i < CmpVec.length; i++) {
                    CmpVec[i].alpha = 0;
                    CmpVec[i].y = 0;
                }
                cardWheelObj.init();
                PicColorTunerAdjustPageInit();
                if (PictureConfig.PicColorTunerSign == PicSignDefine.PicColorTunerSign.PIC_COLOR_TUNER_COLOR) {
                    picColorTunerAdjust.currFocus = UI.getItem(colorTunerColorGrid, "Color" + PicColorTunerAdjustPageData.colorTunerColorVal);
                } else {
                    picColorTunerAdjust.currFocus = UI.getItem(picColorTunerAdjust, "c" + PictureConfig.PicColorTunerSign.substr(4));
                }
                setOnkeyLeftRightFunc(colorTunerHue, colorTunerHueCmp, PicColorTunerAdjustPageData.colorTunerHueVal);
                setOnkeyLeftRightFunc(colorTunerSaturation, colorTunerSaturationCmp, PicColorTunerAdjustPageData.colorTunerSaturationVal);
                setOnkeyLeftRightFunc(colorTunerBrightness, colorTunerBrightnessCmp, PicColorTunerAdjustPageData.colorTunerBrightnessVal);

                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        picColorTunerAdjust.onShow = function () {
            try {
                DBG_INFO('picColorTunerAdjust.onShow');
                var normalCfg = {y: 0 + 175, alpha: 1};
                UI.getItem(picColorTunerAdjust, "c" + PictureConfig.PicColorTunerSign.substr(4)).alpha = 1;
                UI.getItem(picColorTunerAdjust, "c" + PictureConfig.PicColorTunerSign.substr(4)).y = normalCfg.y;
                if (colorTunerColorGrid.selectedItem) {
                    colorTunerColorGrid.selectedItem.removeChild(ColorSelectedFlag, true);
                }
                colorTunerColorGrid.selectedItem = UI.getItem(colorTunerColorGrid, "Color" + PicColorTunerAdjustPageData.colorTunerColorVal);
                UI.getItem(colorTunerColorGrid, "Color" + PicColorTunerAdjustPageData.colorTunerColorVal).addChild(ColorSelectedFlag);
                UI.hideCursor();
                TTSCall();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        var PicColorTunerAdjustPageData = {
            ColorVec:["[SE0517]", "[SE0519]", "[SE0521]", "[SE0536]", "[SE0537]", "[SE0538]", "[SE2532]"],
            colorTunerColorVal: 0,
            colorTunerHueVal: 0,
            colorTunerSaturationVal: 0,
            colorTunerBrightnessVal: 0
        };
        DBG_INFO("PicTunerStep.HueStep: "+getPicHueStep());

        //该函数中实现value初始化
        function PicColorTunerAdjustPageInit() {
            try {
                var colorTunerColorVal = tv ? model.video.getColor() : 2;
                DBG_INFO('model.video.getColor(): ' + colorTunerColorVal);
                PicColorTunerAdjustPageData.colorTunerColorVal = ({0:5,1:0,2:3,3:1,4:4,5:2,6:6}[colorTunerColorVal]);

                PicColorTunerAdjustPageData.colorTunerHueVal = tv ? model.video.getColorHue() : 2;
                DBG_INFO("model.video.getColorHue(): " + PicColorTunerAdjustPageData.colorTunerHueVal);
                PicColorTunerAdjustPageData.colorTunerHueVal=Math.round(PicColorTunerAdjustPageData.colorTunerHueVal/PicTunerStep.HueStep);
                colorTunerHueCmp.setPercentNoVoice(PicColorTunerAdjustPageData.colorTunerHueVal);

                PicColorTunerAdjustPageData.colorTunerSaturationVal = tv ? model.video.getColorSaturation() : 3;// 0~100
                DBG_INFO("model.video.getColorSaturation(): " + PicColorTunerAdjustPageData.colorTunerSaturationVal);
                PicColorTunerAdjustPageData.colorTunerSaturationVal=Math.round(PicColorTunerAdjustPageData.colorTunerSaturationVal/PicTunerStep.HueStep);
                colorTunerSaturationCmp.setPercentNoVoice(PicColorTunerAdjustPageData.colorTunerSaturationVal);

                PicColorTunerAdjustPageData.colorTunerBrightnessVal = tv ? model.video.getColorBrightness() : 10; //0~20
                DBG_INFO("model.video.getColorBrightness(): " + PicColorTunerAdjustPageData.colorTunerBrightnessVal);
                PicColorTunerAdjustPageData.colorTunerBrightnessVal=Math.round(PicColorTunerAdjustPageData.colorTunerBrightnessVal/PicTunerStep.HueStep);
                colorTunerBrightnessCmp.setPercentNoVoice(PicColorTunerAdjustPageData.colorTunerBrightnessVal);

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function TTSCall(){
            if(PictureConfig.PicColorTunerSign != PicSignDefine.PicColorTunerSign.PIC_COLOR_TUNER_COLOR){
                UI.callTTS(PictureConfig.PicColorTunerSign.substr(13)+eval("PicColorTunerAdjustPageData."+"c" + PictureConfig.PicColorTunerSign.substr(4)+"Val") + " ");
                DBG_INFO("UI.callTTS: "+ eval("PicColorTunerAdjustPageData."+"c" + PictureConfig.PicColorTunerSign.substr(4)+"Val"));
            }else{
                var index = eval(picColorTunerAdjust.currFocus.name.substr(5));
                UI.setVoiceStr(colorTunerColorGrid.initSequence[index], "Color"+PicColorTunerAdjustPageData.ColorVec[index]);
            }
        }

        var colorTunerHue = UI.getItem(picColorTunerAdjust, "colorTunerHue");
        var colorTunerHueCmp = UI.getItem(colorTunerHue, "percentBarLine");
        var colorTunerHueTxt = UI.getItem(colorTunerHue, "percentBarText");

        var colorTunerSaturation = UI.getItem(picColorTunerAdjust, "colorTunerSaturation");
        var colorTunerSaturationCmp = UI.getItem(colorTunerSaturation, "percentBarLine");
        var colorTunerSaturationTxt = UI.getItem(colorTunerSaturation, "percentBarText");

        var colorTunerBrightness = UI.getItem(picColorTunerAdjust, "colorTunerBrightness");
        var colorTunerBrightnessCmp = UI.getItem(colorTunerBrightness, "percentBarLine");
        var colorTunerBrightnessTxt = UI.getItem(colorTunerBrightness, "percentBarText");

        Percent.create(colorTunerHueCmp, colorTunerHueTxt, PicColorTunerAdjustPageData.colorTunerHueVal,
            ColorTunerData.HueValMin, ColorTunerData.HueValMax);
        Percent.create(colorTunerSaturationCmp, colorTunerSaturationTxt, PicColorTunerAdjustPageData.colorTunerSaturationVal,
            ColorTunerData.HueValMin, ColorTunerData.HueValMax);
        Percent.create(colorTunerBrightnessCmp, colorTunerBrightnessTxt, PicColorTunerAdjustPageData.colorTunerBrightnessVal,
            ColorTunerData.HueValMin, ColorTunerData.HueValMax);
        function CardWheelFunc() {

            var self = this;
            var cardWheelVec = [];
            self.cardWheelVec = cardWheelVec;
            var cardWheelLength = 4;

            for (var i = 0; i < cardWheelLength; i++) {
                self.cardWheelVec.push(UI.getItem(picColorTunerAdjust, "cardWheel_" + i));
            }
            var posYVec = [0 + 80, 95 + 80, 190 + 80, 95 + 80];
            var DelayTimeData = {
                Time_0: 0,
                Time_400: 400
            };
            var ToVecNumeber = {
                Vec0: 0,
                Vec1: 1,
                Vec2: 2
            };
            var ToYPosition = {
                Y_57: 57,
                Y_80: 80,
                Y_105: 105
            };

            //初始化，0位于最高的一个，当前哪个元素应该是Vector第一个
            self.setHeadIdx = function (idx) {
                try {
                    DBG_INFO('self.setHeadIdx: ' + idx);
                    for (var i = 0; i < idx; i++) {
                        cardWheelVec.unshift(cardWheelVec.pop());
                    }
                    getTweenTime(ToVecNumeber.Vec1,DelayTimeData.Time_0,ToYPosition.Y_80);
                    switchLayer(cardWheelVec)
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };


            //在onShow 函数里面调用init，太早会有问题
            self.init = function () {
                var PicColorTunerSignVec = ['picColorTunerColor', 'picColorTunerHue', 'picColorTunerSaturation', 'picColorTunerBrightness'];
                var idx = PicColorTunerSignVec.indexOf(PictureConfig.PicColorTunerSign);

                cardWheelVec = [];
                for (var i = 0; i < cardWheelLength; i++) {
                    cardWheelVec.push(UI.getItem(picColorTunerAdjust, "cardWheel_" + i));
                }
                self.setHeadIdx(({0: 1, 1: 0, 2: 3, 3: 2}[idx]));
            };

            function switchLayer(cardWheelVec) {
                UI.moveTo(cardWheelVec[1], 3);
                UI.moveTo(cardWheelVec[2], 2);
                UI.moveTo(cardWheelVec[3], 1);
                UI.moveTo(cardWheelVec[0], 0);
            }


            self.keyUp = function () {
                cardWheelVec.unshift(cardWheelVec.pop());
                getTweenTime(ToVecNumeber.Vec0,DelayTimeData.Time_400,ToYPosition.Y_57);
            };

            self.keyDown = function () {
                cardWheelVec.push(cardWheelVec.shift());
                getTweenTime(ToVecNumeber.Vec2,DelayTimeData.Time_400,ToYPosition.Y_105);
            };

            function getTweenTime(number,time,position) {
                DBG_INFO('posYVec['+number + '] ' + 'delayTime:' + time + ' toPosition:' + position);
                UI.getTween(cardWheelVec[1]).to({y: posYVec[number], alpha: 1}, time/2, UI.ease.quadOut).call(switchLayer, [cardWheelVec]).to({
                    y: posYVec[1]
                }, time/2, UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10))).to({y: position}, time/2,UI.ease.quadOut).to({y:ToYPosition.Y_80,alpha: 1},time/2,UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10)).scale).to({x: 1, y: 1});

                UI.getTween(cardWheelVec[2]).to({y: posYVec[2], alpha: 0.8}, time);
                UI.getTween(UI.getItem(cardWheelVec[2],"cardWheelIcon_"+cardWheelVec[2].name.substr(10))).to({y: 105, alpha: 0.8}, 100);
                UI.getTween(UI.getItem(cardWheelVec[2],"cardWheelIcon_"+cardWheelVec[2].name.substr(10)).scale).to({x: 0.67, y: 0.67});
                UI.getTween(cardWheelVec[0]).to({y: posYVec[0], alpha: 0.8}, time);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10))).to({y: 57, alpha: 0.8}, 100);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10)).scale).to({x: 0.67, y: 0.67});


                UI.getTween(cardWheelVec[3]).to({y: posYVec[3], alpha: 0}, 0);
                UI.getTween(UI.getItem(cardWheelVec[3],"cardWheelIcon_"+cardWheelVec[3].name.substr(10))).to({y: 80, alpha: 0}, 100);
                UI.getTween(UI.getItem(cardWheelVec[3],"cardWheelIcon_"+cardWheelVec[3].name.substr(10)).scale).to({x: 1, y: 1});
            }

        }

        var cardWheelObj = new CardWheelFunc();

        var ColorSelectedFlag= new PIXI.Graphics();
        ColorSelectedFlag.beginFill(OEMFunction.getInstance().getBrandColor()).drawRect(0, 152, 295, 8);

        // 当Grid中某个图标处于焦点时
        var ColorLastFocusName;
        colorTunerColorGrid.onFocus = function (focus) {
            setting.onNormal(focus);
            DBG_INFO("colorTunerColorGrid.onFocus");
            var currFocus = picColorTunerAdjust.currFocus;
            ColorLastFocusName = currFocus.name;
            if (!colorTunerColorGrid.selectedItem) {
                currFocus.addChild(ColorSelectedFlag);
                colorTunerColorGrid.selectedItem = UI.getItem(colorTunerColorGrid, currFocus.name);
            }
            TTSCall();
            UI.updateStage();
            return true;
        };
        colorTunerColorGrid.onNormal = function () {
            DBG_INFO("colorTunerColorGrid.onNormal");
            if (GLOBAL.HICONTRAST) {
                UI.base.toNormalContrast(UI.getItem(colorTunerColorGrid, ColorLastFocusName));
            }
            return true;
        };

        // 当Grid中某个图标被选中时
        colorTunerColorGrid.onkey_ENTER = function () {
            // 取得当前焦点对象
            var currFocus = picColorTunerAdjust.currFocus;
            if (colorTunerColorGrid.selectedItem) {
                // 将之前被选定的图标上的标记清除
                colorTunerColorGrid.selectedItem.removeChild(ColorSelectedFlag, true);
                colorTunerColorGrid.selectedItem = UI.getItem(colorTunerColorGrid, currFocus.name);
            }
            // 将文字加入目前被选定的图标上
//            currFocus.addChild(ColorSelectedFlag);
            currFocus.addChildAt(ColorSelectedFlag,currFocus.children.length-2);
            PicColorTunerAdjustPageData.colorTunerColorVal = parseInt(currFocus.name.substr(5));
            var index = PicColorTunerAdjustPageData.colorTunerColorVal;
            index=({0:1,1:3,2:5,3:2,4:4,5:0,6:6}[index]);
            tv && model.video.setColor(index);
            DBG_INFO("model.video.setColor(" + index + ")");
            setTimeout(function(){
                PicColorTunerAdjustPageData.colorTunerHueVal = tv ? model.video.getColorHue() : 1;
                DBG_INFO("model.video.getColorHue(): " + PicColorTunerAdjustPageData.colorTunerHueVal);
                PicColorTunerAdjustPageData.colorTunerHueVal=Math.round(PicColorTunerAdjustPageData.colorTunerHueVal/PicTunerStep.HueStep);
                colorTunerHueCmp.setPercentNoVoice(PicColorTunerAdjustPageData.colorTunerHueVal);

                PicColorTunerAdjustPageData.colorTunerSaturationVal = tv ? model.video.getColorSaturation() : 2;// 0~100
                DBG_INFO("model.video.getColorSaturation(): " + PicColorTunerAdjustPageData.colorTunerSaturationVal);
                PicColorTunerAdjustPageData.colorTunerSaturationVal=Math.round(PicColorTunerAdjustPageData.colorTunerSaturationVal/PicTunerStep.HueStep);
                colorTunerSaturationCmp.setPercentNoVoice(PicColorTunerAdjustPageData.colorTunerSaturationVal);

                PicColorTunerAdjustPageData.colorTunerBrightnessVal = tv ? model.video.getColorBrightness() : 5; //0~20
                DBG_INFO("model.video.getColorBrightness(): " + PicColorTunerAdjustPageData.colorTunerBrightnessVal);
                PicColorTunerAdjustPageData.colorTunerBrightnessVal=Math.round(PicColorTunerAdjustPageData.colorTunerBrightnessVal/PicTunerStep.HueStep);
                colorTunerBrightnessCmp.setPercentNoVoice(PicColorTunerAdjustPageData.colorTunerBrightnessVal);

                for (var i = 1; i < pctCmpVec.length; i++) {
                    var bar = eval(pctCmpVec[i]);
                    var cmp = UI.getItem(eval(pctCmpVec[i]), "percentBarLine");
                    setOnkeyLeftRightFunc(bar, cmp, eval('PicColorTunerAdjustPageData.' + pctCmpVec[i] + "Val"));
                }
            }, 100);
            // 刷新一帧
            UI.updateStage();
        };
        var pctCmpVec = ["colorTunerColor", "colorTunerHue", "colorTunerSaturation", "colorTunerBrightness"];

        function setOnkeyUpDownFunc(cmpOri, cmpUpTo, cmpDownTo) {
            var topCfg = {y: -100 + 175, alpha: 0};
            var normalCfg = {y: 0 + 175, alpha: 1};
            var btmCfg = {y: 100 + 175, alpha: 0};

            cmpOri.onkey_UP = function (focus) {
                DBG_INFO(cmpOri.name + ".onkey_UP");
                UI.getTween(cmpOri).to(btmCfg, 300);
                UI.getTween(cmpUpTo).to(topCfg, 0).to(normalCfg, 400);
                PictureConfig.PicColorTunerSign = "picC" + cmpUpTo.name.substr(1);
                DBG_INFO("pic" + cmpUpTo.name);
                if (cmpUpTo.name == "colorTunerColor"){//colorTunerColor
                    var lastFocusName = "Color" + PicColorTunerAdjustPageData.colorTunerColorVal;
                    picColorTunerAdjust.currFocus = UI.getItem(colorTunerColorGrid, lastFocusName);
//                    UI.setVoiceStr(colorTunerColorGrid.initSequence[PicColorTunerAdjustPageData.colorTunerColorVal],
//                            "Color"+PicColorTunerAdjustPageData.ColorVec[PicColorTunerAdjustPageData.colorTunerColorVal]);
                    UI.focusTo(UI.getItem(colorTunerColorGrid, lastFocusName));
                }else{
                    picColorTunerAdjust.currFocus = cmpUpTo;
                    TTSCall();
                }
                cardWheelObj.keyUp();
            };

            cmpOri.onkey_DOWN = function (focus) {
                DBG_INFO(cmpOri.name + ".onkey_DOWN");
                UI.getTween(cmpOri).to(topCfg, 300);
                UI.getTween(cmpDownTo).to(btmCfg, 0).to(normalCfg, 400);
                PictureConfig.PicColorTunerSign = "picC" + cmpDownTo.name.substr(1);
                DBG_INFO(PictureConfig.PicColorTunerSign);
                if (cmpDownTo.name == "colorTunerColor"){
                    var lastFocusName = "Color" + PicColorTunerAdjustPageData.colorTunerColorVal;
                    picColorTunerAdjust.currFocus = UI.getItem(colorTunerColorGrid, lastFocusName);
//                    UI.setVoiceStr(colorTunerColorGrid.initSequence[PicColorTunerAdjustPageData.colorTunerColorVal],
//                            "Color"+PicColorTunerAdjustPageData.ColorVec[PicColorTunerAdjustPageData.colorTunerColorVal]);
                    UI.focusTo(UI.getItem(colorTunerColorGrid, lastFocusName));
                }else{
                    picColorTunerAdjust.currFocus = cmpDownTo;
                    TTSCall();
                }
                cardWheelObj.keyDown();
            };
        }
        setOnkeyUpDownFunc(colorTunerColor, colorTunerBrightness, colorTunerHue);
        setOnkeyUpDownFunc(colorTunerHue, colorTunerColor, colorTunerSaturation);
        setOnkeyUpDownFunc(colorTunerSaturation, colorTunerHue, colorTunerBrightness);
        setOnkeyUpDownFunc(colorTunerBrightness, colorTunerSaturation, colorTunerColor);

        function setOnkeyLeftRightFunc(bar, comp, val) {
            function setModelValue(name, val) {
                switch (name) {
                    case "colorTunerHue":
                        tv && model.video.setColorHue(val);
                        DBG_INFO("model.video.setColorHue(" + val + ")");
                        break;
                    case "colorTunerBrightness":
                        tv && model.video.setColorBrightness(val);
                        DBG_INFO("model.video.setColorBrightness(" + val + ")");
                        break;
                    case "colorTunerSaturation":
                        tv && model.video.setColorSaturation(val);
                        DBG_INFO("model.video.setColorSaturation(" + val + ")");
                        break;
                    default:
                        DBG_ERROR('setModelValue Error[name error]');
                        break;
                }
                eval("PicColorTunerAdjustPageData."+name.split("PercentBar")[0]+"Val"+"=val");
            }
            bar.onkey_LEFT = function () {
                DBG_INFO(bar.name + ".onkey_LEFT");
                val -= 1;
                var minVal = -10;
                val < minVal && (val = minVal);
                comp.setPercent(val);
                var botVal = val*PicTunerStep.HueStep;
                setModelValue(bar.name, botVal);
            };
            bar.onkey_RIGHT = function () {
                DBG_INFO(bar.name + ".onkey_RIGHT");
                val += 1;
                var maxVal = 10;
                val > maxVal && (val = maxVal);
                comp.setPercent(val);
                var botVal = val*PicTunerStep.HueStep;
                setModelValue(bar.name, botVal);
            };
            bar.onFocus = function () {
                return false;
            };
            bar.onNormal = function () {
                if (GLOBAL.HICONTRAST) {
                    UI.base.toNormalContrast(UI.getItem(colorTunerColorGrid, ColorLastFocusName));
                }
                return true;
            }
        }

        function setOnkeyEnterFunc(cmp){
            cmp.onkey_ENTER = function (focus) {
                return false;
            }
        }

        setOnkeyEnterFunc(colorTunerHue);
        setOnkeyEnterFunc(colorTunerSaturation);
        setOnkeyEnterFunc(colorTunerBrightness);

    } catch (ex) {
        DBG_ERROR(ex.message);
    }

};