/**
 * Created by jiangbo1 on 2016/2/26.
 */

UI.moduleBuilder['setting']['menuChip'] = function(){

    var menuChipData = {
        menuchip_bg: UI.back_bg,
        MCTitle: "[DMP0056]",//Menu
        MCLine:{color : "0x3e4253"}
    };

    var template = Util.readJson("module/setting/menuChip.json");
    var menuChip = SubModule.create(menuChipData, template);

    var MCList = UI.getItem(menuChip, "MCList");
    var crntChips = [];
    //var allChips = ["Accessibility", "[SE2410]", "[SE0829]", "[SE0003]", "[SE0059]", "[SE0461]", "[SS0024]"];
    var allChips = ["[SE3266]","[SE3021]", "[SE0003]", "[SE0059]", "[SE0461]", "[SE0741]", "[SE0829]", "[SE0834]", "[SE2974]","[DMP0123]","[SE0827]"];
    var imgList = [
        GLOBAL.IMAGE_LIST.SELLER_SETTING_ICON,
        GLOBAL.IMAGE_LIST.TTS_ICON,
//        GLOBAL.IMAGE_LIST.KEYBOARD_ICON,
        GLOBAL.IMAGE_LIST.PIC_MODE_ICON,
        GLOBAL.IMAGE_LIST.SND_MODE_ICON,
        GLOBAL.IMAGE_LIST.ASPECT_ICON,
        GLOBAL.IMAGE_LIST.CC_ICON,
        GLOBAL.IMAGE_LIST.SAP_ICON,
        GLOBAL.IMAGE_LIST.AUDIO_ONLY,
        GLOBAL.IMAGE_LIST.HDMI2,
        GLOBAL.IMAGE_LIST.SYSTEM_SETTING_ICON,
        GLOBAL.IMAGE_LIST.SAP_ICON
    ];
    var crntChannel;
    function checkMenuChiplist(subModule){
        var curModeIndex = tv? model.system.getUserMode(): 1;
        if(!!subModule&&subModule.param&&!!subModule.param.origin)
        {
            DBG_INFO("createMenuChipList()");
            if (SourceList.TV == GLOBAL.CURRENT_SOURCE&&subModule.param.origin=="liveTV") {
                crntChips=[];
                if(curModeIndex != 0){
                    crntChips.push(CHIPS.SELLER_SETTINGS);
                    }
                crntChannel = liveTV.getCurrentChannelInfo();
                    if(GLOBAL.NO_SIGNAL){
                    crntChips.push(CHIPS.TTS);
                    crntChips.push(CHIPS.PIC_MODE);
                    crntChips.push(CHIPS.SND_MODE);
                    crntChips.push(CHIPS.ASPECT);
                    crntChips.push(CHIPS.CC);
                    crntChips.push(CHIPS.AUDIO_ONLY);
                    }
                    else{
                    crntChips.push(CHIPS.TTS);
                    crntChips.push(CHIPS.PIC_MODE);
                    crntChips.push(CHIPS.SND_MODE);
                    crntChips.push(CHIPS.ASPECT);
                    crntChips.push(CHIPS.CC);
                    if(!!crntChannel.type&&CONST.ATV == crntChannel.type){
                        crntChips.push(CHIPS.ATV_SAP);
                    }
                    else {
                        crntChips.push(CHIPS.SAP);
                    }
                    crntChips.push(CHIPS.AUDIO_ONLY);
                    }

            } else {
                crntChips=[];
                if(curModeIndex != 0){
                    crntChips.push(CHIPS.SELLER_SETTINGS);
                }
                crntChips.push(CHIPS.TTS);
                crntChips.push(CHIPS.PIC_MODE);
                crntChips.push(CHIPS.SND_MODE);
                crntChips.push(CHIPS.ASPECT);
                crntChips.push(CHIPS.AUDIO_ONLY);
                if(SourceList.HDMI1 == GLOBAL.CURRENT_SOURCE
                    ||SourceList.HDMI2 == GLOBAL.CURRENT_SOURCE
                    ||SourceList.HDMI3 == GLOBAL.CURRENT_SOURCE
                    /*||SourceList.HDMI4 == GLOBAL.CURRENT_SOURCE*/){
                    crntChips.push(CHIPS.HDMI2);
                }

            }
            crntChips.push(CHIPS.SYSTEM_SETTING);
        }else {
            crntChips=[];
            if(curModeIndex != 0){
                crntChips.push(CHIPS.SELLER_SETTINGS);
            }
            crntChips.push(CHIPS.TTS);
            crntChips.push(CHIPS.PIC_MODE);
            crntChips.push(CHIPS.SND_MODE);
            crntChips.push(CHIPS.ASPECT);
            crntChips.push(CHIPS.AUDIO_ONLY);
            crntChips.push(CHIPS.SYSTEM_SETTING);


        }
    }
    function createMenuChipList() {

        try {
            checkMenuChiplist(menuChip);
            var gridInfo = {
                template: "menuChipTile",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceY: 6,
                distanceX: 0,
                container: MCList
            };
            var allArray = [];
            for (var i = 0; i < crntChips.length; i++) {
                allArray.push(
                    {
                        chip_bg: UI.item_bg,
                        chipIcon: imgList[crntChips[i]],
                        chipText: allChips[crntChips[i]],
                        chipSwith: "setting/blank.png",
                        name: "CHIP" + crntChips[i]
                    }
                )
            }
            //while (menuChip.children.length > 3) menuChip.children.pop();
            removeLiveTVShape(MCList);
            MCList.removeAllChildren();
            MCList.initSequence = [];
            Gird.create(allArray, gridInfo);
            UI.addMask(MCList, 440, 498, 20, 10);
            UI.setView(MCList, 440, 498);
            UI.addScrollbar(MCList,0);
          //  for (var i = 0; i < MCList.initSequence.length; i++) {
               // MCList.initSequence[i].alpha = 0.6;
          //  }
            menuChip.currFocus = UI.getItem(MCList, "CHIP" + crntChips[0]);
//            MCList.initSequence[0].onkey_UP = function() {
//                UI.focusTo(MCList.initSequence[MCList.initSequence.length -1]);
//            };
//            MCList.initSequence[MCList.initSequence.length -1].onkey_DOWN = function() {
//                UI.focusTo(MCList.initSequence[0]);
//            };
        } catch(ex){
            DBG_ERROR(ex.message);
        }
        checkMenuChipDisable()

    }
    function checkMenuChipDisable(){
        try {
            var aspectIdx = crntChips.indexOf(CHIPS.ASPECT);
            var isAspectRatioEnable =  checkAspectRatioEnAble();
            //var AspectRatio = UI.getItem(MCList, "CHIP" + crntChips[4])
            if (!isAspectRatioEnable){
                UI.getItem(MCList, "CHIP" +CHIPS.ASPECT).disable = true;
                MCList.initSequence[aspectIdx].alpha = 0.3;
            }else{
                UI.getItem(MCList, "CHIP" + CHIPS.ASPECT).disable = false;
                MCList.initSequence[aspectIdx].alpha = 1;
            }

            var sndModeIdx = crntChips.indexOf(CHIPS.SND_MODE);
            var isSndModeEnable = !((tv ? model.sound.getSpeakerArc() : 1) != 1);//check whether ARC is open
            if (!isSndModeEnable) {
                MCList.initSequence[sndModeIdx].disable = true;
                MCList.initSequence[sndModeIdx].alpha = 0.3
            }
            else {
                MCList.initSequence[sndModeIdx].disable = false;
                MCList.initSequence[sndModeIdx].alpha =1;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    menuChip.onFocus = function (focus) {
        DBG_ONXX("menuChip", "onFocus");
      //  onFocusLiveTVTarget(focus, 1.05, 500);
        return true;
    };

    menuChip.onNormal = function (focus) {
      //  onNormalLiveTVTarget(focus, 0.6, 500);
        MCList.initSequence[0].voiceStr=null;
        return true;
    };
    menuChip.onPush = function () {
        CheckB2BDisableFlag();
        createMenuChipList();
        var curModeIndex = tv? model.system.getUserMode(): 1;
        if(curModeIndex && Config.language.DMP0056&&Config.language.SE3266){
            MCList.initSequence[0].voiceStr =  Config.language.DMP0056+" "+Config.language.SE3266;
        }else if(Config.language.DMP0056&&Config.language.SE3021){
            MCList.initSequence[0].voiceStr =  Config.language.DMP0056+" "+Config.language.SE3021;
        }
       // UI.setLiveTVMenuTimeout(autoExitLiveTVSubModel, GLOBAL.SETTING_TIMEOUT_DELAY);
    };
    menuChip.onShow=function(){
        menuChip.alpha=1;
    }
    menuChip.open=function(){
        menuChip.alpha=1;
        UI.updateStage();
    }
    menuChip.close=function(){
        menuChip.alpha=0;
    }
    menuChip.onPop = function(){
        DBG_ONXX("menuChip", "onPop");
        UI.getTween(UI.base.cursor, true).set({scaleX: 1, scaleY: 1, alpha: 0});
       // UI.clearLiveTVMenuTimeout();
    }

    menuChip.onkey_ENTER = function (focus) {
        var ind = parseInt(focus.name.split("CHIP")[1]);
        switch (ind) {
            case CHIPS.SELLER_SETTINGS:
                UI.popSubModule();
                DBG_INFO('CHIPS.SELLER_SETTINGS');
                UI.pushSubModule("setting",  "storeModeSettingMenu", true);
                break;
            case CHIPS.TTS:
                //UI.popSubModule();
                menuChip.close();
                DBG_INFO('CHIPS.TTS');
                UI.pushSubModule("setting","MenuChipTTS",true,menuChip.param,setting);
                break;
//            case CHIPS.KEYBOARD:
//                UI.popSubModule();
//                UI.pushSubModule(LIVETV.MAIN, LIVETV.NUMBER_KEYBOARD, true);
//                break;
            case CHIPS.CC:
               // UI.popSubModule();
                menuChip.close();
                DBG_INFO('CHIPS.CC');
                UI.pushSubModule("setting","CC",true,menuChip.param,setting);
                //ccIndex = (++ccIndex) % 3;
                //if(Config.tv) model.closedcaption.setControl(ccIndex);
                //UI.setText(focus.children[2], ccList[ccIndex], focus);
                break;
            case CHIPS.SAP:
                DtvAudioLanguageInit();
                break;
            case CHIPS.ATV_SAP:
            {
                menuChip.close();
                UI.pushSubModule("setting", "AudioSAPList", true,menuChip.param);
                break;
            }
            case CHIPS.PIC_MODE:
               // UI.popSubModule();
                menuChip.close();
                DBG_INFO('CHIPS.PIC_MODE');
//                UI.pushModule('setting');
                PictureConfig.picModeSign = PicSignDefine.PicModeSign.PIC_MODE;
                UI.pushSubModule("setting", "picMode", true,menuChip.param,setting);
                break;
            case CHIPS.SND_MODE:
                menuChip.close();
               // UI.popSubModule();
                DBG_INFO('CHIPS.SND_MODE');
                UI.pushSubModule("setting", "AudioMode", true, menuChip.param);
                break;
            case CHIPS.ASPECT:
                menuChip.close();
               //UI.popSubModule();
                DBG_INFO('CHIPS.ASPECT');
//                UI.pushModule('setting');
                PictureConfig.picModeSign = PicSignDefine.PicModeSign.PIC_ASPECT_RATIO;
                UI.pushSubModule("setting", "picMode", true, menuChip.param,setting);
                break;
            case CHIPS.AUDIO_ONLY:
                model.system.setEnumScreenState(0);
                DBG_INFO("Off the screen");
                g_SystemAudioOnlyFlag = 1;
                break;
            case CHIPS.HDMI2:
                UI.popSubModule();
                DBG_INFO('CHIPS.HDMI2');
                PictureConfig.picApplyModeSign = PicSignDefine.PicApplyModeSign.PIC_HDMI_FORMAT;
                UI.pushSubModule("setting", "picApplyMode", true,menuChip.param);
                break;
            case CHIPS.SYSTEM_SETTING:
               // menuChip.close();
                UI.popSubModule();
                DBG_INFO('CHIPS.SYSTEM_SETTING');

                UI.pushSubModule("setting", "mainPanel", true);
                break;
            default:
                DBG_ERROR("do not have this chip[" + ind + "].");
                break;
        }
    }
    menuChip.onkey_MENU=
    menuChip.onkey_BACKSPACE=function(){
        UI.clearAllSubModule("setting");
        if(checkIsAppOn())
        {
            appControl.focusCurrentApp();
        }
        else
        {
            if(AccuWeatherData.startFlag != true && GLOBAL.MIRACAST_STARTFLAG != true){
                openLiveTVModule([Msg.INFO, 0]);
            }else{
                //todo  focusCurrentApp
            }
        }


    }

    function refreshSAPItem(){
        if(checkLiveTVState(LIVETV.MENU_CHIP) && SourceList.TV == GLOBAL.CURRENT_SOURCE){
            DBG_INFO("refresh menu chip when signal changed.");
            createMenuChipList();
            UI.focusTo(menuChip.currFocus);
        }
    }

    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SIGNAL_CHANGED, refreshSAPItem);

    function checkSndModeEnAble() {
        //check whether ARC is open
        try {
            return 1;
            var audioDeviceExist = tv?model.cec.getIsAudioDeviceExist():1;
            DBG_INFO('model.cec.getIsAudioDeviceExist(): ' + audioDeviceExist);
            var arcState = tv?model.cec.getHdmiDevicesArcState():0;
            DBG_INFO('model.cec.getHdmiDevicesArcState(): ' + arcState);
            var cecState = tv?model.cec.getFunctionality():1;
            DBG_INFO('model.cec.getFunctionality(): ' + cecState);

            return !(arcState && audioDeviceExist && cecState);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

};