// Init
UI.moduleBuilder['setting']['accessibilityDetail'] =function(){


    var accessibilityDetail_Data = {
        arrow_left:"setting/ic_leftarrow_focused.png",
        arrow_right:"setting/ic_rightarrow_focused.png",
        bg:{color: 0x282c40},
        bg_pic:UI.btn_normal_bg,
        pic_bar:"setting/Closed_Caption_Setting_breakline.png"
    };
    var template = Util.readJson("module/setting/accessibilityDetail.json");
    var accessibility = SubModule.create(accessibilityDetail_Data, template);
    accessibility.currFocus=UI.getItem(accessibility,"Analog_Caption_content");

 //Actions

    var accessDObj=[];
    var disable=null;
    var focus_group_array=["Analog_Caption_content","Digital_Caption_content","Style_content","Size_content","Font_"+
    "content","Text_Color_content","Text_Opacity_content","Background_Color_content","Background_Opacity"+
    "_content","Edge_Effect_content","Edge_Color_content"];
    var scroll_panel_y=1406.00;
    //--- -----------------------translate begin--------------------//
    var Analog_Caption=['[GE0006]','[SE2592]',"[SE3040]","[SE3041]","[SE3042]","[SE3043]","[SE3044]","[SE3045]","[SE3046]"];
    //var Anolog_CaptionNoTranslate=["Off","CC1","CC2","CC3","CC4","Text1","Text2","Text3","Text4"];
    var Digital_Caption=['[GE0006]',"[SE3047]","[SE3048]","[SE3049]","[SE3050]","[SE3051]","[SE3052]"];
    //var Digital_CaptionNoTranslate=["Off","CS1","CS2","CS3","CS4","CS5","CS6"];
    var Style=['[SE0751]','[SE0010]'];
    //var StyleNoTranslate=["Automatic","Custom"];
    var Size=['[SE0754]','[GE0002]','[SE0755]'];
    //var SizeNoTranslate=["Small","Medium","Large"];
    var Font=['[SE0758]',"[SE3053]","[SE3054]","[SE3055]","[SE3056]","[SE3057]","[SE3058]"]
    //var FontNoTranslate=["Style1","Style2","Style3","Style4","Style5","Style6","Style7"];
    var Text_Color=['[SE0762]','[SE0761]','[SE0519]','[SE0521]','[SE0517]','[SE0537]','[SE0536]','[SE0538]'];
    //var Text_ColorNoTranslate=["Black","White","Green","Blue","Red","Cyan","Yellow","Magenta"];
    var Text_Opacity=['[SE0765]','[SE0766]','[SE0767]'];
    //var Text_OpacityNoTranslate=["Solid","Translucent","Transparent"];
    var Background_Color=['[SE0762]','[SE0761]','[SE0519]','[SE0521]','[SE0517]','[SE0537]','[SE0536]','[SE0538]'];
    //var Background_ColorNoTranslate=["Black","White","Green","Blue","Red","Cyan","Yellow","Magenta"];
    var Background_Opacity=['[SE0765]','[SE0766]','[SE0767]']
    //var Background_OpacityNoTranslate=["Solid","Translucent","Transparent"];
    var Edge_Effect=['[SE0275]','[SE0774]','[SE0775]','[SE0776]','[SE0777]','[SE0778]']
    //var Edge_EffectNoTranslate=["None","Raised","Depressed","Uniform","Left Shadow","Right Shadow"];
    var Edge_Color=['[SE0762]','[SE0761]','[SE0519]','[SE0521]','[SE0517]','[SE0537]','[SE0536]','[SE0538]'];
    //var Edge_ColorNoTranslate=["Black","White","Green","Blue","Red","Cyan","Yellow","Magenta"];
    var Title_content={
            Closed_caption_setting :'[SE3032]',//"Closed Caption Settings",
            Analog_Caption:'[SE0744]',//"Analog Caption",
            Digital_Caption:'[SE0746]',//'Digital Caption',
            Digital_CC_settings:'[SE0748]',//'Digital CC Settings',
            Style:'[SE0750]',//'Style',
            Size:'[SE0753]',//'Size',
            Font:'[SE0757]',//'Font',
            Text_Color:'[SE0760]',//'Text Color',
            Text_Opacity:'[SE0764]',//'Text Opacity',
            Background_Color:'[SE0769]',//'Background Color',
            Background_Opacity:'[SE0771]',//'Background Opacity',
            Edge_Effect:'[SE0773]',//'Edge Effect',
            Edge_Color:'[SE0780]'//'Edge Color'
    };
    //-----------------------translate end--------------------------//
    var dataSelected={
        //default txt
        Analog_Caption:{id:"Off",index:0},
        Digital_Caption:{id:"CS1",index:1},
        Style:{id:"Automatic",index:0},
        Size:{id:"Medium",index:1},
        Font:{id:"Style2",index:1},
        Text_Color:{id:"Green",index:2},
        Text_Opacity:{id:"Translucent",index:2},
        Background_Color:{id:"Black",index:0},
        Background_Opacity:{id:"Translucent",index:1},
        Edge_Effect:{id:"Depressed",index:2},
        Edge_Color:{id:"Black",index:0}
    };
    var accessibility = UI.getSubModule("accessibilityDetail");
    var scroll_panel=UI.getItem(accessibility,"Digital_CC_content");
    var bg = UI.getItem(accessibility,'bg');
    bg.alpha = 0.9;
    var arrow_url={
        arrow_left:{normal:"setting/ic_leftarrow_normal.png",focus:"setting/ic_leftarrow_focused.png"},
        arrow_right:{normal:"setting/ic_rightarrow_normal.png",focus:"setting/ic_rightarrow_focused.png"}
    }

    var nameArray=Object.keys(dataSelected);
    UI.addMask(scroll_panel, 624, 375);
    UI.setView(scroll_panel, 624, 375);
    //UI.addScrollbar(accessibility);

    function setItemTitle(){
        try{
            for (var drop in Title_content){
                if (drop=="Closed_caption_setting"||drop=="Digital_CC_settings")
                {
                    UI.setText(UI.getItem(accessibility,drop),Title_content[drop]);
                }else{
                    var middle=UI.getItem(UI.getItem(accessibility,drop),'title');
                    middle.setLabel(Title_content[drop]);
                }
            }
        }catch(ex){DBG_ERROR(ex.message)}
    }
    function selectbar_common(group_name,select_txt,second_value_arrary){
        try {
            var selectBar = UI.getItem(accessibility, group_name);
            var selectComp = UI.getItem(selectBar, select_txt);
            Select.create(selectComp, second_value_arrary,true);
            selectBar.onkey_RIGHT = function() {
                selectComp.selectNext();
                if (dataSelected[group_name.split('_content')[0]].index <= selectComp.values.length - 1)
                {
                    dataSelected[group_name.split('_content')[0]].index=selectComp.values.indexOf(selectComp.selected);
                }
                setDataToBm(group_name.split('_content')[0]);
                set_lable_common(getCurFocusItem().parent.name,"",selectComp.selected);
                cc_func();
            };
            selectBar.onkey_LEFT = function() {
                selectComp.selectPrev();
                if(dataSelected[group_name.split('_content')[0]].index>=0){
                    dataSelected[group_name.split('_content')[0]].index=selectComp.values.indexOf(selectComp.selected);
                }
                setDataToBm(group_name.split('_content')[0]);
                set_lable_common(getCurFocusItem().parent.name,"",selectComp.selected);
                cc_func();
            };
            selectBar.onkey_ENTER=function(){
                var popList=[];
                popList.push({listArray:eval(group_name.split('_content')[0]),index:dataSelected[group_name.split('_content')[0]].index,groupName:group_name.split('_content')[0],Name:Title_content[group_name.split('_content')[0]]});
                UI.pushSubModule('setting','commonList',true,popList);
            }
            accessDObj.push({
                selectComp:selectComp,
                selectBar_parent:selectBar.parent
            });
        }
        catch(ex){DBG_ERROR("selectbar_common func is error"+ex.message);}

    }
    function cc_func(){
        if(UI.getCurrSubModule().name!="accessibilityDetail"){return;}
        var tempModule=UI.getItem(accessibility,"Style_content");
        if(UI.getText(tempModule,"txt")==Config.language[UI.getMsgId(Style[0])]){
            Disable_common(accessibility,[focus_group_array[3]],true);
        }
        else{
            Disable_common(accessibility,[focus_group_array[3]],false);
        }
	    push_accessibility_data();
        //UI.updateStage();
    }
    function Disable_common(submodule,groupname_arrary,flag){
        try {
            switch (flag) {
                case true:
                    if (groupname_arrary.length == 0) {
                        DBG_ERROR("groupname_arrary is error ");
                    }
                    for (var i = 0; i < groupname_arrary.length; i++) {
                        var temp_group = UI.getItem(submodule, groupname_arrary[i]);
                        disable = true;
                        temp_group.alpha=0.3;
                    }
                    break;
                case false:
                    if (groupname_arrary.length == 0) {
                        DBG_ERROR("groupname_arrary is error ");
                    }
                    for (var i = 0; i < groupname_arrary.length; i++) {
                        var temp_group = UI.getItem(submodule, groupname_arrary[i]);
                        disable = false;
                        temp_group.alpha=1;
                    }
                    break;
                default :
                    break;
            }
            UI.updateStage();
        }catch(e){DBG_ERROR("Disable_common is error"+e.message);}
    }

    function set_lable_common(lable_group_name,title,labletxt,flag){
           try{
               var labelValueBar = UI.getItem(accessibility, lable_group_name);
               var labelvalue = UI.getItem(labelValueBar, "title");
               if(flag)LabelValue.create(labelvalue, title);
               if(labletxt){
                   labelvalue.setValue(labletxt);
                   UI.updateStage();
               }
               labelValueBar.onFocus = function() {
                   //labelvalue.onFocus();
                   return true;
               };
               labelValueBar.onNormal = function() {
                   //labelvalue.onNormal();
                   return true;
               };
           } catch(ex){DBG_ERROR("set_lable_common is error"+ex.message)}
    }
    function getDataFromBm(){
       try{
           var tempArr=[],i=0;
           tempArr.push(model.closedcaption.getControlAnalogMode());
           tempArr.push(model.closedcaption.getControlDigitalMode());
           tempArr.push(model.closedcaption.getControlDigitalStyle());
           tempArr.push(model.closedcaption.getControlDigitalSize());
           tempArr.push(model.closedcaption.getControlDigitalFont());
           tempArr.push(model.closedcaption.getControlDigitalTextcolor());
           tempArr.push(model.closedcaption.getControlDigitalTextopacity());
           tempArr.push(model.closedcaption.getControlDigitalBgcolor());
           tempArr.push(model.closedcaption.getControlDigitalBgopacity());
           tempArr.push(model.closedcaption.getControlDigitalEdgeeffect());
           tempArr.push(model.closedcaption.getControlDigitalEdgecolor());
           for(var drop in dataSelected){
               dataSelected[drop].index=tempArr[i];
               //dataSelected[drop].id=getArrayValue(drop,[tempArr[i]]);
               i++;
           }
       }catch(ex){DBG_ERROR("getDataFromBm is error:"+ex.message);}

    }
    function setDataToBm(name){
        try{
            if(!tv){return}
            switch (name){
                case nameArray[0]:model.closedcaption.setControlAnalogMode(dataSelected.Analog_Caption.index);
                    break;
                case nameArray[1]:model.closedcaption.setControlDigitalMode(dataSelected.Digital_Caption.index);
                    break;
                case nameArray[2]:model.closedcaption.setControlDigitalStyle(dataSelected.Style.index);
                    break;
                case nameArray[3]:model.closedcaption.setControlDigitalSize(dataSelected.Size.index);
                    break;
                case nameArray[4]:model.closedcaption.setControlDigitalFont(dataSelected.Font.index);
                    break;
                case nameArray[5]:model.closedcaption.setControlDigitalTextcolor(dataSelected.Text_Color.index);
                    break;
                case nameArray[6]:model.closedcaption.setControlDigitalTextopacity(dataSelected.Text_Opacity.index);
                    break;
                case nameArray[7]:model.closedcaption.setControlDigitalBgcolor(dataSelected.Background_Color.index);
                    break;
                case nameArray[8]:model.closedcaption.setControlDigitalBgopacity(dataSelected.Background_Opacity.index);
                    break;
                case nameArray[9]:model.closedcaption.setControlDigitalEdgeeffect(dataSelected.Edge_Effect.index);
                    break;
                case nameArray[10]:model.closedcaption.setControlDigitalEdgecolor(dataSelected.Edge_Color.index);
                    break;
                default :
                    break;
            }
            DBG_INFO("send DataSeleted");
        }catch(ex){DBG_ERROR("setDataToBm is error:"+ex.message)}

    }
    function init_accessibility_data(){
        if(tv){getDataFromBm();}
        refreshDataSelected();
    }
    function refreshDataSelected(){
        var tempArr=[];
        //change object to array
        for(var i in dataSelected){
            tempArr.push(dataSelected[i].index);
        }
        set_dataSeleted(tempArr);
    }
    function cloneObjToDataSelected(data){
        if(!!data){
            var name=data.groupName;
            dataSelected[name].index=data[name].index;
        }
    }
    function push_accessibility_data(){
        //get_dataSelected(focus_group_array,"txt");
        //console.log(dataSelected);
        //if(tv){setDataToBm();}
        //DBG_INFO("send DataSeleted");
    }
    function getArrayValue(id,index){
        try{
            switch (id){
                case dataSelected.Analog_Caption:return Analog_Caption[index];
                case dataSelected.Background_Color:return Background_Color[index];
                case dataSelected.Background_Opacity:return Background_Opacity[index];
                case dataSelected.Digital_Caption:return Digital_Caption[index];
                case dataSelected.Edge_Color:return Edge_Color[index];
                case dataSelected.Edge_Effect:return Edge_Effect[index];
                case dataSelected.Font:return Font[index];
                case dataSelected.Size:return Size[index];
                case dataSelected.Style:return Style[index];
                case dataSelected.Text_Color:return Text_Color[index];
                case dataSelected.Text_Opacity:return Text_Opacity[index];
                default :break;
            }
        }catch(ex){
            DBG_ERROR("getArrayValue is error");
        }
    }
    function set_dataSeleted(dataSeleted){
        try{
            if(dataSeleted){
                for(var i=0;i<dataSeleted.length;i++){
                    accessDObj[i].selectComp.selectCurrent(dataSeleted[i], true);
                    //accessDObj[i].selectComp.selected=dataSeleted[i];
                    //UI.setText(accessDObj[i].selectComp,dataSeleted[i]);
                    var temp=UI.getItem(accessDObj[i].selectBar_parent,"title");
                    temp.setValue(accessDObj[i].selectComp.values[dataSeleted[i]]);
                    //UI.updateStage();
                }
                UI.updateStage();
            }
            //console.log(accessDObj);
        }catch(ex){DBG_ERROR("set_dataSeleted is error"+ex.message)}
    }

    function getCurFocusItem(getName){

        return !getName?UI.getCurrFocus():UI.getCurrFocus().name;
    }

    function get_dataSelected(group_name_array,select_txt){
        try{
            if(group_name_array.length<11){DBG_ERROR("group_name_array is error");}
            for(var i=0;i<group_name_array.length;i++){
                var selectBar = UI.getItem(accessibility, group_name_array[i]);
                var selectTxt = UI.getItem(selectBar, select_txt);
                switch (i){
                    case 0:dataSelected.Analog_Caption=UI.getText(selectTxt);break;
                    case 1:dataSelected.Digital_Caption=UI.getText(selectTxt);break;
                    case 2:dataSelected.Style=UI.getText(selectTxt);break;
                    case 3:dataSelected.Size=UI.getText(selectTxt);break;
                    case 4:dataSelected.Font=UI.getText(selectTxt);break;
                    case 5:dataSelected.Text_Color=UI.getText(selectTxt);break;
                    case 6:dataSelected.Text_Opacity=UI.getText(selectTxt);break;
                    case 7:dataSelected.Background_Color=UI.getText(selectTxt);break;
                    case 8:dataSelected.Background_Opacity=UI.getText(selectTxt);break;
                    case 9:dataSelected.Edge_Effect=UI.getText(selectTxt);break;
                    case 10:dataSelected.Edge_Color=UI.getText(selectTxt);break;
                    default :break;
                }
            }
        }catch(ex){DBG_ERROR("push_accessibility_data is error"+ex.message);}
    }

    accessibility.onFocus=function(){

        if(getCurFocusItem().parent.parent.name!="Digital_CC_content"||getCurFocusItem(true)=="Style_content"){
            //UI._callBubble(getCurFocusItem(), "onFocus", getCurFocusItem());
            if(getCurFocusItem().onFocus){
                getCurFocusItem().onFocus();
            }else{
                getCurFocusItem().parent.onFocus();
            }
        }
        return true;
    }
    accessibility.onkey_BACKSPACE=function(){
        UI.popSubModule();

    }
    accessibility.onPop=function(){
        push_accessibility_data();
        DBG_ALWAYS("accessibility on pop");
    }
    accessibility.onExit=function(){

    }
    accessibility.onShow=function(from){
        if(from=='commonList'){
           from= UI.getSubModule('commonList')
        }
        accessibility.alpha=1;
        cloneObjToDataSelected(from.param);
        refreshDataSelected();
        //set_init_lableColor(focus_group_array);
        cc_func();
        DBG_ALWAYS("accessibility on show");
    }
    accessibility.onPush=function(){
        UI.noRefresh = true;
        setItemTitle();
        init_accessibility_data();
        UI.noRefresh = false;
    }
    scroll_panel.onkey_DOWN=function(focus){
        try{
            if(focus.name!=focus_group_array[0]&&focus.name!=focus_group_array[1]&&focus.name!=focus_group_array[2]&&focus.name!="Edge_Color_content"){
                scroll_panel_y-=174;
            }
            var downTo;
            if(disable==true){return;}
            if(focus.name!="Edge_Color_content"){
                downTo = UI.getItem(scroll_panel, focus.downTo);
            }else{
                downTo=UI.getItem(scroll_panel, focus.name);
            }
            if(focus.name!="Edge_Color_content"){
                UI._callBubble(getCurFocusItem(), "onNormal", getCurFocusItem());
                accessibility.currFocus=downTo;

                UI._callBubble(getCurFocusItem(), "onFocus", getCurFocusItem());
                UI.getTween(scroll_panel).to({y:scroll_panel_y}, 400, UI.ease.quartOut);
                UI.base.cursor.alpha = 0;
                UI.getTween(downTo).to({scaleX:1.05, scaleY:1.05}, 300, UI.ease.quartOut);
                UI.getTween(UI.base.cursor).to({scaleX:1.05, scaleY:1.05}, 300, UI.ease.quartOut);
                UI.getTween(UI.base.cursor).wait(300).to({alpha:1}, 300, UI.ease.quartOut);
                UI.getTween(focus).to({scaleX:1, scaleY:1}, 300, UI.ease.quartOut);
            }

            //UI.base.cursor.x = downTo.x;
            //UI.base.cursor.y = downTo.y;
        }catch(ex){DBG_ERROR("scroll_panel.onkey_DOWN is error"+ex.message);}
    }
    scroll_panel.onkey_UP =function(focus) {
        try{
            var upTo = UI.getItem(scroll_panel, focus.upTo);

            if (!upTo) {
                upTo=UI.getItem(accessibility,"Digital_Caption_content");
            }

            if(focus.name!="Size_content"&&focus.name!="Style_content"){
                scroll_panel_y+=174;
            }
            UI._callBubble(getCurFocusItem(), "onNormal", getCurFocusItem());
            accessibility.currFocus = upTo;

            UI._callBubble(getCurFocusItem(), "onFocus", getCurFocusItem());
            UI.getTween(scroll_panel).to({y:scroll_panel_y}, 400, UI.ease.quartOut);
            UI.base.cursor.alpha = 0;
            UI.getTween(upTo).to({scaleX:1.05, scaleY:1.05}, 500, UI.ease.quartOut);
            UI.getTween(UI.base.cursor).to({scaleX:1.05, scaleY:1.05}, 500, UI.ease.quartOut);
            if(focus.name!="Size_content"&&focus.name!="Style_content"){
                UI.getTween(UI.base.cursor).wait(300).to({alpha:1}, 500, UI.ease.quartOut);
            }else{
                UI.getTween(UI.base.cursor).wait(150).to({alpha:1}, 500, UI.ease.quartOut);
            }
            UI.getTween(focus).to({scaleX:1, scaleY:1}, 500, UI.ease.quartOut);

            //UI.base.cursor.x = upTo.x;
            //UI.base.cursor.y = upTo.y;
        }catch(ex){DBG_ERROR("scroll_panel.onkey_UP is error"+ex.message);}
    }
    set_lable_common("Analog_Caption","Analog Caption",Analog_Caption[0],true);
    set_lable_common("Digital_Caption","Digital Caption",Digital_Caption[0],true);
    set_lable_common("Style","Style",Style[0],true);
    set_lable_common("Size","Size",Size[0],true);
    set_lable_common("Font","Font",Font[0],true);
    set_lable_common("Text_Color","Text Color",Text_Color[0],true);
    set_lable_common("Text_Opacity","Text Opacity",Text_Opacity[0],true);
    set_lable_common("Background_Color","Background Color",Background_Color[0],true);
    set_lable_common("Background_Opacity","Background Opacity",Edge_Effect[0],true);
    set_lable_common("Edge_Effect","Edge Effect",Edge_Effect[0],true);
    set_lable_common("Edge_Color","Edge Color",Edge_Color[0],true);

    selectbar_common(focus_group_array[0],"txt",Analog_Caption);
    selectbar_common(focus_group_array[1],"txt",Digital_Caption);
    selectbar_common(focus_group_array[2],"txt",Style);
    selectbar_common(focus_group_array[3],"txt",Size);
    selectbar_common(focus_group_array[4],"txt",Font);
    selectbar_common(focus_group_array[5],"txt",Text_Color);
    selectbar_common(focus_group_array[6],"txt",Text_Opacity);
    selectbar_common(focus_group_array[7],"txt",Background_Color);
    selectbar_common(focus_group_array[8],"txt",Background_Opacity);
    selectbar_common(focus_group_array[9],"txt",Edge_Effect);
    selectbar_common(focus_group_array[10],"txt",Edge_Color);
};