// Init
UI.moduleBuilder['setting']['ChFavListPanel'] = function(){

    var channelListData = {
        ChFavListBg:UI.bg_overlay,
        ChFavListImg:UI.window_bg,
        ChFavListTitle:"[SE0592]", //"Favourites List",
        ChFavListBtn:"[OT0390]" // Press CH +/- to go one page up or down
    };
    var template = Util.readJson("module/setting/ChFavListPanel.json");
    var ChFavListPanel = SubModule.create(channelListData, template);

    var channelList = UI.getItem(ChFavListPanel, "channelList");
    var channelTile = UI.getItem(channelList,"channelTile");
    UI.addMask(channelList, 900, 676,50,10);
    UI.setView(channelList, 900, 676);
    function refreshchannelList(){
        var info = {
            template : "ChTileItem",
            direction : CONST.GIRD_DIRECTION.V,
            distance : 20,
            container : channelList,
            pageCount : 6,
            scrollBar : true,
            scrollBarOffset : -50
        };
        var allArray =[];
        ChFavListPanel.channelData = [];
        if(tv){
            ChFavListPanel.channelData = liveTV.getRefChannels();
        }else {
            for (var i = 0; i < 100; i++) {
                var flag = false;
                if (i % 2 == 0) {
                    flag = false;
                } else {
                    flag = true;
                }
                ChFavListPanel.channelData.push({
                    number: "" + i,
                    name: "Channel" + i,
                    favType: flag,
                    uid: i
                });
            }
        }
        //DBG_INFO(objToString(ChFavListPanel.channelData));
        if(ChFavListPanel.channelData.length == null){
            allArray.push(
                {
                    tileBg:UI.item_bg,
                    chlNo : "",
                    chlName : "No Item",
                    name : "Chl0",
                    isFlag: "setting/blank.png",
                    favType:false
                }
            );
        }else{
            for(var i = 0;i < ChFavListPanel.channelData.length;i++){
                allArray.push(
                    {
                        tileBg:UI.item_bg,
                        chlNo : ChFavListPanel.channelData[i].number,
                        chlName : ChFavListPanel.channelData[i].name,
                        name : "Chl"+i,
                        isFlag: ChFavListPanel.channelData[i].favType ? "setting/fav_sel.png":"setting/blank.png",
                        favType:ChFavListPanel.channelData[i].favType
                    }
                );
            }
        }
        channelList.removeChildren();
        info.container.parent.removeChild(info.container.scroll);
        BigList.create(allArray, info);
    }
    ChFavListPanel.currFocus = UI.getItem(channelList, "Chl0");
    ChFavListPanel.onShow=function(){
        var ChMainPanel=UI.getSubModule("ChMainPanel");
        if(!!ChMainPanel)
        {
            ChMainPanel.close();
        }
    };
    ChFavListPanel.onPush = function(){
        DBG_INFO("ChFavList.onPush");
        refreshchannelList();
        ChFavListPanel.currFocus = UI.getItem(channelList, "Chl0");
    };

    channelList.onkey_ENTER = function(focus) {
        if(ChFavListPanel.channelData.length == null) {
            return true;
        }
        var index = channelList.currIndex;
        var Chnl = ChFavListPanel.channelData[index];
        if(Chnl.favType){
            Chnl.favType = false;
            channelList.data[index].isFlag = "setting/fav_unsel.png";
            tv && model.servicelist.SetServiceAttribute(ServicelistModel.SERVICE_ATTR_FAVORITE,0,Chnl.uid);
            Chnl.attr &= (~ServicelistModel.SERVICE_BITMASK_IS_FAVORITE);
        }else{
            Chnl.favType = true;
            channelList.data[index].isFlag = "setting/fav_sel.png";
            tv && model.servicelist.SetServiceAttribute(ServicelistModel.SERVICE_ATTR_FAVORITE,1,Chnl.uid);
            Chnl.attr |= ServicelistModel.SERVICE_BITMASK_IS_FAVORITE;
        }
        channelList.refreshSingleData();
        UI.updateStage();
        //UI.setVoiceStr(ChFavListPanel.currFocus.children[3],Chnl.favType ? Chnl.name+" "+"add fav":Chnl.name+" "+"cancel fav");
        liveTV.RefreshAftFavEdit(Chnl);
        var crntChannel = liveTV.getCurrentChannelInfo();
        if(crntChannel.uid == Chnl.uid) {
            crntChannel.favType = Chnl.favType;
            liveTV.updateCurrentChannelInfo(crntChannel);
        }
        DBG_INFO("channelId::"+Chnl.uid +"Chnl.favType::"+Chnl.favType,DebugLevel.ALWAYS);
        return false;
    };
    channelList.onFocus = function(focus){
        var index = channelList.currIndex;
        var Chnl = ChFavListPanel.channelData[index];
        channelList.data[index].isFlag = Chnl.favType ?"setting/fav_sel.png":"setting/fav_unsel.png";
        channelList.refreshSingleData();
        return true;
    };
    channelList.onNormal = function(){
        return true;
    };
    channelList.onkey_UP = function () {
        if (channelList.currIndex <= 0) {
            AllListCurrBlur();
            channelList.currIndex = channelList.data.length - 1;
            channelList.navTo(channelList.currIndex, 7);
            return false;
        }else{
            AllListCurrBlur();
        }
        channelList.navPrev();
        return true;
    }
    channelList.onkey_DOWN = function () {
        if (channelList.currIndex >= channelList.data.length - 1) {
            AllListCurrBlur();
            channelList.currIndex = 0;
            channelList.navTo(channelList.currIndex, 0);
            return false;
        }else{
            AllListCurrBlur();
        }
        channelList.navNext();
        return true;
    }
    channelList.onkey_CHUP = function () {
        if(channelList.currIndex > 0){
            AllListCurrBlur();
            channelList.prevPage();
        }else{
            AllListCurrBlur();
            channelList.currIndex = channelList.data.length - 1;
            channelList.navTo(channelList.currIndex, 7);
            return false;
        }
        return true;
    };
    channelList.onkey_CHDOWN = function () {
        if (channelList.initSequence.length <= 1) {
            return false;
        }
        if(channelList.currIndex < channelList.data.length - 1){
            AllListCurrBlur();
            channelList.nextPage();
        }else{
            AllListCurrBlur();
            channelList.currIndex = 0;
            channelList.navTo(channelList.currIndex, 0);
            return false;
        }
        return true;
    };
    function AllListCurrBlur(){
        var Chnl = ChFavListPanel.channelData[channelList.currIndex];
        channelList.data[channelList.currIndex].isFlag = Chnl.favType?"setting/fav_sel.png":"setting/blank.png";
        channelList.refreshSingleData();
    }
}