// Init
UI.moduleBuilder['setting']['BluetoothSetting'] = function(){

    var BluetoothListData = {
        audioSheetImg: UI["setting_bg"],
        audioImg1: "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_network_154x154.png",
        audiotitle1:"[SE0119]",//network
        audioHelpInfo:"[SE2945]",//Connect to the network using Bluetooth technology.
        BluetoothTitle:"[SE0183]",
        DeviceTitle: "[SE3002]",// "Paired devices",
        SearchDeviceTitle: "[SE3003]",// "Available devices",
        RefreshTitle:"[SS0020]",
        sndModeImg1: UI.btn_normal_bg,
        RemoteTipTitle:"[SE3491]",
        RemoteTipImg:UI.btn_normal_bg,
        RefreshImg:UI.btn_normal_bg,
        BluetoothSwitchLoading:"setting/wifi/ic_loading_01.png",
        BluetoothSearchLoading:"setting/ic_loading1.png"
    };
    var template = Util.readJson("module/setting/BluetoothSetting.json");
    var BluetoothSetting = SubModule.create(BluetoothListData, template);
    var audioRightGrp = UI.getItem(BluetoothSetting, "audioRightGrp");
    var BluetoothSearchLoading = UI.getItem(BluetoothSetting, "BluetoothSearchLoading");
    var BluetoothRemoteTip = UI.getItem(audioRightGrp, "BluetoothRemoteTip");
    var BluetoothSwitch = UI.getItem(audioRightGrp, "BluetoothSwitch");
    var BluetoothSwitchImg = UI.getItem(BluetoothSwitch, "BluetoothSwitchImg");
    var BluetoothSwitchLoading = UI.getItem(BluetoothSwitch, "BluetoothSwitchLoading");
    var PairedDevice = UI.getItem(audioRightGrp, "PairedDevice");
    var SearchDevice = UI.getItem(audioRightGrp, "SearchDevice");
    var PairedDeviceList = UI.getItem(PairedDevice, "PairedDeviceList");
    var SearchDeviceList = UI.getItem(SearchDevice, "SearchDeviceList");
    var BluetoothRefresh = UI.getItem(audioRightGrp, "BluetoothRefresh");
    var BluetoothSettingPageData = {
        DeviceTypeImgList: {
            0: "setting/bluetooth/ic_unknown.png",
            1: "setting/bluetooth/ic_keyboard.png",//keyborad
            2: "setting/bluetooth/ic_mouse.png",
            3: "setting/bluetooth/ic_keyboard.png", //keyborad & mouse
            4: "setting/bluetooth/ic_headset.png", //bluetooth Speaker
            5: "setting/bluetooth/ic_sound.png",//sound
            6: "setting/bluetooth/ic_remote.png",//remote
            255:"setting/bluetooth/ic_unknown.png"//unknown device
        },
        DeviceStateImg: {
            0: "",
            1: "setting/blank.png",
            2: "setting/bluetooth/ic_bluetooth_connect.png",
            3: ""
        },
        ConnectFlag: {
            Success: 1,
            Failed: 0
        },
        bluetoothRemoteSupport:true,
        bluetoothStatus:0,
        deviceList:[],
        pairedList:[],
        unPairedList:[],
        refreshDisable:false,
        loadingTimer:0,
        deviceConnectFlag:false,
        deviceConnectIndex:0,
        deviceConnectList:"paired",//unpair: list,paired: list
        waitKeyRelease:false //wait Key Up handle
    };
    BluetoothSetting.noAutoClose = true;
    Switch.create(BluetoothSwitchImg, true);
    BluetoothSwitchLoading.pivot.x = 24;
    BluetoothSwitchLoading.pivot.y = 24;
    UI.addMask(audioRightGrp, 1148, 930, 50, 6);
    UI.setView(audioRightGrp, 1146, 930);

    BluetoothSetting.onPush = function () {
        try {
            BluetoothSetting.currFocus = BluetoothSwitch;
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_DEVICES_ATTR_CHANGED,blueToothDeviceChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_DEVICES_NAME_CHANGED,blueToothDeviceChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_PAIRING_INFO_CHANGED,BluetoothKeyboardPWChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_STATUS_CHANGED,BluetoothStatusChaged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, BluetoothOnkeyReleaseHandler);

            BluetoothSettingPageData.waitKeyRelease = false;
            BluetoothSettingPageData.refreshDisable = false;
            BluetoothSwitchLoading.alpha = 0;
            BluetoothSwitchImg.alpha = 1;
            var bluetoothSwitch = tv ? parseInt(model.bluetooth.getBluetoothStatus()) : 0;
            DBG_ERROR("model.bluetooth.getBluetoothStatus:" + bluetoothSwitch);
            if(bluetoothSwitch == BluetoothStatus.ON){
                BluetoothSettingPageData.bluetoothStatus = 1;
            }else if(bluetoothSwitch == BluetoothStatus.OFF){
                BluetoothSettingPageData.bluetoothStatus = 0;
            }else{
                BluetoothSettingPageData.bluetoothStatus = 0;
                if(tv){
                    model.bluetooth.bluetoothDisableAction();
                }
            }
            setBluetoothSwitch(BluetoothSettingPageData.bluetoothStatus);
            if(BluetoothSettingPageData.bluetoothStatus){
                var noUnpaireList = true;
                getBlueToothDeviceList(noUnpaireList);
                BluetoothSetting.CreateAllList();
                BluetoothSetting.startLoading("setBluetoothSwitch",30);
            }
        }
        catch (ex) {
            DBG_ERROR("BluetoothSetting.onPush:"+ex.message);
        }
    }

    function setBluetoothSwitch(flag) {
        try{
            DBG_ERROR("setBluetoothSwitch:"+flag);
            BluetoothSwitchImg.setSwitch(flag);
            if(BluetoothSettingPageData.deviceConnectFlag){
                BluetoothStopConnectDevice();
            }
            if (!flag) {
                BluetoothSetting.closeSwitchState();
            }
            else {
                BluetoothRefresh.alpha = 1;
                BluetoothRefresh.disable = false;
                BluetoothSwitch.downTo = "BluetoothRefresh";
                UI.updateStage();
            }
        }catch (ex){
            DBG_ERROR("setBluetoothSwitch:"+ex.message);
        }
    }
    //all bluetooth list changed
    function blueToothDeviceChanged(array){
        DBG_ERROR("blueToothDeviceChanged"+array);
        if(UI.getCurrSubModule().name == "BluetoothDialog" || UI.getCurrSubModule().name == "BluetoothPassword"){
            UI.popSubModule();
        }
        if(BluetoothSettingPageData.deviceConnectFlag){
            BluetoothStopConnectDevice();
        }

        if(0 == BluetoothSettingPageData.bluetoothStatus){
            DBG_ERROR("blueToothDeviceChanged:BluetoothSettingPageData.bluetoothStatus = 0");
            return;
        }
        var noUnpaireList = false;
        getBlueToothDeviceList(noUnpaireList);
        BluetoothSetting.CreateAllList();
    }
    function getBlueToothDeviceList(noUnpaireList){
        try{
            if(tv){
                var deviceNum = model.bluetooth.getDeviceCount();
                DBG_ERROR("getBlueToothDeviceList:deviceNum:"+deviceNum);
                var deviceAddrList = model.bluetooth.getDevicesAddr();
                var deviceNameList = model.bluetooth.getDevicesName();
                var deviceAttributesList = model.bluetooth.getDevicesAttributes();
                var deviceProfilesList = model.bluetooth.getDevicesProfiles();
            }else{
                var deviceNum = 8;
                var deviceAddrList = ["1","2","3","4","5","6","7","8"];
                var deviceNameList = ["a1","b2","c3","d4","e5","f6","g7","h8"];
                var deviceAttributesList = [0,1,0,3,0,3,0,3];
                var deviceProfilesList = [1,2,3,4,5,6,255,0];
            }
            BluetoothSettingPageData.pairedList = [];
            BluetoothSettingPageData.unPairedList = [];
            for(var i = 0; i < deviceNum; i ++){
                DBG_ERROR("getBlueToothDeviceList:deviceNum="+deviceNum+",name="+deviceNameList[i]+",addr="+deviceAddrList[i]+",attribute="+deviceAttributesList[i]+",profile="+deviceProfilesList[i]);
                if(deviceAttributesList[i] == BluetoothAttribute.PAIRED || deviceAttributesList[i] == BluetoothAttribute.CONNECTED){
                    BluetoothSettingPageData.pairedList.push(
                        {
                            tileBg: UI.btn_normal_bg,
                            DeviceTypeImg: deviceProfilesList[i] < 7 ? BluetoothSettingPageData.DeviceTypeImgList[deviceProfilesList[i]] : BluetoothSettingPageData.DeviceTypeImgList[deviceProfilesList[0]],
                            DeviceName: deviceNameList[i],
                            DeviceStateImg: BluetoothSettingPageData.DeviceStateImg[deviceAttributesList[i]],
                            deviceAddr: deviceAddrList[i],
                            deviceNametxt: deviceNameList[i],
                            deviceType: deviceProfilesList[i],
                            deviceState: deviceAttributesList[i],
                            name: "paired" + BluetoothSettingPageData.pairedList.length
                        }
                    )
                }else{
                    if(!noUnpaireList){
                        BluetoothSettingPageData.unPairedList.push(
                            {
                                tileBg: UI.btn_normal_bg,
                                DeviceTypeImg:deviceProfilesList[i] < 7 ? BluetoothSettingPageData.DeviceTypeImgList[deviceProfilesList[i]] : BluetoothSettingPageData.DeviceTypeImgList[0],
                                DeviceName: deviceNameList[i],
                                DeviceConnectLoading:"setting/wifi/ic_loading_01.png",
                                deviceNametxt: deviceNameList[i],
                                deviceType: deviceProfilesList[i],
                                deviceAddr: deviceAddrList[i],
                                name: "unpaired" + BluetoothSettingPageData.unPairedList.length
                            }
                        )
                    }

                }
            }
        }catch (ex){
            DBG_ERROR("getBlueToothDeviceList:"+ex.message);
        }

    }
    BluetoothSetting.closeSwitchState = function(){
        BluetoothSwitch.downTo = "BluetoothSwitch";
        BluetoothRefresh.alpha = 0;
        PairedDevice.alpha = 0;
        SearchDevice.alpha = 0;
        BluetoothRefresh.disable = true;
        PairedDeviceList.disable = true;
        SearchDeviceList.disable = true;
        UI.updateStage();
    }
    BluetoothSetting.CreateAllList = function (){
        try{
            //get the focus info before create list
            var currFocus = BluetoothSetting.currFocus.name;
            var currIndex = 0;
            if(!!BluetoothSetting.currFocus.parent &&
                (BluetoothSetting.currFocus.parent.name == "SearchDeviceList" || BluetoothSetting.currFocus.parent.name == "PairedDeviceList")){
                var currAddr = "";
                if(BluetoothSetting.currFocus.parent.name == "SearchDeviceList"){
                    currFocus = BluetoothSetting.currFocus.parent.name;
                    var index = SearchDeviceList.initSequence.indexOf(BluetoothSetting.currFocus);
                    currAddr = SearchDeviceList.initSequence[index].data.deviceAddr;
                }else if(BluetoothSetting.currFocus.parent.name == "PairedDeviceList"){
                    currFocus = BluetoothSetting.currFocus.parent.name;
                    var index = PairedDeviceList.initSequence.indexOf(BluetoothSetting.currFocus);
                    currAddr = PairedDeviceList.initSequence[index].data.deviceAddr;
                }
                for(var i = 0; i < BluetoothSettingPageData.pairedList.length; i++){
                    if(currAddr == BluetoothSettingPageData.pairedList[i].deviceAddr){
                        DBG_ERROR("BluetoothSetting.CreateAllList:PairedDeviceList index is:"+i);
                        currFocus = "PairedDeviceList";
                        currIndex = i;
                        break;
                    }
                }
                if(i == BluetoothSettingPageData.pairedList.length){
                    for(var i = 0; i < BluetoothSettingPageData.unPairedList.length; i++){
                        if(currAddr == BluetoothSettingPageData.unPairedList[i].deviceAddr){
                            DBG_ERROR("BluetoothSetting.CreateAllList:SearchDeviceList index is:"+i);
                            currFocus = "SearchDeviceList";
                            currIndex = i;
                            break;
                        }
                    }
                }
            }
        }catch (ex){
            DBG_ERROR("BluetoothSetting.getCurrFocusAddr:"+ex.message);
        }

        DBG_ERROR("BluetoothSetting.CreateAllList:currFocus="+currFocus+",currIndex="+currIndex);

        try{
            BluetoothSetting.CreatePairedList();
            BluetoothSetting.CreateUnPairedList();
            BluetoothSetting.refreshPagePosition();
            if (currFocus == "BluetoothSwitch") {
                if(UI.getCurrSubModule().name != "BluetoothSetting"){
                    BluetoothSetting.currFocus = BluetoothSwitch;
                }else{
                    UI.focusTo(BluetoothSwitch);
                }
            }else if (currFocus == "BluetoothRefresh") {
                if(UI.getCurrSubModule().name != "BluetoothSetting"){
                    BluetoothSetting.currFocus = BluetoothRefresh;
                }else{
                    UI.focusTo(BluetoothRefresh);
                }
            }else if (currFocus == "SearchDeviceList" && BluetoothSettingPageData.unPairedList.length > 0) {
                if(UI.getCurrSubModule().name != "BluetoothSetting"){
                    BluetoothSetting.currFocus = UI.getItem(SearchDeviceList,"unpaired"+currIndex);
                }else{
                    BluetoothSetting.currFocus = UI.getItem(SearchDeviceList,"unpaired"+currIndex);
                    UI.focusTo(BluetoothSetting.currFocus);
                }

            }else if (currFocus == "PairedDeviceList" && BluetoothSettingPageData.pairedList.length > 0) {
                if(UI.getCurrSubModule().name != "BluetoothSetting"){
                    BluetoothSetting.currFocus = UI.getItem(PairedDeviceList,"paired"+currIndex);
                }else{
                    BluetoothSetting.currFocus = UI.getItem(PairedDeviceList,"paired"+currIndex);
                    UI.focusTo(BluetoothSetting.currFocus);
                }
            }else{
                if(UI.getCurrSubModule().name != "BluetoothSetting"){
                    BluetoothSetting.currFocus = BluetoothSwitch;
                }else{
                    UI.focusTo(BluetoothSwitch);
                }
            }
        }catch (ex){
            DBG_ERROR("CreateAllList:"+ex.message);
            if(UI.getCurrSubModule().name != "BluetoothSetting"){
                BluetoothSetting.currFocus = BluetoothSwitch;
            }else{
                UI.focusTo(BluetoothSwitch);
            }
        }
    }

    BluetoothSetting.refreshPagePosition = function(){
        try{
            if(PairedDeviceList.children.length == 0){
                if(SearchDeviceList.children.length == 0){
                    BluetoothSetting.changePosition(BluetoothSwitch, BluetoothRefresh, 60);
                    BluetoothSwitch.downTo = "BluetoothRefresh";
                }else{

                    BluetoothSetting.changePosition(BluetoothSwitch, SearchDevice, 20);
                    BluetoothSetting.changePosition(SearchDevice, BluetoothRefresh, 80);
                    BluetoothSwitch.downTo = "unpaired0";
                }
            }else{
                if(SearchDeviceList.children.length == 0){

                    BluetoothSetting.changePosition(BluetoothSwitch, PairedDevice, 20);
                    BluetoothSetting.changePosition(PairedDevice, BluetoothRefresh, 80);
                    PairedDeviceList.downTo = "BluetoothRefresh";
                }else{

                    BluetoothSetting.changePosition(BluetoothSwitch, PairedDevice, 20);
                    BluetoothSetting.changePosition(PairedDevice, SearchDevice, 20);
                    BluetoothSetting.changePosition(SearchDevice, BluetoothRefresh, 80);
                    BluetoothSwitch.downTo = "paired0";
                }
            }
            UI.updateStage();
        }catch (ex){
            DBG_ERROR("refreshPagePosition:"+ex.message);
        }
    }
    BluetoothSetting.CreatePairedList = function () {
        try {
            var info = {
                template: "BluetoothPairedList",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceX: 0,
                distanceY: 10,
                container: null
            };
            PairedDeviceList.removeAllChildren(true);
            if (BluetoothSettingPageData.pairedList.length > 0) {
                PairedDeviceList.disable = false;
                PairedDevice.alpha = 1;
                info.container = PairedDeviceList;
                Gird.create(BluetoothSettingPageData.pairedList, info);
            }
            else{
                PairedDeviceList.disable = true;
                PairedDevice.alpha = 0;
            }
        }
        catch (ex) {
            DBG_INFO(ex.message);
        }

    }

    BluetoothSetting.CreateUnPairedList = function () {
        try {
            var info = {
                template: "BluetoothUnpaireList",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceX: 0,
                distanceY: 10,
                container: null
            };
            SearchDeviceList.removeAllChildren(true);

            if (BluetoothSettingPageData.unPairedList.length > 0) {
                info.container = SearchDeviceList;
                Gird.create(BluetoothSettingPageData.unPairedList, info);
                SearchDevice.alpha = 1;
                SearchDeviceList.disable = false;
            }
            else {
                SearchDevice.alpha = 0;
                SearchDeviceList.disable = true;
            }
        }
        catch (ex) {
            DBG_ERROR("BluetoothSetting.CreateUnPairedList:"+ex.message)
        }
    }

    BluetoothSetting.changePosition = function (from, to, value) {
        try{
            if(from.name == "BluetoothSwitch"){
                to.y = from.y + 60 + value;
            }else{
                to.y = from.y + from.height + value;
            }
        }catch (ex){
            DBG_ERROR("BluetoothSetting.changePosition:"+ex.message)
        }
    }
    BluetoothRemoteTip.onkey_ENTER = function(){
        if(BluetoothSettingPageData.deviceConnectFlag){
            BluetoothStopConnectDevice();
        }
        UI.popAllModule();
        UI.pushSubModule(COMMON.MAIN, "BluetoothRemoteFlow", true,{open:BLUETOOTH_REMOTE_STATUS.DEMON});
    }
    BluetoothSwitch.onkey_ENTER = function(){
        DBG_INFO("BluetoothSwitch.onkey_ENTER:bluetoothSwitch="+BluetoothSettingPageData.bluetoothStatus);
        if(!!BluetoothSettingPageData.loadingTimer){
            BluetoothSetting.endLoading("BluetoothSwitch.onkey_ENTER");
        }
        if(BluetoothSettingPageData.deviceConnectFlag){
            BluetoothStopConnectDevice();
        }
        if(1 == BluetoothSettingPageData.bluetoothStatus){
            BluetoothSettingPageData.waitKeyRelease = true;
        }
        else{
            BluetoothWaitSwitch();
            if(tv){
                model.bluetooth.bluetoothEnableAction();
            }else{
                setTimeout(function(){
                    BluetoothStatusChaged(BluetoothStatus.ON);
                },2000);
            }
        }
    }
    function BluetoothOnkeyReleaseHandler(){
        if(BluetoothSettingPageData.waitKeyRelease){
            BluetoothWaitSwitch();
            DBG_ERROR("BluetoothOnkeyReleaseHandler:");
            BluetoothSettingPageData.waitKeyRelease = false;
            if(tv){
                model.bluetooth.bluetoothDisableAction();
            }else{
                setTimeout(function(){
                    BluetoothStatusChaged(BluetoothStatus.OFF);
                },3000);
            }
            return true;
        }
    }
    function BluetoothWaitSwitch(){
        UI.lockAllKeys("BluetoothWaitSwitch");
        UI.getTween(BluetoothSwitchLoading, true, true).to({rotation: BluetoothSwitchLoading.rotation + Math.PI*2}, 3000);
        BluetoothSwitchLoading.alpha = 1;
        BluetoothSwitchImg.alpha = 0;
    }
    function BluetoothEndWaitSwitch(){
        UI.unlockAllKeys("BluetoothEndWaitSwitch");
        createjs.Tween.removeTweens(BluetoothSwitchLoading);
        BluetoothSwitchLoading.alpha = 0;
        BluetoothSwitchImg.alpha = 1;
    }
    function BluetoothStatusChaged(val){
        DBG_ERROR("BluetoothStatusChaged:"+val);
        switch (val){
            case BluetoothStatus.OFF:
                BluetoothEndWaitSwitch();
                BluetoothSettingPageData.bluetoothStatus = 0;
                setBluetoothSwitch(BluetoothSettingPageData.bluetoothStatus);
                if(BluetoothSettingPageData.bluetoothStatus){
                    var noUnpaireList = true;
                    getBlueToothDeviceList(noUnpaireList);
                    BluetoothSetting.CreateAllList();
                    BluetoothSetting.startLoading("BluetoothStatusChaged",30);
                }
                break;
            case BluetoothStatus.ON:
                BluetoothEndWaitSwitch();
                BluetoothSettingPageData.bluetoothStatus = 1;
                setBluetoothSwitch(BluetoothSettingPageData.bluetoothStatus);
                if(BluetoothSettingPageData.bluetoothStatus){
                    var noUnpaireList = true;
                    getBlueToothDeviceList(noUnpaireList);
                    BluetoothSetting.CreateAllList();
                    BluetoothSetting.startLoading("BluetoothStatusChaged",30);
                }
                break;
            case BluetoothStatus.PROGRESS:
                break;
            default :
                break;
        }
    }

    PairedDeviceList.onkey_ENTER = function (focus) {
        try {
            if(!!BluetoothSettingPageData.loadingTimer){
                BluetoothSetting.endLoading("PairedDeviceList.onkey_ENTER");
            }
            if(BluetoothSettingPageData.deviceConnectFlag){
                BluetoothStopConnectDevice();
            }
            var index = PairedDeviceList.initSequence.indexOf(focus);
            DBG_INFO("index:" + index);
            BluetoothSetting.deviceName = PairedDeviceList.initSequence[index].data.deviceNametxt;
            BluetoothSetting.deviceState = PairedDeviceList.initSequence[index].data.deviceState;
            BluetoothSetting.deviceAddr = PairedDeviceList.initSequence[index].data.deviceAddr;
            BluetoothSetting.deviceType = PairedDeviceList.initSequence[index].data.deviceType;
            DBG_ERROR("PairedDeviceList.onkey_ENTER:BluetoothSetting.deviceType"+BluetoothSetting.deviceType);
            if(BluetoothSetting.deviceState == BluetoothAttribute.PAIRED){
                BluetoothSettingPageData.deviceConnectIndex = index;
                BluetoothSettingPageData.deviceConnectList = "paired";
            }
            UI.pushSubModule("setting", "BluetoothDialog", true);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    SearchDeviceList.onkey_ENTER = function (focus) {
        try {
            if(!!BluetoothSettingPageData.loadingTimer){
                DBG_ERROR("SearchDeviceList.onkey_ENTER:loading not end");
                BluetoothSetting.endLoading("SearchDeviceList.onkey_ENTER");
            }
            if(BluetoothSettingPageData.deviceConnectFlag){
                BluetoothStopConnectDevice();
            }
            var index = SearchDeviceList.initSequence.indexOf(focus);
            BluetoothSetting.SearchDeviceName =  SearchDeviceList.initSequence[index].data.deviceNametxt;
            BluetoothSetting.SearchDeviceAddr = SearchDeviceList.initSequence[index].data.deviceAddr;
            BluetoothSetting.deviceType = SearchDeviceList.initSequence[index].data.deviceType;
            DBG_ERROR("SearchDeviceList.onkey_ENTER:BluetoothSetting.deviceType is "+BluetoothSetting.deviceType);
            BluetoothSettingPageData.deviceConnectIndex = index;
            BluetoothSettingPageData.deviceConnectList = "unpair";
            if(parseInt(BluetoothSetting.deviceType) != 1 && parseInt(BluetoothSetting.deviceType) != 3){//not keyboard
                BluetoothSetting.BluetoothStartConnectDevice();
            }
            if (tv) {
                model.bluetooth.bluetoothDeviceSelectAction(BluetoothSettingPageData.unPairedList[index].deviceAddr);
            }
            else {

                var vstr = ["0000",BluetoothSetting.SearchDeviceName];
                BluetoothKeyboardPWChanged(vstr);
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }
    BluetoothSetting.BluetoothStartConnectDevice = function(){
        try{
            BluetoothSettingPageData.deviceConnectFlag = true;
            if(BluetoothSettingPageData.deviceConnectList == "unpair"){
                var  target = UI.getItem(SearchDeviceList,"unpaired"+BluetoothSettingPageData.deviceConnectIndex);
            }else{
                var  target = UI.getItem(PairedDeviceList,"paired"+BluetoothSettingPageData.deviceConnectIndex);
                UI.setImage(target.children[3],"setting/wifi/ic_loading_01.png",target, true);
            }
            if(!!target && !!target.children[3]){
                target.children[3].alpha = 1;
                target.children[3].pivot.x = 24;
                target.children[3].pivot.y = 24;
                UI.getTween(target.children[3], true, true).to({rotation: target.children[3].rotation + Math.PI*2}, 3000);
            }
        }catch (ex){
            DBG_ERROR("BluetoothSetting.BluetoothStartConnectDevice:"+ex.message);
        }
    }
    function BluetoothStopConnectDevice(){
        try{
            BluetoothSettingPageData.deviceConnectFlag = false;
            if(BluetoothSettingPageData.deviceConnectList == "unpair"){
                var  target = UI.getItem(SearchDeviceList,"unpaired"+BluetoothSettingPageData.deviceConnectIndex);
            }else{
                var  target = UI.getItem(PairedDeviceList,"paired"+BluetoothSettingPageData.deviceConnectIndex);
            }
            if(!!target && !!target.children[3]){
                target.children[3].alpha = 0;
                createjs.Tween.removeTweens(target.children[3]);
                target.children[3].pivot.x = 24;
                target.children[3].pivot.y = 24;
            }
        }catch (ex){
            DBG_ERROR("BluetoothStopConnectDevice"+ex.message);
        }

    }
    BluetoothRefresh.onkey_ENTER = function () {
        if(BluetoothSettingPageData.refreshDisable){
            return true;
        }
        if(BluetoothSettingPageData.deviceConnectFlag){
            BluetoothStopConnectDevice();
        }
        SearchDeviceList.disable = true;
        SearchDevice.alpha = 0;
        SearchDeviceList.removeAllChildren(true);
        if (PairedDeviceList.children.length == 0) {
            BluetoothSetting.changePosition(BluetoothSwitch, BluetoothRefresh, 60);
        }
        else if (PairedDeviceList.children.length > 0) {
            BluetoothSetting.changePosition(PairedDevice, BluetoothRefresh, 80);
        }
        UI.focusTo(BluetoothRefresh);
        BluetoothSetting.startLoading("BluetoothRefresh", 30);
    }

    BluetoothSwitch.onkey_DOWN = function () {
        if (PairedDeviceList.disable == false) {
            UI.focusTo(PairedDeviceList.initSequence[0]);
            return;
        }
        else if (SearchDeviceList.disable == false) {
            UI.focusTo(SearchDeviceList.initSequence[0]);
            return;
        }
        else if (BluetoothRefresh.alpha == 1) {
            UI.focusTo(BluetoothRefresh);
        }


    }
    SearchDeviceList.onkey_UP = function (focus) {
        var SearchDeviceList = UI.getItem(SearchDevice, "SearchDeviceList");
        var index = SearchDeviceList.initSequence.indexOf(focus);
        if (index == 0) {
            if (PairedDeviceList.disable == true) {
                UI.focusTo(BluetoothSwitch);
                return false;
            }
            else {
                SearchDeviceList.upTo = "paired" + (PairedDeviceList.initSequence.length - 1);
                return true;
            }
        }else{
            return true;
        }
    }
    SearchDeviceList.onkey_DOWN = function (focus) {
        var index = SearchDeviceList.initSequence.indexOf(focus);
        if (index == SearchDeviceList.initSequence.length - 1) {
            UI.focusTo(BluetoothRefresh);
        }
        return true;
    }
    PairedDeviceList.onkey_UP = function (focus) {
        var index = PairedDeviceList.initSequence.indexOf(focus);
        if (index == 0) {
            UI.focusTo(BluetoothSwitch);
        }else{
            return true;
        }
    }
    PairedDeviceList.onkey_DOWN = function (focus) {
        var index = PairedDeviceList.initSequence.indexOf(focus);
        if (index == PairedDeviceList.initSequence.length - 1) {
            if (SearchDeviceList.disable == false) {
                PairedDeviceList.downTo = "unpaired0"
            }
            else {
                UI.focusTo(BluetoothRefresh);
            }

        }
        return true;
    }
    BluetoothRefresh.onkey_UP = function () {
        if (SearchDeviceList.disable == false) {
            UI.focusTo(SearchDeviceList.initSequence[SearchDeviceList.initSequence.length - 1]);
        }
        else if (PairedDeviceList.disable == false) {
            UI.focusTo(PairedDeviceList.initSequence[PairedDeviceList.initSequence.length - 1]);
        }
        else {
            UI.focusTo(BluetoothSwitch);
        }
    }
    BluetoothSetting.onExit = function (){
        if(!!BluetoothSettingPageData.loadingTimer){
            BluetoothSetting.endLoading("onExit");
        }
        if(BluetoothSettingPageData.deviceConnectFlag){
            BluetoothStopConnectDevice();
        }
    }
    BluetoothSetting.onPop = function () {
        try {
            DBG_INFO(" BluetoothSetting.onPop");
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_DEVICES_ATTR_CHANGED,blueToothDeviceChanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_STATUS_CHANGED,BluetoothStatusChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_PAIRING_INFO_CHANGED,BluetoothKeyboardPWChanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, BluetoothOnkeyReleaseHandler);


            if(!!BluetoothSettingPageData.loadingTimer){
                BluetoothSetting.endLoading("onpop");
            }
            if(BluetoothSettingPageData.deviceConnectFlag){
                BluetoothStopConnectDevice();
            }

        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    BluetoothSetting.onkey_BACKSPACE = function(){
        UI.popSubModule();
    }

    BluetoothSetting.startLoading = function (from, timeout) {
        DBG_INFO("[BluetoothSetting.startLoading]" + from);
        if (!timeout) {
            timeout = 5;
        }
        BluetoothSearchLoading.alpha = 1;
        UI.getTween(BluetoothSearchLoading, true, true).to({rotation: BluetoothSearchLoading.rotation + Math.PI*2}, 3000);

        clearTimeout(BluetoothSettingPageData.loadingTimer);
        BluetoothSettingPageData.loadingTimer = setTimeout(function () {
            BluetoothSetting.endLoading("startLoading timeout");
        }, timeout * 1000);
        BluetoothSettingPageData.refreshDisable = true;
        if(tv){
            model.bluetooth.bluetoothSearchStart();
        }
    };
    BluetoothSetting.endLoading = function (from) {
        DBG_INFO("[BluetoothSetting.endLoading]" + from);
        try {
            if (!!BluetoothSettingPageData.loadingTimer) {
                clearTimeout(BluetoothSettingPageData.loadingTimer);
                BluetoothSettingPageData.loadingTimer = null;
            }
            BluetoothSearchLoading.alpha = 0;
            createjs.Tween.removeTweens(BluetoothSearchLoading);
            BluetoothSettingPageData.refreshDisable = false;
            if(tv){
                model.bluetooth.bluetoothSearchStop();
            }else{
                setTimeout(function(){
                    blueToothDeviceChanged("");
                },2000);
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function BluetoothKeyboardPWChanged(vstr) {
        DBG_ERROR("BluetoothKeyboardPWChanged Password is:" + vstr);
        if(!vstr[0]){
            DBG_ERROR("BluetoothKeyboardPWChanged:update devicename error");
            return;
        }
        if(vstr[0] != BluetoothSetting.SearchDeviceName){
            DBG_ERROR("BluetoothKeyboardPWChanged:str[0]="+vstr[0]+",BluetoothSetting.SearchDeviceName"+BluetoothSetting.SearchDeviceName);
        }
        BluetoothSetting.deviceName = vstr[0];
        BluetoothSetting.password = vstr[1];
        UI.pushSubModule("setting", "BluetoothPassword", true);
    }
};