// Init
UI.moduleBuilder['setting']['AudioSpeaker'] = function () {

    var AudioSpeakerData = {
        audioSheetImg: UI["setting_bg"],
        audioImg1: "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_audio_154x154.png",
        sndModeImg1: UI.btn_normal_bg,
        audiotitle1: "[SE0058]",//Sound
        speakerTitle: "[SE3250]",//Speaker
        DigitalAudioOutTitle: "[SE0557]",//Digital Audio Out
        audioDelayTitle: "[SE0559]",//Digital Audio Delay
        lipSyncTitle: "[SE0561]",//Lip Sync
        balanceTitle: "[SE0069]"//Balance
    };
    var template = Util.readJson("module/setting/AudioSpeaker.json");
    var AudioSpeaker = SubModule.create(AudioSpeakerData, template);
    var timer;
    var speakerMenu = UI.getItem(AudioSpeaker, "speakerMenu");
    var balanceBar = UI.getItem(AudioSpeaker, "balanceBar");
    var bar = UI.getItem(balanceBar, "bar");
    var audioHelpInfo = UI.getItem(AudioSpeaker, "audioHelpInfo");
    var CurrAudioOut = UI.getItem(AudioSpeaker, "CurrAudioOut");
    var digitalAudioOutMenu = UI.getItem(AudioSpeaker, "digitalAudioOutMenu");
    var audioDelayMenu = UI.getItem(AudioSpeaker, "audioDelayMenu");
    var lipSyncMenu = UI.getItem(AudioSpeaker, "lipSyncMenu");
    var AudioMainPanel = UI.getSubModule("AudioMainPanel");
    AudioSpeaker.currFocus = speakerMenu;
    AudioSpeaker.pageData = {
        "DigitalAudioOut": ["[SE0076]", "[SE0077]", "[OT0182]"], // ["RAW","PCM","Dolby Digital"]
        "audioOut": ["[SE0578]", "[SE0577]"], //["Audio Out Fixed", "Audio Out Variable"]
        "AudioSpeakerList": ["[SE2751]", "[SE0792]", "[SE3526]", "[SE0183]"], //TV Speaker/ARC/SPDIF/BlueTooth
        ARCDeviceWorkingState: {
            Working: 1,
            RestIng: 0
        },
        disableTip: [
            "[SE3326]",
            "[SE3264]"
        ],
        BTAvailable: 0
    };
    var audioSheetImg = UI.getItem(AudioSpeaker, "audioSheetImg");
    audioSheetImg.doFlip = true;
    var audioRightGrp = UI.getItem(AudioSpeaker, "audioRightGrp");
    UI.addMask(audioRightGrp, 1242, 925, 80, 6);
    UI.setView(audioRightGrp, 1242, 925);

    selectBar_common(AudioSpeaker, "speakerMenu", "CurrSpeaker", AudioSpeaker.pageData.AudioSpeakerList, "AudioSpeakersList");
    selectBar_common(AudioSpeaker, "digitalAudioOutMenu", "CurrAudioOut", AudioSpeaker.pageData.DigitalAudioOut, "AudioDigitalAudioOutList");
    labelValue_common(AudioSpeaker, "audioDelayMenu", "audioDelayTitle", "[SE0559]");//Digital Audio Delay
    labelValue_common(AudioSpeaker, "lipSyncMenu", "lipSyncTitle", "[SE0561]"); //Lip Sync
    percentBar_common(AudioSpeaker, "balanceBar", "bar", "value", "balanceTitle", -50, 50);

    function selectBar_common(submodule, group_name, select_txt, item_value_arrary, subname) {
        try {
            var selectBar = UI.getItem(submodule, group_name);
            var selectComp = UI.getItem(selectBar, select_txt);
            Select.create(selectComp, item_value_arrary);

            selectBar.onFocus = function () {
                sndMainPageHelpInfo(group_name);
                return true;
            };
            selectBar.onkey_RIGHT = function () {
                if (AudioSpeaker.pageData.BTAvailable == 0 && group_name == "speakerMenu" && selectComp.selected == "[SE3526]") {
                    selectComp.selectNext();
                    selectComp.selectNext();
                } else {
                    selectComp.selectNext();
                }
                UI.updateStage();
                var index = item_value_arrary.indexOf(selectComp.selected);

                if (group_name == "speakerMenu") {
                    clearTimeout(timer);
                    DBG_INFO("TTTTTTTTTTTTT");
                    timer = setTimeout(function(){
                        selectBarMoveHandler(group_name, index);
                    }, 1000);
                } else {
                    selectBarMoveHandler(group_name, index);
                }
            };
            selectBar.onkey_LEFT = function () {
                if (AudioSpeaker.pageData.BTAvailable == 0 && group_name == "speakerMenu" && selectComp.selected == "[SE2751]") {
                    selectComp.selectPrev();
                    selectComp.selectPrev();
                } else {
                    selectComp.selectPrev();
                }
                UI.updateStage();
                var index = item_value_arrary.indexOf(selectComp.selected);

                if (group_name == "speakerMenu") {
                    clearTimeout(timer);
                    DBG_INFO("TTTTTTTTTTTTT");
                    timer = setTimeout(function(){
                        selectBarMoveHandler(group_name, index);
                    }, 1200);
                } else {
                    selectBarMoveHandler(group_name, index);
                }

            };
            selectBar.onkey_ENTER = function () {
                if (selectBar.disable) {
                    if (group_name == "digitalAudioOutMenu") {
                        UI.showSimpleTip(AudioSpeaker.pageData.disableTip[1]);
                    }
                    else {
                        UI.showSimpleTip(AudioSpeaker.pageData.disableTip[0]);
                    }
                } else {
                    UI.pushSubModule("setting", subname, true);
                }

            };
            selectBar.onkey_DOWN = function () {
                if (group_name == "speakerMenu") {
                    var index = item_value_arrary.indexOf(selectComp.selected);
                    clearTimeout(timer);
                    selectBarMoveHandler(group_name, index);
                }
                return true;
            }
        }
        catch (e) {
            DBG_ERROR("Selectbar_common func is error");
        }
    }


    var CurrSpeaker = UI.getItem(AudioSpeaker, "CurrSpeaker");
    speakerMenu.onkey_ENTER = function () {
        var SpeakersList = [];
        SpeakersList.push({
            listArray: AudioSpeaker.pageData.AudioSpeakerList,
            index: AudioSpeaker.pageData.AudioSpeakerList.indexOf(CurrSpeaker.selected),
            groupName: "SpeakersMenu",
            Title: AudioSpeakerData.speakerTitle
        });
        UI.pushSubModule("setting", "AudioSpeakersList", true, SpeakersList);
    };


    function selectBarMoveHandler(group_name, index) {
        try {
            switch (group_name) {
                case "digitalAudioOutMenu":
                    var DigitalAudioOut = index + 1;
                    DBG_INFO("model.sound.setDigitalAudioOut:" + DigitalAudioOut);
                    tv && model.sound.setDigitalAudioOut(DigitalAudioOut);
                    //AudioDelayDisable(DigitalAudioOut);
                    break;
                case "speakerMenu":
                    var speaker = index + 1;
                    DBG_INFO("model.sound.setSpeakerArc:" + speaker);
                    tv && model.sound.setSpeakerArc(speaker);
                    clearTimeout(timer);
                    if (index == 0) {
                        DisableLipSync(0);
                        DisableBalance(0);
                        DisableAudioOut(1);
                        AudioDelayDisable(0);
                    } else {
                        DisableLipSync(1);
                        DisableBalance(1);
                        DisableAudioDelay(0);
                        DisableAudioOut();
                    }
//                    AudioMainPanel.DisableSoundByARCOn();
                    break;
                default:
                    break;
            }

        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }


    function percentBar_common(submodule, groupname, percentImg, percentTxt, percentTitle, min, max) {
        try {
            var percentBar = UI.getItem(submodule, groupname);
            var percentComp = UI.getItem(percentBar, percentImg);
            var percentTxt = UI.getItem(percentBar, percentTxt);
            var percentTitle = UI.getItem(percentBar, percentTitle);
            Percent.create(percentComp, percentTxt, 0, min, max);
            percentBar.onFocus = function (focus) {
                sndMainPageHelpInfo(groupname);
                UI.updateStage();
                return true;
            };
            percentBar.onkey_RIGHT = function () {
                if (!percentBar.disable) {
                    percentComp.plus();
                    //percentBar.updateCache();
                    UI.updateStage();
                    //DBG_INFO("percentComp.percent:"+percentComp.percent);
                    if (!!tv) {
                        model.sound.setBalance(percentComp.percent);
                    }
                }
            };
            percentBar.onkey_LEFT = function () {
                if (!percentBar.disable) {
                    percentComp.minus();
                    //percentBar.updateCache();
                    UI.updateStage();
                    if (!!tv) {
                        model.sound.setBalance(percentComp.percent);
                    }
                    SetRecentUse("[SE0064]", "Sound", "Speakers");
                }
            };
            percentBar.onkey_ENTER = function () {
                if (percentBar.disable) {
                    UI.showSimpleTip(AudioSpeaker.pageData.disableTip[0]);
                }
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function labelValue_common(submodule, groupname, lable, value) {
        try {
            var lableGroup = UI.getItem(submodule, groupname);
            var lableTitle = UI.getItem(lableGroup, lable);
            LabelValue.create(lableTitle, value, "36px SourceSansPro-Light", "0xFFFFFF");
            //lableGroup.updateCache();
            UI.updateStage();
//            lableTitle.setLabelFont("36px SourceSansPro-Light");
            lableGroup.onFocus = function () {
                sndMainPageHelpInfo(groupname);
                // lableTitle.onFocus();
                UI.updateStage();
                return true;
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    AudioSpeaker.onShow = function () {
        AudioSpeaker.alpha = 1;
        InitDigitalAudioOut();
        getAudioDelayData();
        getLipSyncData();
        getSpeakerARC();
    };
    AudioSpeaker.onPush = function () {
        ModelNotifyInit();
        AudioSpeaker.currFocus = speakerMenu;
        var balance = tv ? model.sound.getBalance() : 0;
        DBG_INFO("model.sound.getBalance():" + balance);
        bar.setPercent(balance);
        initBTAvailable();

        if (GLOBAL.NEC_KEY == true) {
            AudioSpeaker.currFocus = balanceBar;
        }
        GLOBAL.NEC_KEY = false;

    };

    function initBTAvailable() {
        try {
            var BTAvailable = tv ? model.bluetooth.getBluetoothAvailability() : 0;
            DBG_INFO("model.bluetooth.getBluetoothAvailability()" + BTAvailable);
            AudioSpeaker.pageData.BTAvailable = BTAvailable;
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function InitDigitalAudioOut() {
        try {
            var digitalOut = tv ? model.sound.getDigitalAudioOut() : 1;
            DBG_INFO("model.sound.getDigitalAudioOut():" + digitalOut);
            DigitalAudioOutChaged(digitalOut);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function getAudioDelayData() {
        try {
            var audioDelay = tv ? model.sound.getDigitalAudioDelay() : 0;
            DBG_INFO("model.sound.getDigitalAudioDelay():" + audioDelay);
            DigitalAudioDelayChaged(audioDelay);

        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    function getLipSyncData() {
        try {
            var lipSync = tv ? model.sound.getLipsync() : 0;
            DBG_INFO("model.sound.getLipsync():" + lipSync);
            LipsyncChaged(lipSync);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    function getSpeakerARC() {
        try {
            var speakerArc = tv ? model.sound.getSpeakerArc() : 2;
            DBG_INFO("model.sound.getSpeakerArc():" + speakerArc);
            SpeakerArcChaged(speakerArc);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    function SpeakerArcChaged(val) {
        try {
            DBG_INFO("SpeakerArcChaged:" + val);
            var CurrSpeaker = UI.getItem(AudioSpeaker, "CurrSpeaker");
            CurrSpeaker.selectCurrent(val - 1);
            if (val == 1) {//TvSpeaker
                DisableLipSync(0);
                DisableBalance(0);
                AudioDelayDisable(0);
                DisableAudioOut(1);
                if (AudioSpeaker.currFocus.name == "lipSyncMenu" || AudioSpeaker.currFocus.name == "balanceBar") {
                    setting.onNormal(AudioSpeaker.currFocus);
                    setting.currFocus = AudioSpeaker.currFocus = speakerMenu;
                    setting.onFocus(AudioSpeaker.currFocus);
                }
            } else {
                DisableLipSync(1);
                DisableBalance(1);
                DisableAudioDelay(0);
                DisableAudioOut();
                if (AudioSpeaker.currFocus.name == "audioDelayMenu" || AudioSpeaker.currFocus.name == "digitalAudioOutMenu") {
                    setting.onNormal(AudioSpeaker.currFocus);
                    setting.currFocus = AudioSpeaker.currFocus = speakerMenu;
                    setting.onFocus(AudioSpeaker.currFocus);
                }
            }

        } catch (ex) {
            DBG_ERROR(ex.message);
        }

        try {
            onARCDeviceWorkingStateChanged(ARCDeviceState);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function DigitalAudioOutChaged(val) {
        try {
            DBG_INFO("DigitalAudioOutChaged:" + val);
            var DigitalAudioOut = val - 1;
            CurrAudioOut.selectCurrent(DigitalAudioOut);
            //var index = AudioSpeaker.pageData.DigitalAudioOut.indexOf(CurrAudioOut.selected);
            //AudioDelayDisable(1);
        }
        catch (ex) {
            DBG_ERROR(ex.message)
        }
    }

    function DigitalAudioDelayChaged(val) {
        try {
            DBG_INFO("DigitalAudioDelayChaged:" + val);
            var audioDelayTitle = UI.getItem(AudioSpeaker, "audioDelayTitle")
            audioDelayTitle.setValue(val);
        }
        catch (ex) {
            DBG_ERROR(ex.message)
        }
    }

    function LipsyncChaged(val) {
        try {
            DBG_INFO("LipsyncChaged:" + val);
            var lipSyncTitle = UI.getItem(AudioSpeaker, "lipSyncTitle");
            lipSyncTitle.setValue(val);
        }
        catch (ex) {
            DBG_ERROR(ex.message)
        }
    }

    function ModelNotifyInit() {
        try {
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.DIGITAL_AUDIO_OUT, DigitalAudioOutChaged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.DIGITAL_AUDIO_DELAY, DigitalAudioDelayChaged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_LIP_SYNC, LipsyncChaged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SPEAKER, SpeakerArcChaged);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function UnModelNotifyInit() {
        try {
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.DIGITAL_AUDIO_OUT, DigitalAudioOutChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.DIGITAL_AUDIO_DELAY, DigitalAudioDelayChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_LIP_SYNC, LipsyncChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SPEAKER, SpeakerArcChaged);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }


    //dbtag:20161115 --Start --Rick
    function DisableAudioDelay() {
        var flag = -1;
        var audioDelayTitle = UI.getItem(AudioSpeaker, "audioDelayTitle");
        var digitalOut = tv ? model.sound.getDigitalAudioOut() : 1;
        if (digitalOut == 0) flag = 1;
        else flag = 0;

        if (flag == 1) {
            audioDelayMenu.disable = true;
            audioDelayMenu.alpha = 0.3;
        }
        else {
            audioDelayMenu.disable = false;
            audioDelayMenu.alpha = 1;
        }
        UI.updateStage();
    }

    function DisableBalance(flag) {
        var balanceBar = UI.getItem(AudioSpeaker, "balanceBar");
        if (flag == 1) {
            balanceBar.disable = true;
            balanceBar.alpha = 0.3;
        }
        else {
            balanceBar.disable = false;
            balanceBar.alpha = 1;
        }
        UI.updateStage();
    }

    function DisableLipSync(flag) {
        var lipSyncTitle = UI.getItem(AudioSpeaker, "lipSyncTitle");
        if (flag == 1) {
            lipSyncMenu.disable = true;
            lipSyncMenu.alpha = 0.3;

        }
        else {
            lipSyncMenu.disable = false;
            lipSyncMenu.alpha = 1;
        }
        UI.updateStage();
    }

    function DisableAudioOut(flag) {
        var digitalAudioOutMenu = UI.getItem(AudioSpeaker, "digitalAudioOutMenu");
        if (flag == 1) {
            digitalAudioOutMenu.disable = true;
            digitalAudioOutMenu.alpha = 0.3;
        }
        else {
            digitalAudioOutMenu.disable = false;
            digitalAudioOutMenu.alpha = 1;
        }
        UI.updateStage();
    }

    //dbtag:20161115 --end --Rick


    var AudioDelayDisable = function (flag) {
        var audioDelayTitle = UI.getItem(AudioSpeaker, "audioDelayTitle");
        if (flag == 0) {
            audioDelayMenu.disable = true;
            audioDelayMenu.alpha = 0.3;

        }
        else {
            audioDelayMenu.disable = false;
            audioDelayMenu.alpha = 1;
        }
        UI.updateStage();
    };
    AudioSpeaker.sndHelpInfo = {
        speakerMenu: {
            title: "[SE3250]",
            info: "[SE3251]"//"Adjust the left and right speaker strength to optimize audio for a specific location."
        },
        digitalAudioOutMenu: {
            title: "Digital Audio Out",
            info: "[SE0558]"//"Select the digital audio output format that best suits the audio device type."
        },
        audioDelayMenu: {
            title: "Digital Audio Delay",
            info: "[SE0560]"//"Adjust the digital audio output delay time to sync sound from an external speaker with the images on the TV."
        },
        lipSyncMenu: {
            title: "lip Sync",
            info: "[SE0562]"//"Synchronize the displayed image with the audio output."
        },
        balanceBar: {
            title: "Balance",
            info: "[SE0563]"//"Adjust the left and right speaker strength to optimize audio for a specific location."
        }
    };
    function sndMainPageHelpInfo(id) {
        UI.setText(audioHelpInfo, AudioSpeaker.sndHelpInfo[id].info);
    }

    audioDelayMenu.onkey_ENTER = function () {
        if (audioDelayMenu.disable) {
            UI.showSimpleTip(AudioSpeaker.pageData.disableTip[1]);
        }
        else {
            AudioSpeaker.alpha = 0;
            AudioMainPanel.alpha = 0;
            UI.pushSubModule("setting", "AudioDigitalAudioDelay", true);
            UI.base.cursor.alpha = 0;
        }

    };
    lipSyncMenu.onkey_ENTER = function () {
        if (!lipSyncMenu.disable) {
            AudioMainPanel.alpha = 0;
            AudioSpeaker.alpha = 0;
            UI.pushSubModule("setting", "AudioLipSync", true);
            UI.base.cursor.alpha = 0;
        }
        else {
            UI.showSimpleTip(AudioSpeaker.pageData.disableTip[1]);
        }
        return true;

    };
    AudioSpeaker.onkey_BACKSPACE = function () {
        UI.popSubModule();
        var caller = UI.getSubModule("AudioMainPanel");
        if (!caller) {
            UI.pushSubModule("setting", "AudioMainPanel", true)
        }
    };
    AudioSpeaker.onPop = function () {
        UnModelNotifyInit();
    };

    // factory-----------------
    function BalanceFunc() {
        var self = this;
        self.numVec = [];
        var KeyFuncNumVec = ["ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"];
        self.clearNumVec = function () {
            self.numVec = [];
        };

        self.IsVecEqual = function (val) {
            var timeOut = 5000;
            var isEqual = false;
            if (self.numVec.length != 4) {
                isEqual = false;
            } else {
                if (self.numVec[0].key == val.toString()[0] &&
                    self.numVec[1].key == val.toString()[1] &&
                    self.numVec[2].key == val.toString()[2] &&
                    self.numVec[3].key == val.toString()[3]) {
                    if (self.numVec[3].time - self.numVec[0].time <= timeOut) {
                        DBG_INFO("Vec Equal");
                        isEqual = true;
                    } else {
                        DBG_INFO("Vec Equal but time out");
                        isEqual = false;
                    }

                } else {
                    DBG_INFO('Vec not Equal');
                    isEqual = false;
                }
            }

            return isEqual;
        };
        self.CreateBalanceKeyFunc = function (bar) {
            for (var i = 0; i < KeyFuncNumVec.length; i++) {
                bar["onkey_" + KeyFuncNumVec[i]] = function () {
                    var num = KeyFuncNumVec.indexOf(arguments[1].value)
                    DBG_INFO("BALANCE KEY: " + num);
                    if (self.numVec.length >= 4) {
                        self.numVec.shift();
                    }
                    self.numVec.push({key: num, time: new Date().getTime()});

                    if (self.IsVecEqual(1969)) {
                        DBG_INFO("===================start factory=================")
                        StartFactory();
                        //UI.clearAllSubModule();
                        //
                        //startThirdPartyApp(APPNAME.FACTORY, null, CMDType.COMMON, CMDMethod.COMMON, false);
                    }
                    else if (self.IsVecEqual("0548")) {
                        //UI.pushSubModule("setting", "AudioSpeaker", true);
//                        UI.pushSubModule("setting", "HotelMenu", true);
                    }
                    //DBG_INFO("self.numVec " + JSON.stringify(self.numVec));

                }
            }
        }
    }

    var balFunc = new BalanceFunc();
//    var balanceBar = UI.getItem(AudioAdvance, "balanceBar");
    balFunc.CreateBalanceKeyFunc(balanceBar);
    //factory end-----------------------------------

};

