/**
 * Created by Hisense on 2016-2-29.
 */
// Init
UI.moduleBuilder['setting']['AudioOutList'] = function(){

    var initData = {
        AudioBg: UI['bg_overlay'],
        AudioOutListBg: UI.window_bg,
        AudioOutTitle:"[SE0575]"//Audio Out

    };
    var template = Util.readJson("module/setting/AudioOutList.json");
    var AudioOutList = SubModule.create(initData, template);

    AudioOutList.operateData = {
        "AudioOutList": [
            {
                "map": 1,
                "name": "[OT0435]",//"[OT0435]Variable",
                "flag": false
            },
            {
                "map": 0,
                "name": "[OT0436]",//"[OT0436]Fixed",
                "flag": false
            }
        ],
        "currAudioOutIdx": 0
    };
    function SndgetAudioOutIdx() {
        try {

            var audioOutTmp = tv ? model.sound.getAudioOut() : 1;
            DBG_INFO("model.sound.getAudioOut=" + audioOutTmp);
            for (var i = 0; i < AudioOutList.operateData.AudioOutList.length; i++) {
                if (audioOutTmp == AudioOutList.operateData.AudioOutList[i].map) {
                    break;
                }
            }
            return i;

        } catch (ex) {
            DBG_ERROR("SndgetAudioOutIdx:" + ex.message);
        }
    }

    // 初始化Grid控件
    // 取得目标锚点
    var List = UI.getItem(AudioOutList, "List");

    // Grid的配置信息JSON
    var info = {
        // 每个图标使用的模板名
        template: "DialogListItem",
        // V表示竖向排列，H表示横向排列
        direction: CONST.GIRD_DIRECTION.H,
        // 每隔几个图标就换行
        breakNum: 1,
        // 每隔图标之间的距离
        distanceX: 0,
        distanceY: 20,
        // 要将此Grid添加到哪个锚点位置上
        container: List
    };

    // 声明一个初始化用数组，将数据配置好
    var allArray = [];
    for (var i = 0; i < AudioOutList.operateData.AudioOutList.length; i++) {
        allArray.push(
            {
                ItemName: AudioOutList.operateData.AudioOutList[i].name,
                tileBg: UI.item_bg,
                name: "item" + i,
                isFlag: "setting/ic_radiobutton_normal.png"
            }
        )
    }
    // 调用Grid.create方法生成Gird并添加到锚点位置上
    Gird.create(allArray, info);
    // 设置视野范围，当焦点超出此范围时，整个Grid会反向移动，达到滚动效果（此处配置的x，y是全局坐标）

    // 设置遮罩范围，隐藏显示不下的图标
    AudioOutList.operateData.currAudioOutIdx = SndgetAudioOutIdx();
    AudioOutList.currFocus = UI.getItem(List, "item" + AudioOutList.operateData.currAudioOutIdx);
    AudioOutList.onShow = function () {
        AudioOutList.operateData.currAudioOutIdx = SndgetAudioOutIdx();
        DBG_INFO("setAudioOutList.onShow");
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png",List.children[i]);
        }
        AudioOutList.currFocus = UI.getItem(List, "item" + AudioOutList.operateData.currAudioOutIdx);
        UI.setImage(AudioOutList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage(),AudioOutList.currFocus);
        UI.focusTo(UI.getItem(List, "item" + AudioOutList.operateData.currAudioOutIdx));
    };

    var AudioOutList = UI.getSubModule("AudioOutList");
    var List = UI.getItem(AudioOutList, "List");

    function SndSetCurrAudioOutIdx(idx) {
        try {
            AudioOutList.operateData.currAudioOutIdx = idx;

            var audioOutList = AudioOutList.operateData.AudioOutList;
            if (idx > audioOutList.length - 1) {
                DBG_ERROR("SndSetCurrAudioOutIdx:idx=" + idx);
                idx = 0;
            }
            DBG_INFO("model.sound.setAudioOut:"+audioOutList[idx].map);
            tv? model.sound.setAudioOut(audioOutList[idx].map) :1;

        } catch (ex) {
            DBG_ERROR("SndSetCurrAudioOutIdx:" + ex.message);
        }

    }

    List.onkey_ENTER = function (focus) {
        var index = List.initSequence.indexOf(focus);//AudioOutList.currFocus.name.slice(-1);
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png");
        }
        UI.setImage(AudioOutList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage());
        SndSetCurrAudioOutIdx(index);
        UI.popSubModule();
        return true;
    };

};