// Init
UI.moduleBuilder['setting']['AudioMenuPromptsSetting'] = function () {

    var AudioMenuPromptsSettingData = {
        AudioMenuPromptsSettingImg: UI.setting_bg,
        AudioMenuPromptsImg: "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_accessibility_154x154.png",
        //panelBg: "setting/bg.png",
        ItemImg1: UI.btn_normal_bg

    };
    var AudioMenuPromptsHelpInfo = {
        VolumeBar: '[SE3062]',//"Set the Menu Audio volume.",
        LanguageBar: '[SE3063]',//"Set the Menu Audio language.",
        RateBar: '[SE3059]',//'Set the Menu Audio speed.',
        PitchBar: '[SE3060]',//"Set the Menu Audio pitch.",
        FocusMenuAudio: '[SE3061]'//"Turn down the background volume when Menu Audio is playing."
    };
    var AudioMenuPromptsSettingTitle = {
        VolumeBar: '[SE1929]',//"Volume",
        LanguageBar: '[SE0190]',//"Language",
        RateBar: '[SE3033]',//'Rate',
        PitchBar: '[SE3034]',//"Pitch",
        FocusMenuAudio: '[SE3035]'//"Focus Menu Audio"
    };
    //--translate ---//
    var LanguageBar = ['[SE0193]', '[SE0196]'];//["English","Spanish"];
    var RateBar = ["[SE3036]", "[DMP0016]", "[SE0080]", "[DMP0015]", "[SE3037]"];//["Very Slow","Slow","Normal","Fast","Very
    // Fast"];
    var left_content_title = ["[SE3021]"];
    var template = Util.readJson("module/setting/AudioMenuPromptsSetting.json");
    var Group_array = ["VolumeBar", "LanguageBar", "RateBar", 'PitchBar', "FocusMenuAudio"];
    var AudioMenuPromptsSetting = SubModule.create(AudioMenuPromptsSettingData, template);
    var SelectDataIndex = {
        RateBar: 0,
        LanguageBar: 0
    };
    var SelectedArray = ["LanguageBar", "RateBar"];
    var VolumeBar = UI.getItem(AudioMenuPromptsSetting, "VolumeBar");
    var PitchBar = UI.getItem(AudioMenuPromptsSetting, "PitchBar");
    var vBar = UI.getItem(VolumeBar, "bar");
    var pBar = UI.getItem(PitchBar, "bar");

    var set_left_content_title = UI.getItem(AudioMenuPromptsSetting, "left_content_title");
    UI.setText(set_left_content_title, left_content_title[0]);
    AudioMenuPromptsSetting.onPush = function () {
        try {
            AudioMenuPromptsSetting.currFocus = VolumeBar;

        }
        catch ( ex ) {
            DBG_ERROR(ex.message);
        }
    }
    AudioMenuPromptsSetting.onShow = function () {
        try {
            AudioMenuPromptsSetting.alpha = 1;
            initSwitchData(AudioMenuPromptsSetting, "FocusMenuAudio", "FocusMenuAudioImg");
            InitCaptionSelectData(get_dataSelectedFromBM, SelectedArray);
            initPercentBarData();
            initTitleContent();
            //initTitleOnNormalStyle();
        }
        catch ( ex ) {
            DBG_ERROR(ex.message);
        }
    }
    AudioMenuPromptsSetting.onExit = function () {
        //if(UI.getCurrSubModule().caller.name == "accessibility_page"){
        //    UI.getCurrSubModule().caller.alpha=1;
        //}
    }
    function listOnKeyEnter( groupName ) {
        try {
            if (groupName == 'LanguageBar') {
                UI.pushSubModule("setting", "AudioMPLanguageList", true);
                //AudioMenuPromptsSetting.alpha = 0;
            }
            if (groupName == 'RateBar') {
                UI.pushSubModule("setting", "AudioMPRateList", true);
                //AudioMenuPromptsSetting.alpha = 0;
            }
        } catch ( ex ) {
            DBG_ERROR(ex.message)
        }
    }

    function setHelpInfo() {
        try {
            //var helpInfoTitle=UI.getItem(accessibility_page,"content_title");
            var helpInfoContent = UI.getItem(AudioMenuPromptsSetting, "AudioMenuPromptsHelpInfo");
            UI.setText(helpInfoContent, AudioMenuPromptsHelpInfo[UI.getCurrFocus().name]);
            UI.updateStage();
        } catch ( ex ) {
            DBG_ERROR("setHelpinfo is error:" + ex.message)
        }
    }

    function initPercentBarData() {
        var Volume = getI32Volume();
        DBG_INFO("model.sound.getBalance():" + Volume);
        vBar.setPercentNoVoice(Volume);
        var Pitch = getI32Pitch();
        DBG_INFO("model.sound.getBalance():" + Pitch);
        pBar.setPercentNoVoice(Pitch);
    }

    function InitCaptionSelectData( SetSelectDataFunc, arr ) {
        for (var i = 0; i < arr.length; i++) {
            var selectBar = UI.getItem(AudioMenuPromptsSetting, arr[i]);
            var selectComp = UI.getItem(selectBar, "Txt");
            if (SetSelectDataFunc) {
                selectComp.selected = SetSelectDataFunc(arr[i]).data;
                SelectDataIndex[arr[i]] = SetSelectDataFunc(arr[i]).index;
                UI.setText(selectComp, SetSelectDataFunc(arr[i]).data);
            }
        }
    }

    function get_dataSelectedFromBM( id ) {
        var SetCcValue = {
            data: null,
            index: 0
        };
        try {
            switch (id) {
                case "LanguageBar":
                    var array = eval(id);
                    SetCcValue.data = array[getI32LangIdx()];
                    SetCcValue.index = getI32LangIdx();
                    DBG_INFO('get_dataSelectedFromBM:' + SetCcValue.index + SetCcValue.data);
                    break;
                case "RateBar":
                    var array = eval(id);
                    SetCcValue.data = array[getI32Speed()];
                    SetCcValue.index = getI32Speed();
                    DBG_INFO('get_dataSelectedFromBM:' + SetCcValue.index + SetCcValue.data);
                    break;
                default :
                    break;
            }

        } catch ( ex ) {
            DBG_ERROR("get_dataSelected is error" + ex.message)
        }
        return SetCcValue;
    }

    function initTitleContent() {
        try {
            for (var i = 0; i < Group_array.length; i++) {
                var TitleContent = UI.getItem(UI.getItem(AudioMenuPromptsSetting, Group_array[i]), "Title");
                UI.setText(TitleContent, AudioMenuPromptsSettingTitle[Group_array[i]]);
            }
        } catch ( ex ) {
            DBG_ERROR(ex.message)
        }
    }

    function initTitleOnNormalStyle() {
        try {
            for (var i = 0; i < Group_array.length; i++) {
                if (UI.getCurrModule().currFocus.name == Group_array[i]) {
                    continue;
                }
                var normalTitleStyle = UI.getItem(UI.getItem(AudioMenuPromptsSetting, Group_array[i]), "Title");
                UI.setTextColor(normalTitleStyle, "rgba(255,255,255,0.6)");
                UI.updateStage();
            }
        } catch ( ex ) {
            DBG_ERROR(ex.message)
        }
    }

    function percentBar_common( submodule, groupname, percentImg, percentTxt, percentTitle, min, max ) {
        try {
            var percentBar = UI.getItem(submodule, groupname);
            var percentComp = UI.getItem(percentBar, percentImg);
            var percentTxt = UI.getItem(percentBar, percentTxt);
            var percentTitle = UI.getItem(percentBar, percentTitle)
            Percent.create(percentComp, percentTxt, 0, min, max);
            percentBar.onFocus = function () {
                setHelpInfo();
                //percentComp.onFocus();
                UI.setTextColor(percentTitle, "#ffffff");
                UI.updateStage();
                return true;
            };
            percentBar.onNormal = function () {
                percentComp.onNormal();
                //UI.setTextColor(percentTitle, "rgba(255,255,255,0.6)");
                //UI.updateStage();
                return true;
            };
            percentBar.onkey_RIGHT = function () {
                percentComp.plus();
                UI.updateStage();
                perCentBarSendToBm(groupname, percentComp.percent)
            };
            percentBar.onkey_LEFT = function () {
                percentComp.minus();
                UI.updateStage();
                perCentBarSendToBm(groupname, percentComp.percent)
            };
        }
        catch ( ex ) {
            DBG_ERROR(ex.message);
        }
    }

    function perCentBarSendToBm( groupname, percent ) {
        try {
            switch (groupname) {
                case 'VolumeBar':
                    setI32Volume(percent);
                    break;
                case "PitchBar":
                    setI32Pitch(percent);
                    break;
                default :
                    break;
            }

        } catch ( ex ) {
            DBG_ERROR(ex.message)
        }
    }

    function selectBarSendToBm( groupname, index ) {
        try {
            var langList=['eng','spa'];
            switch (groupname) {
                case 'LanguageBar':
                    setTTsLanguage(langList[parseInt(index)]);
                    break;
                case "RateBar":
                    setI32Speed(index);
                    break;
                default :
                    break;
            }

        } catch ( ex ) {
            DBG_ERROR(ex.message)
        }
    }

    function focusMenuAudioEnterHandler( flag ) {
        var type = flag == true ? 1 : 0;
        DBG_INFO("VideoDescriptiontype:" + type);
        setI32FocusSpeechAudio(type);
    }

    function initSwitchData( submodule, groupname, pic_switch ) {
        try {

            var switchBar = UI.getItem(submodule, groupname);
            var switchComp = UI.getItem(switchBar, pic_switch);
            var tmpData = getI32FocusSpeechAudio();
            switchComp.setSwitch(tmpData);
            //switchBar.updateCache();
            UI.updateStage();

        } catch ( ex ) {
            DBG_ERROR(ex.message)
        }
    }

    function Switchbar_common( submodule, groupname, pic_switch_name, txt_switch_name ) {
        try {
            var switchBar = UI.getItem(submodule, groupname);
            var switchBarText = UI.getItem(switchBar, txt_switch_name);
            var switchComp = UI.getItem(switchBar, pic_switch_name);
            Switch.create(switchComp, true);
            ////switchBar.updateCache();
            switchBar.onFocus = function () {
                setHelpInfo();
                switchComp.onFocus();
                UI.setTextColor(switchBarText, "#ffffff");
                //switchBar.updateCache();
                UI.updateStage();
                return true;
            };
            switchBar.onNormal = function () {
                switchComp.onNormal();
                //UI.setTextColor(switchBarText, "rgba(255,255,255,0.6)");
                ////switchBar.updateCache();
                //UI.updateStage();
                return true;
            };
            switchBar.onkey_LEFT = switchBar.onkey_RIGHT =
                switchBar.onkey_ENTER = function () {
                    switchComp.switch();
                    //switchBar.updateCache();
                    UI.updateStage();
                    focusMenuAudioEnterHandler(switchComp.flag);
                };
        }
        catch ( ex ) {
            DBG_ERROR("Switchbar_common func is error" + ex.message);
        }
    }

    function selectbar_common( group_name, title_select_txt, select_txt, second_value_arrary ) {
        try {
            var selectBar = UI.getItem(AudioMenuPromptsSetting, group_name);
            var selectBarText = UI.getItem(selectBar, title_select_txt);
            var selectComp = UI.getItem(selectBar, select_txt);
            Select.create(selectComp, second_value_arrary);
            selectBar.onkey_RIGHT = function () {
                var index = selectComp.values.indexOf(selectComp.selected);
                var length = selectComp.values.length;
                index = (length+index+1) % length;
                selectBarSendToBm(group_name, index);
                selectComp.selectNext();

            };
            selectBar.onkey_LEFT = function () {
                var index = selectComp.values.indexOf(selectComp.selected);
                var length = selectComp.values.length;
                index = (length+index-1) % length;
                selectBarSendToBm(group_name, index);
                selectComp.selectPrev();

            };
            selectBar.onFocus = function () {
                setHelpInfo();
                selectComp.onFocus();
                UI.setTextColor(selectBarText, "#ffffff");
                UI.updateStage();
                return true;
            };
            selectBar.onkey_ENTER = function () {
                listOnKeyEnter(group_name);
            }
            selectBar.onNormal = function () {
                //selectComp.onNormal();
                //UI.setTextColor(selectBarText, "rgba(255,255,255,0.6)");
                //UI.updateStage();
                return true;
            };
        }
        catch ( ex ) {
            DBG_ERROR("selectbar_common func is error" + ex.message);
        }

    }

    Switchbar_common(AudioMenuPromptsSetting, "FocusMenuAudio", "FocusMenuAudioImg", "Title");
    selectbar_common(Group_array[1], 'Title', 'Txt', LanguageBar);
    selectbar_common(Group_array[2], 'Title', 'Txt', RateBar);
    percentBar_common(AudioMenuPromptsSetting, "VolumeBar", "bar", "value", "Title", 0, 100);
    percentBar_common(AudioMenuPromptsSetting, "PitchBar", "bar", "value", "Title", 0, 100);
}
