/**
 * Created by Hisense on 2016-1-5.
 */
// Init
UI.moduleBuilder['setting']['AudioMainPanel'] = function(){

    var initData = {
        audioSheetImg: UI["setting_bg"],
        audioImg1: "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_audio_154x154.png",
        sndModeImg1: UI.btn_normal_bg,
        audiotitle1: "[SE0058]",//Sound
        SndModeTitle: "[SE0059]",//Sound Mode
        speakerTitle:"[SE3250]",//Speakers
        sModeSettingTitle: "[SE3556]", //todo
        headphoneTitle: "[SE0084]",//Headphone
        AdvanceTitle: "[SE0553]",//Advanced Audio Settings
        resetTitle: "[OT0395]" //Reset Audio Settings
    };
    var template = Util.readJson("module/setting/AudioMainPanel.json");
    var setSndPanel = SubModule.create(initData, template);
    var AudioMainPanel = UI.getSubModule("AudioMainPanel");
    var audioRightGrp = UI.getItem(setSndPanel, "audioRightGrp");
    UI.addMask(audioRightGrp, 1242, 926, 50, 6);
    UI.setView(audioRightGrp, 1242, 926);
    var sndModeMenu = UI.getItem(audioRightGrp, "sndModeMenu");
    var speakerMenu = UI.getItem(audioRightGrp, "speakerMenu");
    var sModeSettingMenu = UI.getItem(audioRightGrp, "sModeSettingMenu");
    var headphoneMenu = UI.getItem(audioRightGrp, "headphoneMenu");
    var advanceMenu = UI.getItem(audioRightGrp, "advanceMenu");
    var resetMenu = UI.getItem(audioRightGrp, "resetMenu");

    AudioMainPanel.PageData = {
        "ModeEnum": ["[SE0004]", "[SE0062]", "[SE0542]", "[SE0060]", "[SE0061]", "[LA0013]"],//"Standard", "Speech", "Late Night", "Music", "Theatre", "Sports"

        sndHelpInfo: {
            sndModeMenu: {
                title: "Sound Mode",
                info: "[SE0541]"//"Select a preset sound mode to suit the type of content you are listening to."
            },
            speakerMenu: {
                title: "Speakers",
                info: "[SE3251]"//Select the speakers which you want to use
            },
            sModeSettingMenu: {
                title: "[SE3556]",
                info: "[SE3750]"//
            },
            headphoneMenu: {
                title: "Headphone",
                info: "[SE3751]"
            },
            advanceMenu: {
                title: "Advanced Audio Settings",
                info: "[SE0554]"//"Tune the audio settings and quality of the TV."
            },
            resetMenu: {
                title: "Reset Audio Settings",
                info: "[SE0581]"//"Restore all of the audio settings in current audio mode to the factory default values."
            }
        },
        ARCDeviceWorkingState: {
            Working: 1,
            RestIng: 0
        },
        DisableMenuNameARC:["sndModeMenu"],
        headphoneInsert: 0
    };

    function initModeData() {
        try {
            var SndModeTitle = UI.getItem(sndModeMenu, "SndModeTitle");
            var sndMode = tv ? model.sound.getSoundMode() : 5;
            DBG_INFO("model.sound.getSoundMode():" + sndMode);
            SndModeTitle.setValue(AudioMainPanel.PageData.ModeEnum[sndMode]);
            UI.updateStage();

        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }


    setSndPanel.onShow = function () {
        if(UI.isExistModule('launcher')){
            UI.hideModule(launcher);
        }
        if(!!UI.getItem(setting, 'mainPanel')){
            UI.getItem(setting, 'mainPanel').alpha = 0;
        }
        AudioMainPanel.alpha = 1;
        try {
            initModeData();
            getHeadphone();
            sModeSettingDisable();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    };

    function sModeSettingDisable() {
        try {
            var speakerArc = tv ? model.sound.getSpeakerArc() : 1;
            if (speakerArc != 1 && AudioMainPanel.PageData.headphoneInsert == 0) {
                sndModeMenu.disable = true;
                sModeSettingMenu.disable = true;
                sModeSettingMenu.alpha = 0.3;
                sndModeMenu.alpha = 0.3;
                if (AudioMainPanel.currFocus == sndModeMenu){
                    setting.onNormal(AudioMainPanel.currFocus);
                    setting.currFocus=AudioMainPanel.currFocus = speakerMenu;
                    setting.onFocus(AudioMainPanel.currFocus);
                }
            } else {
                sndModeMenu.disable = false;
                sModeSettingMenu.disable = false;
                sModeSettingMenu.alpha = 1;
                sndModeMenu.alpha = 1;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function getHeadphone() {
        try {
            var headphoneInsert = tv ? model.sound.getHeadphoneInsert() : 0;
            AudioMainPanel.PageData.headphoneInsert = headphoneInsert;
            HeadphoneDisable(headphoneInsert);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function HeadphoneDisable(val) {  //todo xiugai
        try {
            DBG_INFO("HeadphoneDisable " + val);
            var speakerArc = tv ? model.sound.getSpeakerArc() : 0;
            if (val == 1) {
                headphoneMenu.disable = false;
                headphoneMenu.alpha = 1;
                sModeSettingMenu.disable = false;
                sModeSettingMenu.alpha = 1;
            } else if (val == 0 && speakerArc == 1) {
                headphoneMenu.disable = true;
                headphoneMenu.alpha = 0.3;
                if (AudioMainPanel.currFocus == headphoneMenu){
                    setting.onNormal(AudioMainPanel.currFocus);
                    setting.currFocus=AudioMainPanel.currFocus = sndModeMenu;
                    setting.onFocus(AudioMainPanel.currFocus);
                }
            } else if (val == 0 && speakerArc != 1) {
                headphoneMenu.disable = true;
                headphoneMenu.alpha = 0.3;
                sModeSettingMenu.disable = true;
                sModeSettingMenu.alpha = 0.3;
                sndModeMenu.disable = true;
                sndModeMenu.alpha = 0.3;
                if (AudioMainPanel.currFocus == headphoneMenu || AudioMainPanel.currFocus == sModeSettingMenu || AudioMainPanel.currFocus == sndModeMenu){
                    setting.onNormal(AudioMainPanel.currFocus);
                    setting.currFocus=AudioMainPanel.currFocus = speakerMenu;
                    setting.onFocus(AudioMainPanel.currFocus);
                }
            }


            UI.updateStage();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function SpeakerArcChaged(val) {
        try {
            DBG_INFO("SpeakerArcChaged " + val);
            var HeadphoneInsert = tv ? model.sound.getHeadphoneInsert() : 0;
            DBG_INFO("HeadphoneInsert " + HeadphoneInsert);
            if (HeadphoneInsert == 1) {
                headphoneMenu.disable = false;
                headphoneMenu.alpha = 1;
                sModeSettingMenu.disable = false;
                sModeSettingMenu.alpha = 1;
            } else if (HeadphoneInsert == 0 && val == 1) {
                headphoneMenu.disable = true;
                headphoneMenu.alpha = 0.3;
                sModeSettingMenu.disable = false;
                sModeSettingMenu.alpha = 1;
                sndModeMenu.disable = false;
                sndModeMenu.alpha = 1;
                if (AudioMainPanel.currFocus == headphoneMenu){
                    setting.onNormal(AudioMainPanel.currFocus);
                    setting.currFocus=AudioMainPanel.currFocus = sndModeMenu;
                    setting.onFocus(AudioMainPanel.currFocus);
                }
            } else if (HeadphoneInsert == 0 && val != 1) {
                headphoneMenu.disable = true;
                headphoneMenu.alpha = 0.3;
                sModeSettingMenu.disable = true;
                sModeSettingMenu.alpha = 0.3;
                sndModeMenu.disable = true;
                sndModeMenu.alpha = 0.3;
                if (AudioMainPanel.currFocus == headphoneMenu || AudioMainPanel.currFocus == sModeSettingMenu || AudioMainPanel.currFocus == sndModeMenu){
                    setting.onNormal(AudioMainPanel.currFocus);
                    setting.currFocus=AudioMainPanel.currFocus = speakerMenu;
                    setting.onFocus(AudioMainPanel.currFocus);
                }
            }
            UI.updateStage();
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    var DBXVolumeMenu = UI.getItem(AudioMainPanel,"DBXVolumeMenu");
    var DBXSonicMenu = UI.getItem(AudioMainPanel, "DBXSonicMenu");
    var DBXSurrMenu = UI.getItem(AudioMainPanel, "DBXSurrMenu");
    setSndPanel.onPush = function () {
        ModelNotifyInit();
        setSndPanel.currFocus = sndModeMenu;

       /* getARCStateInit();
        AudioMainPanel.DisableSoundByARCOn();*/

    };


    function ModelNotifyInit() {
        try {
           // UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SPEAKER, speakersChaged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, HeadphoneDisable);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SPEAKER, SpeakerArcChaged);
        }
        catch (ex) {
            DBG_ERROR(ex.message)
        }
    }
    function UnModelNotifyInit() {
        try {
           // UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SPEAKER, speakersChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, HeadphoneDisable);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SPEAKER, SpeakerArcChaged);
        }
        catch (ex) {
            DBG_ERROR(ex.message)
        }
    }

    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CEC_DEVICE_EXIST_CHANGED, onArcDeviceExistChaged);

    var audioLeftGrp = UI.getItem(AudioMainPanel, "audioLeftGrp");
    var audioHelpInfo = UI.getItem(AudioMainPanel, "audioHelpInfo");
    var resetMenu = UI.getItem(audioRightGrp, "resetMenu");

    var audioInfoGrp = UI.getItem(AudioMainPanel, "audioLeftGrp");
    var audiotitle1 = UI.getItem(audioInfoGrp, "audiotitle1");

    labelValue_common(audioRightGrp, "sndModeMenu", "SndModeTitle", "[SE0059]");//Sound Mode
    group_common(audioRightGrp, "speakerMenu", "AudioSpeaker", "speakerTitle");
    group_common(audioRightGrp, "sModeSettingMenu", "AudioModeSettings", "sModeSettingTitle");
    group_common(audioRightGrp, "headphoneMenu", "AudioHeadphone", "headphoneTitle");
    group_common(audioRightGrp, "advanceMenu", "AudioAdvance", "AdvanceTitle");
    group_common(audioRightGrp, "resetMenu", "AudioReset", "resetTitle");


    resetMenu.onkey_ENTER = function () {
        UI.pushSubModule("setting", "AudioReset", true);

    };
    function sndMainPageHelpInfo(id) {
        UI.setText(audioHelpInfo, AudioMainPanel.PageData.sndHelpInfo[id].info);
    }

    function group_common(submodule, group_name, subName, title) {
        try {
            var groupLine = UI.getItem(submodule, group_name);
            var titleTxt = UI.getItem(groupLine, title);
            groupLine.onFocus = function () {
                sndMainPageHelpInfo(group_name);
                //UI.setTextColor(titleTxt, "#FFFFFF");
                return true;
            };
            groupLine.onkey_ENTER = function () {
//                AudioMainPanel.alpha = 0;
                /*try {
                    var DTSorDBX = tv ? model.sound.getSoundEffectType() : 0;  //0--DTS  1--DBX
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }*/
                if (subName == "AudioModeSettings") {
                    //if (DTSorDBX == 0) {
                        UI.pushSubModule("setting", "AudioModeSettingsDTS", true);
                    //} else {
                    //    UI.pushSubModule("setting", "AudioModeSettingsDBX", true);
                    //}
                } else if (subName == "AudioAdvance") {
                    //if (DTSorDBX == 0) {
                        UI.pushSubModule("setting", "AudioAdvanceDTS", true);
                    //} else {
                    //    UI.pushSubModule("setting", "AudioAdvanceDBX", true);
                   // }
                } else {
                    UI.pushSubModule("setting", subName, true);
                }

            };
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    function labelValue_common(submodule, groupname, lable, value) {
        try {
            var lableGroup = UI.getItem(submodule, groupname);
            var lableTitle = UI.getItem(lableGroup, lable);
            LabelValue.create(lableTitle, value, "36px SourceSansPro-Light", "0xFFFFFF");
            UI.updateStage();

            lableGroup.onFocus = function () {
                sndMainPageHelpInfo(groupname);
                UI.updateStage();
                return true;
            };
            lableGroup.onkey_ENTER = function () {
                AudioMainPanel.alpha = 0;
                //UI.getItem(setting, 'mainPanel').alpha = 0;
                UI.pushSubModule("setting", "AudioMode", true);
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    AudioMainPanel.onkey_BACKSPACE= function() {
        UI.popSubModule();
        var caller=UI.getSubModule("mainPanel");
        if (!caller) {
            UI.pushSubModule("setting", "mainPanel", true, null, null, "soundBtn");
        }
    };

    AudioMainPanel.onPop = function () {
        UnModelNotifyInit();
    }
};
