// Init
UI.moduleBuilder['setting']['AudioLipSync'] = function(){

    var lipSyncData = {
        sndModeImg1: UI["liveTV_bg"],
        lipSyncTitle:"[SE0561]",//Lip Sync
        lipSyncInfo:"[SE0562]"//Synchronize the displayed image with the audio output.

    };
    var template = Util.readJson("module/setting/AudioLipSync.json");
    var lipSync = SubModule.create(lipSyncData, template);
    var lipSyncBar = UI.getItem(lipSync, "lipSyncBar");
    var bar = UI.getItem(lipSync,"bar");
    lipSync.currFocus = lipSyncBar;
    lipSync.onShow = function(){
        var lipSyncValue = tv ? model.sound.getLipsync() : 5;
        DBG_INFO("model.sound.getLipsync():"+lipSyncValue);
        bar.setPercent(lipSyncValue);
    };
    var AudioLipSync = UI.getSubModule("AudioLipSync");
    AudioLipSync.onkey_BACKSPACE = function () {
        var AudioSpeaker = UI.getSubModule("AudioSpeaker");
        AudioSpeaker.alpha = 1;
        UI.popSubModule();
    };
    percentBar_common(AudioLipSync,"lipSyncBar","bar","value",0,10);
    function percentBar_common(submodule, groupname,percentImg,percentTxt,min,max){
        try{
            var percentBar = UI.getItem(submodule, groupname);
            var percentComp = UI.getItem(percentBar, percentImg);
            var percentTxt = UI.getItem(percentBar, percentTxt);

            Percent.create(percentComp, percentTxt, 0,min,max);
            percentBar.onFocus = function(focus) {
                percentComp.onFocus();
                return false;
            };
            percentBar.onNormal = function(focus) {
                percentComp.onNormal();
                return true;
            };
            percentBar.onkey_RIGHT = function() {
                percentComp.plus();
                //percentBar.updateCache();
                //UI.updateStage();
                if(!!tv){
                    model.sound.setLipsync(percentComp.percent);
                }
            };
            percentBar.onkey_LEFT = function() {
                percentComp.minus();
                //percentBar.updateCache();
                //UI.updateStage();
                if(!!tv){
                    model.sound.setLipsync(percentComp.percent);
                }
            };
        }
        catch(ex){
            DBG_ERROR(ex.message);
        }
    }
};